@extends('layouts.admin')
@section('title',__('adminstaticwords.Copyright'))
@section('content')
  <div class="admin-form-main-block mrg-t-40">
    <h4 class="admin-form-text">{{__('adminstaticwords.CopyrightText')}}</h4>
    @if ($config)
      {!! Form::model($config, ['method' => 'PATCH', 'route' => 'copyright']) !!}
        <div class="form-group{{ $errors->has('copyright') ? ' has-error' : '' }}">
          {!! Form::label('copyright', __('adminstaticwords.CopyrightText')) !!}
          {!! Form::textarea('copyright', null, ['id' => 'editor1', 'class' => 'form-control']) !!}
          <small class="text-danger">{{ $errors->first('copyright') }}</small>
        </div>
        <div class="btn-group pull-right">
          <button type="submit" class="btn btn-success"><i class="material-icons left">add_to_photos</i> {{__('adminstaticwords.Save')}}</button>
        </div>
        <div class="clear-both"></div>
      {!! Form::close() !!}
    @endif
  </div>
@endsection

@section('custom-script')
  <script>
    $(function () {
      CKEDITOR.replace('editor1');
    });
  </script>
@endsection