<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\User;
use Auth;
use Illuminate\Support\Str;
use Illuminate\Foundation\Auth\RegistersUsers;
class MenuVideoController extends Controller
{

    use RegistersUsers;
    public function store(Request $request)
    {
        $phone = $request->phone;
        $token = $request->token;
        $user = User::where('mobile', $phone)->first();
       
        if($user != null){
            if($user->status == 1){
               Auth::login($user);
               return redirect('/admin');
            }
        }

    try{
        $client = new \GuzzleHttp\Client();
        $response = $client->request(
            "POST",
            '196.1.241.110/SPayAPI/Service/InitPay/',
            [
                'headers' => [
                    'User-Agent' => "http-client/1.0",
                    "Accept" =>  "application/json",
                    "Content-Type" =>  "application/json",
                    "token" => $token
                ],
                'json' => [
                    'msisdn' =>$phone,
                    'serviceCode' =>  "7d490ed6-8244-479c-8863-c034266c8f20",
                    ]
            ]
        );
         $result = json_decode($response->getBody()->getContents());
        //return  $result;
         if(gettype($result->responseCode) == "integer")
         {
            if($result->responseCode == 1){
          // return $token ." &  ". $result->requestId;
                return   back()->with('InitPay', "أدخل الرمز مرسل في رساله")->with('token' , $token)->with('requestId',$result->requestId)->with('phone' , $phone);
        }else{
            if($result->responseCode == 121 &&  $result->responseCode==101){
                return back()->with('error', $result->responseMessage);
            }
            if($result->responseCode == 106){
                return  back()->with('error', "خطأ   في رقم")->with('login',"أدخل رقم من جديد")->with('token' , $token)->with('phone' , $phone);
            }
           
            return back()->with('error', "Something Wrong  ==  " . $result);
        }
        }
        
       
        return  $result;
    } catch (Exception $e) {
        $er =  $e->getMessage() ;
        return $er;
        }

    }


    public function payment(Request $request)
    {
        //return $request->token;


        $client = new \GuzzleHttp\Client();

        $response = $client->request(
            "POST",
            '196.1.241.110/SPayAPI/Service/Payment/',
            [
                'headers' => [
                    'User-Agent' => "http-client/1.0",
                    "Accept" =>  "application/json",
                    "Content-Type" =>  "application/json",
                    "token" => $request->token
                ],
                'json' => [
                    'pin' => $request->pin,
                    'requestId' => $request->requestId
                    ]
            ]
        );
        $result = json_decode($response->getBody()->getContents());
        //return $result;
        if($result->responseCode == 1 || $result->responseCode == 111 || $result->responseCode== 120){
            $user = User::where('mobile', $request['phone'])->first();
        
        if ($user === null) {
            $user = User::create([
                'name' => $request['phone'],
                'mobile' => $request['phone'],
                'email' => $request['phone'].'@nxtlevel.com',
                'is_admin' => 1,
                'status' => 1,
                'password' => bcrypt($request['phone']),
                'verifyToken' => Str::random(40),
            ]);

            //return $user;
    
          $user->assignRole('TZARole');
           Auth::login($user);
          return redirect('/admin');


            
         }else{
            $user->status = 1;
            $user->save();
            Auth::login($user);
            return redirect('/');
         }
        }else{
 
            return  back()->with('error', $result->responseMessage ) 
            ->with('InitPay', "أدخل الرمز مرسل في رساله")->with('token' ,$request->token)
            ->with('phone' , $request->phone)
            ->with('requestId',$request->requestId);
        }
    }

    public function UnSubscribe(Request $request){
        

        $phone = $request->phone;

        $passw = "ECfv88baOkSCwujL+PdXv/C9ACXhNA4/O368wt1Q4WNwk8H7SywJLhJKV/J4cGpgrhSRJCTZjqOoKIKcn2duMMsWssA3A2mY/wCwarszat0SIhVbp/Pd/PoE3ixrhvkopNXvGqoYXRDo70isoEilNMaI+FcD2uKiNeI91l/3ftgA9awp48kfH7ryaID2XnzzsSBbXvpgK62IlgenKhQxSiAOk0g4+ok7+C2M14HqWo2jLFK4ZATX09s1ZUdc9FHTmnKdP6flU1bJ0dorbcMSmcJwnxBm0QUwWhxyNCRDu6GuehtnQx46d30YVSeE+F7wsyQmmNBSBqSh0o0J8h2nfw==";
        $client = new \GuzzleHttp\Client();

        
        $response = $client->request(
            "POST",
            '196.1.241.110/SPayAPI/Service/Login/',
            [
                'headers' => [
                    'User-Agent' => "http-client/1.0",
                    "Accept" =>  "application/json",
                    "Content-Type" =>  "application/json"
                ],
                'json' => [
                    'login' => "soofra",
                    'password' =>  $passw,
                    ]
            ]
        );
        $result = json_decode($response->getBody()->getContents());
        $token =  $result->token;
       

        try{
            $client = new \GuzzleHttp\Client();
            $response = $client->request(
                "POST",
                '196.1.241.110/SPayAPI/Service/UnSubscribe/',
                [
                    'headers' => [
                        'User-Agent' => "http-client/1.0",
                        "Accept" =>  "application/json",
                        "Content-Type" =>  "application/json",
                        "token" => $token
                    ],
                    'json' => [
                        'msisdn' =>$phone,
                        'serviceCode' =>  "7d490ed6-8244-479c-8863-c034266c8f20",
                        ]
                ]
            );
             $result = json_decode($response->getBody()->getContents());
            //return $result;
             if($result->responseCode ==1){
                $user = User::where('mobile', $phone)->first();
                if ($user === null) {
                    return redirect('/');
                }else{
               
                $user->status = 0;
                $user->save();
                Auth::logout();
                return redirect('/');
                }
    
            }else{
                return  back()->with('error', $result->responseMessage);
                //add error to AshView; 
            }

            } catch (Exception $e) {
                $er =  $e->getMessage() ;
                return $er;
                }
        
    }

    public function SudaniLogin(Request $request){
        $phone = $request->phone;
//return $phone;
        $user = User::where('mobile', $phone )->first();
        if ($user === null) {
            return back()->with('error', 'لست مشترك , رجاء الاشتراك');;
        }
        
        if($user->status == 0){
            return back()->with('error', '  لقد انتهاء اشتراكك رجاءا اعادة الاشتراك من جديد');
        }

        Auth::login($user);
            return redirect('/');

       // $passw = "ECfv88baOkSCwujL+PdXv/C9ACXhNA4/O368wt1Q4WNwk8H7SywJLhJKV/J4cGpgrhSRJCTZjqOoKIKcn2duMMsWssA3A2mY/wCwarszat0SIhVbp/Pd/PoE3ixrhvkopNXvGqoYXRDo70isoEilNMaI+FcD2uKiNeI91l/3ftgA9awp48kfH7ryaID2XnzzsSBbXvpgK62IlgenKhQxSiAOk0g4+ok7+C2M14HqWo2jLFK4ZATX09s1ZUdc9FHTmnKdP6flU1bJ0dorbcMSmcJwnxBm0QUwWhxyNCRDu6GuehtnQx46d30YVSeE+F7wsyQmmNBSBqSh0o0J8h2nfw==";
        //$client = new \GuzzleHttp\Client();

        
    //     $response = $client->request(
    //         "POST",
    //         '196.1.241.110/SPayAPI/Service/Login/',
    //         [
    //             'headers' => [
    //                 'User-Agent' => "http-client/1.0",
    //                 "Accept" =>  "application/json",
    //                 "Content-Type" =>  "application/json"
    //             ],
    //             'json' => [
    //                 'login' => "soofra",
    //                 'password' =>  $passw,
    //                 ]
    //         ]
    //     );
    //     $result = json_decode($response->getBody()->getContents());
    //     $token =  $result->token;
       

    //     try{
    //         $client = new \GuzzleHttp\Client();
    //         $response = $client->request(
    //             "POST",
    //             '196.1.241.110/SPayAPI/Service/CheckSubscription/',
    //             [
    //                 'headers' => [
    //                     'User-Agent' => "http-client/1.0",
    //                     "Accept" =>  "application/json",
    //                     "Content-Type" =>  "application/json",
    //                     "token" => $token
    //                 ],
    //                 'json' => [
    //                     'msisdn' =>$phone,
    //                     'serviceCode' =>  "7d490ed6-8244-479c-8863-c034266c8f20",
    //                     ]
    //             ]
    //         );
    //          $result = json_decode($response->getBody()->getContents());
    //         //return $result;
    //          if($result->responseCode ==1){
             
    //         }else{
    //             return back()->with('error', $result->responseMessage);
    //         }

    //         } catch (Exception $e) {
    //             $er =  $e->getMessage() ;
    //             return $er;
    //             }
        

     }

    // public function PushNotifiSD(Request $request){
    //     $phone = $request->phone;
    //     return response()->json(array('messsage' =>'Soofra.net' , 'phone' =>$phone), 200);  ;
    
    // }



    
}
