<?php
use App\Language;
use App\Menu;
use App\PackageMenu;

//for get stripe plan
function getPlan()
{

    $userplan = auth()->user()->subscriptions()->orderBy('id', 'DESC')->first();

    $subscription = \Stripe\Stripe::setApiKey(env('STRIPE_SECRET'));

    $subscription = \Stripe\Subscription::retrieve($userplan->stripe_id);

    if (isset($subscription) && $subscription->canceled_at == '' && $subscription->pause_collection == '') {

        return 1;

    } else {
        return 0;
    }
}

//for selected language
if (!function_exists('selected_lang')) {
    function selected_lang()
    {
        $lang = Language::firstWhere('local', '=', session()->get('changed_language') ?? config('translatable.fallback_locale'));
        return $lang;
    }
}
// for release update
if (!function_exists('get_release')) {

    function get_release()
    {

        $version = @file_get_contents(storage_path() . '/app/bugfixer/version.json');
        $version = json_decode($version, true);
        $current_subversion = $version['subversion'];

        return '(Release ' . $current_subversion . ')';
    }

}

// function subscribed(){
//     $subscribed = 0;
//     $config = \App\Config::first();
//     $auth = auth()->user();
//     $nav_menus = Menu::all();
//     \Stripe\Stripe::setApiKey(env('STRIPE_SECRET'));
//     if (isset($auth)) {
        
//         $current_date = Illuminate\Support\Carbon::now();
//         $paypal = App\PaypalSubscription::where('user_id', $auth->id)->orderBy('created_at', 'desc')->first();
//         if (isset($paypal)) {
           
//             if (date($current_date) <= date($paypal->subscription_to)) {
                
//                 if ($paypal->package_id == 0) {
//                     $nav_menus = Menu::all();

//                     return response()->json([
//                         'subs_type' => 'all_menu',
//                         'nav_menus' => $nav_menus,
//                         'subscribed' => true,
//                         'status' => 'OK',
//                     ]);

//                 }
//             }
//         }
//         if ($auth->is_admin == 1 || $auth->is_assistant == 1) {
            
//             $nav_menus = Menu::orderBy('position', 'ASC')->get();
//             return response()->json([
//                 'subs_type' => 'all_menu',
//                 'nav_menus' => $nav_menus,
//                 'subscribed' => true,
//                 'status' => 'OK',
//             ]);

//         } else {
            
//             /** Stripe Subscription start */

//             Stripe\Stripe::setApiKey(env('STRIPE_SECRET'));
//             if ($auth->stripe_id != null) {
//                 $customer = \Laravel\Cashier\Cashier::findBillable($auth->stripe_id);
//                 // $customer = Stripe\Customer::retrieve($auth->stripe_id);
//                 if (isset($customer)) {
//                     $data = $auth->subscriptions->last();
//                 }
//             }
//             if (isset($paypal) && $paypal != null && $paypal->count() > 0) {
//                 $last = $paypal;
//             }
//             $stripedate = isset($data) ? $data->created_at : null;
//             $paydate = isset($last) ? $last->created_at : null;
//             if ($stripedate > $paydate) {
                
//                 if ($auth->subscribed($data->name) && date($current_date) <= date($data->subscription_to) && getPlan() == 1) {
//                     if (isset($data->stripe_plan) && $data->stripe_plan != NULL) {
//                         $planmenus = PackageMenu::where('package_id', $data->stripe_plan)->get();

//                         if (count($planmenus)) {
//                             /** @return specfic plan menus */

//                             $nav_menus = Menu::whereIn('id', $planmenus->pluck('menu_id'))->get();
//                             return response()->json([
//                                 'subs_type' => 'single_menu',
//                                 'nav_menus' => $nav_menus,
//                                 'subscribed' => true,
//                                 'status' => 'OK',
//                             ]);

//                         }else{
//                             /** If pkg has no menu selected @return all menu */

//                             $nav_menus = Menu::orderBy('position', 'ASC')->get();
//                             return response()->json([
//                                 'subs_type' => 'all_menu',
//                                 'nav_menus' => $nav_menus,
//                                 'subscribed' => true,
//                                 'status' => 'OK',
//                             ]);
//                         }

//                     }
//                 }
//                 else{
                    
//                     return response()->json([
//                         'subs_type' => 'all_menu',
//                         'nav_menus' => $nav_menus,
//                         'subscribed' => false,
//                         'status' => 'FAIL',
//                     ]);
//                 }
//             } elseif ($stripedate < $paydate) {
                
//                 if ((date($current_date) <= date($last->subscription_to)) && $last->status == 1) {
                   
//                     if (isset($last->plan['plan_id']) && $last->plan['plan_id'] != NULL) {

//                         $planmenus = PackageMenu::where('package_id', $last->plan['plan_id'])->get();

//                         if (count($planmenus)) {

//                              /** @return specfic plan menus */

//                             $nav_menus = Menu::whereIn('id', $planmenus->pluck('menu_id'))->get();

//                             return response()->json([
//                                 'subs_type' => 'single_menu',
//                                 'nav_menus' => $nav_menus,
//                                 'subscribed' => true,
//                                 'status' => 'OK',
//                             ]);

//                         }else{
//                             /** If pkg has no menu selected @return all menu */
//                             $nav_menus = Menu::orderBy('position', 'ASC')->get();
//                             return response()->json([
//                                 'subs_type' => 'all_menu',
//                                 'nav_menus' => $nav_menus,
//                                 'subscribed' => true,
//                                 'status' => 'OK',
//                             ]);
//                         }

//                     }

//                 }else{
                    
//                     return response()->json([
//                         'subs_type' => 'all_menu',
//                         'nav_menus' => $nav_menus,
//                         'subscribed' => false,
//                         'status' => 'FAIL',
//                     ]);
//                 }
//             }else{
               
//                 return response()->json([
//                     'subs_type' => 'all_menu',
//                     'nav_menus' => $nav_menus,
//                     'subscribed' => false,
//                     'status' => 'FAIL',
//                 ]);
//             }
//         }
//     }else{
//         return response()->json([
//             'subscribed' => false,
//             'status' => 'FAIL',
//         ]);
//     }
// }

function getSubscription()
{
    
    $subscribed = 0;
    $config = \App\Config::first();
    $auth = auth()->user();
    $nav_menus = Menu::all();
    \Stripe\Stripe::setApiKey(env('STRIPE_SECRET'));
    if (isset($auth)) {
        
        $current_date = Illuminate\Support\Carbon::now();
        $paypal = App\PaypalSubscription::where('user_id', $auth->id)->orderBy('created_at', 'desc')->first();
        if (isset($paypal)) {
           
            if (date($current_date) <= date($paypal->subscription_to)) {
                
                if ($paypal->package_id == 0) {
                    $nav_menus = Menu::all();

                    return response()->json([
                        'subs_type' => 'all_menu',
                        'nav_menus' => $nav_menus,
                        'subscribed' => true,
                        'status' => 'OK',
                    ]);

                }
            }
        }
        if ($auth->is_admin == 1 || $auth->is_assistant == 1) {
            
            $nav_menus = Menu::orderBy('position', 'ASC')->get();
            return response()->json([
                'subs_type' => 'all_menu',
                'nav_menus' => $nav_menus,
                'subscribed' => true,
                'status' => 'OK',
            ]);

        } else {
            
            /** Stripe Subscription start */

            Stripe\Stripe::setApiKey(env('STRIPE_SECRET'));
            if ($auth->stripe_id != null) {
                $customer = \Laravel\Cashier\Cashier::findBillable($auth->stripe_id);
                // $customer = Stripe\Customer::retrieve($auth->stripe_id);
                if (isset($customer)) {
                    $data = $auth->subscriptions->last();
                }
            }
            if (isset($paypal) && $paypal != null && $paypal->count() > 0) {
                $last = $paypal;
            }
            $stripedate = isset($data) ? $data->created_at : null;
            $paydate = isset($last) ? $last->created_at : null;
            if ($stripedate > $paydate) {
                
                if ($auth->subscribed($data->name) && date($current_date) <= date($data->subscription_to) && getPlan() == 1) {
                    if (isset($data->stripe_plan) && $data->stripe_plan != NULL) {
                        $planmenus = PackageMenu::where('package_id', $data->stripe_plan)->get();

                        if (count($planmenus)) {
                            /** @return specfic plan menus */

                            $nav_menus = Menu::whereIn('id', $planmenus->pluck('menu_id'))->get();
                            return response()->json([
                                'subs_type' => 'single_menu',
                                'nav_menus' => $nav_menus,
                                'subscribed' => true,
                                'status' => 'OK',
                            ]);

                        }else{
                            /** If pkg has no menu selected @return all menu */

                            $nav_menus = Menu::orderBy('position', 'ASC')->get();
                            return response()->json([
                                'subs_type' => 'all_menu',
                                'nav_menus' => $nav_menus,
                                'subscribed' => true,
                                'status' => 'OK',
                            ]);
                        }

                    }
                }
                else{
                    
                    return response()->json([
                        'subs_type' => 'all_menu',
                        'nav_menus' => $nav_menus,
                        'subscribed' => false,
                        'status' => 'FAIL',
                    ]);
                }
            } elseif ($stripedate < $paydate) {
                
                if ((date($current_date) <= date($last->subscription_to)) && $last->status == 1) {
                   
                    if (isset($last->plan['plan_id']) && $last->plan['plan_id'] != NULL) {

                        $planmenus = PackageMenu::where('package_id', $last->plan['plan_id'])->get();

                        if (count($planmenus)) {

                             /** @return specfic plan menus */

                            $nav_menus = Menu::whereIn('id', $planmenus->pluck('menu_id'))->get();

                            return response()->json([
                                'subs_type' => 'single_menu',
                                'nav_menus' => $nav_menus,
                                'subscribed' => true,
                                'status' => 'OK',
                            ]);

                        }else{
                            /** If pkg has no menu selected @return all menu */
                            $nav_menus = Menu::orderBy('position', 'ASC')->get();
                            return response()->json([
                                'subs_type' => 'all_menu',
                                'nav_menus' => $nav_menus,
                                'subscribed' => true,
                                'status' => 'OK',
                            ]);
                        }

                    }

                }else{
                    
                    return response()->json([
                        'subs_type' => 'all_menu',
                        'nav_menus' => $nav_menus,
                        'subscribed' => false,
                        'status' => 'FAIL',
                    ]);
                }
            }else{
               
                return response()->json([
                    'subs_type' => 'all_menu',
                    'nav_menus' => $nav_menus,
                    'subscribed' => false,
                    'status' => 'FAIL',
                ]);
            }
        }
    }else{
        return response()->json([
            'subscribed' => false,
            'status' => 'FAIL',
        ]);
    }
}


function checkInMovie($movie){


    if(getSubscription()->getData()->subscribed == true){
            
        if(isset(getSubscription()->getData()->subs_type) && getSubscription()->getData()->subs_type == 'all_menu'){
           return true;
        }

        if(isset(getSubscription()->getData()->subs_type) && getSubscription()->getData()->subs_type == 'single_menu'){
            
            foreach($movie->menus as $moviemenu){
                if(array_search($moviemenu->menu_id, array_column(getSubscription()->getData()->nav_menus, 'id')) !== false)
                {
                    return true;
                }
            }
        }
        
        
    }
}


function checkInTvseries($tv){
    if(getSubscription()->getData()->subscribed == true){
            
        if(isset(getSubscription()->getData()->subs_type) && getSubscription()->getData()->subs_type == 'all_menu'){
           return true;
        }

        if(isset(getSubscription()->getData()->subs_type) && getSubscription()->getData()->subs_type == 'single_menu'){
            
            foreach($tv->menus as $tvmenu){
                if(array_search($tvmenu->menu_id, array_column(getSubscription()->getData()->nav_menus, 'id')) !== false)
                {
                    return true;
                }
            }
        }
        
        
    }
}

function checkInViewAllTv($tv){
    if(getSubscription()->getData()->subscribed == true){
            
        if(isset(getSubscription()->getData()->subs_type) && getSubscription()->getData()->subs_type == 'all_menu'){
           return true;
        }

        if(isset(getSubscription()->getData()->subs_type) && getSubscription()->getData()->subs_type == 'single_menu'){
            
            foreach($tv['menus'] as $tvmenu){
                if(array_search($tvmenu['menu_id'], array_column(getSubscription()->getData()->nav_menus, 'id')) !== false)
                {
                    return true;
                }
            }
        }
        
        
    }
}

function checkInViewAllMovie($tv){
    if(getSubscription()->getData()->subscribed == true){
            
        if(isset(getSubscription()->getData()->subs_type) && getSubscription()->getData()->subs_type == 'all_menu'){
           return true;
        }

        if(isset(getSubscription()->getData()->subs_type) && getSubscription()->getData()->subs_type == 'single_menu'){
            
            foreach($tv['menus'] as $tvmenu){
                if(array_search($tvmenu['menu_id'], array_column(getSubscription()->getData()->nav_menus, 'id')) !== false)
                {
                    return true;
                }
            }
        }
        
        
    }
}


// function hideForMe(){
//     $hide = \DB::table('hide_for_me')->where('user_id',auth()->user->id)->first();
// }
