<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\User;
use Auth;
use Illuminate\Support\Str;
use Illuminate\Foundation\Auth\RegistersUsers;
use Mail;
use App\Config;
use App\Mail\Contactus;
use App\sudani\SudaniRequest;
class MenuVideoController extends Controller
{

    use RegistersUsers;
    public function store(Request $request)
    {
        $phoneArray = str_split($request->phone);
        $phone="";
        $arrLength = count($phoneArray);
        for ($i = 1; $i < $arrLength; $i++) {
           $phone=$phone.$phoneArray[$i];
        }
        $phone = "249". $phone;

        $token = $request->token;
        if($request->phone == ""){
            return  back()->with('error', "رجاء ادخل الرقم")->with('login',"أدخل رقم من جديد")->with('token' , $token)->with('phone' , $phone);
        }
        $user = User::where('mobile', $phone)->first();
       
        if($user != null){
            if($user->status == 1){
               Auth::login($user);
               return redirect('/');
            }
        }

    try{
        $client = new \GuzzleHttp\Client();
        $response = $client->request(
            "POST",
            '196.1.241.110/SPayAPI/Service/InitPay/',
            [
                'headers' => [
                    'User-Agent' => "http-client/1.0",
                    "Accept" =>  "application/json",
                    "Content-Type" =>  "application/json",
                    "token" => $token
                ],
                'json' => [
                    'msisdn' =>$phone,
                    'serviceCode' =>  "7d490ed6-8244-479c-8863-c034266c8f20",
                    ]
            ]
        );
         $result = json_decode($response->getBody()->getContents());
        //return  $result;
       
         if(gettype($result->responseCode) == "integer")
         {
        
            if($result->responseCode == 1){
          // return $token ." &  ". $result->requestId;
                return   back()->with('InitPay', "أدخل الرمز مرسل في رساله")->with('token' , $token)->with('requestId',$result->requestId)->with('phone' , $phone);
        }else{
            if($result->responseCode == 121){
                $user = User::where('mobile', $request['phone'])->first();
        
                if ($user === null) {
                    $user = User::create([
                        'name' => $request['phone'],
                        'mobile' => $request['phone'],
                        'email' => $request['phone'].'@nxtlevel.com',
                        'is_admin' => 1,
                        'status' => 1,
                        'password' => bcrypt($request['phone']),
                        'verifyToken' => Str::random(40),
                    ]);
        
                    //return $user;
            
                  $user->assignRole('TZARole');
                   Auth::login($user);
                  return redirect('/');
        
        
                    
                 }else{
                    $user->status = 1;
                    $user->save();
                    Auth::login($user);
                    return redirect('/');
                 }
            }
            if($result->responseCode == 101){
                return back()->with('error', $result->responseMessage);
            }
            if($result->responseCode == 106){
                return  back()->with('error', "الرقم خطأ")->with('login',"الرجاء التأكد ان الرقم تابع لشركة سوداني")->with('token' , $token)->with('phone' , $phone);
            }
           
            return back()->with('error', "Something Wrong  ==  " . $result);
        }
        }
        
       
        return  $result;
    } catch (Exception $e) {
        $er =  $e->getMessage() ;
        return $er;
        }

    }


    public function payment(Request $request)
    {
        //return $request->token;
        if($request->pin ==""){
            return  back()->with('error', "رجاء ادخال الرمز" ) 
            ->with('InitPay', "أدخل الرمز مرسل في رساله")->with('token' ,$request->token)
            ->with('phone' , $request->phone)
            ->with('requestId',$request->requestId);    
        }


        $client = new \GuzzleHttp\Client();

        $response = $client->request(
            "POST",
            '196.1.241.110/SPayAPI/Service/Payment/',
            [
                'headers' => [
                    'User-Agent' => "http-client/1.0",
                    "Accept" =>  "application/json",
                    "Content-Type" =>  "application/json",
                    "token" => $request->token
                ],
                'json' => [
                    'pin' => $request->pin,
                    'requestId' => $request->requestId
                    ]
            ]
        );
        $result = json_decode($response->getBody()->getContents());
        //return $result;
        if($result->responseCode == 1 || $result->responseCode == 111 || $result->responseCode== 120){
            $user = User::where('mobile', $request['phone'])->first();
        
        if ($user === null) {
            $user = User::create([
                'name' => $request['phone'],
                'mobile' => $request['phone'],
                'email' => $request['phone'].'@nxtlevel.com',
                'is_admin' => 1,
                'status' => 1,
                'password' => bcrypt($request['phone']),
                'verifyToken' => Str::random(40),
            ]);

            //return $user;
    
          $user->assignRole('TZARole');
           Auth::login($user);
          return redirect('/');


            
         }else{
            $user->status = 1;
            $user->save();
            Auth::login($user);
            return redirect('/');
         }
        }else{

            if($result->responseCode == 105){
                return  back()->with('error', "الرمز غير صحيح , رجاء ادخال الرمز الصحيح" ) 
                ->with('InitPay', "أدخل الرمز مرسل في رساله")->with('token' ,$request->token)
                ->with('phone' , $request->phone)
                ->with('requestId',$request->requestId);    
            }

 
            return  back()->with('error', $result->responseMessage ) 
            ->with('InitPay', "أدخل الرمز مرسل في رساله")->with('token' ,$request->token)
            ->with('phone' , $request->phone)
            ->with('requestId',$request->requestId);
        }
    }

    public function UnSubscribe(Request $request){
        

        $phone = $request->phone;
        if($phone ==""){
            return  back()->with('error',"رجاءا ادخل الرقم" );
        }
        $phoneArray = str_split($request->phone);
        $phone="";
        $arrLength = count($phoneArray);
        for ($i = 1; $i < $arrLength; $i++) {
           $phone=$phone.$phoneArray[$i];
        }
        $phone = "249". $phone;
    
        if(Auth::user()->mobile != $phone){
            return  back()->with('error',"رجاء ادخل رقم الاشتراك الصحيح" );
        }

        $passw = "ECfv88baOkSCwujL+PdXv/C9ACXhNA4/O368wt1Q4WNwk8H7SywJLhJKV/J4cGpgrhSRJCTZjqOoKIKcn2duMMsWssA3A2mY/wCwarszat0SIhVbp/Pd/PoE3ixrhvkopNXvGqoYXRDo70isoEilNMaI+FcD2uKiNeI91l/3ftgA9awp48kfH7ryaID2XnzzsSBbXvpgK62IlgenKhQxSiAOk0g4+ok7+C2M14HqWo2jLFK4ZATX09s1ZUdc9FHTmnKdP6flU1bJ0dorbcMSmcJwnxBm0QUwWhxyNCRDu6GuehtnQx46d30YVSeE+F7wsyQmmNBSBqSh0o0J8h2nfw==";
        $client = new \GuzzleHttp\Client();

        
        $response = $client->request(
            "POST",
            '196.1.241.110/SPayAPI/Service/Login/',
            [
                'headers' => [
                    'User-Agent' => "http-client/1.0",
                    "Accept" =>  "application/json",
                    "Content-Type" =>  "application/json"
                ],
                'json' => [
                    'login' => "soofra",
                    'password' =>  $passw,
                    ]
            ]
        );
        $result = json_decode($response->getBody()->getContents());
        $token =  $result->token;
       

        try{
            $client = new \GuzzleHttp\Client();
            $response = $client->request(
                "POST",
                '196.1.241.110/SPayAPI/Service/UnSubscribe/',
                [
                    'headers' => [
                        'User-Agent' => "http-client/1.0",
                        "Accept" =>  "application/json",
                        "Content-Type" =>  "application/json",
                        "token" => $token
                    ],
                    'json' => [
                        'msisdn' =>$phone,
                        'serviceCode' =>  "7d490ed6-8244-479c-8863-c034266c8f20",
                        ]
                ]
            );
             $result = json_decode($response->getBody()->getContents());
            //return $result;
            
             if($result->responseCode ==1 || $result->responseCode ==116){
                $user =Auth::user();
                if ($user === null) {
                    return redirect('/');
                }else{
               
                $user->status = 0;
                $user->save();
                Auth::logout();
                return redirect('/');
                }
    
            }else{

                Auth::logout();
                return  back()->with('error', $result->responseMessage);
                //add error to AshView; 
            }

            } catch (Exception $e) {
                $er =  $e->getMessage() ;
                return $er;
                }
        
    }

    public function SudaniLogin(Request $request){
        //$phone = $request->phone;
        $phoneArray = str_split($request->phone);
        $phone="";
        $arrLength = count($phoneArray);
        for ($i = 1; $i < $arrLength; $i++) {
           $phone=$phone.$phoneArray[$i];
        }
        $phone = "249". $phone;

//return $phone;
        $user = User::where('mobile', $phone )->first();
        if ($user === null) {
            return back()->with('error', 'لست مشترك الرجاء التأكد من رقم الهاتف او الاشتراك');;
        }
        
        if($user->status == 0){
            return back()->with('error', ' لست مشترك الرجاء التأكد من رقم الهاتف او الاشتراك');
        }

        Auth::login($user);
            return redirect('/');

      
        

     }

    public function PushNotifiSD(Request $request){

        $phone = $request->msisdn;
        $user = User::where('mobile', $phone )->first();
        if($user != null){
        if($request->status == 0){
            $user->status = 0;
            $user->save();

        }else{
            $user->status = 1;
            $user->save();

        }
        return  ["responseMessage "=> "successful" ,
         "responseStatus"=> true ,
         "responseCode" =>200];

    }else{
        return  ["responseMessage "=> "failed" , "responseStatus"=> false , "responseCode" =>0];

    }


        return  ["Result "=> "data has fdsfdskds" , "phone"=> $phone];
    
    }

    public function send(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'email' => 'required|regex:/^.+@.+$/i',
            'subj' => 'required',
            'msg' => 'required',
        ],
            [
                'name.required' => 'Name cannot be empty',
                'email.required' => 'Email cannot be empty',
                'subj.required' => 'Please choose a subject',
                'msg.required' => 'Message caanot be empty',
            ]);

        $contact = array(
            'name' => $request->name,
            'email' => $request->email,
            'subj' => $request->subj,
            'msg' => $request->msg,
        );



        $defaultemail = Config::findOrFail(1)->w_email;
       $con = new Contactus($contact);
       //return $con;
        Mail::to($defaultemail)->send($con);
        return back()->with('success', 'Sent Succesfully, Thanks for contacting us!');
         
    }



    
}
