<?php
// This file was auto-generated from sdk-root/src/data/chime-sdk-messaging/2021-05-15/api-2.json
return [ 'version' => '2.0', 'metadata' => [ 'apiVersion' => '2021-05-15', 'endpointPrefix' => 'messaging-chime', 'protocol' => 'rest-json', 'serviceFullName' => 'Amazon Chime SDK Messaging', 'serviceId' => 'Chime SDK Messaging', 'signatureVersion' => 'v4', 'signingName' => 'chime', 'uid' => 'chime-sdk-messaging-2021-05-15', ], 'operations' => [ 'BatchCreateChannelMembership' => [ 'name' => 'BatchCreateChannelMembership', 'http' => [ 'method' => 'POST', 'requestUri' => '/channels/{channelArn}/memberships?operation=batch-create', 'responseCode' => 200, ], 'input' => [ 'shape' => 'BatchCreateChannelMembershipRequest', ], 'output' => [ 'shape' => 'BatchCreateChannelMembershipResponse', ], 'errors' => [ [ 'shape' => 'ServiceFailureException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'UnauthorizedClientException', ], [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'ThrottledClientException', ], ], ], 'CreateChannel' => [ 'name' => 'CreateChannel', 'http' => [ 'method' => 'POST', 'requestUri' => '/channels', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateChannelRequest', ], 'output' => [ 'shape' => 'CreateChannelResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'UnauthorizedClientException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ResourceLimitExceededException', ], [ 'shape' => 'ThrottledClientException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ServiceFailureException', ], ], ], 'CreateChannelBan' => [ 'name' => 'CreateChannelBan', 'http' => [ 'method' => 'POST', 'requestUri' => '/channels/{channelArn}/bans', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateChannelBanRequest', ], 'output' => [ 'shape' => 'CreateChannelBanResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'UnauthorizedClientException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ResourceLimitExceededException', ], [ 'shape' => 'ThrottledClientException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ServiceFailureException', ], ], ], 'CreateChannelMembership' => [ 'name' => 'CreateChannelMembership', 'http' => [ 'method' => 'POST', 'requestUri' => '/channels/{channelArn}/memberships', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateChannelMembershipRequest', ], 'output' => [ 'shape' => 'CreateChannelMembershipResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'UnauthorizedClientException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ResourceLimitExceededException', ], [ 'shape' => 'ThrottledClientException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ServiceFailureException', ], ], ], 'CreateChannelModerator' => [ 'name' => 'CreateChannelModerator', 'http' => [ 'method' => 'POST', 'requestUri' => '/channels/{channelArn}/moderators', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateChannelModeratorRequest', ], 'output' => [ 'shape' => 'CreateChannelModeratorResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'UnauthorizedClientException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ResourceLimitExceededException', ], [ 'shape' => 'ThrottledClientException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ServiceFailureException', ], ], ], 'DeleteChannel' => [ 'name' => 'DeleteChannel', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/channels/{channelArn}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteChannelRequest', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'UnauthorizedClientException', ], [ 'shape' => 'ThrottledClientException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ServiceFailureException', ], ], ], 'DeleteChannelBan' => [ 'name' => 'DeleteChannelBan', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/channels/{channelArn}/bans/{memberArn}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteChannelBanRequest', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'UnauthorizedClientException', ], [ 'shape' => 'ThrottledClientException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ServiceFailureException', ], ], ], 'DeleteChannelMembership' => [ 'name' => 'DeleteChannelMembership', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/channels/{channelArn}/memberships/{memberArn}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteChannelMembershipRequest', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'UnauthorizedClientException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottledClientException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ServiceFailureException', ], ], ], 'DeleteChannelMessage' => [ 'name' => 'DeleteChannelMessage', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/channels/{channelArn}/messages/{messageId}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteChannelMessageRequest', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'UnauthorizedClientException', ], [ 'shape' => 'ThrottledClientException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ServiceFailureException', ], ], ], 'DeleteChannelModerator' => [ 'name' => 'DeleteChannelModerator', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/channels/{channelArn}/moderators/{channelModeratorArn}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteChannelModeratorRequest', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'UnauthorizedClientException', ], [ 'shape' => 'ThrottledClientException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ServiceFailureException', ], ], ], 'DescribeChannel' => [ 'name' => 'DescribeChannel', 'http' => [ 'method' => 'GET', 'requestUri' => '/channels/{channelArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DescribeChannelRequest', ], 'output' => [ 'shape' => 'DescribeChannelResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'UnauthorizedClientException', ], [ 'shape' => 'ThrottledClientException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ServiceFailureException', ], ], ], 'DescribeChannelBan' => [ 'name' => 'DescribeChannelBan', 'http' => [ 'method' => 'GET', 'requestUri' => '/channels/{channelArn}/bans/{memberArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DescribeChannelBanRequest', ], 'output' => [ 'shape' => 'DescribeChannelBanResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'UnauthorizedClientException', ], [ 'shape' => 'ThrottledClientException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ServiceFailureException', ], ], ], 'DescribeChannelMembership' => [ 'name' => 'DescribeChannelMembership', 'http' => [ 'method' => 'GET', 'requestUri' => '/channels/{channelArn}/memberships/{memberArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DescribeChannelMembershipRequest', ], 'output' => [ 'shape' => 'DescribeChannelMembershipResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'UnauthorizedClientException', ], [ 'shape' => 'ThrottledClientException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ServiceFailureException', ], ], ], 'DescribeChannelMembershipForAppInstanceUser' => [ 'name' => 'DescribeChannelMembershipForAppInstanceUser', 'http' => [ 'method' => 'GET', 'requestUri' => '/channels/{channelArn}?scope=app-instance-user-membership', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DescribeChannelMembershipForAppInstanceUserRequest', ], 'output' => [ 'shape' => 'DescribeChannelMembershipForAppInstanceUserResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'UnauthorizedClientException', ], [ 'shape' => 'ThrottledClientException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ServiceFailureException', ], ], ], 'DescribeChannelModeratedByAppInstanceUser' => [ 'name' => 'DescribeChannelModeratedByAppInstanceUser', 'http' => [ 'method' => 'GET', 'requestUri' => '/channels/{channelArn}?scope=app-instance-user-moderated-channel', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DescribeChannelModeratedByAppInstanceUserRequest', ], 'output' => [ 'shape' => 'DescribeChannelModeratedByAppInstanceUserResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'UnauthorizedClientException', ], [ 'shape' => 'ThrottledClientException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ServiceFailureException', ], ], ], 'DescribeChannelModerator' => [ 'name' => 'DescribeChannelModerator', 'http' => [ 'method' => 'GET', 'requestUri' => '/channels/{channelArn}/moderators/{channelModeratorArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DescribeChannelModeratorRequest', ], 'output' => [ 'shape' => 'DescribeChannelModeratorResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'UnauthorizedClientException', ], [ 'shape' => 'ThrottledClientException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ServiceFailureException', ], ], ], 'GetChannelMessage' => [ 'name' => 'GetChannelMessage', 'http' => [ 'method' => 'GET', 'requestUri' => '/channels/{channelArn}/messages/{messageId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetChannelMessageRequest', ], 'output' => [ 'shape' => 'GetChannelMessageResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'UnauthorizedClientException', ], [ 'shape' => 'ThrottledClientException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ServiceFailureException', ], ], ], 'GetMessagingSessionEndpoint' => [ 'name' => 'GetMessagingSessionEndpoint', 'http' => [ 'method' => 'GET', 'requestUri' => '/endpoints/messaging-session', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetMessagingSessionEndpointRequest', ], 'output' => [ 'shape' => 'GetMessagingSessionEndpointResponse', ], 'errors' => [ [ 'shape' => 'UnauthorizedClientException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'ThrottledClientException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ServiceFailureException', ], ], ], 'ListChannelBans' => [ 'name' => 'ListChannelBans', 'http' => [ 'method' => 'GET', 'requestUri' => '/channels/{channelArn}/bans', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListChannelBansRequest', ], 'output' => [ 'shape' => 'ListChannelBansResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'UnauthorizedClientException', ], [ 'shape' => 'ThrottledClientException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ServiceFailureException', ], ], ], 'ListChannelMemberships' => [ 'name' => 'ListChannelMemberships', 'http' => [ 'method' => 'GET', 'requestUri' => '/channels/{channelArn}/memberships', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListChannelMembershipsRequest', ], 'output' => [ 'shape' => 'ListChannelMembershipsResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'UnauthorizedClientException', ], [ 'shape' => 'ThrottledClientException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ServiceFailureException', ], ], ], 'ListChannelMembershipsForAppInstanceUser' => [ 'name' => 'ListChannelMembershipsForAppInstanceUser', 'http' => [ 'method' => 'GET', 'requestUri' => '/channels?scope=app-instance-user-memberships', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListChannelMembershipsForAppInstanceUserRequest', ], 'output' => [ 'shape' => 'ListChannelMembershipsForAppInstanceUserResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'UnauthorizedClientException', ], [ 'shape' => 'ThrottledClientException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ServiceFailureException', ], ], ], 'ListChannelMessages' => [ 'name' => 'ListChannelMessages', 'http' => [ 'method' => 'GET', 'requestUri' => '/channels/{channelArn}/messages', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListChannelMessagesRequest', ], 'output' => [ 'shape' => 'ListChannelMessagesResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'UnauthorizedClientException', ], [ 'shape' => 'ThrottledClientException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ServiceFailureException', ], ], ], 'ListChannelModerators' => [ 'name' => 'ListChannelModerators', 'http' => [ 'method' => 'GET', 'requestUri' => '/channels/{channelArn}/moderators', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListChannelModeratorsRequest', ], 'output' => [ 'shape' => 'ListChannelModeratorsResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'UnauthorizedClientException', ], [ 'shape' => 'ThrottledClientException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ServiceFailureException', ], ], ], 'ListChannels' => [ 'name' => 'ListChannels', 'http' => [ 'method' => 'GET', 'requestUri' => '/channels', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListChannelsRequest', ], 'output' => [ 'shape' => 'ListChannelsResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'UnauthorizedClientException', ], [ 'shape' => 'ThrottledClientException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ServiceFailureException', ], ], ], 'ListChannelsModeratedByAppInstanceUser' => [ 'name' => 'ListChannelsModeratedByAppInstanceUser', 'http' => [ 'method' => 'GET', 'requestUri' => '/channels?scope=app-instance-user-moderated-channels', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListChannelsModeratedByAppInstanceUserRequest', ], 'output' => [ 'shape' => 'ListChannelsModeratedByAppInstanceUserResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'UnauthorizedClientException', ], [ 'shape' => 'ThrottledClientException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ServiceFailureException', ], ], ], 'RedactChannelMessage' => [ 'name' => 'RedactChannelMessage', 'http' => [ 'method' => 'POST', 'requestUri' => '/channels/{channelArn}/messages/{messageId}?operation=redact', 'responseCode' => 200, ], 'input' => [ 'shape' => 'RedactChannelMessageRequest', ], 'output' => [ 'shape' => 'RedactChannelMessageResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'UnauthorizedClientException', ], [ 'shape' => 'ThrottledClientException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ServiceFailureException', ], ], ], 'SendChannelMessage' => [ 'name' => 'SendChannelMessage', 'http' => [ 'method' => 'POST', 'requestUri' => '/channels/{channelArn}/messages', 'responseCode' => 201, ], 'input' => [ 'shape' => 'SendChannelMessageRequest', ], 'output' => [ 'shape' => 'SendChannelMessageResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'UnauthorizedClientException', ], [ 'shape' => 'ThrottledClientException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ServiceFailureException', ], ], ], 'UpdateChannel' => [ 'name' => 'UpdateChannel', 'http' => [ 'method' => 'PUT', 'requestUri' => '/channels/{channelArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateChannelRequest', ], 'output' => [ 'shape' => 'UpdateChannelResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'UnauthorizedClientException', ], [ 'shape' => 'ThrottledClientException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ServiceFailureException', ], ], ], 'UpdateChannelMessage' => [ 'name' => 'UpdateChannelMessage', 'http' => [ 'method' => 'PUT', 'requestUri' => '/channels/{channelArn}/messages/{messageId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateChannelMessageRequest', ], 'output' => [ 'shape' => 'UpdateChannelMessageResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'UnauthorizedClientException', ], [ 'shape' => 'ThrottledClientException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ServiceFailureException', ], ], ], 'UpdateChannelReadMarker' => [ 'name' => 'UpdateChannelReadMarker', 'http' => [ 'method' => 'PUT', 'requestUri' => '/channels/{channelArn}/readMarker', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateChannelReadMarkerRequest', ], 'output' => [ 'shape' => 'UpdateChannelReadMarkerResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'UnauthorizedClientException', ], [ 'shape' => 'ThrottledClientException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ServiceFailureException', ], ], ], ], 'shapes' => [ 'AppInstanceUserMembershipSummary' => [ 'type' => 'structure', 'members' => [ 'Type' => [ 'shape' => 'ChannelMembershipType', ], 'ReadMarkerTimestamp' => [ 'shape' => 'Timestamp', ], ], ], 'BadRequestException' => [ 'type' => 'structure', 'members' => [ 'Code' => [ 'shape' => 'ErrorCode', ], 'Message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], 'BatchChannelMemberships' => [ 'type' => 'structure', 'members' => [ 'InvitedBy' => [ 'shape' => 'Identity', ], 'Type' => [ 'shape' => 'ChannelMembershipType', ], 'Members' => [ 'shape' => 'Members', ], 'ChannelArn' => [ 'shape' => 'ChimeArn', ], ], ], 'BatchCreateChannelMembershipError' => [ 'type' => 'structure', 'members' => [ 'MemberArn' => [ 'shape' => 'ChimeArn', ], 'ErrorCode' => [ 'shape' => 'ErrorCode', ], 'ErrorMessage' => [ 'shape' => 'String', ], ], ], 'BatchCreateChannelMembershipErrors' => [ 'type' => 'list', 'member' => [ 'shape' => 'BatchCreateChannelMembershipError', ], ], 'BatchCreateChannelMembershipRequest' => [ 'type' => 'structure', 'required' => [ 'ChannelArn', 'MemberArns', 'ChimeBearer', ], 'members' => [ 'ChannelArn' => [ 'shape' => 'ChimeArn', 'location' => 'uri', 'locationName' => 'channelArn', ], 'Type' => [ 'shape' => 'ChannelMembershipType', ], 'MemberArns' => [ 'shape' => 'MemberArns', ], 'ChimeBearer' => [ 'shape' => 'ChimeArn', 'location' => 'header', 'locationName' => 'x-amz-chime-bearer', ], ], ], 'BatchCreateChannelMembershipResponse' => [ 'type' => 'structure', 'members' => [ 'BatchChannelMemberships' => [ 'shape' => 'BatchChannelMemberships', ], 'Errors' => [ 'shape' => 'BatchCreateChannelMembershipErrors', ], ], ], 'Channel' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'NonEmptyResourceName', ], 'ChannelArn' => [ 'shape' => 'ChimeArn', ], 'Mode' => [ 'shape' => 'ChannelMode', ], 'Privacy' => [ 'shape' => 'ChannelPrivacy', ], 'Metadata' => [ 'shape' => 'Metadata', ], 'CreatedBy' => [ 'shape' => 'Identity', ], 'CreatedTimestamp' => [ 'shape' => 'Timestamp', ], 'LastMessageTimestamp' => [ 'shape' => 'Timestamp', ], 'LastUpdatedTimestamp' => [ 'shape' => 'Timestamp', ], ], ], 'ChannelBan' => [ 'type' => 'structure', 'members' => [ 'Member' => [ 'shape' => 'Identity', ], 'ChannelArn' => [ 'shape' => 'ChimeArn', ], 'CreatedTimestamp' => [ 'shape' => 'Timestamp', ], 'CreatedBy' => [ 'shape' => 'Identity', ], ], ], 'ChannelBanSummary' => [ 'type' => 'structure', 'members' => [ 'Member' => [ 'shape' => 'Identity', ], ], ], 'ChannelBanSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ChannelBanSummary', ], ], 'ChannelMembership' => [ 'type' => 'structure', 'members' => [ 'InvitedBy' => [ 'shape' => 'Identity', ], 'Type' => [ 'shape' => 'ChannelMembershipType', ], 'Member' => [ 'shape' => 'Identity', ], 'ChannelArn' => [ 'shape' => 'ChimeArn', ], 'CreatedTimestamp' => [ 'shape' => 'Timestamp', ], 'LastUpdatedTimestamp' => [ 'shape' => 'Timestamp', ], ], ], 'ChannelMembershipForAppInstanceUserSummary' => [ 'type' => 'structure', 'members' => [ 'ChannelSummary' => [ 'shape' => 'ChannelSummary', ], 'AppInstanceUserMembershipSummary' => [ 'shape' => 'AppInstanceUserMembershipSummary', ], ], ], 'ChannelMembershipForAppInstanceUserSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ChannelMembershipForAppInstanceUserSummary', ], ], 'ChannelMembershipSummary' => [ 'type' => 'structure', 'members' => [ 'Member' => [ 'shape' => 'Identity', ], ], ], 'ChannelMembershipSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ChannelMembershipSummary', ], ], 'ChannelMembershipType' => [ 'type' => 'string', 'enum' => [ 'DEFAULT', 'HIDDEN', ], ], 'ChannelMessage' => [ 'type' => 'structure', 'members' => [ 'ChannelArn' => [ 'shape' => 'ChimeArn', ], 'MessageId' => [ 'shape' => 'MessageId', ], 'Content' => [ 'shape' => 'Content', ], 'Metadata' => [ 'shape' => 'Metadata', ], 'Type' => [ 'shape' => 'ChannelMessageType', ], 'CreatedTimestamp' => [ 'shape' => 'Timestamp', ], 'LastEditedTimestamp' => [ 'shape' => 'Timestamp', ], 'LastUpdatedTimestamp' => [ 'shape' => 'Timestamp', ], 'Sender' => [ 'shape' => 'Identity', ], 'Redacted' => [ 'shape' => 'NonNullableBoolean', ], 'Persistence' => [ 'shape' => 'ChannelMessagePersistenceType', ], ], ], 'ChannelMessagePersistenceType' => [ 'type' => 'string', 'enum' => [ 'PERSISTENT', 'NON_PERSISTENT', ], ], 'ChannelMessageSummary' => [ 'type' => 'structure', 'members' => [ 'MessageId' => [ 'shape' => 'MessageId', ], 'Content' => [ 'shape' => 'Content', ], 'Metadata' => [ 'shape' => 'Metadata', ], 'Type' => [ 'shape' => 'ChannelMessageType', ], 'CreatedTimestamp' => [ 'shape' => 'Timestamp', ], 'LastUpdatedTimestamp' => [ 'shape' => 'Timestamp', ], 'LastEditedTimestamp' => [ 'shape' => 'Timestamp', ], 'Sender' => [ 'shape' => 'Identity', ], 'Redacted' => [ 'shape' => 'NonNullableBoolean', ], ], ], 'ChannelMessageSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ChannelMessageSummary', ], ], 'ChannelMessageType' => [ 'type' => 'string', 'enum' => [ 'STANDARD', 'CONTROL', ], ], 'ChannelMode' => [ 'type' => 'string', 'enum' => [ 'UNRESTRICTED', 'RESTRICTED', ], ], 'ChannelModeratedByAppInstanceUserSummary' => [ 'type' => 'structure', 'members' => [ 'ChannelSummary' => [ 'shape' => 'ChannelSummary', ], ], ], 'ChannelModeratedByAppInstanceUserSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ChannelModeratedByAppInstanceUserSummary', ], ], 'ChannelModerator' => [ 'type' => 'structure', 'members' => [ 'Moderator' => [ 'shape' => 'Identity', ], 'ChannelArn' => [ 'shape' => 'ChimeArn', ], 'CreatedTimestamp' => [ 'shape' => 'Timestamp', ], 'CreatedBy' => [ 'shape' => 'Identity', ], ], ], 'ChannelModeratorSummary' => [ 'type' => 'structure', 'members' => [ 'Moderator' => [ 'shape' => 'Identity', ], ], ], 'ChannelModeratorSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ChannelModeratorSummary', ], ], 'ChannelPrivacy' => [ 'type' => 'string', 'enum' => [ 'PUBLIC', 'PRIVATE', ], ], 'ChannelSummary' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'NonEmptyResourceName', ], 'ChannelArn' => [ 'shape' => 'ChimeArn', ], 'Mode' => [ 'shape' => 'ChannelMode', ], 'Privacy' => [ 'shape' => 'ChannelPrivacy', ], 'Metadata' => [ 'shape' => 'Metadata', ], 'LastMessageTimestamp' => [ 'shape' => 'Timestamp', ], ], ], 'ChannelSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ChannelSummary', ], ], 'ChimeArn' => [ 'type' => 'string', 'max' => 1600, 'min' => 5, 'pattern' => 'arn:[a-z0-9-\\.]{1,63}:[a-z0-9-\\.]{0,63}:[a-z0-9-\\.]{0,63}:[a-z0-9-\\.]{0,63}:[^/].{0,1023}', ], 'ClientRequestToken' => [ 'type' => 'string', 'max' => 64, 'min' => 2, 'pattern' => '[-_a-zA-Z0-9]*', 'sensitive' => true, ], 'ConflictException' => [ 'type' => 'structure', 'members' => [ 'Code' => [ 'shape' => 'ErrorCode', ], 'Message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 409, ], 'exception' => true, ], 'Content' => [ 'type' => 'string', 'max' => 4096, 'min' => 0, 'pattern' => '[\\s\\S]*', 'sensitive' => true, ], 'CreateChannelBanRequest' => [ 'type' => 'structure', 'required' => [ 'ChannelArn', 'MemberArn', 'ChimeBearer', ], 'members' => [ 'ChannelArn' => [ 'shape' => 'ChimeArn', 'location' => 'uri', 'locationName' => 'channelArn', ], 'MemberArn' => [ 'shape' => 'ChimeArn', ], 'ChimeBearer' => [ 'shape' => 'ChimeArn', 'location' => 'header', 'locationName' => 'x-amz-chime-bearer', ], ], ], 'CreateChannelBanResponse' => [ 'type' => 'structure', 'members' => [ 'ChannelArn' => [ 'shape' => 'ChimeArn', ], 'Member' => [ 'shape' => 'Identity', ], ], ], 'CreateChannelMembershipRequest' => [ 'type' => 'structure', 'required' => [ 'ChannelArn', 'MemberArn', 'Type', 'ChimeBearer', ], 'members' => [ 'ChannelArn' => [ 'shape' => 'ChimeArn', 'location' => 'uri', 'locationName' => 'channelArn', ], 'MemberArn' => [ 'shape' => 'ChimeArn', ], 'Type' => [ 'shape' => 'ChannelMembershipType', ], 'ChimeBearer' => [ 'shape' => 'ChimeArn', 'location' => 'header', 'locationName' => 'x-amz-chime-bearer', ], ], ], 'CreateChannelMembershipResponse' => [ 'type' => 'structure', 'members' => [ 'ChannelArn' => [ 'shape' => 'ChimeArn', ], 'Member' => [ 'shape' => 'Identity', ], ], ], 'CreateChannelModeratorRequest' => [ 'type' => 'structure', 'required' => [ 'ChannelArn', 'ChannelModeratorArn', 'ChimeBearer', ], 'members' => [ 'ChannelArn' => [ 'shape' => 'ChimeArn', 'location' => 'uri', 'locationName' => 'channelArn', ], 'ChannelModeratorArn' => [ 'shape' => 'ChimeArn', ], 'ChimeBearer' => [ 'shape' => 'ChimeArn', 'location' => 'header', 'locationName' => 'x-amz-chime-bearer', ], ], ], 'CreateChannelModeratorResponse' => [ 'type' => 'structure', 'members' => [ 'ChannelArn' => [ 'shape' => 'ChimeArn', ], 'ChannelModerator' => [ 'shape' => 'Identity', ], ], ], 'CreateChannelRequest' => [ 'type' => 'structure', 'required' => [ 'AppInstanceArn', 'Name', 'ClientRequestToken', 'ChimeBearer', ], 'members' => [ 'AppInstanceArn' => [ 'shape' => 'ChimeArn', ], 'Name' => [ 'shape' => 'NonEmptyResourceName', ], 'Mode' => [ 'shape' => 'ChannelMode', ], 'Privacy' => [ 'shape' => 'ChannelPrivacy', ], 'Metadata' => [ 'shape' => 'Metadata', ], 'ClientRequestToken' => [ 'shape' => 'ClientRequestToken', 'idempotencyToken' => true, ], 'Tags' => [ 'shape' => 'TagList', ], 'ChimeBearer' => [ 'shape' => 'ChimeArn', 'location' => 'header', 'locationName' => 'x-amz-chime-bearer', ], ], ], 'CreateChannelResponse' => [ 'type' => 'structure', 'members' => [ 'ChannelArn' => [ 'shape' => 'ChimeArn', ], ], ], 'DeleteChannelBanRequest' => [ 'type' => 'structure', 'required' => [ 'ChannelArn', 'MemberArn', 'ChimeBearer', ], 'members' => [ 'ChannelArn' => [ 'shape' => 'ChimeArn', 'location' => 'uri', 'locationName' => 'channelArn', ], 'MemberArn' => [ 'shape' => 'ChimeArn', 'location' => 'uri', 'locationName' => 'memberArn', ], 'ChimeBearer' => [ 'shape' => 'ChimeArn', 'location' => 'header', 'locationName' => 'x-amz-chime-bearer', ], ], ], 'DeleteChannelMembershipRequest' => [ 'type' => 'structure', 'required' => [ 'ChannelArn', 'MemberArn', 'ChimeBearer', ], 'members' => [ 'ChannelArn' => [ 'shape' => 'ChimeArn', 'location' => 'uri', 'locationName' => 'channelArn', ], 'MemberArn' => [ 'shape' => 'ChimeArn', 'location' => 'uri', 'locationName' => 'memberArn', ], 'ChimeBearer' => [ 'shape' => 'ChimeArn', 'location' => 'header', 'locationName' => 'x-amz-chime-bearer', ], ], ], 'DeleteChannelMessageRequest' => [ 'type' => 'structure', 'required' => [ 'ChannelArn', 'MessageId', 'ChimeBearer', ], 'members' => [ 'ChannelArn' => [ 'shape' => 'ChimeArn', 'location' => 'uri', 'locationName' => 'channelArn', ], 'MessageId' => [ 'shape' => 'MessageId', 'location' => 'uri', 'locationName' => 'messageId', ], 'ChimeBearer' => [ 'shape' => 'ChimeArn', 'location' => 'header', 'locationName' => 'x-amz-chime-bearer', ], ], ], 'DeleteChannelModeratorRequest' => [ 'type' => 'structure', 'required' => [ 'ChannelArn', 'ChannelModeratorArn', 'ChimeBearer', ], 'members' => [ 'ChannelArn' => [ 'shape' => 'ChimeArn', 'location' => 'uri', 'locationName' => 'channelArn', ], 'ChannelModeratorArn' => [ 'shape' => 'ChimeArn', 'location' => 'uri', 'locationName' => 'channelModeratorArn', ], 'ChimeBearer' => [ 'shape' => 'ChimeArn', 'location' => 'header', 'locationName' => 'x-amz-chime-bearer', ], ], ], 'DeleteChannelRequest' => [ 'type' => 'structure', 'required' => [ 'ChannelArn', 'ChimeBearer', ], 'members' => [ 'ChannelArn' => [ 'shape' => 'ChimeArn', 'location' => 'uri', 'locationName' => 'channelArn', ], 'ChimeBearer' => [ 'shape' => 'ChimeArn', 'location' => 'header', 'locationName' => 'x-amz-chime-bearer', ], ], ], 'DescribeChannelBanRequest' => [ 'type' => 'structure', 'required' => [ 'ChannelArn', 'MemberArn', 'ChimeBearer', ], 'members' => [ 'ChannelArn' => [ 'shape' => 'ChimeArn', 'location' => 'uri', 'locationName' => 'channelArn', ], 'MemberArn' => [ 'shape' => 'ChimeArn', 'location' => 'uri', 'locationName' => 'memberArn', ], 'ChimeBearer' => [ 'shape' => 'ChimeArn', 'location' => 'header', 'locationName' => 'x-amz-chime-bearer', ], ], ], 'DescribeChannelBanResponse' => [ 'type' => 'structure', 'members' => [ 'ChannelBan' => [ 'shape' => 'ChannelBan', ], ], ], 'DescribeChannelMembershipForAppInstanceUserRequest' => [ 'type' => 'structure', 'required' => [ 'ChannelArn', 'AppInstanceUserArn', 'ChimeBearer', ], 'members' => [ 'ChannelArn' => [ 'shape' => 'ChimeArn', 'location' => 'uri', 'locationName' => 'channelArn', ], 'AppInstanceUserArn' => [ 'shape' => 'ChimeArn', 'location' => 'querystring', 'locationName' => 'app-instance-user-arn', ], 'ChimeBearer' => [ 'shape' => 'ChimeArn', 'location' => 'header', 'locationName' => 'x-amz-chime-bearer', ], ], ], 'DescribeChannelMembershipForAppInstanceUserResponse' => [ 'type' => 'structure', 'members' => [ 'ChannelMembership' => [ 'shape' => 'ChannelMembershipForAppInstanceUserSummary', ], ], ], 'DescribeChannelMembershipRequest' => [ 'type' => 'structure', 'required' => [ 'ChannelArn', 'MemberArn', 'ChimeBearer', ], 'members' => [ 'ChannelArn' => [ 'shape' => 'ChimeArn', 'location' => 'uri', 'locationName' => 'channelArn', ], 'MemberArn' => [ 'shape' => 'ChimeArn', 'location' => 'uri', 'locationName' => 'memberArn', ], 'ChimeBearer' => [ 'shape' => 'ChimeArn', 'location' => 'header', 'locationName' => 'x-amz-chime-bearer', ], ], ], 'DescribeChannelMembershipResponse' => [ 'type' => 'structure', 'members' => [ 'ChannelMembership' => [ 'shape' => 'ChannelMembership', ], ], ], 'DescribeChannelModeratedByAppInstanceUserRequest' => [ 'type' => 'structure', 'required' => [ 'ChannelArn', 'AppInstanceUserArn', 'ChimeBearer', ], 'members' => [ 'ChannelArn' => [ 'shape' => 'ChimeArn', 'location' => 'uri', 'locationName' => 'channelArn', ], 'AppInstanceUserArn' => [ 'shape' => 'ChimeArn', 'location' => 'querystring', 'locationName' => 'app-instance-user-arn', ], 'ChimeBearer' => [ 'shape' => 'ChimeArn', 'location' => 'header', 'locationName' => 'x-amz-chime-bearer', ], ], ], 'DescribeChannelModeratedByAppInstanceUserResponse' => [ 'type' => 'structure', 'members' => [ 'Channel' => [ 'shape' => 'ChannelModeratedByAppInstanceUserSummary', ], ], ], 'DescribeChannelModeratorRequest' => [ 'type' => 'structure', 'required' => [ 'ChannelArn', 'ChannelModeratorArn', 'ChimeBearer', ], 'members' => [ 'ChannelArn' => [ 'shape' => 'ChimeArn', 'location' => 'uri', 'locationName' => 'channelArn', ], 'ChannelModeratorArn' => [ 'shape' => 'ChimeArn', 'location' => 'uri', 'locationName' => 'channelModeratorArn', ], 'ChimeBearer' => [ 'shape' => 'ChimeArn', 'location' => 'header', 'locationName' => 'x-amz-chime-bearer', ], ], ], 'DescribeChannelModeratorResponse' => [ 'type' => 'structure', 'members' => [ 'ChannelModerator' => [ 'shape' => 'ChannelModerator', ], ], ], 'DescribeChannelRequest' => [ 'type' => 'structure', 'required' => [ 'ChannelArn', 'ChimeBearer', ], 'members' => [ 'ChannelArn' => [ 'shape' => 'ChimeArn', 'location' => 'uri', 'locationName' => 'channelArn', ], 'ChimeBearer' => [ 'shape' => 'ChimeArn', 'location' => 'header', 'locationName' => 'x-amz-chime-bearer', ], ], ], 'DescribeChannelResponse' => [ 'type' => 'structure', 'members' => [ 'Channel' => [ 'shape' => 'Channel', ], ], ], 'ErrorCode' => [ 'type' => 'string', 'enum' => [ 'BadRequest', 'Conflict', 'Forbidden', 'NotFound', 'PreconditionFailed', 'ResourceLimitExceeded', 'ServiceFailure', 'AccessDenied', 'ServiceUnavailable', 'Throttled', 'Throttling', 'Unauthorized', 'Unprocessable', 'VoiceConnectorGroupAssociationsExist', 'PhoneNumberAssociationsExist', ], ], 'ForbiddenException' => [ 'type' => 'structure', 'members' => [ 'Code' => [ 'shape' => 'ErrorCode', ], 'Message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 403, ], 'exception' => true, ], 'GetChannelMessageRequest' => [ 'type' => 'structure', 'required' => [ 'ChannelArn', 'MessageId', 'ChimeBearer', ], 'members' => [ 'ChannelArn' => [ 'shape' => 'ChimeArn', 'location' => 'uri', 'locationName' => 'channelArn', ], 'MessageId' => [ 'shape' => 'MessageId', 'location' => 'uri', 'locationName' => 'messageId', ], 'ChimeBearer' => [ 'shape' => 'ChimeArn', 'location' => 'header', 'locationName' => 'x-amz-chime-bearer', ], ], ], 'GetChannelMessageResponse' => [ 'type' => 'structure', 'members' => [ 'ChannelMessage' => [ 'shape' => 'ChannelMessage', ], ], ], 'GetMessagingSessionEndpointRequest' => [ 'type' => 'structure', 'members' => [], ], 'GetMessagingSessionEndpointResponse' => [ 'type' => 'structure', 'members' => [ 'Endpoint' => [ 'shape' => 'MessagingSessionEndpoint', ], ], ], 'Identity' => [ 'type' => 'structure', 'members' => [ 'Arn' => [ 'shape' => 'ChimeArn', ], 'Name' => [ 'shape' => 'ResourceName', ], ], ], 'ListChannelBansRequest' => [ 'type' => 'structure', 'required' => [ 'ChannelArn', 'ChimeBearer', ], 'members' => [ 'ChannelArn' => [ 'shape' => 'ChimeArn', 'location' => 'uri', 'locationName' => 'channelArn', ], 'MaxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'max-results', ], 'NextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'next-token', ], 'ChimeBearer' => [ 'shape' => 'ChimeArn', 'location' => 'header', 'locationName' => 'x-amz-chime-bearer', ], ], ], 'ListChannelBansResponse' => [ 'type' => 'structure', 'members' => [ 'ChannelArn' => [ 'shape' => 'ChimeArn', ], 'NextToken' => [ 'shape' => 'NextToken', ], 'ChannelBans' => [ 'shape' => 'ChannelBanSummaryList', ], ], ], 'ListChannelMembershipsForAppInstanceUserRequest' => [ 'type' => 'structure', 'required' => [ 'ChimeBearer', ], 'members' => [ 'AppInstanceUserArn' => [ 'shape' => 'ChimeArn', 'location' => 'querystring', 'locationName' => 'app-instance-user-arn', ], 'MaxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'max-results', ], 'NextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'next-token', ], 'ChimeBearer' => [ 'shape' => 'ChimeArn', 'location' => 'header', 'locationName' => 'x-amz-chime-bearer', ], ], ], 'ListChannelMembershipsForAppInstanceUserResponse' => [ 'type' => 'structure', 'members' => [ 'ChannelMemberships' => [ 'shape' => 'ChannelMembershipForAppInstanceUserSummaryList', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListChannelMembershipsRequest' => [ 'type' => 'structure', 'required' => [ 'ChannelArn', 'ChimeBearer', ], 'members' => [ 'ChannelArn' => [ 'shape' => 'ChimeArn', 'location' => 'uri', 'locationName' => 'channelArn', ], 'Type' => [ 'shape' => 'ChannelMembershipType', 'location' => 'querystring', 'locationName' => 'type', ], 'MaxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'max-results', ], 'NextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'next-token', ], 'ChimeBearer' => [ 'shape' => 'ChimeArn', 'location' => 'header', 'locationName' => 'x-amz-chime-bearer', ], ], ], 'ListChannelMembershipsResponse' => [ 'type' => 'structure', 'members' => [ 'ChannelArn' => [ 'shape' => 'ChimeArn', ], 'ChannelMemberships' => [ 'shape' => 'ChannelMembershipSummaryList', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListChannelMessagesRequest' => [ 'type' => 'structure', 'required' => [ 'ChannelArn', 'ChimeBearer', ], 'members' => [ 'ChannelArn' => [ 'shape' => 'ChimeArn', 'location' => 'uri', 'locationName' => 'channelArn', ], 'SortOrder' => [ 'shape' => 'SortOrder', 'location' => 'querystring', 'locationName' => 'sort-order', ], 'NotBefore' => [ 'shape' => 'Timestamp', 'location' => 'querystring', 'locationName' => 'not-before', ], 'NotAfter' => [ 'shape' => 'Timestamp', 'location' => 'querystring', 'locationName' => 'not-after', ], 'MaxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'max-results', ], 'NextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'next-token', ], 'ChimeBearer' => [ 'shape' => 'ChimeArn', 'location' => 'header', 'locationName' => 'x-amz-chime-bearer', ], ], ], 'ListChannelMessagesResponse' => [ 'type' => 'structure', 'members' => [ 'ChannelArn' => [ 'shape' => 'ChimeArn', ], 'NextToken' => [ 'shape' => 'NextToken', ], 'ChannelMessages' => [ 'shape' => 'ChannelMessageSummaryList', ], ], ], 'ListChannelModeratorsRequest' => [ 'type' => 'structure', 'required' => [ 'ChannelArn', 'ChimeBearer', ], 'members' => [ 'ChannelArn' => [ 'shape' => 'ChimeArn', 'location' => 'uri', 'locationName' => 'channelArn', ], 'MaxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'max-results', ], 'NextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'next-token', ], 'ChimeBearer' => [ 'shape' => 'ChimeArn', 'location' => 'header', 'locationName' => 'x-amz-chime-bearer', ], ], ], 'ListChannelModeratorsResponse' => [ 'type' => 'structure', 'members' => [ 'ChannelArn' => [ 'shape' => 'ChimeArn', ], 'NextToken' => [ 'shape' => 'NextToken', ], 'ChannelModerators' => [ 'shape' => 'ChannelModeratorSummaryList', ], ], ], 'ListChannelsModeratedByAppInstanceUserRequest' => [ 'type' => 'structure', 'required' => [ 'ChimeBearer', ], 'members' => [ 'AppInstanceUserArn' => [ 'shape' => 'ChimeArn', 'location' => 'querystring', 'locationName' => 'app-instance-user-arn', ], 'MaxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'max-results', ], 'NextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'next-token', ], 'ChimeBearer' => [ 'shape' => 'ChimeArn', 'location' => 'header', 'locationName' => 'x-amz-chime-bearer', ], ], ], 'ListChannelsModeratedByAppInstanceUserResponse' => [ 'type' => 'structure', 'members' => [ 'Channels' => [ 'shape' => 'ChannelModeratedByAppInstanceUserSummaryList', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListChannelsRequest' => [ 'type' => 'structure', 'required' => [ 'AppInstanceArn', 'ChimeBearer', ], 'members' => [ 'AppInstanceArn' => [ 'shape' => 'ChimeArn', 'location' => 'querystring', 'locationName' => 'app-instance-arn', ], 'Privacy' => [ 'shape' => 'ChannelPrivacy', 'location' => 'querystring', 'locationName' => 'privacy', ], 'MaxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'max-results', ], 'NextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'next-token', ], 'ChimeBearer' => [ 'shape' => 'ChimeArn', 'location' => 'header', 'locationName' => 'x-amz-chime-bearer', ], ], ], 'ListChannelsResponse' => [ 'type' => 'structure', 'members' => [ 'Channels' => [ 'shape' => 'ChannelSummaryList', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'MaxResults' => [ 'type' => 'integer', 'max' => 50, 'min' => 1, ], 'MemberArns' => [ 'type' => 'list', 'member' => [ 'shape' => 'ChimeArn', ], 'max' => 100, 'min' => 1, ], 'Members' => [ 'type' => 'list', 'member' => [ 'shape' => 'Identity', ], ], 'MessageId' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '[-_a-zA-Z0-9]*', ], 'MessagingSessionEndpoint' => [ 'type' => 'structure', 'members' => [ 'Url' => [ 'shape' => 'UrlType', ], ], ], 'Metadata' => [ 'type' => 'string', 'max' => 1024, 'min' => 0, 'pattern' => '.*', 'sensitive' => true, ], 'NextToken' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, 'pattern' => '.*', 'sensitive' => true, ], 'NonEmptyContent' => [ 'type' => 'string', 'min' => 1, 'pattern' => '[\\s\\S]*', 'sensitive' => true, ], 'NonEmptyResourceName' => [ 'type' => 'string', 'max' => 256, 'min' => 1, 'pattern' => '[\\u0009\\u000A\\u000D\\u0020-\\u007E\\u0085\\u00A0-\\uD7FF\\uE000-\\uFFFD\\u10000-\\u10FFFF]*', 'sensitive' => true, ], 'NonNullableBoolean' => [ 'type' => 'boolean', ], 'NotFoundException' => [ 'type' => 'structure', 'members' => [ 'Code' => [ 'shape' => 'ErrorCode', ], 'Message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], 'RedactChannelMessageRequest' => [ 'type' => 'structure', 'required' => [ 'ChannelArn', 'MessageId', 'ChimeBearer', ], 'members' => [ 'ChannelArn' => [ 'shape' => 'ChimeArn', 'location' => 'uri', 'locationName' => 'channelArn', ], 'MessageId' => [ 'shape' => 'MessageId', 'location' => 'uri', 'locationName' => 'messageId', ], 'ChimeBearer' => [ 'shape' => 'ChimeArn', 'location' => 'header', 'locationName' => 'x-amz-chime-bearer', ], ], ], 'RedactChannelMessageResponse' => [ 'type' => 'structure', 'members' => [ 'ChannelArn' => [ 'shape' => 'ChimeArn', ], 'MessageId' => [ 'shape' => 'MessageId', ], ], ], 'ResourceLimitExceededException' => [ 'type' => 'structure', 'members' => [ 'Code' => [ 'shape' => 'ErrorCode', ], 'Message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], 'ResourceName' => [ 'type' => 'string', 'max' => 256, 'min' => 0, 'pattern' => '[\\u0009\\u000A\\u000D\\u0020-\\u007E\\u0085\\u00A0-\\uD7FF\\uE000-\\uFFFD\\u10000-\\u10FFFF]*', 'sensitive' => true, ], 'SendChannelMessageRequest' => [ 'type' => 'structure', 'required' => [ 'ChannelArn', 'Content', 'Type', 'Persistence', 'ClientRequestToken', 'ChimeBearer', ], 'members' => [ 'ChannelArn' => [ 'shape' => 'ChimeArn', 'location' => 'uri', 'locationName' => 'channelArn', ], 'Content' => [ 'shape' => 'NonEmptyContent', ], 'Type' => [ 'shape' => 'ChannelMessageType', ], 'Persistence' => [ 'shape' => 'ChannelMessagePersistenceType', ], 'Metadata' => [ 'shape' => 'Metadata', ], 'ClientRequestToken' => [ 'shape' => 'ClientRequestToken', 'idempotencyToken' => true, ], 'ChimeBearer' => [ 'shape' => 'ChimeArn', 'location' => 'header', 'locationName' => 'x-amz-chime-bearer', ], ], ], 'SendChannelMessageResponse' => [ 'type' => 'structure', 'members' => [ 'ChannelArn' => [ 'shape' => 'ChimeArn', ], 'MessageId' => [ 'shape' => 'MessageId', ], ], ], 'ServiceFailureException' => [ 'type' => 'structure', 'members' => [ 'Code' => [ 'shape' => 'ErrorCode', ], 'Message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 500, ], 'exception' => true, 'fault' => true, ], 'ServiceUnavailableException' => [ 'type' => 'structure', 'members' => [ 'Code' => [ 'shape' => 'ErrorCode', ], 'Message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 503, ], 'exception' => true, 'fault' => true, ], 'SortOrder' => [ 'type' => 'string', 'enum' => [ 'ASCENDING', 'DESCENDING', ], ], 'String' => [ 'type' => 'string', ], 'Tag' => [ 'type' => 'structure', 'required' => [ 'Key', 'Value', ], 'members' => [ 'Key' => [ 'shape' => 'TagKey', ], 'Value' => [ 'shape' => 'TagValue', ], ], ], 'TagKey' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'sensitive' => true, ], 'TagList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Tag', ], 'max' => 50, 'min' => 1, ], 'TagValue' => [ 'type' => 'string', 'max' => 256, 'min' => 1, 'sensitive' => true, ], 'ThrottledClientException' => [ 'type' => 'structure', 'members' => [ 'Code' => [ 'shape' => 'ErrorCode', ], 'Message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], 'Timestamp' => [ 'type' => 'timestamp', ], 'UnauthorizedClientException' => [ 'type' => 'structure', 'members' => [ 'Code' => [ 'shape' => 'ErrorCode', ], 'Message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], 'UpdateChannelMessageRequest' => [ 'type' => 'structure', 'required' => [ 'ChannelArn', 'MessageId', 'ChimeBearer', ], 'members' => [ 'ChannelArn' => [ 'shape' => 'ChimeArn', 'location' => 'uri', 'locationName' => 'channelArn', ], 'MessageId' => [ 'shape' => 'MessageId', 'location' => 'uri', 'locationName' => 'messageId', ], 'Content' => [ 'shape' => 'Content', ], 'Metadata' => [ 'shape' => 'Metadata', ], 'ChimeBearer' => [ 'shape' => 'ChimeArn', 'location' => 'header', 'locationName' => 'x-amz-chime-bearer', ], ], ], 'UpdateChannelMessageResponse' => [ 'type' => 'structure', 'members' => [ 'ChannelArn' => [ 'shape' => 'ChimeArn', ], 'MessageId' => [ 'shape' => 'MessageId', ], ], ], 'UpdateChannelReadMarkerRequest' => [ 'type' => 'structure', 'required' => [ 'ChannelArn', 'ChimeBearer', ], 'members' => [ 'ChannelArn' => [ 'shape' => 'ChimeArn', 'location' => 'uri', 'locationName' => 'channelArn', ], 'ChimeBearer' => [ 'shape' => 'ChimeArn', 'location' => 'header', 'locationName' => 'x-amz-chime-bearer', ], ], ], 'UpdateChannelReadMarkerResponse' => [ 'type' => 'structure', 'members' => [ 'ChannelArn' => [ 'shape' => 'ChimeArn', ], ], ], 'UpdateChannelRequest' => [ 'type' => 'structure', 'required' => [ 'ChannelArn', 'Name', 'Mode', 'ChimeBearer', ], 'members' => [ 'ChannelArn' => [ 'shape' => 'ChimeArn', 'location' => 'uri', 'locationName' => 'channelArn', ], 'Name' => [ 'shape' => 'NonEmptyResourceName', ], 'Mode' => [ 'shape' => 'ChannelMode', ], 'Metadata' => [ 'shape' => 'Metadata', ], 'ChimeBearer' => [ 'shape' => 'ChimeArn', 'location' => 'header', 'locationName' => 'x-amz-chime-bearer', ], ], ], 'UpdateChannelResponse' => [ 'type' => 'structure', 'members' => [ 'ChannelArn' => [ 'shape' => 'ChimeArn', ], ], ], 'UrlType' => [ 'type' => 'string', 'max' => 4096, ], ],];
