<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use App\User;
use Illuminate\Support\Str;
use App\Helpers\FileManager;
use App\Helpers\Functions; 
use Hash;
use App\Setting;

use Illuminate\Support\Facades\Cache;

class ExceedController extends Controller
{

    protected $baseURL;

    protected $secretKey;
    protected $channelId;
    protected $_client;
    protected $username;
    protected $dashboardServiceCode;

    public function __construct()
    {
        $this->baseURL =env('XCEED_BASEPATH');
        $this->secretKey =env('XCEED_KEY');
        $this->channelId =env('XCEED_CHANNEL_ID');
        $this->dashboardServiceCode=env('DASHBOARD_SERVICE_CODE');
        $this->username=env('XCEED_USERNAME');

        // $this->validateConfigs();
        $this->_client = new \GuzzleHttp\Client();
    }


     public function adClick($companyId, $clickId){
    $url = "http://164.92.184.24:81/AdCompanies/AdClick?serviceId=" . $this->dashboardServiceCode . "&adCompanyId=" . $companyId . "&ClickId=" . $clickId;
    
    try {
        $_client = new \GuzzleHttp\Client();
        $response = $_client->request( "GET",
        $url,
        [
            'headers' => [
                "Accept" =>  "application/json",
                "Content-Type" =>  "application/json"
            ],
        ]
    );
    return 'ok';
    } 
     catch (\Exception $e) {
        return 'Error: ' . $e->getMessage();
    }

  }
   public function ConfirmAdClick($clickId,$msisdn){
    $response = $this->_client->request( "POST",
    '164.92.184.24:81/AdCompanies/ConfirmAdClick',
    [
        'headers' => [
            "Accept" =>  "application/json",
            "Content-Type" =>  "application/json"
        ],
        'json' => [
            'clickId' => $clickId,
            'serviceId' => $this->dashboardServiceCode,
            'phoneNumber' =>$msisdn
            ]
    ]
);
  }

    public function GetToken(){
            $user = Auth::user(); 
            if(!$user){
                return false;
            }
            $phone249 = 249 . $user->mobile;
            $credentials = $this->username . ":" .$this->secretKey;
            $base64Credentials = base64_encode($credentials);
            $token = "Basic " . $base64Credentials;
            $data = [
                "API" => [
                    "ClickID" =>  sprintf('%010d', mt_rand()),
                    "MSISDN" => $phone249,
                    "ChannelID" =>  $this->channelId,
                    "SPID" => "111"
                ]
            ];
            $_client = new \GuzzleHttp\Client();

            try {
            $response = $_client->request( "POST",
            'http://apisdp.digitalsp.net/api/v1/SyncUser',
            [
                'headers' => [
                    "Accept" =>  "application/json",
                    "Content-Type" =>  "application/json",
                    'Authorization' => $token
                ],
                'json' =>$data
            ]
            );
        

        } catch (\GuzzleHttp\Exception\ClientException $e) {
            return $e->getResponse()->getBody()->getContents();
        } catch (\Exception $e) {
            return 'Error: ' . $e->getMessage();
        }
        $responseArray = json_decode($response->getBody(), true);
        if (isset($responseArray[0]['STATUS'])) {
           
            if($responseArray[0]['STATUS'] == "NOTEXIST" || $responseArray[0]['STATUS'] == "UNSUBSCRIBED"){
               // $this->changeUserStatus($phone249,false);
               Auth::logout();
                return false;
            }
            if($responseArray[0]['STATUS'] == "SUBSCRIBED"){
             //   $this->changeUserStatus($phone249,true);
                return true;
            }
            
           
        }
    }

    function changeUserStatus($phone,$status){
        $this->Dashboard($phone249,$status);
        $user->is_subscriber = $status;
        $user->save();
    }

   



  public function exceedNotifi(){
   
    if($_GET['STATUS']== 'ACT-SB' || $_GET['STATUS'] == 'FSC-BL' || $_GET['STATUS'] == 'RSC-BL'|| $_GET['STATUS'] == 'RCL-SB' ){ //subscribe  
        $msisdn = $_GET['MSISDN'];
        $phone = $this->EditPhone($msisdn);
        $user = User::where('mobile', $phone)->first();
         // Dashboard Connection
        //   $this->ConnectToDashboard($phone, true);
        
        if(!$user){
                $user = User::create([
                'name' => $phone,
                'mobile' =>$phone,
                'email' => $phone.'@nxtlevel.com',
                'is_admin' => 0,
                'status' => true,
                'password' => bcrypt($phone),
                'verifyToken' => Str::random(40),
                'last_status' => $_GET['STATUS'],
            ]);
           
            $user->assignRole('TZARole');

          }
          if($user){
            $user->status = true;
            $user->last_status = $_GET['STATUS'];
            $user->save();
          }
    }
    if($_GET['STATUS']== 'BLD-SB' || $_GET['STATUS']== 'FFL-BL' || $_GET['STATUS'] == 'RCL-BL'){  //unsbcribe
         $msisdn = $_GET['MSISDN'];
        $phone = $this->EditPhone($msisdn);
        $user = User::where('mobile', $phone)->first();
         // Dashboard Connection
        //   $this->ConnectToDashboard($phone, false);
         if(!$user){
           $user = User::create([
                'name' => $phone,
                'mobile' =>$phone,
                'email' => $phone.'@nxtlevel.com',
                'is_admin' => 0,
                'status' => false,
                'password' => bcrypt($phone),
                'verifyToken' => Str::random(40),
                'last_status' => $_GET['STATUS'],
            ]);
           
            $user->assignRole('TZARole');

          }
        if($user){
            $user->status = false;
             $user->last_status = $_GET['STATUS'];
            $user->save();
        }
    }
    return 'ok';
  }

    public function redirect(Request $request){
        $msisdn = $request->MSISDN;
        $status = $_GET['CGSTATUS'];
        $phone = $this->EditPhone($msisdn);


        if ($status == 0 || $status == 5){
       if($phone !="wrong number"){
       
          // Dashboard Connection
        //   $this->ConnectToDashboard($phone, true);
          Session(['added'=> $status ==0 ?"تم الأشتراك بنجاح" : "أنت مشترك مسبقا" ]);
         return redirect('/');
       }
        }
        else{
            if($phone !="wrong number"){
            //$this->ConnectToDashboard($phone, false);
            }
        return redirect('/')->with('error', $status == 6 ? "ممنوع من الأشتراك - القائمة السوداء " :  "خطأ في الأشتراك" );
              }
    

    }

    public function unsubUrl($msisdn){
        mt_srand(microtime(true) * 10000);
        $transactionId ="NXT" . sprintf('%010d', mt_rand());
        $text = $this->channelId . $msisdn . $transactionId;
        $hash = hash_hmac('sha256', $text,  $this->secretKey);
        $url =  $this->baseURL  . '?ChannelID=' . $this->channelId . '&msisdn=' . $msisdn . '&TransactionID='
        . $transactionId . '&Hash=' . $hash;
        return $url;
        
    }
    public function unsub($msisdn){
        $phone249 = Functions::getPhone249($msisdn);
        $user = User::where('phone_number', $phone249)->first();
        if($user){
            $user->is_subscriber = false;
            $user->save();
        }
        $token = \Auth::user()->token();
        $token->revoke();
        return 'ok';
    }

     public function userScopes($user)
     {
         $scopes = [];
         if ($user->is('user')) {
             array_push(
                 $scopes,
                 'user_scope'
             );
         }
         if ($user->is('artist')) {
             array_push(
                 $scopes,
                 'manage_own_content'
             );
         }
         if ($user->is('admin') || $user->is_admin) {
             array_push(
                 $scopes,
                 'manage_own_content',
                 'manage_everything'
             );
         }
         if ($user->is_super_admin) {
             array_push(
                 $scopes,
                 'do_anything'
             );
         }
         return $scopes;
     }

public function ConnectToDashboard($phone ,$status){
        $response = $this->_client->request( "POST",
        '164.92.184.24:81/SubscriptionLog/CreatefromAPI',
        [
            'headers' => [
                "Accept" =>  "application/json",
                "Content-Type" =>  "application/json"
            ],
            'json' => [
                'subscriberPhone' => $phone,
                'serviceId' =>  $this->dashboardServiceCode,
                'status'=>$status
                ]
        ]
    );
    return 'ok';
    }

     public function Dashboard($phone, $status){
        $_client = new \GuzzleHttp\Client();
        $response = $_client->request( "POST",
        '164.92.184.24:81/SubscriptionLog/CreatefromAPI',
        [
            'headers' => [
                "Accept" =>  "application/json",
                "Content-Type" =>  "application/json"
            ],
            'json' => [
                'subscriberPhone' => $phone,
                'serviceId' =>  $this->dashboardServiceCode,
                'status'=>$status
                ]
        ]
    );
    return 'ok';
     }

    public function checkUser($phone){
        $user = User::where('mobile', $phone)->first();
        if($user != null){
            if($user->status == 1){
               Auth::login($user);
               return true;
            }
        }
        return false;
    }

    public function AddEditUser($phone ,$status){
      
        $user = User::where('mobile', $phone)->first();
       
        if ($user === null) {
            $user = User::create([
                'name' => $phone,
                'mobile' =>$phone,
                'email' => $phone.'@nxtlevel.com',
                'is_admin' => 0,
                'status' => $status,
                'password' => bcrypt($phone),
                'verifyToken' => Str::random(40),
            ]);
           
          $user->assignRole('TZARole');
           Auth::login($user);
      
           
        }else{
            $user->status =$status;
            $user->save();
            Auth::login($user);

         }
         
         return "ok";
     
    }

//check Number and return with 9 digits only
     public function EditPhone($phone){
        $length = strlen($phone);
        $result='';
        $phoneArray = str_split($phone);

        if($length==12){
            for ($i = 3; $i < $length; $i++) {
                $result=$result.$phoneArray[$i];
             }
             return $result;
        }

        if($length == 10){
            for ($i = 1; $i < $length; $i++) {
                $result=$result.$phoneArray[$i];
             }
             return $result;

        }
        if($length == 9){   return $phone;  }

        if($length >12 || $length <9 || $length ==11){
            return "wrong number";
        }
       
    }
  

    }