<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\User;
use Auth;
use Illuminate\Support\Str;
use Illuminate\Foundation\Auth\RegistersUsers;
use Mail;
use App\Config;
use App\Mail\Contactus;
class MenuVideoController extends Controller
{

    protected $baseURL;

    /**
     * Service product code
     *
     * @var string
     */
    protected $productCode;

    /**
     * Service username
     *
     * @var string
     */
    protected $username;

    /**
     * Service password
     *
     * @var string
     */
    protected $password;

    /**
     * Remember token when fetched from DSP
     *
     * @var boolean
     */
    protected $rememberToken;

    /**
     * Custom DSP token
     *
     * @var string
     */
    protected $token;


    protected $_client;
    public function __construct()
    {
        $this->baseURL = env('ZAIN_SERVER_BASE_API_URL');
        $this->password =env('ZAIN_PASSWORD');
        $this->username = env('ZAIN_USERNAME');
        $this->rememberToken = env('ZAIN_REMEMBER_TOKEN');
        $this->productCode = env('ZAIN_PRODUCT_CODE');
        $this->_client = new \GuzzleHttp\Client();

       // $this->validateConfigs();
        
    }
    public function validateConfigs()
    {
      

        if (
            is_null($this->baseURL) ||
            is_null($this->password) ||
            is_null($this->username) ||
            is_null($this->rememberToken) ||
            is_null($this->productCode)
        ) {
            $message = __('The provided configs is invalid, make sure laravel-zain config file is published and all its configs are set.');

           

            throw new InvlalidConfigsValuesException($message);
        }
    }
    use RegistersUsers;

    public function login()
    {

        $response = $this->_client->request( "POST",
        $this->baseURL.'login.php',
        [
            'headers' =>
            [               
                "Content-Type" =>  "application/json",
            ],
            'json' => 
            [
                'username' => $this->username,
                'password' => $this->password,
            ]
        ]
    );
        $result = json_decode($response->getBody()->getContents());
        return $result;
    }

    public function token()
    {
        // $this->log("Get Remote Token");

        $response = $this->login();
        
        if (isset($response->success) && $response->success == true) {

            // $this->log("Remote Token Fetched");

            $this->token = $response->token; // To be cached into this instance

            return $response->token;
        }

        return null;
    }
    private function getAvailableToken()
    {
        return $this->token ?? $this->token();
    }
    private function getHeaders()
    {
        return [
            'Content-Type' => 'application/json',
            'Authorization' => 'Bearer ' . $this->getAvailableToken()
        ];
    }

    public function initiate($phone)
    {
        $response = $this->_client->request( "POST",
        $this->baseURL.'initiate.php',
        [
            'headers' =>$this->getHeaders(),
            'json' => [
                'msisdn' => $phone,
                'product_code' => $this->productCode
                ]
        ]
    );
        $result = json_decode($response->getBody()->getContents());
        return $result;
    }


    public function verify($otp, $requestId)
    {
        $response = $this->_client->request( "POST",
        $this->baseURL.'payment.php',
        [
            'headers' =>$this->getHeaders(),
            'json' => [
                'otp' => $otp,
                'subscribe_request_id' => $requestId,
                ]
        ]
    );
        $result = json_decode($response->getBody()->getContents());
        return $result;
    }
    public function checkSubscription($phone)
    {
        $response = $this->_client->request( "POST",
        $this->baseURL.'check.php',
        [
            'headers' =>$this->getHeaders(),
            'json' => [
                'msisdn' => $phone,
                'product_code' => $this->productCode,
                ]
        ]
    );
        $result = json_decode($response->getBody()->getContents());
        return $result;
  
       
    }


    public function addUsersToDashboard(Request $request){

        $phone =$this->EditPhone($request->phone);
    
        $response =  $this->checkSubscription($phone);
       
        $this->ConnectToDashboard($phone, $response->success);
            $this->AddEditUser($phone,$response->success);
                return response()->json(__('Logged out successfully.'), 200);
      }

    public function GetAllUsers(){
        $users = User::where('id','>' , '9')->select('mobile AS phone' )->get();  
        return response()->json($users);
      }


    public function ZainCheck(){
        // if(Auth::user())
        // {
        //          $response = $this->checkSubscription(Auth::user()->mobile);
        //         if($response->success){
        //             if($response->subscription_data->is_active =="0"){return $this->updateUserStatus();}
        //         }else{
        //             if($response->error_code==111){ return $this->updateUserStatus(); }
        //         }
        // }
    }

    public function updateUserStatus(){
        $user =Auth::user();
        $user->status = 0;
        $user->save();
        $this->ConnectToDashboard($user->mobile,false);
        Auth::logout();
        return '/subscribe';
    }


    //Unsubscribe Zain Function
    //start
    public function _unsubscribe($phone)
    {
        $response = $this->_client->request( "POST",
        $this->baseURL.'cancel.php',
        [
            'headers' =>$this->getHeaders(),
            'json' => [
                'msisdn' => $phone,
                'product_code' => $this->productCode,
                ]
        ]
    );
    $result = json_decode($response->getBody()->getContents());
    return $result;
    }

    public function unsubscribeZain(){

        
        $user =Auth::user();

        if ($user === null) {
            Session(['deleted'=>' تم إلغاء الاشتراك']);
            return redirect('/');
        }

        $phone = $user->mobile;

        if($phone =='wrong number') {  
            return back()->with('error', '  الرجاء التأكد من رقم الهاتف  ');
        }

        $response = $this->_unsubscribe($phone);
       
        if($response->success ==true)
        {
           
            
         
           
            $this->ConnectToDashboard($phone,false);
            $user->status = 0;
            $user->save();
            Auth::logout();
            Session(['deleted'=>' تم إلغاء الاشتراك']);
            return redirect('/');


        }else
        {
           
            if( $response->error_code== 111){
              
            $user =Auth::user();
            $user->status = 0;
            $this->ConnectToDashboard($user->mobile,false);
            $user->save();
            Auth::logout();
            Session(['deleted'=>'  تم إلغاء الاشتراك بنجاح']);
            return redirect('/');   

            }
            return  back()->with('error',$response->message);

        }
    }
    //End

    public function payZain(Request $request){
        if($request->pin ==""){
            return  back()->with('error', "رجاء ادخال الرمز" ) 
            ->with('InitPay', "أدخل الرمز مرسل في رساله")
            ->with('phone' , $request->phone)
            ->with('requestId',$request->requestId);    
        }

        $response = $this->verify($request->pin , $request->requestId);
      
        if($response->success ==true)
        {
            $subscription_data = $response->subscription_data;
            if($subscription_data->is_active == 1){
                $this->AddEditUser($request->phone,1);
                $this->ConnectToDashboard($phone, true);
                return redirect('/');
            }else{
                
                $this->AddEditUser($request->phone,0);
                $this->ConnectToDashboard($phone, false);
                return redirect('/');
            }

        }else
        {
            
            if($response->error_code ==110){
                return  back()->with('error', "الرمز غير صحيح , رجاء ادخال الرمز الصحيح" ) 
                ->with('InitPay', "أدخل الرمز مرسل في رساله")
                ->with('phone' , $request->phone)
                ->with('requestId',$request->requestId);
            }
            if($response->error_code ==118){
                $this->AddEditUser($request->phone,0);
                $this->ConnectToDashboard($phone, false);
                return  back()->with('error', "  لقد تم الاشتراك وفشل الدفع " ) 
                ->with('InitPay', "أدخل الرمز مرسل في رساله")
                ->with('phone' , $request->phone)
                ->with('requestId',$request->requestId);
            }
        }
    }

    public function landingPage(Request $request){
        $this->checkUser($request->msisdn);

    }
  
    public function Zainlogin(Request $request){

        $phone =$this->EditPhone($request->phone);

        if($phone =='wrong number') 
        {
        return back()->with('error', '  الرجاء التأكد من رقم الهاتف  ');
        }
       
        $response =  $this->checkSubscription($request->phone);

 
        if($response->success){

            $this->AddEditUser($phone ,1);

            $this->ConnectToDashboard($phone, true);

            Session(['added'=>'تم تسجيل الدخول']);
        
            return redirect('/');

         }else{
           
            if($response->error_code ==111){
                
                $this->ConnectToDashboard($phone, false);
                return back()->with('error', 'لست مشترك الرجاء التأكد من رقم الهاتف او الاشتراك');
              }
              
              if($response->error_code ==118){
                $this->ConnectToDashboard($phone, false);
                return  back()->with('error', "تأكد من انك مشترك في الخدمه" )
                ->with('login'," بعض البيانات مفقودة يرجى المحاولة مرة اخرى")
                ->with('phone' , $phone);
              }

            if($response->error_code ==102){

                return  back()->with('error', "الرقم خطأ")
                ->with('login'," بعض البيانات مفقودة يرجى المحاولة مرة اخرى")
                ->with('phone' , $phone);
              }
          if($response->error_code >113 && $response->error_code <1000){ 
             return  back()->with('error', "الرقم خطأ")
             ->with('login'," حدث خطاء ,  المحاولة مرة اخرى")
             ->with('phone' , $phone);
          }
 
        }
        
        $user = User::where('mobile', $phone )->first();
        
        if ($user === null) {
            return back()->with('error', 'لست مشترك الرجاء التأكد من رقم الهاتف او الاشتراك');
        }
        
        if($user->status == 0){
            return back()->with('error', ' لست مشترك الرجاء التأكد من رقم الهاتف او الاشتراك');
        }

        Auth::login($user);
        Session(['added'=>'تم تسجيل الدخول']);
        return redirect('/');
    }


    public function connectZain(Request $request){
        $phone =$this->EditPhone($request->phone);
        if($phone =='wrong number') {            return back()->with('error', '  الرجاء التأكد من رقم الهاتف  ');}
       $response =  $this->initiate($request->phone);
    
       if($response->success ==true){
            if($this->checkUser($phone)== true){return redirect('/');}
        // $this->Add_Edit_User($request->phone);
        // return redirect('/');
        }else{
           
            if($response->error_code ==113){ 
               $this->AddEditUser($phone ,1);
               $this->ConnectToDashboard($phone, true);
             return redirect('/');
            }
            if($response->error_code ==102){ 
                
                return  back()->with('error', "الرقم خطأ")
                ->with('login'," بعض البيانات مفقودة يرجى المحاولة مرة اخرى")
                ->with('phone' , $phone);
             }
         if($response->error_code >113 && $response->error_code <1000){ 
            return  back()->with('error', "الرقم خطأ")
            ->with('login'," حدث خطاء ,  المحاولة مرة اخرى")
            ->with('phone' , $phone);
         }

       }
       
       return   back()->with('InitPay', "أدخل الرمز مرسل في رساله")
       ->with('requestId',$response->subscribe_request_id)
       ->with('phone' , $phone);
       
    }


    public function checkUser($phone){
        $user = User::where('mobile', $phone)->first();
        if($user != null){
            if($user->status == 1){
               Auth::login($user);
               return true;
            }
        }
        return false;
    }

    public function AddEditUser($phone ,$status){
      
        $user = User::where('mobile', $phone)->first();
       
        if ($user === null) {
            $user = User::create([
                'name' => $phone,
                'mobile' =>$phone,
                'email' => $phone.'@nxtlevel.com',
                'is_admin' => 1,
                'status' => $status,
                'password' => bcrypt($phone),
                'verifyToken' => Str::random(40),
            ]);
           
          $user->assignRole('TZARole');
           Auth::login($user);
      
           
        }else{
            $user->status =$status;
            $user->save();
            Auth::login($user);

         }
         
         return "ok";
     
    }


    public function GetNewUser(){
        if(!isset($_GET['msisdn'])){return redirect('/');}

        $msisdn =  $_GET['msisdn'];
        $phone = $this->EditPhone($msisdn);
       if($phone !="wrong number"){
          $this->AddEditUser($phone ,1);
          $this->ConnectToDashboard($phone, true);
          Session(['added'=>'تم الأشتراك']);
         return redirect('/');
       }
    }

    public function ConnectToDashboard($phone ,$status){
        $response = $this->_client->request( "POST",
        '164.92.184.24:81/SubscriptionLog/CreatefromAPI',
        [
            'headers' => [
                "Accept" =>  "application/json",
                "Content-Type" =>  "application/json"
            ],
            'json' => [
                'subscriberPhone' => $phone,
                'serviceId' => '54dae7f9-29ce-49bd-b484-8d2a651f79b8',
                'status'=>$status
                ]
        ]
    );
    return 'ok';
    }


     //check Number and return with 9 digits only
     public function EditPhone($phone){
        $length = strlen($phone);
        $result='';
        $phoneArray = str_split($phone);

        if($length==12){
            for ($i = 3; $i < $length; $i++) {
                $result=$result.$phoneArray[$i];
             }
             return $result;
        }

        if($length == 10){
            for ($i = 1; $i < $length; $i++) {
                $result=$result.$phoneArray[$i];
             }
             return $result;

        }
        if($length == 9){   return $phone;  }

        if($length >12 || $length <9 || $length ==11){
            return "wrong number";
        }
       
    }

    
}
