<?php

namespace App\Http\Controllers;

use App\Mail\SendInvoiceMailable;
use App\Package;
use Auth;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Mail;
use Paystack;
use App\PaypalSubscription;
use App\Config;
use App\Button;
use Illuminate\Support\Carbon;

class PaystackController extends Controller
{
  public function paystackgateway()
  {
      return Paystack::getAuthorizationUrl()->redirectNow();
  }

  public function paystackcallback()
  {
    $auth = Auth::user();
    $payment = Paystack::getPaymentData();
    if($payment['data']['status'] == 'success' && $payment['status'] == 'true'){
      $plan = Package::wherePlanId($payment['data']['metadata']['plan_id'])->first();
      $user_email = $auth->email;
      $com_email = Config::findOrFail(1)->w_email;


      $payment_id = $payment['data']['reference'];
      $payment_amount = $payment['data']['amount'];
      $payment_method = 'paystack';
      $payment_status = 1;
      $plan_id = $plan->id;
      $checkout = new SubscriptionController;
      return $checkout->subscribe($payment_id,$payment_method,$plan_id,$payment_status,$payment_amount);
     
    } else {
      return redirect('/')->with('error', 'Payment error occured. Please try again !');
    }
  }
}