<?php

namespace App\Http\Controllers;

use App\Audio;
use App\Config;
use App\LiveEvent;
use App\Movie;
use App\MovieSeries;
use App\MultipleLinks;
use App\Season;
use App\TvSeries;
use App\User;
use Auth;
use App\Traits\UserWatchingPatternTrait;
use App\Button;
use Artesaos\SEOTools\Facades\SEOTools;
use Artesaos\SEOTools\Facades\SEOMeta;
use Artesaos\SEOTools\Facades\OpenGraph;
use Illuminate\Http\Request;

class PrimeDetailController extends Controller
{
    use UserWatchingPatternTrait;
    /**
     * @param $id
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View|void
     */

    public function __construct(){
        $this->button = Button::first();
    }

    public function showMovie($slug)
    {
    
        // if (!Auth:: check()) {
        //     return redirect("/subscribe");
        //    } 
           
           $user_id = Auth::user()->id ?? 1;

         $movie = Movie::with(['menus' => function($q){
            return $q->select('movie_id','menu_id');
        }])->where('slug', $slug)->where('status', 1)->first();

        // Commented Out This:
        // if(getSubscription()->getData()->subscribed == true){
        //     if(isset(getSubscription()->getData()->subs_type) && getSubscription()->getData()->subs_type == 'all_menu'){
        //         $is_play = 1;
        //     }
        //     if(isset(getSubscription()->getData()->subs_type) && getSubscription()->getData()->subs_type == 'single_menu'){
        //         // if(array_search($slug, array_column(subscribed()->getData()->nav_menus, 'slug')) !== false)
        //         // {
        //         //     $pass_to_page = 1;
        //         // }
        //         foreach($movie->menus as $moviemenu){
        //             if(array_search($moviemenu->menu_id, array_column(getSubscription()->getData()->nav_menus, 'id')) !== false)
        //             {
        //                 $is_play = 1;
        //             }
        //         }
        //     }
        // }
        // if($is_play == 0){
        //     // return to thier first menu
        //     // Throw warning
        //     // This menu is not in your currenct plan kindly contact Admin
        //     return redirect()->route('home', subscribed()->getData()->nav_menus[0]->slug)->with('deleted','This movie is not included in your current subscription');
        //     // return subscribed()->getData()->nav_menus[0]->slug;
        // }
        //$type_check = "M";
        //$movies = Movie::all();
        //$filter_series = collect();
        $config = Config::findOrFail(1);
        $age = 0;
        if (!isset($movie)) {
            return back()->with('deleted','Movie Is Not Available right now, Please comeback later !');
        }
        if ($config->age_restriction == 1) {
            if (Auth::check()) {
                $user = User::findOrfail($user_id);
                $age = $user->age;
            }
        } else {
            $age = 100;
        }
        if($this->button->countviews != 1){
            // Commented Out This:
            // views($movie)->record(@$user_id);
            // Added This:
            $this->storeUserViews($movie->id,$user_id);
        }
        // Added  This:
        $suggested_movies = $this->mostWatchedGenred($user_id, $movie->genre_id);
                
        // Commented Out This:
        // if ($movie->series == 1) {
        //     $single_series_list = MovieSeries::where('series_movie_id', $movie->id)->first();
        //     if (isset($single_series_list)) {
        //         $main_movie_series = Movie::where('id', $single_series_list->movie_id)->first();
        //         $filter_series->push($main_movie_series);
        //         $series_list = (MovieSeries::where([['movie_id', $main_movie_series->id], ['series_movie_id', '!=', $movie->id]])->get());
        //         foreach ($series_list as $item) {
        //             $filter_movie_exc_self = Movie::where('id', $item->series_movie_id)->first();
        //             $filter_series->push($filter_movie_exc_self);
        //         }
        //     }
        // }
        // Added This:
        $movie->load(['comments' => function ($query) use ($user_id) {
            $query->where('status', '1')
                  ->orWhere('user_id', $user_id)
                  ->with(['subcomments' => function ($subQuery) use ($user_id) {
                    $subQuery->where('status', '1')
                             ->orWhere('user_id', $user_id);
                }]);
        }]);

        // Added This:

        if ($config->prime_movie_single == 1) {
            return view('movie_single_prime', compact('movie','suggested_movies',  'age', ));
        } 
        // Commented Out This:
        // if ($config->prime_movie_single == 1) {
        //     return view('movie_single_prime', compact('movie', 'movies', 'filter_series', 'type_check', 'age', 'config'));
        // } 

else {
            return view('movie_single', compact('movie', 'movies', 'filter_series', 'type_check', 'age', 'config'));
        }
    }
    public function showSeasons($season_slug)
    {

        $season = Season::where('season_slug', $season_slug)->first();

        $type_check = "S";
        $movies = Movie::all();
        
        $config = Config::findOrFail(1);
        $age = 0;

         if($this->button->countviews != 1){
            views($season)->record();
        }

        if ($season->tvseries->status != 1) {
            return back()->with('deleted','This Season is not available right now, Please comeback later !');
        }

        if ($config->age_restriction == 1) {
            if (Auth::check()) {
                $user_id = Auth::user()->id;
                $user = User::findOrfail($user_id);
                $age = $user->age;
            }
        } else {
            $age = 100;
        }

        if ($config->prime_movie_single == 1) {
            return view('movie_single_prime', compact('season', 'age', 'movies', 'type_check', 'config'));
        } else {
            return view('movie_single', compact('season', 'age', 'movies', 'config', 'type_check'));
        }
    }

    public function moviedownload($upload_video)
    {

        $file = $upload_video;

        $path = public_path() . "/movies_upload/" . $upload_video;
        $headers = array(
            'Content-Type : application/pdf',
        );
        return response()->download($path, $file, $headers);
    }

    public function seasondownload($upload_video)
    {

        $file = $upload_video;

        $path = public_path() . "/tvshow_upload/" . $upload_video;
        $headers = array(
            'Content-Type : application/pdf',
        );
        return response()->download($path, $file, $headers);

    }

    public function updateclick(Request $request)
    {
        $link = MultipleLinks::find($request->id);

        if (isset($link)) {
            $link->clicks = $link->clicks + 1;
            $link->save();

            return response()->json('Updated !');
        } else {
            return response()->json('Oops error');
        }
    }

    public function eventshow($slug)
    {
        $liveevent = LiveEvent::where('status', '=', '1')->where('slug', $slug)->first();
        if (!isset($liveevent)) {
            return abort(404);
        }

        return view('event_detail', compact('liveevent'));

    }

    public function audioshow($id)
    {
        $audio = Audio::where('id', $id)->first();
        if (!isset($audio)) {
            return abort(404);
        }

        return view('audio_detail', compact('audio'));

    }

}
