<?php

namespace App\Http\Controllers;

use App\User;
use App\SubscriberHistory;
use App\SudaniDaySubReport;
use Illuminate\Http\Request;
use App\SudaniDayUnSubReport;
use App\SudaniChargeDayReport;
use Illuminate\Support\Carbon;
use App\SudaniMonthUnSubReport;
use App\SudaniMonthChargeReport;
use Illuminate\Support\Facades\DB;

class SudaniAdminSubscribersController extends Controller
{
    /**
     * Get all the users.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $users = User::where('is_admin', 0)
            ->where('is_subscriber', 1)
            ->orderBy('created_at', 'desc')
            ->select(['id', 'name', 'phone_number', 'is_un_subscribe'])
            ->get();
        return response()->json($users, 200);
    }
    public function todayUnSubscriber()
    {
        $now = Carbon::now();
        $items = SubscriberHistory::query()
            ->where('is_confirm', true)
            ->whereDate('un_subscribe_date', '=', $now)
            ->count();
        return response()->json(['count' => $items], 200);
    }
    public function todaySubscribers()
    {
        $nowDate = Carbon::now();
        $items = DB::table("subscriber_histories")
            ->join("users", "subscriber_histories.subscriber_id", "users.id")
            ->whereDate("subscriber_histories.confirm_date", '=', $nowDate)
            ->whereDate("users.created_at", '=', $nowDate)
            ->where("subscriber_histories.re_new", false)
            ->where("subscriber_histories.is_confirm", true)
            ->count();
        return response()->json(['count' => $items], 200);
    }

    public function monthSubscribers()
    {
        $nowDate = Carbon::now();
        $items = SudaniChargeDayReport::where('year', $nowDate->year)
            ->where('month', $nowDate->month)
            ->sum('count');
        return response()->json(['sum' => $items], 200);
    }

    public function monthUnSubscribers()
    {
        $nowDate = Carbon::now();
        $items = SudaniMonthUnSubReport::where('year', $nowDate->year)
            ->orderBy('month', 'desc')
            ->get();
        foreach ($items as $item) {
            $date = Carbon::create($item->year, $item->month);
            $item['month_name'] = $date->monthName;
            $item['date'] = $item->month . "-" . $item->year;
        }
        return response()->json($items, 200);
    }
    public function monthTotalSubscribers()
    {
        $nowDate = Carbon::now();
        $items = SudaniMonthChargeReport::where('year', $nowDate->year)
            ->orderBy('month', 'desc')
            ->get();
        foreach ($items as $item) {
            $item["price"] = (float)env("MIX_SUDANI_PRICE") * (float) $item->count;
            $date = Carbon::create($item->year, $item->month);
            $item['month_name'] = $date->monthName;
            $item['date'] = $item->month . "-" . $item->year;
        }
        return response()->json($items, 200);
    }
    public function estimatedSales()
    {
        $nowDate = Carbon::now();
        $items = SudaniChargeDayReport::where('year', $nowDate->year)
            ->where('month', $nowDate->month)
            ->orderBy('month', 'desc')
            ->sum('count');
        $total = (float)env("MIX_SUDANI_PRICE") * (float) $items;
        return response()->json(['estimatedSales' => $total], 200);
    }
    public function reportDaySubscribers()
    {
        $items = SudaniDaySubReport::orderBy('created_at', 'desc')
            ->take(70)
            ->get();
        foreach ($items as $item) {
            $item['date'] = $item->day . "-" . $item->month . "-" . $item->year;
        }
        return response()->json($items, 200);
    }

    public function reportDayUnSubscribers()
    {
        $items = SudaniDayUnSubReport::orderBy('created_at', 'desc')
            ->take(70)
            ->get();
        foreach ($items as $item) {
            $item['date'] = $item->day . "-" . $item->month . "-" . $item->year;
        }
        return response()->json($items, 200);
    }
}
