<?php

namespace App\Http\Controllers;

use App\User;
use App\Setting;
use App\Helpers\Functions;
use App\SubscriberHistory;
use App\Helpers\FileManager;
use Illuminate\Http\Request;
use App\SudaniChargeDayReport;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Hash;

class SudaniHeController extends Controller
{
    public function test(Request $request)
    {
        $nowDate = Carbon::now();
        $items = SudaniChargeDayReport::where('year', $nowDate->year)
            ->where('month', $nowDate->month)
            ->orderBy('month', 'desc')
            ->sum('count');
        $total = (float)env("MIX_SUDANI_PRICE") * (float) $items;
        return response()->json(['estimatedSales' => $total], 200);
    }
    public function confirm(Request $request)
    {
        Log::info("heConfirm: " . json_encode($request->all()));
        $nowDateTime = Carbon::now();
        $nowDate = Carbon::parse($nowDateTime)->toDateString();
        $phonNumber = null;
        if (isset($request->msisdn)) {
            $phoneNumber = Functions::getPhone249($request->msisdn);
        }

        switch ((int)$request->responseCode) {
            case 1:
            case 121:
            case 111:
            case 500:
                if ($phoneNumber != null) {
                    $sub_hist = DB::table("subscriber_histories")
                        ->join("users", "subscriber_histories.subscriber_id", "users.id")
                        ->whereDate("subscriber_histories.confirm_date", '=', $nowDate)
                        ->where("subscriber_histories.is_active", true)
                        ->where("subscriber_histories.is_confirm", true)
                        ->where("users.phone_number", '=', $phoneNumber)
                        ->orderByDesc("subscriber_histories.confirm_date")
                        ->select("subscriber_histories.*")
                        ->first();
                    if ($sub_hist == null) {
                        $subscriber = User::where('phone_number', $phoneNumber)->first();
                        if ($subscriber == null) {
                            $subscriber = User::create([
                                'name' => $phoneNumber,
                                'email' => $phoneNumber,
                                'is_subscriber' => true,
                                'phone_number' => $phoneNumber,
                                'avatar' => FileManager::generateFileData('/storage/defaults/images/user_avatar.png'),
                                'password' => Hash::make($phoneNumber),
                                'available_disk_space' => floatval(Setting::get('availableUserDiskSpace')),
                                'lang' => Setting::get('locale')
                            ]);
                        }
                        SubscriberHistory::create([
                            'send_date' => Carbon::now(),
                            'code' => "by_he_method",
                            'request_id' => 0,
                            'is_confirm' => true,
                            'is_sent' => true,
                            'is_active' => true,
                            're_new' => false,
                            'confirm_date' => Carbon::now(),
                            'subscriber_id' => $subscriber->id,
                        ]);
                    }
                    $responseCode = (int)$request->responseCode;
                    if($responseCode == 121){
                        return redirect("/sudani/success/" . $phoneNumber."/1");
                    }else{
                        return redirect("/sudani/success/" . $phoneNumber);
                    }

                } else {
                    return redirect("/sudani/usingphone/");
                }
            default:
                return redirect("/sudani/usingphone/");
        }
    }
}
