<?php

namespace App\Http\Controllers;

use App\Exceptions\FEException;
use App\Helpers\FileManager;
use Illuminate\Http\Request;
use Hash;
use App\Setting;
use App\User;
use App\Helpers\Functions;
use App\Helpers\Sudani\SudaniAPI;
use App\Helpers\Sudani\SudaniStatus;
use App\SpayNotification;
use App\SubscriberHistory;
use Carbon\Carbon;
use Illuminate\Log\Logger;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Validation\ValidationException;

class SudaniSubscribeController extends Controller
{

    public  function TestSudani(Request $request)
    {
        $initPay = new SudaniAPI();
        $initPayResult = $initPay->payment($sub_hist->request_id, (int)$request->pin);
    }

    public function init(Request $request)
    {
        $request->validate([
            'phoneNumber' => ['required', 'string', 'regex:/^(0\d{9}|249\d{9})$/'],
        ], [
            'regex' => 'The phone number format is invalid.',
            'string' => 'The Phone number is not valid.',
            'required' => 'Please enter the phone number.'
        ]);
        $sanitize_phone = Functions::getPhone249($request->phoneNumber);
        //return response()->json(["status" => "OK", "responseCode" => 2, "phoneNumber" => $request->phoneNumber], 200);
        $subscriber = User::where('phone_number', $sanitize_phone)->first();
        if ($subscriber == null) {
            $subscriber = User::create([
                'name' => $sanitize_phone,
                'email' => $sanitize_phone,
                'is_subscriber' => true,
                'phone_number' => $sanitize_phone,
                'avatar' => FileManager::generateFileData('/storage/defaults/images/user_avatar.png'),
                'password' => Hash::make($sanitize_phone),
                'available_disk_space' => floatval(Setting::get('availableUserDiskSpace')),
                'lang' => Setting::get('locale')
            ]);
        }

        $initPay = new SudaniAPI();
        $initPayResult = $initPay->initPay($sanitize_phone);
        $nowDateTime = Carbon::now();
        $nowDate = Carbon::parse($nowDateTime)->toDateString();
        $responseCode = 0;
        switch ($initPayResult->getStatus()) {
            case SudaniStatus::USER_IS_SUBSCRIBED:
            case SudaniStatus::USER_IS_ALREADY_SUBSCRIBE:
                $subscriber->subscription_completed = true;
                $subscriber->is_un_subscribe = false;
                $subscriber->save();
                $sub_hist = SubscriberHistory::whereDate('send_date', '=', $nowDate)
                    ->where('subscriber_id', $subscriber->id)->first();
                if ($sub_hist == null) {
                    SubscriberHistory::create([
                        'send_date' => Carbon::now(),
                        'code' => "UserIsSubscribed",
                        'is_confirm' => true,
                        'is_sent' => true,
                        'is_active' => true,
                        're_new' => false,
                        'confirm_date' => Carbon::now(),
                        'subscriber_id' => $subscriber->id,
                    ]);
                } else {
                    $sub_hist->is_active = true;
                    $sub_hist->re_new = false;
                    $sub_hist->is_confirm = true;
                    $sub_hist->confirm_date = Carbon::now();
                    $sub_hist->is_sent = true;
                    $sub_hist->send_date = Carbon::now();
                    $sub_hist->save();
                }
                $responseCode = 2;
                break;
            case SudaniStatus::OK:
                $sub_hist = SubscriberHistory::whereDate('send_date', '=', $nowDate)
                    ->where('subscriber_id', $subscriber->id)->first();
                if ($sub_hist == null) {
                    SubscriberHistory::create([
                        'send_date' => Carbon::now(),
                        'request_id' => $initPayResult->response->requestId,
                        'is_sent' => true,
                        'subscriber_id' => $subscriber->id,
                    ]);
                } else {
                    $sub_hist->request_id = $initPayResult->response->requestId;
                    $sub_hist->is_active = false;
                    $sub_hist->re_new = false;
                    $sub_hist->is_sent = true;
                    $sub_hist->is_confirm = false;
                    $sub_hist->send_date = Carbon::now();
                    $sub_hist->save();
                }
                $responseCode = 1;
                break;
            case SudaniStatus::PHONE_NUMBER_IN_CORRECT:
                throw ValidationException::withMessages(["phoneNumber" => "The phone number must be a sudani number."]);
                break;
            default:
                throw ValidationException::withMessages(["phoneNumber" => "Unknown error happened."]);
        }

        return response()->json(["status" => "OK", "responseCode" => $responseCode, "phoneNumber" => $request->phoneNumber], 200);
    }

    public function confirmPayment(Request $request)
    {
        $request->validate([
            'phoneNumber' => ['required', 'string', 'regex:/^(0\d{9}|249\d{9})$/'],
            'pin' => ['required', 'numeric', 'regex:/^\d{4}$/'],
        ], [
            'phoneNumber.regex' => 'The phone number format is invalid.',
            'phoneNumber.string' => 'The Phone number is not valid.',
            'phoneNumber.required' => 'Please enter the phone number.',
            'pin.required' => 'Pin code is required.',
            'pin.numeric' => 'Must be a valid number like 1234.',
            'pin.regex' => 'Pin code must be valid number with 4 digits.',
        ]);
        $sanitize_phone = Functions::getPhone249($request->phoneNumber);
        $nowDateTime = Carbon::now();
        $nowDate = Carbon::parse($nowDateTime)->toDateString();
        $responseCode = 0;
        $sub_hist = DB::table("subscriber_histories")
            ->join("users", "subscriber_histories.subscriber_id", "users.id")
            ->whereDate("subscriber_histories.send_date", '=', $nowDate)
            ->where("users.phone_number", '=', $sanitize_phone)
            ->orderByDesc("subscriber_histories.send_date")
            ->select("subscriber_histories.*")
            ->first();
        if ($sub_hist == null) {
            throw ValidationException::withMessages(["phoneNumber" => "The phone number is invalid."]);
        }

        $initPay = new SudaniAPI();
        $initPayResult = $initPay->payment($sub_hist->request_id, (int)$request->pin);

        $responseCode = 0;
        switch ($initPayResult->getStatus()) {
            case SudaniStatus::OK:
            case SudaniStatus::USER_IS_SUBSCRIBED:
            case SudaniStatus::USER_IS_ALREADY_SUBSCRIBE:
                DB::table('users')
                    ->where("id", $sub_hist->subscriber_id)
                    ->update(['subscription_completed' => true, 'is_un_subscribe' => false]);
                DB::table('subscriber_histories')
                    ->where('id', $sub_hist->id)
                    ->update([
                        'send_date' => Carbon::now(),
                        'code' => (string)$request->pin,
                        'is_confirm' => true,
                        'is_sent' => true,
                        'is_active' => true,
                        're_new' => false,
                        'confirm_date' => Carbon::now()
                    ]);
                if (
                    $initPayResult->getStatus() == SudaniStatus::USER_IS_SUBSCRIBED
                    || $initPayResult->getStatus() == SudaniStatus::USER_IS_ALREADY_SUBSCRIBE
                ) {
                    $responseCode = 2;
                } else {
                    $responseCode = 1;
                }
                break;
            case SudaniStatus::PHONE_NUMBER_IN_CORRECT:
                throw ValidationException::withMessages(["phoneNumber" => "The phone number must be a sudani number."]);
                break;
            case SudaniStatus::PIN_CODE_INVALID:
                throw ValidationException::withMessages(["pin" => "The Pin Code is in valid."]);
                break;
            case SudaniStatus::USER_HAVE_NO_BALANCE:
                throw ValidationException::withMessages(["pin" => "You do not have a balance."]);
                break;
            case SudaniStatus::PHONE_NUMBER_IN_CORRECT:
                throw ValidationException::withMessages(["phoneNumber" => "The Phone number is incorrect."]);
                break;
            case SudaniStatus::SUDANI_ERROR:
                throw ValidationException::withMessages(["phoneNumber" => "Error form the service provider."]);
                break;
            default:
                throw ValidationException::withMessages(["phoneNumber" => "Unknown error happened."]);
        }

        return response()->json(["status" => "OK", "responseCode" => $responseCode, "phoneNumber" => $request->phoneNumber], 200);
    }
    public function unsubscribe(Request $request)
    {
        $request->validate([
            'phoneNumber' => ['required', 'string', 'regex:/^(0\d{9}|249\d{9})$/'],
        ], [
            'regex' => 'The phone number format is invalid.',
            'string' => 'The Phone number is not valid.',
            'required' => 'Please enter the phone number.'
        ]);
        //return response()->json(["status" => "OK", "responseCode" => 1, "phoneNumber" => $request->phoneNumber], 200);
        $sanitize_phone = Functions::getPhone249($request->phoneNumber);
        $nowDateTime = Carbon::now();
        $nowDate = Carbon::parse($nowDateTime)->toDateString();
        $responseCode = 0;
        $sub_hist = DB::table("subscriber_histories")
            ->join("users", "subscriber_histories.subscriber_id", "users.id")
            ->whereDate("subscriber_histories.confirm_date", '=', $nowDate)
            ->where("users.phone_number", '=', $sanitize_phone)
            ->where("subscriber_histories.is_active", '=', true)
            ->orderByDesc("subscriber_histories.confirm_date")
            ->select("subscriber_histories.*")
            ->first();

        $initPay = new SudaniAPI();
        $initPayResult = $initPay->unSubscribe($sanitize_phone);
        //Log::info("User Un Subscribed ".json_encode($initPayResult));
        switch ($initPayResult->getStatus()) {
            case SudaniStatus::OK:
            case SudaniStatus::USER_IS_NOT_SUBSCRIBER:
                //Log::info("User Un Subscribed " . json_encode($sub_hist));
                if ($sub_hist != null) {
                    DB::table('users')
                        ->where("id", $sub_hist->subscriber_id)
                        ->update(['subscription_completed' => false, "is_un_subscribe" => true]);
                    DB::table('subscriber_histories')
                        ->where('id', $sub_hist->id)
                        ->whereDate("confirm_date", '=', $nowDate)
                        ->update([
                            'is_active' => false,
                            'un_subscribe_date' => Carbon::now(),
                        ]);
                }
                $responseCode = 1;
                break;

            case SudaniStatus::PHONE_NUMBER_IN_CORRECT:
                throw ValidationException::withMessages(["phoneNumber" => "The phone number must be a sudani number."]);
                break;
            case SudaniStatus::PIN_CODE_INVALID:
                throw ValidationException::withMessages(["pin" => "The Pin Code is in valid."]);
                break;
            case SudaniStatus::USER_HAVE_NO_BALANCE:
                throw ValidationException::withMessages(["pin" => "You do not have a balance."]);
                break;
            case SudaniStatus::PHONE_NUMBER_IN_CORRECT:
                throw ValidationException::withMessages(["phoneNumber" => "The Phone number is incorrect."]);
                break;
            case SudaniStatus::SUDANI_ERROR:
                throw ValidationException::withMessages(["phoneNumber" => "Error form the service provider."]);
                break;
            default:
                throw ValidationException::withMessages(["phoneNumber" => "Unknown error happened."]);
        }

        return response()->json(["status" => "OK", "responseCode" => $responseCode, "phoneNumber" => $request->phoneNumber], 200);
    }

    public function notify(Request $request)
    {
        Log::info("notify: " . json_encode($request->all()));
        $spayDateFormat = "Y-m-d H:i.s.u";
        $spayNotification = new SpayNotification();
        $spayNotification->phone_number = $request->msisdn;
        $spayNotification->service_code = $request->service_code;
        $spayNotification->status = $request->status;
        if (isset($request->sub_date) && $request->sub_date != null && !empty($request->sub_date)) {
            $spayNotification->subscribe_date = Carbon::createFromFormat($spayDateFormat, $request->sub_date);
        }
        if (isset($request->expire_date) && $request->expire_date != null && !empty($request->expire_date)) {
            $spayNotification->expire_date = Carbon::createFromFormat($spayDateFormat, $request->expire_date);
        }
        if (isset($request->retry_date) && $request->retry_date != null && !empty($request->retry_date)) {
            $spayNotification->retry_date = Carbon::createFromFormat($spayDateFormat, $request->retry_date);
        }
        $spayNotification->save();
        $nowDateTime = Carbon::now();
        $nowDate = Carbon::parse($nowDateTime)->toDateString();

        $sub_hist = DB::table("subscriber_histories")
            ->join("users", "subscriber_histories.subscriber_id", "users.id")
            ->whereDate("subscriber_histories.confirm_date", '=', $nowDate)
            ->where("subscriber_histories.is_active", true)
            ->where("subscriber_histories.is_confirm", true)
            ->where("users.phone_number", '=', $spayNotification->phone_number)
            ->orderByDesc("subscriber_histories.confirm_date")
            ->select("subscriber_histories.*")
            ->first();
        if ($spayNotification->status == "0" && $sub_hist != null) {
            DB::table('subscriber_histories')->where('id', $sub_hist->id)->delete();
        }
        if ($spayNotification->status == "1" && $sub_hist == null) {
            $subscriber = User::where('phone_number', $spayNotification->phone_number)->first();
            if ($subscriber == null) {
                $subscriber = User::create([
                    'name' => $spayNotification->phone_number,
                    'email' => $spayNotification->phone_number,
                    'is_subscriber' => true,
                    'phone_number' => $spayNotification->phone_number,
                    'avatar' => FileManager::generateFileData('/storage/defaults/images/user_avatar.png'),
                    'password' => Hash::make($spayNotification->phone_number),
                    'available_disk_space' => floatval(Setting::get('availableUserDiskSpace')),
                    'lang' => Setting::get('locale')
                ]);
            }
            SubscriberHistory::create([
                'send_date' => Carbon::now(),
                'code' => "notfiy-renew",
                'request_id' => 0,
                'is_confirm' => true,
                'is_sent' => true,
                'is_active' => true,
                're_new' => false,
                'confirm_date' => Carbon::now(),
                'subscriber_id' => $subscriber->id,
            ]);
        }

        return response()->json([
            "responseMessage" => "successful",
            'responseStatus' => true,
            'responseCode' => 200
        ], 200);
    }

    public function getPrice(Request $request)
    {
        return response()->json([
            "price" => (float)env("MIX_SUDANI_PRICE")
        ], 200);
    }
}
