<?php

namespace App\Traits;

use DB;
use App\Setting;
use App\Genre;
use App\Movie;
use Illuminate\Database\Eloquent\Collection;
use Carbon\Carbon;

trait UserWatchingPatternTrait
{

    /**
     * Get the most liked songs.
     *
     * @param int $nb_items
     * @return \Illuminate\Database\Eloquent\Collection
     */
    public function mostWatchedGenred($user_id, $current_genre_id)
    {
        $genre_views = DB::table('user_views') 
                ->select(DB::raw('COUNT(*) as views, movies.genre_id as id'))
                ->leftJoin('movies', 'movies.id', '=', 'user_views.viewable_id')
                ->where('user_views.visitor', $user_id)
                ->groupBy('movies.genre_id')
                ->orderBy('views', 'desc')
                ->get();
        
        return $this->getVideos($genre_views, $current_genre_id);
    }
    public function storeUserViews($movie_id , $user_id)
    {
        DB::table('user_views')->insert([
            // Your target user ID
            'viewable_id' => $movie_id, // ID of the movie/post being viewed
            'viewable_type' => 'App\Movie', // Model class name
            'visitor' => $user_id,
            'collection'=>null, // Optional (if tracking guests)
            'viewed_at' => Carbon::now(), // Current timestamp
        ]);

    }

    private function getVideos($genre_views, $current_genre_id)
    {
        $movies = new Collection();
        $top4Genres = [(int)$current_genre_id];
        foreach ($genre_views  as $genre_view) {
            if ($genre_view->id != $current_genre_id) {
                array_push($top4Genres, (int)$genre_view->id);
            }            
        }
        if (count($top4Genres) < 4) {
            $top4Genres = array_merge($top4Genres, $this->getTop4Genres($top4Genres, 4 - count($top4Genres)));
        }
        for ($i = 0; $i < 4; $i++) {
            $items = 2;
            if ($i == 0) {
                $items = 5;
            }
            if ($i == 3) {
                $items = 1;
            }
            
            $movies = $movies->merge($this->getMovieByGenre($top4Genres[$i], $items));
        }
        return $movies;
    }
    private function getTop4Genres($top_genrs,$rem)
    {
        return Genre::whereNotIn('id', $top_genrs)
        ->inRandomOrder()  // Randomize the order
        ->take($rem)       // Limit results
        ->get()
        ->pluck('id')->toArray();
    
}
private function getMovieByGenre($genre_id, $nb_items)
{
    return Movie::where('genre_id', $genre_id)
        ->inRandomOrder()
        ->take($nb_items)
        ->get();
}
}