<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;

class ActorsTableSeeder extends Seeder
{

    /**
     * Auto generated seed file
     *
     * @return void
     */
    public function run()
    {
        

        \DB::table('actors')->delete();
        
        \DB::table('actors')->insert(array (
            0 => 
            array (
                'id' => 1,
                'name' => '{"en":"Tom Hardy"}',
                'image' => 'tmdb_sGMA6pA2D6X0gun49igJT3piHs3.jpg',
            'biography' => '{"en":"Edward Thomas \\"Tom\\" Hardy (born 15 September 1977) is an English actor. He is best known for playing the title character in the 2009 British film Bronson, and for his roles in the films Star Trek Nemesis, RocknRolla, and Inception. He has been cast in the Christopher Nolan film The Dark Knight Rises as Bane."}',
                'place_of_birth' => 'Hammersmith, London, England, UK',
                'DOB' => '1977-09-15',
                'created_at' => '2021-10-19 13:22:52',
                'updated_at' => '2021-10-19 14:30:21',
                'slug' => 'tom-hardy',
            ),
            1 => 
            array (
                'id' => 2,
                'name' => '{"en":"Michelle Williams"}',
                'image' => 'tmdb_sXTP6wlqIDz1tDGLU3DFbklSTpq.jpg',
            'biography' => '{"en":"Michelle Ingrid Williams (born September 9, 1980) is an American actress. Known for her roles in small-scale independent productions with dark or tragic themes, Williams is the recipient of several accolades, including two Golden Globe Awards, a Primetime Emmy Award, and nominations for four Academy Awards, and a Tony Award.\\r\\n\\r\\nDaughter of the politician and trader Larry R. Williams, she was raised in Kalispell and San Diego. She began her career with television guest appearances and made her film debut in the family film Lassie in 1994. At 15, she gained emancipation from her parents, and soon achieved recognition for her leading role in the television teen drama series Dawson\'s Creek (1998\\u20132003). This was followed by low-profile films, before having her breakthrough with the drama film Brokeback Mountain (2005), for which she received a nomination for the Academy Award for Best Supporting Actress.\\r\\n\\r\\nWilliams went on to gain critical acclaim for playing emotionally troubled women coping with loss or loneliness in the independent dramas Wendy and Lucy (2008), Blue Valentine (2010), and Manchester by the Sea (2016). For the last two of these she received nominations for the Academy Award for Best Actress and the Academy Award for Best Supporting Actress, respectively. She won two Golden Globes for portraying Marilyn Monroe in the drama My Week with Marilyn (2011) and Gwen Verdon in the miniseries Fosse\\/Verdon (2019), in addition to a Primetime Emmy Award for Outstanding Lead Actress for the latter. Her highest-grossing releases came with the thriller Shutter Island (2010), the fantasy film Oz the Great and Powerful (2013), the musical The Greatest Showman (2017), and the superhero film Venom (2018). On Broadway, she starred in revivals of the musical Cabaret in 2014 and the drama Blackbird in 2016, for which she received a nomination for the Tony Award for Best Actress in a Play.\\r\\n\\r\\nWilliams is an advocate for equal pay. She is reticent about her personal life; she has a daughter from her relationship with the late actor Heath Ledger, and was briefly married to the musician Phil Elverum. She is married to theater director Thomas Kail, with whom she has a child.\\r\\n\\r\\nDescription above from the Wikipedia article Michelle Williams (actress), licensed under CC-BY-SA, full list of contributors on Wikipedia."}',
                'place_of_birth' => 'Kalispell, Montana, USA',
                'DOB' => '1980-09-09',
                'created_at' => '2021-10-19 13:22:53',
                'updated_at' => '2021-10-19 14:30:45',
                'slug' => 'michelle-williams',
            ),
            2 => 
            array (
                'id' => 3,
                'name' => '{"en":"Riz Ahmed"}',
                'image' => 'tmdb_1uP9RaX7BGVx7XGTEmwObBJJzsC.jpg',
            'biography' => '{"en":"Rizwan \\"Riz\\" Ahmed (born 1 December 1982), also known as Riz MC, is a British actor and rapper. As an actor, he was initially known for his work in independent films such as The Road to Guantanamo, Shifty, Four Lions, Trishna, and Ill Manors, before his breakout role in Nightcrawler. Since then, he has appeared in the films Una, Jason Bourne, and the first Star Wars Anthology film, Rogue One. He also starred in the HBO miniseries The Night Of as Nasir Khan; the show and his performance were critically lauded, earning him Golden Globe and SAG nominations."}',
                'place_of_birth' => 'Wembley, London, England, UK',
                'DOB' => '1982-12-01',
                'created_at' => '2021-10-19 13:22:54',
                'updated_at' => '2021-10-19 14:30:57',
                'slug' => 'riz-ahmed',
            ),
            3 => 
            array (
                'id' => 4,
                'name' => '{"en":"Scott Haze"}',
                'image' => 'tmdb_6cd3Jt8Vo52j8cRKbNf1j7cERhs.jpg',
                'biography' => '{"en":null}',
                'place_of_birth' => 'Dallas, Texas, USA',
                'DOB' => '1993-06-28',
                'created_at' => '2021-10-19 13:22:55',
                'updated_at' => '2021-10-19 14:31:03',
                'slug' => 'scott-haze',
            ),
            4 => 
            array (
                'id' => 5,
                'name' => '{"en":"Reid Scott"}',
                'image' => 'tmdb_kBAeDUDA7XJRXFLGNALlpE5d3lA.jpg',
                'biography' => '{"en":null}',
                'place_of_birth' => 'Albany, New York, USA',
                'DOB' => '1977-11-19',
                'created_at' => '2021-10-19 13:22:57',
                'updated_at' => '2021-10-19 14:31:09',
                'slug' => 'reid-scott',
            ),
            5 => 
            array (
                'id' => 6,
                'name' => '{"en":"Gilles Lellouche"}',
                'image' => 'tmdb_mrd6gOwofUe3AO1hUmr2KSnVV6y.jpg',
            'biography' => '{"en":"Gilles Lellouche (born 5 July 1972) is a French actor. He started his career as a director. Lellouche has appeared in more than fifty films since 1995. He was nominated twice for a C\\u00e9sar Award; in 2006 for Most Promising Actor and in 2011 for Best Supporting actor for his performance in Little White Lies.\\r\\n\\r\\nFrom 2002 to 2013, Lellouche was in a relationship with actress M\\u00e9lanie Doutey. They have a daughter named Ava, born on 5 September 2009. His brother Philippe Lellouche is also an actor and director.\\r\\n\\r\\nSource: Article \\"Gilles Lellouche\\" from Wikipedia in english, licensed under CC-BY-SA 3.0."}',
                'place_of_birth' => 'Savigny-sur-Orge, Essonne, France',
                'DOB' => '1972-07-05',
                'created_at' => '2021-10-19 14:08:24',
                'updated_at' => '2021-10-19 14:31:17',
                'slug' => 'gilles-lellouche',
            ),
            6 => 
            array (
                'id' => 7,
                'name' => '{"en":"Fran\\u00e7ois Civil"}',
                'image' => 'tmdb_vSkggoDmEHl820VMBzpGkjARU2z.jpg',
            'biography' => '{"en":"Fran\\u00e7ois Civil, n\\u00e9 le\\u00a029 janvier\\u00a01990\\u00a0\\u00e0\\u00a0Paris, est un acteur fran\\u00e7ais.\\r\\n\\r\\n Alors qu\'il d\\u00e9marre des \\u00e9tudes de th\\u00e9\\u00e2tre au studio Le Magasin, Fran\\u00e7ois Civil d\\u00e9croche un r\\u00f4le dans le film\\u00a0Le Cactus\\u00a0r\\u00e9alis\\u00e9 par\\u00a0Michel Munz\\u00a0et\\u00a0G\\u00e9rard Bitton. Puis\\u00a0Laurence Ferreira-Barbosa\\u00a0lui confie le premier r\\u00f4le de son film\\u00a0Soit je meurs, soit je vais mieux\\u00a0pour lequel il est pr\\u00e9nomm\\u00e9 pour le C\\u00e9sar de la R\\u00e9v\\u00e9lation Masculine en 2009.  Il continue ses \\u00e9tudes de th\\u00e9\\u00e2tre tout en tournant pour le cin\\u00e9ma et la t\\u00e9l\\u00e9vision, notamment dans\\u00a0Dans nos veines\\u00a0r\\u00e9alis\\u00e9 par\\u00a0Guillaume Senez\\u00a0pour lequel il obtient le Prix d\'interpr\\u00e9tation au Brussels Short Film Festival, et le double Prix d\'interpr\\u00e9tation (Prix du Jury Jeune Espoir et Prix du Public) au 15\\u00e8me\\u00a0Festival Jean Carmet\\u00a0de Moulins,\\u00a0Nos r\\u00e9sistances\\u00a0r\\u00e9alis\\u00e9 par\\u00a0Romain Cogitore\\u00a0pour lequel il est \\u00e0 nouveau pr\\u00e9nomm\\u00e9 pour le C\\u00e9sar de la R\\u00e9v\\u00e9lation Masculine en 2012,\\u00a0Bus Palladium\\u00a0r\\u00e9alis\\u00e9 par\\u00a0Christopher Thompson,\\u00a0Elles\\u00a0r\\u00e9alis\\u00e9 par\\u00a0Ma\\u0142gorzata Szumowska.  En 2013, il obtient le prix Premier Rendez-vous au Festival du film de Cabourg pour son r\\u00f4le dans\\u00a0Macadam baby\\u00a0de Patrick bossard.  Plus r\\u00e9cemment, il a tourn\\u00e9 - en anglais - dans\\u00a0Frank\\u00a0r\\u00e9alis\\u00e9 par\\u00a0Lenny Abrahamson."}',
                'place_of_birth' => 'Paris, France',
                'DOB' => '1990-01-29',
                'created_at' => '2021-10-19 14:08:25',
                'updated_at' => '2021-10-19 14:31:24',
                'slug' => 'francois-civil',
            ),
            7 => 
            array (
                'id' => 8,
                'name' => '{"en":"Karim Leklou"}',
                'image' => 'tmdb_siY3B37DzlNIa5w8cQ5vPTrThd1.jpg',
                'biography' => '{"en":null}',
                'place_of_birth' => 'Sèvres, France',
                'DOB' => '1982-06-20',
                'created_at' => '2021-10-19 14:08:26',
                'updated_at' => '2021-10-19 14:31:30',
                'slug' => 'karim-leklou',
            ),
            8 => 
            array (
                'id' => 9,
                'name' => '{"en":"Ad\\u00e8le Exarchopoulos"}',
                'image' => 'tmdb_zlto2xvsdzLnfzoZNnS6txzNO5l.jpg',
            'biography' => '{"en":"Ad\\u00e8le Exarchopoulos (born 22 November 1993) is a French actress. She is known for her leading performance as Ad\\u00e8le in Blue Is the Warmest Colour, a role which gave her worldwide attention and critical acclaim and she became the youngest artist ever to be awarded the Palme d\'Or at the Cannes Film Festival.\\r\\n\\r\\nDescription above from the Wikipedia article Ad\\u00e8le Exarchopoulos, licensed under CC-BY-SA, full list of contributors on Wikipedia."}',
                'place_of_birth' => 'Paris, France',
                'DOB' => '1993-11-22',
                'created_at' => '2021-10-19 14:08:27',
                'updated_at' => '2021-10-19 14:31:45',
                'slug' => 'adele-exarchopoulos',
            ),
            9 => 
            array (
                'id' => 10,
                'name' => '{"en":"Cyril Lecomte"}',
                'image' => 'tmdb_sE7I31LJx9Zfh2IIWg3qhCC8Lzh.jpg',
                'biography' => '{"en":null}',
                'place_of_birth' => 'Marseille, Bouches-du-Rhône, France',
                'DOB' => '1967-07-30',
                'created_at' => '2021-10-19 14:08:28',
                'updated_at' => '2021-10-19 14:31:53',
                'slug' => 'cyril-lecomte',
            ),
            10 => 
            array (
                'id' => 11,
                'name' => '{"en":"Yuki Kaji"}',
                'image' => 'tmdb_8wKdPV11IwowfwoqGqMMNt9hmp6.jpg',
                'biography' => '{"en":"Yuki Kaji is a Japanese voice\\u2005actor and singer affiliated with the agency VIMS. He has also been a radio host and acted on stage, and since 2015 has also occasionally been cast in on-screen roles in television dramas. He has voiced many notable roles such as Eren\\u2005Yeager in Attack\\u2005on\\u2005Titan, Issei\\u2005Hyodo in High\\u2005School\\u2005DxD, Shu Ouma in Guilty\\u2005Crown, Alibaba in Magi:\\u2005The\\u2005Labyrinth\\u2005of\\u2005Magic, Kazuya Ichinose and Akio Fudou in Inazuma\\u2005Eleven:\\u2005Orion\\u2005no\\u2005Kokuin, Clemont in Pok\\u00e9mon\\u2005XY, Meliodas and Zeldris in The\\u2005Seven\\u2005Deadly\\u2005Sins, Yukine in Noragami, Speed-O\'Sound\\u2005Sonic in One-Punch\\u2005Man, Kanato Sakamaki in Diabolik\\u2005Lovers, Todoroki Sh\\u014dto in My\\u2005Hero\\u2005Academia, Kozume Kenma in Haikyu!!, Koichi Hirose in JoJo\'s\\u2005Bizarre\\u2005Adventure."}',
                'place_of_birth' => 'Tokyo, Japan',
                'DOB' => '1985-09-03',
                'created_at' => '2021-10-19 14:09:21',
                'updated_at' => '2021-10-19 14:32:01',
                'slug' => 'yuki-kaji',
            ),
            11 => 
            array (
                'id' => 12,
                'name' => '{"en":"Sora Amamiya"}',
                'image' => 'tmdb_25o1W6AtzQqHJTu56wICengUOuj.jpg',
            'biography' => '{"en":"Japanese voice actress and singer from Toyko, affiliated with Music Ray\'n.  After passing an audition held by Music Ray\'n, she made her voice acting debut in 2012.  She played her first main role as Kaori Fujimiya in the 2014 anime series.\\r\\n\\r\\nIn 2015 She form a group Unit call \\"Try Sail\\" 3 voice actress (Momo Asakura, Sora Amamiya, Shiina Natsukawa), Mange by Sony\'s Music Ray\'s Subdivision. Their 1st single \\"Whiz\\" reached the 4th palce on the weekly Oricon Singles Chart. And still active to this day.\\r\\n\\r\\nIn 2017, they song Original \\"Interviews with Monster Girls, Adrenaline!!!\\" for \\"Eromanga Senl-sei\\".\\r\\n\\r\\nIn 2018, they song azure for \\"Zoku monogatari\\", \\"Wanted Girl\\" and \\"Truth\\" for \\"Time Bokan 24."}',
                'place_of_birth' => 'Tokyo, Japan',
                'DOB' => '1993-08-28',
                'created_at' => '2021-10-19 14:09:22',
                'updated_at' => '2021-10-19 14:32:08',
                'slug' => 'sora-amamiya',
            ),
            12 => 
            array (
                'id' => 13,
                'name' => '{"en":"Misaki Kuno"}',
                'image' => 'tmdb_6qslBrgao1mthGJK3M9keUYyMIw.jpg',
            'biography' => '{"en":"Misaki Kuno (\\u4e45\\u91ce \\u7f8e\\u54b2, Kuno Misaki, born January 19, 1993) is a Japanese actress and voice actress from Tokyo, Japan."}',
                'place_of_birth' => 'Tokyo, Tokyo Prefecture, Japan',
                'DOB' => '1993-01-19',
                'created_at' => '2021-10-19 14:09:23',
                'updated_at' => '2021-10-19 14:32:54',
                'slug' => 'misaki-kuno',
            ),
            13 => 
            array (
                'id' => 14,
                'name' => '{"en":"Aoi Yuki"}',
                'image' => 'tmdb_4kHNZSUIux52UU2BD3H6b5c5ymZ.jpg',
                'biography' => '{"en":"Aoi Yuki is a Japanese voice actress, actress and singer."}',
                'place_of_birth' => 'Chiba Prefecture, Japan',
                'DOB' => '1992-03-27',
                'created_at' => '2021-10-19 14:09:25',
                'updated_at' => '2021-10-19 14:32:54',
                'slug' => 'aoi-yuki',
            ),
            14 => 
            array (
                'id' => 15,
                'name' => '{"en":"Tatsuhisa Suzuki"}',
                'image' => 'tmdb_foytL2OreKzQcTNftz2qMgClKKg.jpg',
            'biography' => '{"en":"Tatsuhisa Suzuki (\\u9234\\u6728 \\u9054\\u592e) is a Japanese voice actor and singer. He is affiliated with I\'m Enterprise and Lantis. He is the vocalist of the rock band Oldcodex under his stage name Ta_2.\\n\\nFrom Wikipedia, the free encyclopedia"}',
                'place_of_birth' => 'Ichikawa, Chiba Prefecture, Japan',
                'DOB' => '1983-11-11',
                'created_at' => '2021-10-19 14:09:26',
                'updated_at' => '2021-10-19 14:32:54',
                'slug' => 'tatsuhisa-suzuki',
            ),
            15 => 
            array (
                'id' => 16,
                'name' => '{"en":"Dwayne Johnson"}',
                'image' => 'tmdb_cgoy7t5Ve075naBPcewZrc08qGw.jpg',
                'biography' => '{"en":"An American and Canadian actor, producer and semi-retired professional wrestler, signed with WWE.  Johnson is half-Black and half-Samoan. His father, Rocky Johnson, is a Black Canadian, from Nova Scotia, and part of the first Black tag team champions in WWE history back when it was known as the WWF along with Tony Atlas. His mother is Samoan and the daughter of Peter Maivia, who was also a pro wrestler. Maivia\'s wife, Lia Maivia, was one of wrestling\'s few female promoters, taking over Polynesian Pacific Pro Wrestling after her husband\'s death in 1982, until 1988. Through his mother, he is considered a non-blood relative of the Anoa\'i wrestling family. On March 29, 2008, The Rock inducted his father and his grandfather into the WWE Hall of Fame.\\n\\nAs of 2014, Johnson has a home in Southwest Ranches, Florida as well as Los Angeles, California. He also owns a farm in Virginia. In 2009, Johnson gained citizenship in Canada in honor of his father\'s background. Though Johnson was previously registered as a Republican, he voted for Barack Obama in the 2008 and 2012 United States presidential elections and is now an independent voter. He stated he did not vote in the 2016 U.S. election.\\n\\nIn recognition of his service to the Samoan people, and because he is a descendant of Samoan chiefs, Johnson had the noble title of Seiuli bestowed upon him by Malietoa Tanumafili II during his visit there in July 2004. He received a partial Samoan pe\'a tattoo on his left side in 2003,and, in 2017, had the small \\"Brahma bull\\" tattoo on his right arm covered with a larger half-sleeve tattoo of a bull\'s skull.\\n\\nJohnson married Dany Garcia on May 3, 1997. Their only child together, a daughter named Simone, was born in August 2001. On June 1, 2007, they announced they were splitting up amicably. Johnson then began dating Lauren Hashian, daughter of Boston drummer Sib Hashian. They first met in 2006 while Johnson was filming The Game Plan. Their first child together, a daughter, was born in December 2015. Their second child, another daughter, was born in April 2018.\\n\\nJohnson attended the 2000 Democratic National Convention as part of WWE\'s non-partisan \\"Smackdown Your Vote\\" campaign, which aimed to influence young people to vote. He also had a speaking role at the 2000 Republican National Convention that same year.\\n\\nIn 2006, Johnson founded the Dwayne Johnson Rock Foundation, a charity working with at-risk and terminally ill children. On October 2, 2007, he and his ex-wife donated $1 million to the University of Miami to support the renovation of its football facilities; it was noted as the largest donation ever given to the university\'s athletics department by former students. The University of Miami renamed the Hurricanes\' locker room in Johnson\'s honor. In 2015, Johnson donated $1,500 to a GoFundMe to pay for an abandoned dog\'s surgery. In 2017, he donated $25,000 to Hurricane Harvey relief efforts. In 2018, Johnson donated a gym to a military base in Oahu, Hawaii. After the 2018 Hawaii floods, he worked with Malama Kauai, a nonprofit organization, to help repair damages caused by the floods."}',
                'place_of_birth' => 'Hayward, California, USA',
                'DOB' => '1972-05-02',
                'created_at' => '2021-10-19 14:10:34',
                'updated_at' => '2021-10-19 14:32:54',
                'slug' => 'dwayne-johnson',
            ),
            16 => 
            array (
                'id' => 17,
                'name' => '{"en":"Emily Blunt"}',
                'image' => 'tmdb_jqlqq3knztTnty5rcMg5evqZRCa.jpg',
            'biography' => '{"en":"Emily Olivia Leah Blunt (born 23 February 1983) is a British actress. Her accolades include a Golden Globe Award and a Screen Actors Guild Award, in addition to nominations for two British Academy Film Awards.\\n\\nEducated at Hurtwood House in Dorking, Blunt made her acting debut in a 2001 stage production of The Royal Family. She went on to appear in the television film Boudica (2003) and portrayed Queen Catherine Howard in the miniseries Henry VIII (2003). She made her feature film debut in the drama My Summer of Love (2004). Blunt\'s breakthrough came in 2006 with her starring roles in the television film Gideon\'s Daughter and the comedy-drama film The Devil Wears Prada. The former won her a Golden Globe Award for Best Supporting Actress and the latter earned her a nomination for the BAFTA Award for Best Actress in a Supporting Role.\\n\\nBlunt\'s profile continued to grow with leading roles in the period film The Young Victoria (2009), the romantic comedy Salmon Fishing in the Yemen (2011), the science fiction films The Adjustment Bureau (2011), Looper (2012), and Edge of Tomorrow (2014), and the musical films Into the Woods (2014) and Mary Poppins Returns (2018). She received critical acclaim for playing a principled FBI agent in the crime film Sicario (2015), an alcoholic in the thriller The Girl on the Train (2016), which earned her a nomination for the BAFTA Award for Best Actress in a Leading Role, and a survivalist mother in the horror film A Quiet Place (2018). For the latter, which was directed by her husband John Krasinski, she won the Screen Actors Guild Award for Best Supporting Actress."}',
                'place_of_birth' => 'Wandsworth, London, England, UK',
                'DOB' => '1983-02-23',
                'created_at' => '2021-10-19 14:10:36',
                'updated_at' => '2021-10-19 14:32:54',
                'slug' => 'emily-blunt',
            ),
            17 => 
            array (
                'id' => 18,
                'name' => '{"en":"Edgar Ram\\u00edrez"}',
                'image' => 'tmdb_7VZnIAI7Yye0rfs7fPM5wI2CI6N.jpg',
            'biography' => '{"en":"Edgar Ramirez Arellano is a venezuelan actor. He played Carlos in the 2010 French-German biopic series Carlos, a role for which he won the C\\u00e9sar Award for Most Promising Actor at the C\\u00e9sar Awards 2011.\\n\\nHis first recognition as an actor was the successful soap opera Cosita Rica, for Venevisi\\u00f3n which aired in September 2003 to August 2004 lasting 270 episodes. In 2005, he made his major motion picture d\\u00e9but playing Choco, Domino Harvey\'s love interest in the film Domino directed by Tony Scott.\\n\\nHe was in Vantage Point directed by Pete Travis. In this high-budgeted Sony Pictures political thriller, Ram\\u00edrez joined an all-star international cast including Dennis Quaid, Matthew Fox, William Hurt, Forrest Whitaker, Eduardo Noriega, and Ayelet Zurer. Ram\\u00edrez plays Javier, an ex-special forces soldier forced to kidnap the American President in order to get his brother back. Upcoming is Cyrano Fernandez, with Ram\\u00edrez in the title role. This independent production was directed by Alberto Arvelo and is based on the French play Cyrano de Bergerac.\\n\\nRam\\u00edrez has appeared in several other productions. Among those are the first part of the two film bundle Che by Steven Soderbergh, where he played the role of Ciro Redondo (a Cuban revolutionary who fought amongst Ch\\u00e9 Guevara), La Hora Cero (The Magic Hour), a short film directed by Guillermo Arriaga, the acclaimed screenwriter of Amores Perros, 21 Grams and Babel (Mexico); Plan B, directed by Alejandro Garc\\u00eda Wiederman (Venezuela); Yotama se va volando (Yotama Flies Away), directed by Luis Armando Roche (Venezuela-France); Punto y raya (Step Forward), directed by Elia K. Schneider (Venezuela-Spain-Chile-Uruguay), submitted by Venezuela for Oscar consideration for 2004 Best Foreign Film, in which he played Colombian soldier Pedro.\\n\\nIn 2007, he played the role of Paz, a Blackbriar assassin, in The Bourne Ultimatum. In the original Bourne Ultimatum, the villain is Illich Ramirez Sanchez, aka Carlos the Jackal. Ram\\u00edrez went on to play the role of the actual Carlos in the 2010 French-German limited series Carlos. At the French C\\u00e9sar Awards 2011, he was awarded, for the film version of the TV series, the C\\u00e9sar Award for Most Promising Actor.\\n\\nRam\\u00edrez appeared in the Clash of the Titans (2010) sequel, Wrath of the Titans (2012), playing Ares, the God of War. Also in 2012, he played Larry in the Kathryn Bigelow film, Zero Dark Thirty."}',
                'place_of_birth' => 'San Cristobal, Venezuela',
                'DOB' => '1977-03-25',
                'created_at' => '2021-10-19 14:10:38',
                'updated_at' => '2021-10-19 14:32:54',
                'slug' => 'edgar-ramirez',
            ),
            18 => 
            array (
                'id' => 19,
                'name' => '{"en":"Jack Whitehall"}',
                'image' => 'tmdb_8xRKz1tiVyjLxIMuD0ckOmF3xMY.jpg',
            'biography' => '{"en":"An English comedian, television presenter, actor and writer. He is best known for his stand up comedy, for starring as JP in the TV series Fresh Meat (2011\\u20132016), and for playing Alfie Wickers in the TV series Bad Education (2012\\u20132014) and the spin-off film The Bad Education Movie (2015), both of which he also co-wrote. He has also starred in Frozen in the role of Gothi the Troll. From 2012 to 2018, Whitehall was a regular panellist on the game show A League of Their Own. In 2017, Whitehall appeared with his father, Michael, in the Netflix comedy documentary series Jack Whitehall: Travels with My Father and starred in the television series Decline and Fall. Since 2018, Whitehall has been the host of the BRIT Awards."}',
                'place_of_birth' => 'London, England, UK',
                'DOB' => '1988-07-07',
                'created_at' => '2021-10-19 14:10:39',
                'updated_at' => '2021-10-19 14:32:54',
                'slug' => 'jack-whitehall',
            ),
            19 => 
            array (
                'id' => 20,
                'name' => '{"en":"Jesse Plemons"}',
                'image' => 'tmdb_ckTthGclQE0y6b7gR0RpRo7LskL.jpg',
            'biography' => '{"en":"Plemons began his career as a child actor and achieved a career breakthrough with his supporting role as Landry Clarke in the NBC drama series Friday Night Lights (2006\\u201311). He subsequently portrayed Todd Alquist in season 5 of the AMC crime drama series Breaking Bad and won a Screen Actors Guild Award for his performance as part of the show\'s ensemble cast; he reprised the role in its sequel, the television film El Camino: A Breaking Bad Movie (2019).  Following Breaking Bad, Plemons received his first Primetime Emmy Award nomination and won a Critics\' Choice Television Award for portraying Ed Blumquist in the season 2 of the FX anthology series Fargo. He received a second Primetime Emmy Award nomination for his portrayal of Robert Daly in \\"USS Callister\\", an episode of the Netflix anthology series Black Mirror."}',
                'place_of_birth' => 'Dallas, Texas, United States',
                'DOB' => '1988-04-02',
                'created_at' => '2021-10-19 14:10:40',
                'updated_at' => '2021-10-19 14:32:54',
                'slug' => 'jesse-plemons',
            ),
            20 => 
            array (
                'id' => 21,
                'name' => '{"en":"Asa Butterfield"}',
                'image' => 'tmdb_hMDIBO0QcOydD0UtfeDjTR7mhi6.jpg',
                'biography' => '{"en":"Asa Butterfield is an English actor.\\u00a0He is best known for his leading roles in the Holocaust film The Boy in the Striped Pyjamas,\\u00a0Martin Scorsese\'s Hugo, and the\\u00a0film adaptation of Ender\'s Game."}',
                'place_of_birth' => 'Islington, London, England, UK',
                'DOB' => '1997-04-01',
                'created_at' => '2021-10-19 14:14:06',
                'updated_at' => '2021-10-19 14:32:54',
                'slug' => 'asa-butterfield',
            ),
            21 => 
            array (
                'id' => 22,
                'name' => '{"en":"Gillian Anderson"}',
                'image' => 'tmdb_60fOJNhmfEmyskQDmHStSMHRjgK.jpg',
            'biography' => '{"en":"Gillian Leigh Anderson (born August 9, 1968) is an American actress. After beginning her career in theatre, Anderson achieved international recognition for her role as Special Agent Dana Scully on the American television series The X-Files. Her film work includes The House of Mirth (2000), The Mighty Celt (2005), The Last King of Scotland (2006), and two X-Files films, The X-Files (1998) and The X-Files: I Want to Believe (2008).\\n\\nAnderson was born in Chicago, Illinois, the daughter of Rosemary Anderson (n\\u00e9e Lane), a computer analyst, and Edward Anderson, who owned a film post-production company.Her father was of English descent, while her mother was of Irish and German ancestry. Soon after her birth, her family moved to Puerto Rico for 15 months; her family then moved to the United Kingdom where she lived until she was 11 years old. She lived for five years in Rosebery Gardens, Crouch End, London, and for 15 months in Albany Road, Stroud Green, London, so that her father could attend the London Film School.\\n\\nShe was a pupil of Coleridge Primary School. When Anderson was 11 years old, her family moved again, this time to Grand Rapids, Michigan. She attended Fountain Elementary and then City High-Middle School, a program for gifted students with a strong emphasis on the humanities; she graduated in 1986.\\n\\nAlong with other actors (notably Linda Thorson and John Barrowman) Anderson is bidialectal. With her English accent and background, Anderson was mocked and felt out of place in the American Midwest and soon adopted a Midwest accent. To this day, her accent depends on her location \\u2014 for instance, in an interview with Jay Leno she spoke in an American accent, but shifted it for an interview with Michael Parkinson.\\n\\nAnderson was interested in marine biology, but began acting her freshman year in high school productions, and later in community theater, and served as a student intern at the Grand Rapids Civic Theatre & School of Theatre Arts. She attended The Theatre School at DePaul University in Chicago (formerly the Goodman School of Drama), where she earned a Bachelor of Fine Arts in 1990. She also participated in the National Theatre of Great Britain\'s summer program at Cornell University.\\n\\nAnderson\'s brother died in 2011 of a brain tumor, at the age of 30.\\n\\nAnderson married her first husband, Clyde Klotz, The X-Files series assistant art director, on New Year\'s Day, 1994, in Hawaii in a Buddhist ceremony. They had a daughter, Piper Maru (born September 1994), for whom Chris Carter named the X-Files episode of the same name, and divorced in 1997.] In December 2004, Anderson married Julian Ozanne, a documentary filmmaker, on Lamu Island, off the coast of Kenya. Anderson announced their separation on April 21, 2006.\\n\\nAnderson and former boyfriend, Mark Griffiths, have two sons: Oscar, born November 2006 and Felix, born October 2008. She ended their relationship in 2012. In March 2012, Anderson told Out magazine about her past relationship with a girl while in high school.\\n\\nIn 1997, she was chosen by People magazine as one of the 50 Most Beautiful People in the World. Askmen listed her at No. 6 on their Top 7: \'90s Sex Symbols. In 2008, she was listed 21st in FHM\'s All Time 100 Sexiest Hall of Fame."}',
                'place_of_birth' => 'Chicago, Illinois, USA',
                'DOB' => '1968-08-09',
                'created_at' => '2021-10-19 14:14:07',
                'updated_at' => '2021-10-19 14:32:54',
                'slug' => 'gillian-anderson',
            ),
            22 => 
            array (
                'id' => 23,
                'name' => '{"en":"Ncuti Gatwa"}',
                'image' => 'tmdb_zc7x4xSaSUb85PBYUj7sXu17NvT.jpg',
                'biography' => '{"en":""}',
                'place_of_birth' => 'Edinburgh, Scotland, UK',
                'DOB' => '1992-10-16',
                'created_at' => '2021-10-19 14:14:08',
                'updated_at' => '2021-10-19 14:32:54',
                'slug' => 'ncuti-gatwa',
            ),
            23 => 
            array (
                'id' => 24,
                'name' => '{"en":"Emma Mackey"}',
                'image' => 'tmdb_nVcW3khbrOdCZrsmx1VeTxQGQSv.jpg',
                'biography' => '{"en":"Born January 4th, 1996 in Le Mans, France to a British mother and a French father. Emma Mackey moved to the UK at the age of 17 to study English Language and Literature at the University of Leeds from 2013 to 2016. After directing and appearing in various stage productions there, she started to pursue a career in acting and moved to London after graduating. Her breakout role was in 2019, as Maeve in the Netflix series Sex Education. In 2020 she played Jacqueline de Bellefort in Death on the Nile."}',
                'place_of_birth' => 'Le Mans, France',
                'DOB' => '1996-01-04',
                'created_at' => '2021-10-19 14:14:09',
                'updated_at' => '2021-10-19 14:32:54',
                'slug' => 'emma-mackey',
            ),
            24 => 
            array (
                'id' => 25,
                'name' => '{"en":"Connor Swindells"}',
                'image' => 'tmdb_jUY1Ayi79usRpwjMmrGVtGmWL6B.jpg',
            'biography' => '{"en":"An actor, known for VS. (2018), The Vanishing (2018) and Sex Education (2019)."}',
                'place_of_birth' => 'West Chiltington, West Sussex, England, UK',
                'DOB' => '1996-09-19',
                'created_at' => '2021-10-19 14:14:10',
                'updated_at' => '2021-10-19 14:32:54',
                'slug' => 'connor-swindells',
            ),
            25 => 
            array (
                'id' => 26,
                'name' => '{"en":"Asa Butterfield"}',
                'image' => 'tmdb_hMDIBO0QcOydD0UtfeDjTR7mhi6.jpg',
                'biography' => '{"en":"Asa Butterfield is an English actor.\\u00a0He is best known for his leading roles in the Holocaust film The Boy in the Striped Pyjamas,\\u00a0Martin Scorsese\'s Hugo, and the\\u00a0film adaptation of Ender\'s Game."}',
                'place_of_birth' => 'Islington, London, England, UK',
                'DOB' => '1997-04-01',
                'created_at' => '2021-10-19 14:14:19',
                'updated_at' => '2021-10-19 14:32:54',
                'slug' => 'asa-butterfield',
            ),
            26 => 
            array (
                'id' => 27,
                'name' => '{"en":"Gillian Anderson"}',
                'image' => 'tmdb_60fOJNhmfEmyskQDmHStSMHRjgK.jpg',
            'biography' => '{"en":"Gillian Leigh Anderson (born August 9, 1968) is an American actress. After beginning her career in theatre, Anderson achieved international recognition for her role as Special Agent Dana Scully on the American television series The X-Files. Her film work includes The House of Mirth (2000), The Mighty Celt (2005), The Last King of Scotland (2006), and two X-Files films, The X-Files (1998) and The X-Files: I Want to Believe (2008).\\n\\nAnderson was born in Chicago, Illinois, the daughter of Rosemary Anderson (n\\u00e9e Lane), a computer analyst, and Edward Anderson, who owned a film post-production company.Her father was of English descent, while her mother was of Irish and German ancestry. Soon after her birth, her family moved to Puerto Rico for 15 months; her family then moved to the United Kingdom where she lived until she was 11 years old. She lived for five years in Rosebery Gardens, Crouch End, London, and for 15 months in Albany Road, Stroud Green, London, so that her father could attend the London Film School.\\n\\nShe was a pupil of Coleridge Primary School. When Anderson was 11 years old, her family moved again, this time to Grand Rapids, Michigan. She attended Fountain Elementary and then City High-Middle School, a program for gifted students with a strong emphasis on the humanities; she graduated in 1986.\\n\\nAlong with other actors (notably Linda Thorson and John Barrowman) Anderson is bidialectal. With her English accent and background, Anderson was mocked and felt out of place in the American Midwest and soon adopted a Midwest accent. To this day, her accent depends on her location \\u2014 for instance, in an interview with Jay Leno she spoke in an American accent, but shifted it for an interview with Michael Parkinson.\\n\\nAnderson was interested in marine biology, but began acting her freshman year in high school productions, and later in community theater, and served as a student intern at the Grand Rapids Civic Theatre & School of Theatre Arts. She attended The Theatre School at DePaul University in Chicago (formerly the Goodman School of Drama), where she earned a Bachelor of Fine Arts in 1990. She also participated in the National Theatre of Great Britain\'s summer program at Cornell University.\\n\\nAnderson\'s brother died in 2011 of a brain tumor, at the age of 30.\\n\\nAnderson married her first husband, Clyde Klotz, The X-Files series assistant art director, on New Year\'s Day, 1994, in Hawaii in a Buddhist ceremony. They had a daughter, Piper Maru (born September 1994), for whom Chris Carter named the X-Files episode of the same name, and divorced in 1997.] In December 2004, Anderson married Julian Ozanne, a documentary filmmaker, on Lamu Island, off the coast of Kenya. Anderson announced their separation on April 21, 2006.\\n\\nAnderson and former boyfriend, Mark Griffiths, have two sons: Oscar, born November 2006 and Felix, born October 2008. She ended their relationship in 2012. In March 2012, Anderson told Out magazine about her past relationship with a girl while in high school.\\n\\nIn 1997, she was chosen by People magazine as one of the 50 Most Beautiful People in the World. Askmen listed her at No. 6 on their Top 7: \'90s Sex Symbols. In 2008, she was listed 21st in FHM\'s All Time 100 Sexiest Hall of Fame."}',
                'place_of_birth' => 'Chicago, Illinois, USA',
                'DOB' => '1968-08-09',
                'created_at' => '2021-10-19 14:14:20',
                'updated_at' => '2021-10-19 14:32:54',
                'slug' => 'gillian-anderson',
            ),
            27 => 
            array (
                'id' => 28,
                'name' => '{"en":"Ncuti Gatwa"}',
                'image' => 'tmdb_zc7x4xSaSUb85PBYUj7sXu17NvT.jpg',
                'biography' => '{"en":""}',
                'place_of_birth' => 'Edinburgh, Scotland, UK',
                'DOB' => '1992-10-16',
                'created_at' => '2021-10-19 14:14:21',
                'updated_at' => '2021-10-19 14:32:54',
                'slug' => 'ncuti-gatwa',
            ),
            28 => 
            array (
                'id' => 29,
                'name' => '{"en":"Emma Mackey"}',
                'image' => 'tmdb_nVcW3khbrOdCZrsmx1VeTxQGQSv.jpg',
                'biography' => '{"en":"Born January 4th, 1996 in Le Mans, France to a British mother and a French father. Emma Mackey moved to the UK at the age of 17 to study English Language and Literature at the University of Leeds from 2013 to 2016. After directing and appearing in various stage productions there, she started to pursue a career in acting and moved to London after graduating. Her breakout role was in 2019, as Maeve in the Netflix series Sex Education. In 2020 she played Jacqueline de Bellefort in Death on the Nile."}',
                'place_of_birth' => 'Le Mans, France',
                'DOB' => '1996-01-04',
                'created_at' => '2021-10-19 14:14:22',
                'updated_at' => '2021-10-19 14:32:54',
                'slug' => 'emma-mackey',
            ),
            29 => 
            array (
                'id' => 30,
                'name' => '{"en":"Connor Swindells"}',
                'image' => 'tmdb_jUY1Ayi79usRpwjMmrGVtGmWL6B.jpg',
            'biography' => '{"en":"An actor, known for VS. (2018), The Vanishing (2018) and Sex Education (2019)."}',
                'place_of_birth' => 'West Chiltington, West Sussex, England, UK',
                'DOB' => '1996-09-19',
                'created_at' => '2021-10-19 14:14:22',
                'updated_at' => '2021-10-19 14:32:54',
                'slug' => 'connor-swindells',
            ),
            30 => 
            array (
                'id' => 31,
                'name' => '{"en":"Lee Jung-jae"}',
                'image' => 'tmdb_s3Sv4bZORQ5DuZJahgU2X0RgMUQ.jpg',
            'biography' => '{"en":"Lee Jung-jae (\\uc774\\uc815\\uc7ac) is a South Korean actor. Born on March 15, 1973, he began modeling in 1993 before getting his first acting roles the film The Young Man (1994) and the TV series Feelings (1994) and Sandglass (1995), which is one of the highest rated Korean dramas of all time with a peak rating of 64.5%. But his real breakthrough was with leading roles in award-winning films The Affair (1998) and City of the Rising Sun (1999). The latter of which earned him the Best Actor award at the prestigious Blue Dragon film awards.\\n\\nThis was followed by a series of critical hits like Il Mare (2000) and commercial successes including Last Present (2001), The Last Witness (2001), Oh Brothers (2003), and the blockbuster Typhoon (2005). After a brief career slump of flop movies and tv shows, he returned with the critical and commercial hit The Housemaid (2010), which is a remake of the 1960 film of the same name. Since then, he went on to cement himself as one of Korea\'s biggest movie stars with a string of some of the biggest blockbusters in Korean history including The Thieves (2012), New World (2013), The Face Reader (2013), Assassination (2015), Operation Chromite (2016), and the Along with the Gods films (2017-2018). Most of these films did north of 12 million admissions at the domestic box-office, with The Thieves (2012) and Along with the Gods (2017) becoming the #2 biggest Korean hit in history at their respective time of release. He received a number of awards and nominations for these works including a Popularity Award at the prestigious Grand Bell awards.\\n\\nHis most recent blockbuster is Deliver Us From Evil (2020) in which he reunited with his New World (2013) co-star Hwang Jung-min. It crossed 4 million admissions domestically and was the second biggest hit of the year in Korea."}',
                'place_of_birth' => 'Seoul, South Korea',
                'DOB' => '1973-03-15',
                'created_at' => '2021-10-19 14:16:25',
                'updated_at' => '2021-10-19 14:32:54',
                'slug' => 'lee-jung-jae',
            ),
            31 => 
            array (
                'id' => 32,
                'name' => '{"en":"Park Hae-soo"}',
                'image' => 'tmdb_hfejrQ8gjRWCheiKpJANajXT0xi.jpg',
                'biography' => '{"en":""}',
                'place_of_birth' => 'South Korea',
                'DOB' => '1981-11-21',
                'created_at' => '2021-10-19 14:16:26',
                'updated_at' => '2021-10-19 14:32:54',
                'slug' => 'park-hae-soo',
            ),
            32 => 
            array (
                'id' => 33,
                'name' => '{"en":"Jung Ho-yeon"}',
                'image' => 'tmdb_2nKZaOgwpJbJXegDISQIdfsfnm0.jpg',
            'biography' => '{"en":"HoYeon Jung is a South Korean fashion model. Vogue has dubbed her as \\u201cKorea\\u2019s next top model\\u201d, and she appeared on the namesake show\\u2019s 4th season (where she was placed second). She currently ranks as one of the \\u201cTop 50\\u201d fashion models by models.com."}',
                'place_of_birth' => 'Seoul, South Korea',
                'DOB' => '1994-06-23',
                'created_at' => '2021-10-19 14:16:28',
                'updated_at' => '2021-10-19 14:32:54',
                'slug' => 'jung-ho-yeon',
            ),
            33 => 
            array (
                'id' => 34,
                'name' => '{"en":"Wi Ha-joon"}',
                'image' => 'tmdb_5fObmvzd1g8nu53itss3JZQiKo7.jpg',
                'biography' => '{"en":""}',
                'place_of_birth' => 'Wando, South Jeolla, South Korea',
                'DOB' => '1991-08-05',
                'created_at' => '2021-10-19 14:16:29',
                'updated_at' => '2021-10-19 14:32:54',
                'slug' => 'wi-ha-joon',
            ),
            34 => 
            array (
                'id' => 35,
                'name' => '{"en":"Oh Yeong-su"}',
                'image' => 'tmdb_kUzd955UTVnac2sVG0tYmt9w5jb.jpg',
                'biography' => '{"en":""}',
                'place_of_birth' => 'South Korea',
                'DOB' => '1944-10-19',
                'created_at' => '2021-10-19 14:16:30',
                'updated_at' => '2021-10-19 14:32:54',
                'slug' => 'oh-yeong-su',
            ),
            35 => 
            array (
                'id' => 36,
                'name' => '{"en":"Thomasin McKenzie"}',
                'image' => 'tmdb_WOpnEFG5Q8LWxP81MtUrskmVox.jpg',
            'biography' => '{"en":"Thomasin \\"Tom\\" McKenzie (born July 2000) is a New Zealand actress. Most well known for playing Pixie Hannah in Shortland Street, she has also starred in The Hobbit: The Battle of the Five Armies as Astrid, in Lucy Lewis Can\'t Lose as Lucy Lewis, and in the webseries Bright Summer Night as Petra Quince, having the leading role in the film Leave No Trace (2018) and Jojo Rabbit (2019).\\n\\nDescription above from the Wikipedia article Thomasin McKenzie, licensed under CC-BY-SA, full list of contributors on Wikipedia."}',
                'place_of_birth' => 'Wellington, New Zealand',
                'DOB' => '2000-07-01',
                'created_at' => '2021-10-19 14:20:01',
                'updated_at' => '2021-10-19 14:32:54',
                'slug' => 'thomasin-mckenzie',
            ),
            36 => 
            array (
                'id' => 37,
                'name' => '{"en":"Anya Taylor-Joy"}',
                'image' => 'tmdb_aSOvCmB1nsl19IqrjuuWwaguvDh.jpg',
            'biography' => '{"en":"Anya Josephine Marie Taylor-Joy (born 16 April 1996)\\u00a0is an American-British actress. She first became known for making appearances on the fantasy series\\u00a0Atlantis\\u00a0(2015), and had her breakthrough with the period horror film\\u00a0The Witch\\u00a0(2015), for which she earned several accolades. She gained further recognition and praise for her role as Casey Cooke in the psychological horror films\\u00a0Split\\u00a0(2016) and\\u00a0Glass\\u00a0(2019), Lily Reynolds in the black comedy\\u00a0Thoroughbreds\\u00a0(2017) and\\u00a0Emma Woodhouse\\u00a0in the comedy-drama\\u00a0Emma\\u00a0(2020). She won an Golden Globe award for best actress in a limited series for her performance as\\u00a0Beth Harmon\\u00a0in the Netflix miniseries\\u00a0The Queen\'s Gambit\\u00a0(2020)."}',
                'place_of_birth' => 'Miami, Florida, USA',
                'DOB' => '1996-04-16',
                'created_at' => '2021-10-19 14:20:04',
                'updated_at' => '2021-10-19 14:32:54',
                'slug' => 'anya-taylor-joy',
            ),
            37 => 
            array (
                'id' => 38,
                'name' => '{"en":"Matt Smith"}',
                'image' => 'tmdb_xr2GSp8Pm6fT5VGm0I9tsWVcZ8q.jpg',
            'biography' => '{"en":"Matthew Robert Smith (born 28 October 1982) is an English stage and television actor. He is known for his role as the eleventh incarnation of the Doctor in the British television series Doctor Who, for which he received a BAFTA Award nomination in 2011. He initially aspired to be a professional footballer, but a back injury forced him out of the sport. After joining the National Youth Theatre and studying Drama and Creative Writing at the University of East Anglia, Smith became an actor in 2003, performing in plays like Murder in the Cathedral, Fresh Kills, The History Boys and On the Shore of the Wide World in London theatres. Extending his repertoire into West End theatre, he has since performed in the stage adaptation of Swimming with Sharks with Christian Slater, followed a year later by a critically acclaimed performance as Henry in That Face. Before his role in Doctor Who, Smith\'s first television role came in 2006 as Jim Taylor in the BBC adaptations of Phillip Pullman\'s The Ruby in the Smoke and The Shadow in the North while his first major role in television came as Danny in the 2007 BBC series Party Animals. Smith, who was cast as the eleventh incarnation of the Doctor in January 2009, is the youngest person to play the character in the British television series. He has most recently appeared in the 2011 BBC television film Christopher and His Kind playing Christopher Isherwood.\\n\\nDescription above from the Wikipedia article Matt Smith (actor), licensed under CC-BY-SA, full list of contributors on Wikipedia"}',
                'place_of_birth' => 'Northampton, Northamptonshire, England, UK',
                'DOB' => '1982-10-28',
                'created_at' => '2021-10-19 14:20:05',
                'updated_at' => '2021-10-19 14:32:54',
                'slug' => 'matt-smith',
            ),
            38 => 
            array (
                'id' => 39,
                'name' => '{"en":"Terence Stamp"}',
                'image' => 'tmdb_v0htmOknJWTMWmt4DIhZlc0VC7.jpg',
            'biography' => '{"en":"Terence Henry Stamp (born 22 July 1938) is an English actor. After training at the Webber Douglas Academy of Dramatic Art in London he started his acting career in 1962. He has been referred to as the \\u201cmaster of the brooding silence\\u201d by The Guardian. His performance in the title role of Billy Budd, his film debut, earned him an Academy Award nomination for Best Supporting Actor and a BAFTA nomination for Best Newcomer. Associated with the Swinging London scene of the 1960s \\u2013 during which time he was in high-profile relationships with actress Julie Christie and supermodel Jean Shrimpton \\u2013 Stamp was among the subjects photographed by David Bailey for a set titled Box of Pin-Ups.\\n\\nStamp played butterfly collector Freddie Clegg in The Collector (1965), and in 1967 appeared in Far from the Madding Crowd, starring opposite Christie. His other major roles include playing archvillain General Zod in Superman and Superman II, tough guy Wilson in The Limey, Supreme Chancellor Valorum in Star Wars: Episode I \\u2013 The Phantom Menace, transgender woman Bernadette Bassinger in The Adventures of Priscilla, Queen of the Desert, ghost antagonist Ramsley in The Haunted Mansion, Stick in Elektra, Pekwarsky in Wanted, Siegfried in Get Smart, Terrence Bundley in Yes Man, the Prophet of Truth in Halo 3, Mankar Camoran in The Elder Scrolls IV: Oblivion, and General Ludwig Beck in Valkyrie. He has appeared in two Tim Burton films, Big Eyes (2014) and Miss Peregrine\'s Home for Peculiar Children (2016).\\n\\nDescription above from the Wikipedia article Terence Stamp, licensed under CC-BY-SA, full list of contributors on Wikipedia."}',
                'place_of_birth' => 'Stepney, London, England, UK',
                'DOB' => '1938-07-22',
                'created_at' => '2021-10-19 14:20:06',
                'updated_at' => '2021-10-19 14:32:54',
                'slug' => 'terence-stamp',
            ),
            39 => 
            array (
                'id' => 40,
                'name' => '{"en":"Diana Rigg"}',
                'image' => 'tmdb_tFZei9BMHqau7XN2PeQ0M24RT7G.jpg',
            'biography' => '{"en":"Dame Enid Diana Elizabeth Rigg DBE (20 July 1938 - 10 September 2020) was an English actress. She played Emma Peel in the TV series The Avengers (1965-1968) and Olenna Tyrell in Game of Thrones (2013-2017). She has also had a career in theatre, including playing the title role in Medea, both in London and New York, for which she won the 1994 Tony Award for Best Actress in a Play. She was made a CBE in 1988 and a Dame in 1994 for services to drama.\\n\\nRigg made her professional stage debut in 1957 in The Caucasian Chalk Circle, and joined the Royal Shakespeare Company in 1959. She made her Broadway debut in the 1971 production of Abelard & Heloise. Her film roles include Helena in A Midsummer Night\'s Dream (1968); Countess Teresa di Vicenzo, wife of James Bond, in On Her Majesty\'s Secret Service (1969); Lady Holiday in The Great Muppet Caper (1981); and Arlena Marshall in Evil Under the Sun (1982). She won the BAFTA TV Award for Best Actress for the BBC miniseries Mother Love (1989), and an Emmy Award for her role as Mrs. Danvers in an adaptation of Rebecca (1997). Her other television credits include You, Me and the Apocalypse (2015), Detectorists (2015), and the Doctor Who episode \\"The Crimson Horror\\" (2013) with her daughter, Rachael Stirling.\\n\\nDescription above from the Wikipedia article Diana Rigg, licensed under CC-BY-SA, full list of contributors on Wikipedia."}',
                'place_of_birth' => 'Doncaster, Yorkshire, England, UK',
                'DOB' => '1938-07-20',
                'created_at' => '2021-10-19 14:20:07',
                'updated_at' => '2021-10-19 14:32:54',
                'slug' => 'diana-rigg',
            ),
            40 => 
            array (
                'id' => 41,
                'name' => '{"en":"Trace Adkins"}',
                'image' => 'tmdb_9MMbYFI0WL2rp5iQG9DeYL0Pgvl.jpg',
            'biography' => '{"en":"Tracy Darrell \\"Trace\\" Adkins (born January 13, 1962) is an American country music artist. He made his debut in 1996 with the album Dreamin\' Out Loud, released on Capitol Records Nashville. Since then, Adkins has released seven more studio albums and two Greatest Hits compilations. In addition, he has charted more than twenty singles on the Billboard country music charts, including the Number One hits \\"(This Ain\'t) No Thinkin\' Thing\\", \\"Ladies Love Country Boys\\", and \\"You\'re Gonna Miss This\\", which peaked in 1997, 2007, and 2008, respectively. \\"I Left Something Turned on at Home\\" went to #1 on Canada\'s country chart. All but one of his studio albums have received gold or platinum certification in the United States; his highest-selling to date is 2005\'s Songs About Me, which has been certified 2\\u00d7 Multi-Platinum for shipping two million copies.\\n\\nHe has also made several appearances on television, including as a panelist on the game shows Hollywood Squares and Pyramid, as a finalist on The Celebrity Apprentice, as the voice for recurring character Elvin on King of the Hill, and in television commercial voice-overs for the KFC restaurant chain. In addition, Adkins has written an autobiography entitled A Personal Stand: Observations and Opinions from a Free-Thinking Roughneck, which was released in late 2007.\\n\\nDescription above from the Wikipedia article Trace Adkins, licensed under CC-BY-SA, full list of contributors on Wikipedia."}',
                'place_of_birth' => 'Springhill, Louisiana, USA',
                'DOB' => '1962-01-13',
                'created_at' => '2021-10-19 14:20:23',
                'updated_at' => '2021-10-19 14:32:54',
                'slug' => 'trace-adkins',
            ),
            41 => 
            array (
                'id' => 42,
                'name' => '{"en":"Thora Birch"}',
                'image' => 'tmdb_7rRirYcL5JJS5P2W67yhsmAfO3x.jpg',
            'biography' => '{"en":"Thora Birch (born March 11, 1982) is an American actress. She was a child actor in the 1990s, starring in movies such as All I Want for Christmas (1991), Patriot Games (1992), Hocus Pocus (1993), Now and Then (1995), and Alaska (1996). She came to prominence in 1999 after earning worldwide attention and praise for her performance in American Beauty. She then starred in the well received film Ghost World (2001), which earned her a Golden Globe nomination.\\n\\nDescription above from the Wikipedia article Thora Birch, licensed under CC-BY-SA, full list of contributors on Wikipedia."}',
                'place_of_birth' => 'Los Angeles, California, USA',
                'DOB' => '1982-03-11',
                'created_at' => '2021-10-19 14:20:24',
                'updated_at' => '2021-10-19 14:32:54',
                'slug' => 'thora-birch',
            ),
            42 => 
            array (
                'id' => 43,
                'name' => '{"en":"Peter Facinelli"}',
                'image' => 'tmdb_rxB2Iwh0xMpQAlt6ZsheTDa48J2.jpg',
            'biography' => '{"en":"Peter Facinelli (born November 26, 1973) is an Italian-American actor, known as the star of Fastlane. He also stars as Carlisle Cullen in the Twilight movies and as Mike Dexter in the film Can\'t Hardly Wait."}',
                'place_of_birth' => 'Queens, New York, USA',
                'DOB' => '1973-11-26',
                'created_at' => '2021-10-19 14:20:26',
                'updated_at' => '2021-10-19 14:32:54',
                'slug' => 'peter-facinelli',
            ),
            43 => 
            array (
                'id' => 44,
                'name' => '{"en":"Anne Heche"}',
                'image' => 'tmdb_mILfZXKuF6HRrpSo5V4yIiCt0Nu.jpg',
            'biography' => '{"en":"Anne Celeste Heche ( born May 25, 1969) is an American actress, director, and screenwriter. She is a three-time Emmy Award nominee, winning the Daytime Emmy award for \\"Outstanding Younger Actress in a Drama Series\\" for her role on Another World, nominated again for the same role, and then again nominated for \\"Outstanding Supporting Actress in a Miniseries or Movie\\" for her role in Gracie\'s Choice.\\n\\n\\u200bFrom Wikipedia, the free encyclopedia"}',
                'place_of_birth' => 'Aurora, Ohio, USA',
                'DOB' => '1969-05-25',
                'created_at' => '2021-10-19 14:20:27',
                'updated_at' => '2021-10-19 14:32:54',
                'slug' => 'anne-heche',
            ),
            44 => 
            array (
                'id' => 45,
                'name' => '{"en":"William Peltz"}',
                'image' => 'tmdb_qN3cclEyvxwela4dgix0Xd9JWEl.jpg',
                'biography' => '{"en":""}',
                'place_of_birth' => 'New York City, New York, USA',
                'DOB' => '1986-05-30',
                'created_at' => '2021-10-19 14:20:28',
                'updated_at' => '2021-10-19 14:32:54',
                'slug' => 'william-peltz',
            ),
            45 => 
            array (
                'id' => 46,
                'name' => '{"en":"Natalie Zea"}',
                'image' => 'tmdb_gzGx4oD7fvHBV9SzQyeiobH70aP.jpg',
            'biography' => '{"en":"\\u200bNatalie Zea (born March 17, 1975 height 5\' 5\\" (1,65 m)) is an American actress known for her roles as Gwen Hotchkiss on the NBC daytime soap Passions, socialite Karen Darling on Dirty Sexy Money on ABC and Winona Hawkins on Justified on FX crime drama Justified (2010-2013), and as Claire Matthews in Fox series The Following (2013).\\n\\nZea was born in Harris County, Texas, and attended Monahans High School, graduating in 1993.She then graduated from The American Musical and Dramatic Academy in New York City in 1995.\\n\\nZea had a few small film roles before joining the cast of NBC daytime soap opera Passions in 2000 as Gwen Hotchkiss, replacing exiting actress Liza Huber. Zea left the show in 2002, and was replaced by Huber. Zea later guest-starred in several primetime shows, including CSI: Crime Scene Investigation in 2001. In 2004, she had a recurring role on the FX police drama The Shield playing a love interest of Michael Chiklis\' Vic Mackey. In 2005, Zea won her first regular role in primetime, on the short-lived ABC drama series Eyes. Her next major role was on the ABC primetime soap opera Dirty Sexy Money, playing spoiled socialite Karen Darling. The soap aired from 2007 to 2009, and was canceled after two seasons. In 2009, she had a recurring role during the first season of the HBO comedy series Hung. Zea also guest-starred on Two and a Half Men, Without a Trace, Medium, Franklin &amp; Bash, Person of Interest, and Californication. In film, Zea had small role of 2010 comedy The Other Guys. In 2010, Zea began starring as series regular during the first three seasons of the FX drama Justified, changing to a recurring role from Season 4. In 2013 she starred in the major role of Dr. Claire Matthews, the estranged wife of a serial killer, in the Fox thriller drama The Following. The same year, she had a recurring role as Maxine Seagrave, a drug and gambling kingpin, on the CBS summer series Under the Dome. Later that year, Zea was cast in her first lead role of the Amazon comedy pilot The Outlaws.\\n\\nDescription above from the Wikipedia article Natalie Zea, licensed under CC-BY-SA, full list of contributors on Wikipedia."}',
                'place_of_birth' => 'Harris County, Texas, USA',
                'DOB' => '1975-03-17',
                'created_at' => '2021-10-19 14:28:52',
                'updated_at' => '2021-10-19 14:32:54',
                'slug' => 'natalie-zea',
            ),
            46 => 
            array (
                'id' => 47,
                'name' => '{"en":"Eoin Macken"}',
                'image' => 'tmdb_m8JLsLDaZCjHiOtaPkUfwG2yvAx.jpg',
            'biography' => '{"en":"\\u200bFrom Wikipedia, the free encyclopedia. \\u00a0\\n\\nEoin Macken (born 21 February 1983) is an Irish actor and film maker. Eoin has modelled for Abercrombie and Fitch, Ralph Lauren, and GQ. He has appeared in films such as Studs, 3Crosses and Centurion, and as Gavin Cluxton on RTE television show Fair City. Eoin has directed two feature films; Christian Blake in 2008, which screened in the 2008 Galway Film Fleadh before being released on May 19, 2009 in the USA with distributor Celebrity Distribution and Dreaming For You, shot in New York, and selected for the 2009 Galway Film Fleadh. Eoin directed the documentary The Fashion of Modelling which screened on RTE on May 24, 2009.\\n\\nDescription above from the Wikipedia article Eoin Macken, licensed under CC-BY-SA, full list of contributors on Wikipedia."}',
                'place_of_birth' => 'Dublino, Irlanda',
                'DOB' => '1983-02-21',
                'created_at' => '2021-10-19 14:28:54',
                'updated_at' => '2021-10-19 14:32:54',
                'slug' => 'eoin-macken',
            ),
            47 => 
            array (
                'id' => 48,
                'name' => '{"en":"Jack Martin"}',
                'image' => NULL,
                'biography' => '{"en":""}',
                'place_of_birth' => NULL,
                'DOB' => NULL,
                'created_at' => '2021-10-19 14:28:55',
                'updated_at' => '2021-10-19 14:32:54',
                'slug' => 'jack-martin',
            ),
            48 => 
            array (
                'id' => 49,
                'name' => '{"en":"Zyra Gorecki"}',
                'image' => NULL,
                'biography' => '{"en":""}',
                'place_of_birth' => '  United States',
                'DOB' => '2002-07-04',
                'created_at' => '2021-10-19 14:28:57',
                'updated_at' => '2021-10-19 14:32:54',
                'slug' => 'zyra-gorecki',
            ),
            49 => 
            array (
                'id' => 50,
                'name' => '{"en":"Jon Seda"}',
                'image' => 'tmdb_hGDXJKzXGPulVmxWBxyzrTY4RT4.jpg',
            'biography' => '{"en":"Jonathan Seda (born October 14, 1970) is an American actor of Puerto Rican descent, possibly best known for his role as Detective Paul Falsone on NBC\'s: Homicide: Life on the Street. Seda was an amateur boxer who in 1992, auditioned for and was given a role in the film Gladiator. He became interested in acting and appeared in various films. He portrayed Chris P\\u00e9rez alongside Jennifer Lopez in Selena and became widely known to both the Hispanic and non-Hispanic communities. He continues to act and has had numerous television appearances, and recently appeared as legendary Marine John Basilone in Tom Hanks and Steven Spielberg\'s follow up to Band of Brothers, The Pacific. Seda currently stars in the HBO series, Treme."}',
                'place_of_birth' => 'Manhattan, New York City, New York, USA',
                'DOB' => '1970-10-14',
                'created_at' => '2021-10-19 14:28:58',
                'updated_at' => '2021-10-19 14:32:54',
                'slug' => 'jon-seda',
            ),
            50 => 
            array (
                'id' => 51,
                'name' => '{"en":"Tom Hardy"}',
                'image' => 'tmdb_sGMA6pA2D6X0gun49igJT3piHs3.jpg',
            'biography' => '{"en":"Edward Thomas \\"Tom\\" Hardy (born 15 September 1977) is an English actor. He is best known for playing the title character in the 2009 British film Bronson, and for his roles in the films Star Trek Nemesis, RocknRolla, and Inception. He has been cast in the Christopher Nolan film The Dark Knight Rises as Bane."}',
                'place_of_birth' => 'Hammersmith, London, England, UK',
                'DOB' => '1977-09-15',
                'created_at' => '2021-10-19 14:39:55',
                'updated_at' => '2021-10-19 14:39:55',
                'slug' => NULL,
            ),
            51 => 
            array (
                'id' => 52,
                'name' => '{"en":"Michelle Williams"}',
                'image' => 'tmdb_sXTP6wlqIDz1tDGLU3DFbklSTpq.jpg',
            'biography' => '{"en":"Michelle Ingrid Williams (born September 9, 1980) is an American actress. Known for her roles in small-scale independent productions with dark or tragic themes, Williams is the recipient of several accolades, including two Golden Globe Awards, a Primetime Emmy Award, and nominations for four Academy Awards, and a Tony Award.\\n\\nDaughter of the politician and trader Larry R. Williams, she was raised in Kalispell and San Diego. She began her career with television guest appearances and made her film debut in the family film Lassie in 1994. At 15, she gained emancipation from her parents, and soon achieved recognition for her leading role in the television teen drama series Dawson\'s Creek (1998\\u20132003). This was followed by low-profile films, before having her breakthrough with the drama film Brokeback Mountain (2005), for which she received a nomination for the Academy Award for Best Supporting Actress.\\n\\nWilliams went on to gain critical acclaim for playing emotionally troubled women coping with loss or loneliness in the independent dramas Wendy and Lucy (2008), Blue Valentine (2010), and Manchester by the Sea (2016). For the last two of these she received nominations for the Academy Award for Best Actress and the Academy Award for Best Supporting Actress, respectively. She won two Golden Globes for portraying Marilyn Monroe in the drama My Week with Marilyn (2011) and Gwen Verdon in the miniseries Fosse\\/Verdon (2019), in addition to a Primetime Emmy Award for Outstanding Lead Actress for the latter. Her highest-grossing releases came with the thriller Shutter Island (2010), the fantasy film Oz the Great and Powerful (2013), the musical The Greatest Showman (2017), and the superhero film Venom (2018). On Broadway, she starred in revivals of the musical Cabaret in 2014 and the drama Blackbird in 2016, for which she received a nomination for the Tony Award for Best Actress in a Play.\\n\\nWilliams is an advocate for equal pay. She is reticent about her personal life; she has a daughter from her relationship with the late actor Heath Ledger, and was briefly married to the musician Phil Elverum. She is married to theater director Thomas Kail, with whom she has a child.\\n\\nDescription above from the Wikipedia article Michelle Williams (actress), licensed under CC-BY-SA, full list of contributors on Wikipedia."}',
                'place_of_birth' => 'Kalispell, Montana, USA',
                'DOB' => '1980-09-09',
                'created_at' => '2021-10-19 14:39:56',
                'updated_at' => '2021-10-19 14:39:56',
                'slug' => NULL,
            ),
            52 => 
            array (
                'id' => 53,
                'name' => '{"en":"Riz Ahmed"}',
                'image' => 'tmdb_1uP9RaX7BGVx7XGTEmwObBJJzsC.jpg',
            'biography' => '{"en":"Rizwan \\"Riz\\" Ahmed (born 1 December 1982), also known as Riz MC, is a British actor and rapper. As an actor, he was initially known for his work in independent films such as The Road to Guantanamo, Shifty, Four Lions, Trishna, and Ill Manors, before his breakout role in Nightcrawler. Since then, he has appeared in the films Una, Jason Bourne, and the first Star Wars Anthology film, Rogue One. He also starred in the HBO miniseries The Night Of as Nasir Khan; the show and his performance were critically lauded, earning him Golden Globe and SAG nominations."}',
                'place_of_birth' => 'Wembley, London, England, UK',
                'DOB' => '1982-12-01',
                'created_at' => '2021-10-19 14:39:57',
                'updated_at' => '2021-10-19 14:39:57',
                'slug' => NULL,
            ),
            53 => 
            array (
                'id' => 54,
                'name' => '{"en":"Scott Haze"}',
                'image' => 'tmdb_6cd3Jt8Vo52j8cRKbNf1j7cERhs.jpg',
                'biography' => '{"en":""}',
                'place_of_birth' => 'Dallas, Texas, USA',
                'DOB' => '1993-06-28',
                'created_at' => '2021-10-19 14:39:58',
                'updated_at' => '2021-10-19 14:39:58',
                'slug' => NULL,
            ),
            54 => 
            array (
                'id' => 55,
                'name' => '{"en":"Reid Scott"}',
                'image' => 'tmdb_kBAeDUDA7XJRXFLGNALlpE5d3lA.jpg',
                'biography' => '{"en":""}',
                'place_of_birth' => 'Albany, New York, USA',
                'DOB' => '1977-11-19',
                'created_at' => '2021-10-19 14:39:58',
                'updated_at' => '2021-10-19 14:39:58',
                'slug' => NULL,
            ),
            55 => 
            array (
                'id' => 56,
                'name' => '{"en":"Yuki Kaji"}',
                'image' => 'tmdb_8wKdPV11IwowfwoqGqMMNt9hmp6.jpg',
                'biography' => '{"en":"Yuki Kaji is a Japanese voice\\u2005actor and singer affiliated with the agency VIMS. He has also been a radio host and acted on stage, and since 2015 has also occasionally been cast in on-screen roles in television dramas. He has voiced many notable roles such as Eren\\u2005Yeager in Attack\\u2005on\\u2005Titan, Issei\\u2005Hyodo in High\\u2005School\\u2005DxD, Shu Ouma in Guilty\\u2005Crown, Alibaba in Magi:\\u2005The\\u2005Labyrinth\\u2005of\\u2005Magic, Kazuya Ichinose and Akio Fudou in Inazuma\\u2005Eleven:\\u2005Orion\\u2005no\\u2005Kokuin, Clemont in Pok\\u00e9mon\\u2005XY, Meliodas and Zeldris in The\\u2005Seven\\u2005Deadly\\u2005Sins, Yukine in Noragami, Speed-O\'Sound\\u2005Sonic in One-Punch\\u2005Man, Kanato Sakamaki in Diabolik\\u2005Lovers, Todoroki Sh\\u014dto in My\\u2005Hero\\u2005Academia, Kozume Kenma in Haikyu!!, Koichi Hirose in JoJo\'s\\u2005Bizarre\\u2005Adventure."}',
                'place_of_birth' => 'Tokyo, Japan',
                'DOB' => '1985-09-03',
                'created_at' => '2021-10-19 14:40:17',
                'updated_at' => '2021-10-19 14:40:17',
                'slug' => NULL,
            ),
            56 => 
            array (
                'id' => 57,
                'name' => '{"en":"Sora Amamiya"}',
                'image' => 'tmdb_25o1W6AtzQqHJTu56wICengUOuj.jpg',
            'biography' => '{"en":"Japanese voice actress and singer from Toyko, affiliated with Music Ray\'n.  After passing an audition held by Music Ray\'n, she made her voice acting debut in 2012.  She played her first main role as Kaori Fujimiya in the 2014 anime series.\\n\\nIn 2015 She form a group Unit call \\"Try Sail\\" 3 voice actress (Momo Asakura, Sora Amamiya, Shiina Natsukawa), Mange by Sony\'s Music Ray\'s Subdivision. Their 1st single \\"Whiz\\" reached the 4th palce on the weekly Oricon Singles Chart. And still active to this day.\\n\\nIn 2017, they song Original \\"Interviews with Monster Girls, Adrenaline!!!\\" for \\"Eromanga Senl-sei\\".\\n\\nIn 2018, they song azure for \\"Zoku monogatari\\", \\"Wanted Girl\\" and \\"Truth\\" for \\"Time Bokan 24."}',
                'place_of_birth' => ' Tokyo, Japan',
                'DOB' => '1993-08-28',
                'created_at' => '2021-10-19 14:40:18',
                'updated_at' => '2021-10-19 14:40:18',
                'slug' => NULL,
            ),
            57 => 
            array (
                'id' => 58,
                'name' => '{"en":"Misaki Kuno"}',
                'image' => 'tmdb_6qslBrgao1mthGJK3M9keUYyMIw.jpg',
            'biography' => '{"en":"Misaki Kuno (\\u4e45\\u91ce \\u7f8e\\u54b2, Kuno Misaki, born January 19, 1993) is a Japanese actress and voice actress from Tokyo, Japan."}',
                'place_of_birth' => 'Tokyo, Tokyo Prefecture, Japan',
                'DOB' => '1993-01-19',
                'created_at' => '2021-10-19 14:40:20',
                'updated_at' => '2021-10-19 14:40:20',
                'slug' => NULL,
            ),
            58 => 
            array (
                'id' => 59,
                'name' => '{"en":"Aoi Yuki"}',
                'image' => 'tmdb_4kHNZSUIux52UU2BD3H6b5c5ymZ.jpg',
                'biography' => '{"en":"Aoi Yuki is a Japanese voice actress, actress and singer."}',
                'place_of_birth' => 'Chiba Prefecture, Japan',
                'DOB' => '1992-03-27',
                'created_at' => '2021-10-19 14:40:21',
                'updated_at' => '2021-10-19 14:40:21',
                'slug' => NULL,
            ),
            59 => 
            array (
                'id' => 60,
                'name' => '{"en":"Tatsuhisa Suzuki"}',
                'image' => 'tmdb_foytL2OreKzQcTNftz2qMgClKKg.jpg',
            'biography' => '{"en":"Tatsuhisa Suzuki (\\u9234\\u6728 \\u9054\\u592e) is a Japanese voice actor and singer. He is affiliated with I\'m Enterprise and Lantis. He is the vocalist of the rock band Oldcodex under his stage name Ta_2.\\n\\nFrom Wikipedia, the free encyclopedia"}',
                'place_of_birth' => 'Ichikawa, Chiba Prefecture, Japan',
                'DOB' => '1983-11-11',
                'created_at' => '2021-10-19 14:40:22',
                'updated_at' => '2021-10-19 14:40:22',
                'slug' => NULL,
            ),
            60 => 
            array (
                'id' => 61,
                'name' => '{"en":"Jodie Comer"}',
                'image' => 'tmdb_va8pcuzXodVLYUQLjB1USZVB6gz.jpg',
                'biography' => '{"en":"Jodie Comer is a British actress who rose to prominence in 2011 when she played the role of Sharna in BBC One drama Justice. Other TV credits include the BAFTA-nominated British comedy-drama series My Mad Fat Diary, Thirteen, Dr Foster and Killing Eve. Her film credits include the Morrissey biopic England is Mine."}',
                'place_of_birth' => 'Liverpool, England',
                'DOB' => '1993-03-11',
                'created_at' => '2021-10-19 14:50:02',
                'updated_at' => '2021-10-19 14:50:02',
                'slug' => NULL,
            ),
            61 => 
            array (
                'id' => 62,
                'name' => '{"en":"Matt Damon"}',
                'image' => 'tmdb_cQanDcd6nNz2hIlJRib126feqZE.jpg',
            'biography' => '{"en":"Matthew Paige Damon (born October 8, 1970) is an American actor, film producer, screenwriter, and environmentalist. He is ranked among Forbes magazine\'s most bankable stars and is one of the highest-grossing actors of all time. Damon has received various accolades, including an Academy Award from five nominations, two Golden Globe Awards from eight nominations, and has been nominated for three British Academy Film Awards and seven Emmy Awards.\\n\\nBorn and raised in Cambridge, Massachusetts, Damon began his acting career by appearing in high school theater productions. He made his professional acting debut in the film Mystic Pizza (1988). He came to prominence in 1997, when he wrote and starred in Good Will Hunting, alongside Ben Affleck, which won them the Academy and Golden Globe awards for Best Screenplay and earned Damon a nomination for the Academy Award for Best Actor. He continued to garner praise from critics for his roles as the eponymous character in Saving Private Ryan (1998), the antihero in The Talented Mr. Ripley (1999), a fallen angel in Dogma (1999) and Jay and Silent Bob Reboot (2019), an energy analyst in Syriana (2005), and a corrupt Irish-American police officer in The Departed (2006). In 2019 he starred as race car driver and designer Carroll Shelby in James Mangold\'s Ford v Ferrari.\\n\\nDamon is also known for his starring roles as Jason Bourne in the Bourne franchise (2002\\u20132016) and as a con man in the Ocean\'s trilogy (2001\\u20132007). For his supporting role as the rugby player Francois Pienaar in Invictus (2009) and his leading role as an astronaut stranded on Mars in The Martian (2015), Damon received Academy Award nominations for Best Supporting Actor and Best Actor, respectively. The latter also won him a Golden Globe Award for Best Actor. Damon has received Emmy Award nominations for his portrayal of Scott Thorson in the biopic Behind the Candelabra (2013) and for producing the reality series Project Greenlight. He also received an Academy Award nomination for producing Manchester by the Sea (2016).\\n\\nDescription above from the Wikipedia article Matt Damon, licensed under CC-BY-SA, full list of contributors on Wikipedia."}',
                'place_of_birth' => 'Boston, Massachusetts, USA',
                'DOB' => '1970-10-08',
                'created_at' => '2021-10-19 14:50:03',
                'updated_at' => '2021-10-19 14:50:03',
                'slug' => NULL,
            ),
            62 => 
            array (
                'id' => 63,
                'name' => '{"en":"Adam Driver"}',
                'image' => 'tmdb_fsbGQ1eZFgdsG1XnKlhNSvHsiGo.jpg',
            'biography' => '{"en":"Adam Douglas Driver (born November 19, 1983) is an American actor. He rose to prominence in the supporting role of Adam Sackler in the HBO comedy-drama series Girls (2012\\u20132017), for which he received three consecutive nominations for the Primetime Emmy Award for Outstanding Supporting Actor in a Comedy Series. He made his Broadway debut in Mrs. Warren\'s Profession (2010). In 2011, he returned to Broadway in Man and Boy and made his feature film debut in J. Edgar.\\n\\nDriver has appeared in supporting roles in a wide range of films, including Lincoln (2012), Frances Ha (2012) and Inside Llewyn Davis (2013). He starred in While We\'re Young (2014) and won the Volpi Cup for his role in Hungry Hearts (2014), as well as several best actor awards for his performance in Jim Jarmusch\'s Paterson (2016). Driver also appeared in Spike Lee\'s BlacKkKlansman (2018), which earned him an Academy Award for Best Supporting Actor nomination.\\n\\nDriver gained worldwide attention and acclaim for playing the villain Kylo Ren in Star Wars: The Force Awakens (2015), a role which he reprised in Star Wars: The Last Jedi (2017).\\n\\nHe is also the founder of Arts in the Armed Forces (AITAF), a nonprofit that performs theater for all branches of the military, both in the US and abroad."}',
                'place_of_birth' => 'San Diego, California, USA',
                'DOB' => '1983-11-19',
                'created_at' => '2021-10-19 14:50:04',
                'updated_at' => '2021-10-19 14:50:04',
                'slug' => NULL,
            ),
            63 => 
            array (
                'id' => 64,
                'name' => '{"en":"Ben Affleck"}',
                'image' => 'tmdb_aTcqu8cI4wMohU17xTdqmXKTGrw.jpg',
            'biography' => '{"en":"Ben Affleck (born August 15, 1972) is an American actor, film director, writer, and producer. He became known in the mid-1990s with his performance in the Kevin Smith films Mallrats (1995) and Chasing Amy (1997). Affleck is an Academy Award as well as a Golden Globe Award winner, along with Matt Damon, for their collaborative screenplay for the 1997 film Good Will Hunting. He established himself as a Hollywood leading man, having starred in several big budget films, such as Armageddon (1998), Pearl Harbor (2001), Changing Lanes (2002), The Sum of All Fears (2002), and Daredevil (2003). Affleck also portrays Bruce Wayne\\/Batman in the DC Extended Universe. He has portrayed the character in Batman vs Superman: Dawn of Justice (2016), Suicide Squad (2016), and Justice League (2017). He will reprise the role in 2021\\u2019s new version of Zack Snyder\\u2019s Justice League. Affleck has drawn critical acclaim for his work as a filmmaker, directing Gone Baby Gone (2007) and The Town (2010), and playing the lead role in the latter. He has worked with his younger brother, actor Casey Affleck, on several projects, including Good Will Hunting and Gone Baby Gone.\\n\\nAfter a high profile relationship with actress Gwyneth Paltrow in 1998, his relationship with actress\\/singer Jennifer Lopez attracted worldwide media attention in which Affleck and Lopez were dubbed \\"Bennifer\\". Following their breakup in 2004, he began dating Jennifer Garner. The two married in June 2005 and have two daughters, Violet Anne, born December 2005, and Seraphina Rose Elizabeth, born January 2009.\\n\\nAffleck has been actively involved in politics and charitable causes. He and Matt Damon also founded the production company LivePlanet.\\n\\n\\u200bFrom Wikipedia, the free encyclopedia"}',
                'place_of_birth' => 'Berkeley, California, USA',
                'DOB' => '1972-08-15',
                'created_at' => '2021-10-19 14:50:06',
                'updated_at' => '2021-10-19 14:50:06',
                'slug' => NULL,
            ),
            64 => 
            array (
                'id' => 65,
                'name' => '{"en":"Marton Csokas"}',
                'image' => 'tmdb_bUO8mwJQ00ZD9wNZsNCevCZQR5L.jpg',
            'biography' => '{"en":"Marton Csokas (born 30 June 1966) is a New Zealand film and television actor.\\n\\nDescription above from the Wikipedia article Marton Csokas, licensed under CC-BY-SA, full list of contributors on Wikipedia."}',
                'place_of_birth' => 'Invercargill, New Zealand',
                'DOB' => '1966-06-30',
                'created_at' => '2021-10-19 14:50:07',
                'updated_at' => '2021-10-19 14:50:07',
                'slug' => NULL,
            ),
            65 => 
            array (
                'id' => 66,
                'name' => '{"en":"Bill Murray"}',
                'image' => 'tmdb_nnCsJc9x3ZiG3AFyiyc3FPehppy.jpg',
            'biography' => '{"en":"William James \\"Bill\\" Murray (born September 21, 1950) is an American actor and comedian. He first gained national exposure on Saturday Night Live and later went on to star in a number of critically and commercially successful comedic films, including Caddyshack (1980), Ghostbusters (1984), and Groundhog Day (1993). Murray gained additional critical acclaim later in his career, starring in Lost in Translation (2003), for which he was nominated for an Academy Award, and a series of films directed by Wes Anderson, including Rushmore (1998), The Royal Tenenbaums (2001), The Life Aquatic with Steve Zissou (2004) and Fantastic Mr. Fox (2009).\\n\\nDescription above from the Wikipedia article Bill Murray, licensed under CC-BY-SA, full list of contributors on Wikipedia."}',
                'place_of_birth' => 'Wilmette, Illinois, USA',
                'DOB' => '1950-09-21',
                'created_at' => '2021-10-19 14:50:45',
                'updated_at' => '2021-10-19 14:50:45',
                'slug' => NULL,
            ),
            66 => 
            array (
                'id' => 67,
                'name' => '{"en":"Benicio del Toro"}',
                'image' => 'tmdb_cVh4UgCMu6aAkZ2BqymTLV86FzZ.jpg',
            'biography' => '{"en":"Benicio Monserrate Rafael del Toro S\\u00e1nchez (born February 19, 1967) is a Puerto Rican actor and film producer. His awards include the Academy Award, Golden Globe, Screen Actors Guild (SAG) Award and British Academy of Film and Television Arts (BAFTA) Award. He is known for his roles as Fred Fenster in The Usual Suspects, Javier Rodr\\u00edguez in Traffic (his Oscar-winning role), Jack \'Jackie Boy\' Rafferty in Sin City, Dr. Gonzo in Fear and Loathing in Las Vegas, Franky Four Fingers in Snatch, and Che Guevara in Che. He is the third Puerto Rican to win an Academy Award.\\n\\nDescription above from the Wikipedia article Benicio del Toro, licensed under CC-BY-SA, full list of contributors on Wikipedia."}',
                'place_of_birth' => 'San Germán, Puerto Rico',
                'DOB' => '1967-02-19',
                'created_at' => '2021-10-19 14:50:46',
                'updated_at' => '2021-10-19 14:50:46',
                'slug' => NULL,
            ),
            67 => 
            array (
                'id' => 68,
                'name' => '{"en":"Frances McDormand"}',
                'image' => 'tmdb_r0A7hZsM1zuavTr0jN7bwmBcliR.jpg',
            'biography' => '{"en":"An American film, stage and television actress. McDormand began her career on stage and made her screen debut in the 1984 film Blood Simple, having since appeared in several theatrical and television roles. McDormand has been recognized for her performances in \'Mississippi Burning\' (1988), \'Short Cuts\' (1993), \'Fargo\' (1996), \'Wonder Boys\' (2000), \'Almost Famous\' (2000), \'North Country\' (2005), \'Moonrise Kingdom\' (2012), \'Hail, Caesar!\' (2016) and \'Three Billboards Outside Ebbing, Missouri\' (2017).\\n\\nThroughout her career, she has been nominated for eight Golden Globes, five Academy Awards, four BAFTA Awards, and three Emmy Awards. She is one of the few performers to achieve the \\"Triple Crown of Acting\\", winning an Academy Award, a Primetime Emmy Award, and a Tony Award. She won her first Academy Award for Best Actress in 1997 for her role as Marge Gunderson in \'Fargo\'. \\u00a0She also won Best Supporting Actress from the Broadcast Film Critics Association, the Florida Film Critics Circle, and the Los Angeles Film Critics Association for her performance in \'Wonder Boys\' (2000).  McDormand returned to the stage in the David Lindsay-Abaire play Good People on Broadway from February 8, 2011 to April 24, 2011. In 2017, McDormand starred in \'Three Billboards Outside Ebbing, Missouri\' which earned her a second Academy Award for Best Actress.\\n\\nMcDormand has been married to filmmaker Joel Coen since 1984, they reside in New York City along with their adopted son Pedro."}',
                'place_of_birth' => 'Chicago, Illinois, USA ',
                'DOB' => '1957-06-23',
                'created_at' => '2021-10-19 14:50:47',
                'updated_at' => '2021-10-19 14:50:47',
                'slug' => NULL,
            ),
            68 => 
            array (
                'id' => 69,
                'name' => '{"en":"Jeffrey Wright"}',
                'image' => 'tmdb_npJjOiFiAP4wiRDNjKsO8ho03Mg.jpg',
            'biography' => '{"en":"Jeffrey Wright (born December 7, 1965 in Washington, D.C.) is an American actor. He is best known for his Emmy and Golden Globe-winning role in the HBO miniseries Angels in America and his Tony Award winning role in the Broadway production of the same name. He starred in The French Dispatch (2020), The Batman (2022), the James Bond films Casino Royale, Quantum of Solace and No Time to Die, and The Hunger Games films."}',
                'place_of_birth' => 'Washington, D.C., USA',
                'DOB' => '1965-12-07',
                'created_at' => '2021-10-19 14:50:48',
                'updated_at' => '2021-10-19 14:50:48',
                'slug' => NULL,
            ),
            69 => 
            array (
                'id' => 70,
                'name' => '{"en":"Adrien Brody"}',
                'image' => 'tmdb_1dBItgLFBNGEXnI48VvnnN2vFaX.jpg',
                'biography' => '{"en":"Adrien Nicholas Brody was born in Woodhaven, Queens, New York, the only child of retired history professor Elliot Brody and Hungarian-born photographer\\u00a0Sylvia Plachy. He accompanied his mother on assignments for the Village Voice, and credits her with making him feel comfortable in front of the camera. Adrien attended the American Academy of Dramatic Arts and LaGuardia High School for the Performing Arts in New York."}',
                'place_of_birth' => 'New York City, New York, USA',
                'DOB' => '1973-04-14',
                'created_at' => '2021-10-19 14:50:50',
                'updated_at' => '2021-10-19 14:50:50',
                'slug' => NULL,
            ),
        ));
        
        
    }
}