-- MySQL dump 10.13  Distrib 8.0.44, for Linux (x86_64)
--
-- Host: localhost    Database: chef
-- ------------------------------------------------------
-- Server version	8.0.44-0ubuntu0.22.04.1

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actors`
--

DROP TABLE IF EXISTS `actors`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `actors` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `biography` text COLLATE utf8mb4_unicode_ci,
  `place_of_birth` text COLLATE utf8mb4_unicode_ci,
  `DOB` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `slug` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actors`
--

LOCK TABLES `actors` WRITE;
/*!40000 ALTER TABLE `actors` DISABLE KEYS */;
/*!40000 ALTER TABLE `actors` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ads`
--

DROP TABLE IF EXISTS `ads`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ads` (
  `id` int NOT NULL AUTO_INCREMENT,
  `ad_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ad_image` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ad_video` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ad_url` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ad_location` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ad_target` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ad_hold` int DEFAULT NULL,
  `time` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `endtime` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ads`
--

LOCK TABLES `ads` WRITE;
/*!40000 ALTER TABLE `ads` DISABLE KEYS */;
/*!40000 ALTER TABLE `ads` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adsenses`
--

DROP TABLE IF EXISTS `adsenses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `adsenses` (
  `id` int NOT NULL AUTO_INCREMENT,
  `code` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL,
  `ishome` tinyint(1) NOT NULL,
  `isviewall` tinyint(1) NOT NULL,
  `issearch` tinyint(1) NOT NULL,
  `iswishlist` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adsenses`
--

LOCK TABLES `adsenses` WRITE;
/*!40000 ALTER TABLE `adsenses` DISABLE KEYS */;
INSERT INTO `adsenses` VALUES (1,'<script type=\"text/javascript\">\r\ngoogle_ad_client = \"\";  \r\ngoogle_ad_slot = \"99*****99\"; \r\ngoogle_ad_width = 728;\r\ngoogle_ad_height =  90; \r\n\n</script>',0,0,0,0,0,'2019-09-09 12:43:44','2020-02-11 11:08:26');
/*!40000 ALTER TABLE `adsenses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `app_configs`
--

DROP TABLE IF EXISTS `app_configs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `app_configs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `stripe_payment` tinyint(1) NOT NULL DEFAULT '0',
  `paypal_payment` tinyint(1) NOT NULL DEFAULT '0',
  `razorpay_payment` tinyint(1) NOT NULL DEFAULT '0',
  `brainetree_payment` tinyint(1) NOT NULL DEFAULT '0',
  `paystack_payment` tinyint(1) NOT NULL DEFAULT '0',
  `bankdetails` tinyint(1) NOT NULL DEFAULT '0',
  `fb_check` tinyint(1) NOT NULL DEFAULT '0',
  `google_login` tinyint(1) NOT NULL DEFAULT '0',
  `git_lab_check` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `inapp_payment` tinyint(1) NOT NULL DEFAULT '0',
  `push_key` tinyint(1) NOT NULL DEFAULT '0',
  `remove_ads` tinyint(1) NOT NULL DEFAULT '0',
  `paytm_payment` tinyint(1) NOT NULL DEFAULT '0',
  `amazon_login` tinyint(1) NOT NULL DEFAULT '0',
  `is_admob` tinyint(1) NOT NULL DEFAULT '0',
  `instamojo_payment` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `app_configs`
--

LOCK TABLES `app_configs` WRITE;
/*!40000 ALTER TABLE `app_configs` DISABLE KEYS */;
INSERT INTO `app_configs` VALUES (1,'applogo_1606642921logo.png','Nexthour',0,0,0,0,0,0,0,0,0,NULL,'2020-11-29 15:12:01',0,0,0,0,0,0,0);
/*!40000 ALTER TABLE `app_configs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `app_sliders`
--

DROP TABLE IF EXISTS `app_sliders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `app_sliders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `movie_id` int unsigned DEFAULT NULL,
  `tv_series_id` int unsigned DEFAULT NULL,
  `slide_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '0',
  `position` int NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `app_sliders_movie_id_foreign` (`movie_id`),
  KEY `app_sliders_tv_series_id_foreign` (`tv_series_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `app_sliders`
--

LOCK TABLES `app_sliders` WRITE;
/*!40000 ALTER TABLE `app_sliders` DISABLE KEYS */;
INSERT INTO `app_sliders` VALUES (1,NULL,NULL,'app_slide_1606642528movie.jpg',1,1,'2020-11-29 14:47:00','2020-11-29 15:05:28'),(2,NULL,NULL,'app_slide_1606642578tvshow.jpg',1,2,'2020-11-29 15:06:18','2020-11-29 15:06:18');
/*!40000 ALTER TABLE `app_sliders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `audio`
--

DROP TABLE IF EXISTS `audio`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `audio` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `keyword` text COLLATE utf8mb4_unicode_ci,
  `description` text COLLATE utf8mb4_unicode_ci,
  `thumbnail` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `poster` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `rating` double(8,2) DEFAULT NULL,
  `maturity_rating` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `upload_audio` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `genre_id` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `detail` text COLLATE utf8mb4_unicode_ci,
  `is_protect` tinyint(1) NOT NULL DEFAULT '0',
  `password` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `audiourl` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `featured` tinyint(1) DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `audio`
--

LOCK TABLES `audio` WRITE;
/*!40000 ALTER TABLE `audio` DISABLE KEYS */;
/*!40000 ALTER TABLE `audio` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `audio_languages`
--

DROP TABLE IF EXISTS `audio_languages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `audio_languages` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `language` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `audio_languages`
--

LOCK TABLES `audio_languages` WRITE;
/*!40000 ALTER TABLE `audio_languages` DISABLE KEYS */;
/*!40000 ALTER TABLE `audio_languages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auth_customizes`
--

DROP TABLE IF EXISTS `auth_customizes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `auth_customizes` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `detail` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auth_customizes`
--

LOCK TABLES `auth_customizes` WRITE;
/*!40000 ALTER TABLE `auth_customizes` DISABLE KEYS */;
INSERT INTO `auth_customizes` VALUES (1,'{\"en\":\"auth_page1604309119login.jpg\"}','{\"en\":\"<h1>Welcome to<br \\/>\\r\\nNext Hour<\\/h1>\\r\\n\\r\\n<h2>Are you ready to join the elite?<\\/h2>\"}',NULL,'2020-11-02 14:55:19');
/*!40000 ALTER TABLE `auth_customizes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blog_menu`
--

DROP TABLE IF EXISTS `blog_menu`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `blog_menu` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` int NOT NULL,
  `blog_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blog_menu`
--

LOCK TABLES `blog_menu` WRITE;
/*!40000 ALTER TABLE `blog_menu` DISABLE KEYS */;
/*!40000 ALTER TABLE `blog_menu` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs`
--

DROP TABLE IF EXISTS `blogs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `blogs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `title` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `detail` varchar(5000) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_active` int NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `poster` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs`
--

LOCK TABLES `blogs` WRITE;
/*!40000 ALTER TABLE `blogs` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `buttons`
--

DROP TABLE IF EXISTS `buttons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `buttons` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `rightclick` tinyint(1) NOT NULL DEFAULT '1',
  `inspect` tinyint(1) DEFAULT NULL,
  `goto` tinyint(1) NOT NULL DEFAULT '1',
  `color` tinyint(1) NOT NULL DEFAULT '1',
  `uc_browser` tinyint(1) NOT NULL DEFAULT '1',
  `comming_soon` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `commingsoon_enabled_ip` longtext COLLATE utf8mb4_unicode_ci,
  `ip_block` tinyint(1) NOT NULL DEFAULT '1',
  `block_ips` longtext COLLATE utf8mb4_unicode_ci,
  `maintenance` tinyint(1) NOT NULL DEFAULT '1',
  `comming_soon_text` longtext COLLATE utf8mb4_unicode_ci,
  `remove_subscription` tinyint(1) NOT NULL DEFAULT '0',
  `protip` tinyint(1) NOT NULL DEFAULT '1',
  `multiplescreen` tinyint(1) NOT NULL DEFAULT '0',
  `two_factor` tinyint(1) NOT NULL DEFAULT '0',
  `countviews` tinyint(1) NOT NULL DEFAULT '0',
  `remove_ads` tinyint(1) NOT NULL DEFAULT '0',
  `is_toprated` tinyint(1) NOT NULL DEFAULT '0',
  `toprated_count` text COLLATE utf8mb4_unicode_ci,
  `remove_thumbnail` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `buttons`
--

LOCK TABLES `buttons` WRITE;
/*!40000 ALTER TABLE `buttons` DISABLE KEYS */;
INSERT INTO `buttons` VALUES (1,0,0,1,0,1,0,'2018-07-31 11:30:00','2022-04-17 12:32:38',NULL,0,NULL,1,NULL,1,1,0,0,0,1,0,NULL,0);
/*!40000 ALTER TABLE `buttons` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `callback_addresses`
--

DROP TABLE IF EXISTS `callback_addresses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `callback_addresses` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `address` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `currency` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pubkey` text COLLATE utf8mb4_unicode_ci,
  `ipn_url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dest_tag` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `callback_addresses_address_currency_unique` (`address`,`currency`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `callback_addresses`
--

LOCK TABLES `callback_addresses` WRITE;
/*!40000 ALTER TABLE `callback_addresses` DISABLE KEYS */;
/*!40000 ALTER TABLE `callback_addresses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `chat_settings`
--

DROP TABLE IF EXISTS `chat_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `chat_settings` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `enable_messanger` tinyint(1) NOT NULL DEFAULT '0',
  `script` longtext COLLATE utf8mb4_unicode_ci,
  `mobile` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `text` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `header` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `color` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `size` int DEFAULT NULL,
  `enable_whatsapp` tinyint(1) NOT NULL DEFAULT '0',
  `position` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'right',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `chat_settings`
--

LOCK TABLES `chat_settings` WRITE;
/*!40000 ALTER TABLE `chat_settings` DISABLE KEYS */;
INSERT INTO `chat_settings` VALUES (1,'messanger',0,NULL,NULL,NULL,NULL,'#52D668',30,0,'right',NULL,NULL),(2,'whatsapp',0,NULL,'9999999999','Hey! We can help you?','Chat with us','#4fd896',30,0,'right',NULL,NULL);
/*!40000 ALTER TABLE `chat_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `color_schemes`
--

DROP TABLE IF EXISTS `color_schemes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `color_schemes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `color_scheme` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `default_navigation_color` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `custom_navigation_color` text COLLATE utf8mb4_unicode_ci,
  `default_text_color` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `custom_text_color` text COLLATE utf8mb4_unicode_ci,
  `default_text_on_color` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `custom_text_on_color` text COLLATE utf8mb4_unicode_ci,
  `default_back_to_top_color` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `custom_back_to_top_color` text COLLATE utf8mb4_unicode_ci,
  `default_back_to_top_bgcolor` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `custom_back_to_top_bgcolor` text COLLATE utf8mb4_unicode_ci,
  `default_back_to_top_bgcolor_on_hover` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `custom_back_to_top_bgcolor_on_hover` text COLLATE utf8mb4_unicode_ci,
  `default_back_to_top_color_on_hover` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `custom_back_to_top_color_on_hover` text COLLATE utf8mb4_unicode_ci,
  `default_footer_background_color` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `custom_footer_background_color` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `color_schemes`
--

LOCK TABLES `color_schemes` WRITE;
/*!40000 ALTER TABLE `color_schemes` DISABLE KEYS */;
INSERT INTO `color_schemes` VALUES (1,'light','#111111FA','rgba(71,71,69,0.86)','#48A3C6','#fec901','#90DFFE','#fec901','#111',NULL,'#FFF',NULL,'#48A3C6',NULL,'#FFF',NULL,'#111','rgba(71,71,69,0.86)',NULL,'2025-09-25 17:34:51');
/*!40000 ALTER TABLE `color_schemes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `comments`
--

DROP TABLE IF EXISTS `comments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `comments` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `blog_id` int NOT NULL,
  `comment` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `comments`
--

LOCK TABLES `comments` WRITE;
/*!40000 ALTER TABLE `comments` DISABLE KEYS */;
/*!40000 ALTER TABLE `comments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `configs`
--

DROP TABLE IF EXISTS `configs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `configs` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `favicon` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `livetvicon` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `w_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `verify_email` int NOT NULL,
  `download` int DEFAULT '0',
  `free_sub` int NOT NULL DEFAULT '0',
  `free_days` int DEFAULT NULL,
  `stripe_pub_key` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `stripe_secret_key` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paypal_mar_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `currency_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `currency_symbol` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `invoice_add` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `prime_main_slider` tinyint(1) NOT NULL DEFAULT '1',
  `catlog` tinyint(1) NOT NULL,
  `withlogin` tinyint(1) NOT NULL,
  `prime_genre_slider` tinyint(1) NOT NULL DEFAULT '1',
  `donation` tinyint(1) DEFAULT NULL,
  `donation_link` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `prime_footer` tinyint(1) NOT NULL DEFAULT '1',
  `prime_movie_single` tinyint(1) NOT NULL DEFAULT '1',
  `terms_condition` text COLLATE utf8mb4_unicode_ci,
  `privacy_pol` text COLLATE utf8mb4_unicode_ci,
  `refund_pol` text COLLATE utf8mb4_unicode_ci,
  `copyright` text COLLATE utf8mb4_unicode_ci,
  `stripe_payment` tinyint(1) NOT NULL DEFAULT '1',
  `paypal_payment` tinyint(1) NOT NULL DEFAULT '1',
  `razorpay_payment` tinyint(1) NOT NULL DEFAULT '1',
  `age_restriction` tinyint(1) DEFAULT '0',
  `payu_payment` tinyint(1) NOT NULL DEFAULT '1',
  `bankdetails` tinyint(1) NOT NULL,
  `account_no` varchar(111) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `branch` varchar(111) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_name` varchar(111) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ifsc_code` varchar(111) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bank_name` varchar(111) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paytm_payment` int unsigned DEFAULT '0',
  `paytm_test` tinyint(1) DEFAULT NULL,
  `preloader` tinyint(1) NOT NULL DEFAULT '1',
  `fb_login` tinyint(1) NOT NULL,
  `gitlab_login` tinyint(1) NOT NULL,
  `google_login` tinyint(1) NOT NULL,
  `wel_eml` tinyint(1) DEFAULT NULL,
  `blog` tinyint(1) NOT NULL DEFAULT '0',
  `is_playstore` tinyint(1) NOT NULL DEFAULT '0',
  `is_appstore` tinyint(1) NOT NULL DEFAULT '0',
  `playstore` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `appstore` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_rating` tinyint(1) NOT NULL DEFAULT '0',
  `comments` tinyint(1) NOT NULL DEFAULT '0',
  `braintree` tinyint(1) NOT NULL DEFAULT '0',
  `paystack` tinyint(1) NOT NULL DEFAULT '0',
  `remove_landing_page` tinyint(1) NOT NULL DEFAULT '0',
  `coinpay` tinyint(1) NOT NULL DEFAULT '0',
  `captcha` tinyint(1) NOT NULL DEFAULT '0',
  `amazon_login` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `mollie_payment` tinyint(1) NOT NULL DEFAULT '0',
  `cashfree_payment` tinyint(1) NOT NULL DEFAULT '0',
  `aws` tinyint(1) NOT NULL DEFAULT '0',
  `omise_payment` tinyint(1) NOT NULL DEFAULT '0',
  `flutterrave_payment` tinyint(1) NOT NULL DEFAULT '0',
  `instamojo_payment` tinyint(1) NOT NULL DEFAULT '0',
  `comments_approval` tinyint(1) NOT NULL DEFAULT '1',
  `payhere_payment` tinyint(1) NOT NULL DEFAULT '0',
  `preloader_img` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `configs`
--

LOCK TABLES `configs` WRITE;
/*!40000 ALTER TABLE `configs` DISABLE KEYS */;
INSERT INTO `configs` VALUES (1,'logo_1758724927alchef logo png.ico','favicon.png','livetvicon_1634623645default-tvicon.png','{\"en\":\"bilhana\",\"Spanish\":\"bilhana\",\"spanish\":\"bilhana\",\"FR\":\"bilhana\",\"EN\":\"bilhana\",\"ar\":\"بالهناء\"}','contact@nexthour.com',0,0,0,40,'','','','USD','fa fa-dollar','{\"ar\":null}',0,1,1,1,0,NULL,1,1,'{\"en\":\"\",\"nl\":\"<p>newvious&nbsp;goodesioanos<\\/p>\"}','{\"en\":\"\"}','{\"en\":\"\"}','{\"en\":\"Zain | All Rights Reserved\",\"ar\":\"Zain | All Rights Reserved\"} ',0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,0,0,0,0,'https://www.youtube.com/upload','https://www.youtube.com/upload',1,1,0,0,1,0,0,0,NULL,'2025-09-24 19:12:07',0,0,0,0,0,0,1,0,'preloader_1758670647favicon.jpg');
/*!40000 ALTER TABLE `configs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conversions`
--

DROP TABLE IF EXISTS `conversions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `conversions` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `amount` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ref_id` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `from` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `to` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dest_tag` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `conversions_ref_id_unique` (`ref_id`),
  KEY `conversions_from_index` (`from`),
  KEY `conversions_to_index` (`to`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conversions`
--

LOCK TABLES `conversions` WRITE;
/*!40000 ALTER TABLE `conversions` DISABLE KEYS */;
/*!40000 ALTER TABLE `conversions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `coupon_applies`
--

DROP TABLE IF EXISTS `coupon_applies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `coupon_applies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `coupon_id` int NOT NULL,
  `redeem` int NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `coupon_applies`
--

LOCK TABLES `coupon_applies` WRITE;
/*!40000 ALTER TABLE `coupon_applies` DISABLE KEYS */;
/*!40000 ALTER TABLE `coupon_applies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `coupon_codes`
--

DROP TABLE IF EXISTS `coupon_codes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `coupon_codes` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `coupon_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `percent_off` double(8,2) DEFAULT NULL,
  `currency` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount_off` double(8,2) DEFAULT NULL,
  `duration` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'once',
  `max_redemptions` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `redeem_by` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `in_stripe` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `coupon_codes`
--

LOCK TABLES `coupon_codes` WRITE;
/*!40000 ALTER TABLE `coupon_codes` DISABLE KEYS */;
/*!40000 ALTER TABLE `coupon_codes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cps_cpp`
--

DROP TABLE IF EXISTS `cps_cpp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cps_cpp` (
  `userid` int NOT NULL,
  `expire` int NOT NULL,
  `info` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `plan` int NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cps_cpp`
--

LOCK TABLES `cps_cpp` WRITE;
/*!40000 ALTER TABLE `cps_cpp` DISABLE KEYS */;
/*!40000 ALTER TABLE `cps_cpp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `currencies`
--

DROP TABLE IF EXISTS `currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `currencies` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `symbol` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `format` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `exchange_rate` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payment_method` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `currencies_code_index` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `currencies`
--

LOCK TABLES `currencies` WRITE;
/*!40000 ALTER TABLE `currencies` DISABLE KEYS */;
INSERT INTO `currencies` VALUES (1,'Indian Rupee','INR','₹','1,0.00₹','75.298292','[\"flutterrave\",\"instamojo\",\"paytm\",\"mollie\",\"cashfree\",\"razorpay\"]',0,'2021-09-08 17:11:27','2021-10-18 11:30:00'),(2,'US Dollar','USD','$','$1,0.00','1','[\"stripe\",\"paypal\",\"braintree\",\"omise\",\"payhere\",\"flutterrave\",\"mollie\"]',0,'2021-09-08 17:13:00','2021-10-18 11:30:00'),(3,'Euro','EUR','€','1.0,00 €','0.863677','[\"stripe\",\"paypal\",\"braintree\",\"omise\",\"payhere\",\"flutterrave\"]',0,'2021-09-08 17:13:39','2021-10-18 11:30:00'),(4,'Sri Lanka Rupee','LKR','₨','₨ 1,0.','202.450844','[\"payhere\"]',0,'2021-09-08 17:52:46','2021-10-18 11:30:00'),(5,'UAE Dirham','AED','دإ‏','دإ‏ 1,0.00','3.6731','[\"mollie\",\"cashfree\"]',0,'2021-09-09 15:58:19','2021-10-18 11:30:00'),(6,'Nigeria, Naira','NGN','₦','₦1,0.00','411.92','[\"stripe\",\"flutterrave\",\"paystack\"]',0,'2021-09-13 15:03:42','2021-10-18 11:30:00'),(7,'Angola, Kwanza','AOA','Kz','Kz1,0.00','597.698','[\"stripe\"]',0,'2021-10-01 14:01:26','2021-10-18 11:30:00'),(8,'Tunisian Dinar','TND','د.ت.‏','د.ت.‏ 1,0.000','2.8235','[\"stripe\"]',0,'2021-10-04 12:33:43','2021-10-18 11:30:00'),(9,'Kenyan Shilling','KES','S','S1,0.00','110.9','[\"stripe\"]',0,'2021-10-04 13:46:10','2021-10-18 11:30:00');
/*!40000 ALTER TABLE `currencies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `custom_pages`
--

DROP TABLE IF EXISTS `custom_pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `custom_pages` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `in_show_menu` tinyint(1) DEFAULT NULL,
  `detail` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_active` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `custom_pages`
--

LOCK TABLES `custom_pages` WRITE;
/*!40000 ALTER TABLE `custom_pages` DISABLE KEYS */;
/*!40000 ALTER TABLE `custom_pages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `deposits`
--

DROP TABLE IF EXISTS `deposits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `deposits` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `address` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `txn_id` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint NOT NULL,
  `status_text` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `currency` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `confirms` tinyint unsigned NOT NULL,
  `amount` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amounti` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fee` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `feei` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dest_tag` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `deposits_txn_id_unique` (`txn_id`),
  KEY `deposits_address_index` (`address`),
  CONSTRAINT `deposits_address_foreign` FOREIGN KEY (`address`) REFERENCES `callback_addresses` (`address`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `deposits`
--

LOCK TABLES `deposits` WRITE;
/*!40000 ALTER TABLE `deposits` DISABLE KEYS */;
/*!40000 ALTER TABLE `deposits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `directors`
--

DROP TABLE IF EXISTS `directors`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `directors` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `biography` text COLLATE utf8mb4_unicode_ci,
  `place_of_birth` text COLLATE utf8mb4_unicode_ci,
  `DOB` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `slug` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `directors`
--

LOCK TABLES `directors` WRITE;
/*!40000 ALTER TABLE `directors` DISABLE KEYS */;
/*!40000 ALTER TABLE `directors` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `donater_lists`
--

DROP TABLE IF EXISTS `donater_lists`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `donater_lists` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned DEFAULT NULL,
  `method` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `donor_msg` text COLLATE utf8mb4_unicode_ci,
  `amount` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `donater_lists`
--

LOCK TABLES `donater_lists` WRITE;
/*!40000 ALTER TABLE `donater_lists` DISABLE KEYS */;
/*!40000 ALTER TABLE `donater_lists` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `episodes`
--

DROP TABLE IF EXISTS `episodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `episodes` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `seasons_id` int unsigned NOT NULL,
  `tmdb_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `thumbnail` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `episode_no` int DEFAULT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tmdb` char(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `duration` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `detail` text COLLATE utf8mb4_unicode_ci,
  `a_language` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subtitle` tinyint(1) DEFAULT NULL,
  `released` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` char(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'E',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `episodes_seasons_id_foreign` (`seasons_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `episodes`
--

LOCK TABLES `episodes` WRITE;
/*!40000 ALTER TABLE `episodes` DISABLE KEYS */;
/*!40000 ALTER TABLE `episodes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faqs`
--

DROP TABLE IF EXISTS `faqs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faqs` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `question` text COLLATE utf8mb4_unicode_ci,
  `answer` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faqs`
--

LOCK TABLES `faqs` WRITE;
/*!40000 ALTER TABLE `faqs` DISABLE KEYS */;
INSERT INTO `faqs` VALUES (1,'{\"en\":\"\\u0645\\u0627 \\u0647\\u064a \\u0627\\u0644\\u062e\\u062f\\u0645\\u0629 \\u0627\\u0644\\u062a\\u064a \\u064a\\u0642\\u062f\\u0645\\u0647\\u0627 \\u0627\\u0644\\u0645\\u0648\\u0642\\u0639 \\u061f\"}','{\"en\":\"\\u064a\\u0642\\u062f\\u0645 \\u0645\\u0648\\u0642\\u0639 \\u0628\\u0627\\u0644\\u0647\\u0646\\u0627 \\u0645\\u0642\\u0627\\u0637\\u0639 \\u0641\\u064a\\u062f\\u064a\\u0648 \\u0639\\u0646 \\u0648\\u0635\\u0641\\u0627\\u062a \\u0645\\u062e\\u062a\\u0644\\u0641\\u0629 \\u0644\\u0644\\u0627\\u0643\\u0644\"}','2022-04-10 16:29:42','2022-07-28 17:05:29'),(2,'{\"en\":\"\\u0643\\u064a\\u0641 \\u062a\\u0642\\u0648\\u0645 \\u0628\\u0627\\u0644\\u0627\\u0634\\u062a\\u0631\\u0627\\u0643 \\u0641\\u064a \\u0627\\u0644\\u0645\\u0648\\u0642\\u0639 \\u061f\"}','{\"en\":\"\\u0642\\u0645 \\u0628\\u0627\\u0644\\u0636\\u063a\\u0637 \\u0639\\u0644\\u0649 \\u0632\\u0631 \\u0627\\u0634\\u062a\\u0631\\u0627\\u0643 \\u0628\\u0627\\u0644\\u0627\\u0639\\u0644\\u0649 \\u0644\\u0643\\u064a \\u062a\\u062a\\u0645\\u062a\\u0639 \\u0628\\u0645\\u0634\\u0627\\u0647\\u062f\\u0629 \\u0627\\u0634\\u0647\\u0649 \\u0627\\u0644\\u0648\\u0635\\u0641\\u0627\\u062a\"}','2022-04-10 16:30:37','2022-04-10 16:30:37'),(3,'{\"en\":\"\\u0647\\u0644 \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u0627\\u0644\\u063a\\u0627\\u0621 \\u0627\\u0644\\u0627\\u0634\\u062a\\u0631\\u0627\\u0643 \\u0641\\u064a \\u0627\\u064a \\u0648\\u0642\\u062a \\u061f\"}','{\"en\":\"\\u0646\\u0639\\u0645 .. \\u0628\\u0627\\u0644\\u0636\\u063a\\u0637 \\u0639\\u0644\\u0649 \\u0632\\u0631 \\u0627\\u0644\\u063a\\u0627\\u0621 \\u0627\\u0644\\u0627\\u0634\\u062a\\u0631\\u0627\\u0643\"}','2022-04-10 16:31:13','2022-04-10 16:31:13');
/*!40000 ALTER TABLE `faqs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `front_slider_updates`
--

DROP TABLE IF EXISTS `front_slider_updates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `front_slider_updates` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `item_show` int unsigned DEFAULT NULL,
  `orderby` int DEFAULT '1',
  `sliderview` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `front_slider_updates`
--

LOCK TABLES `front_slider_updates` WRITE;
/*!40000 ALTER TABLE `front_slider_updates` DISABLE KEYS */;
/*!40000 ALTER TABLE `front_slider_updates` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `genres`
--

DROP TABLE IF EXISTS `genres`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `genres` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` int NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `genres`
--

LOCK TABLES `genres` WRITE;
/*!40000 ALTER TABLE `genres` DISABLE KEYS */;
INSERT INTO `genres` VALUES (9,'{\"ar\":\"\\u0645\\u0623\\u0643\\u0648\\u0644\\u0627\\u062a\",\"en\":\"test\"}','genre_1759949240ماكولات.jpg',1,'2025-09-23 02:10:24','2025-10-08 23:17:20'),(10,'{\"ar\":\"\\u062d\\u0644\\u0648\\u064a\\u0627\\u062a\"}','genre_1759949252حلويات (1).jpg',2,'2025-09-23 02:10:59','2025-10-08 23:17:32'),(11,'{\"ar\":\"\\u0634\\u0648\\u0631\\u0628\\u0627\\u062a \\u0648\\u0633\\u0644\\u0637\\u0627\\u062a\"}','genre_1759949260شوربات و سلطات.jpg',3,'2025-09-23 02:11:33','2025-10-08 23:17:40'),(12,'{\"ar\":\"\\u0639\\u0635\\u0627\\u0626\\u0631 \\u0648\\u0645\\u0634\\u0631\\u0648\\u0628\\u0627\\u062a\"}','genre_1759949270عصائر ومشروبات (1).jpg',4,'2025-09-23 02:11:58','2025-10-08 23:17:50'),(13,'{\"ar\":\"\\u0643\\u064a\\u0643 \\u0648\\u0628\\u0633\\u0643\\u0648\\u064a\\u062a\"}','genre_1759949279كيك و بسكويت.jpg',5,'2025-09-23 02:12:20','2025-10-08 23:17:59');
/*!40000 ALTER TABLE `genres` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `google_ads`
--

DROP TABLE IF EXISTS `google_ads`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `google_ads` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `google_ad_client` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `google_ad_slot` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `google_ad_width` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `google_ad_height` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `google_ad_starttime` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `google_ad_endtime` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `google_ads`
--

LOCK TABLES `google_ads` WRITE;
/*!40000 ALTER TABLE `google_ads` DISABLE KEYS */;
/*!40000 ALTER TABLE `google_ads` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `home_blocks`
--

DROP TABLE IF EXISTS `home_blocks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `home_blocks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `movie_id` int DEFAULT NULL,
  `tv_series_id` int DEFAULT NULL,
  `is_active` int NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `home_blocks`
--

LOCK TABLES `home_blocks` WRITE;
/*!40000 ALTER TABLE `home_blocks` DISABLE KEYS */;
/*!40000 ALTER TABLE `home_blocks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `home_sliders`
--

DROP TABLE IF EXISTS `home_sliders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `home_sliders` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `movie_id` int unsigned DEFAULT NULL,
  `tv_series_id` int unsigned DEFAULT NULL,
  `slide_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '0',
  `position` int NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `home_sliders_movie_id_foreign` (`movie_id`),
  KEY `home_sliders_tv_series_id_foreign` (`tv_series_id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `home_sliders`
--

LOCK TABLES `home_sliders` WRITE;
/*!40000 ALTER TABLE `home_sliders` DISABLE KEYS */;
INSERT INTO `home_sliders` VALUES (10,NULL,NULL,'slide_1698843072slide_1649502941WhatsApp Image 2022-03-28 at 1.23.52 PM.jpeg',1,1,'2022-11-03 19:00:57','2023-11-01 18:21:12'),(11,NULL,NULL,'slide_1698843091slide_1649502719WhatsApp Image 2022-03-28 at 1.23.56 PM.jpeg',1,2,'2022-11-03 19:01:26','2023-11-01 18:21:31');
/*!40000 ALTER TABLE `home_sliders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `home_translations`
--

DROP TABLE IF EXISTS `home_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `home_translations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `status` int NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `home_translations`
--

LOCK TABLES `home_translations` WRITE;
/*!40000 ALTER TABLE `home_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `home_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ipns`
--

DROP TABLE IF EXISTS `ipns`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ipns` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `ipn_version` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ipn_id` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ref_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ipn_mode` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `merchant` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ipn_type` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `txn_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` smallint DEFAULT NULL,
  `status_text` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `currency` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `currency1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `currency2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `confirms` tinyint unsigned DEFAULT NULL,
  `amount` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amounti` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fee` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `feei` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dest_tag` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `buyer_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `item_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `item_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom` text COLLATE utf8mb4_unicode_ci,
  `send_tx` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `received_amount` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `received_confirms` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ipns_ipn_id_unique` (`ipn_id`),
  KEY `ipns_address_index` (`address`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ipns`
--

LOCK TABLES `ipns` WRITE;
/*!40000 ALTER TABLE `ipns` DISABLE KEYS */;
/*!40000 ALTER TABLE `ipns` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jobs`
--

DROP TABLE IF EXISTS `jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint(1) NOT NULL,
  `reserved_at` int unsigned DEFAULT NULL,
  `available_at` int unsigned NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `jobs`
--

LOCK TABLES `jobs` WRITE;
/*!40000 ALTER TABLE `jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `labels`
--

DROP TABLE IF EXISTS `labels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `labels` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `labels`
--

LOCK TABLES `labels` WRITE;
/*!40000 ALTER TABLE `labels` DISABLE KEYS */;
/*!40000 ALTER TABLE `labels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `landing_pages`
--

DROP TABLE IF EXISTS `landing_pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `landing_pages` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `heading` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `detail` text COLLATE utf8mb4_unicode_ci,
  `button` tinyint(1) NOT NULL DEFAULT '1',
  `button_text` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `button_link` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `left` tinyint(1) NOT NULL DEFAULT '1',
  `position` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `landing_pages`
--

LOCK TABLES `landing_pages` WRITE;
/*!40000 ALTER TABLE `landing_pages` DISABLE KEYS */;
INSERT INTO `landing_pages` VALUES (1,'landing_page_1604308741home_1.jpg','{\"en\":\"Welcome!  Join Next Hour\"}','{\"en\":\"Join Next Hour to watch the most recent motion pictures, elite TV appears and grant winning Next Hour membership at simply least cost.\"}',1,'{\"en\":\"Join Next Hour\"}','login',0,1,'2020-11-02 14:29:21','2020-11-02 14:49:01'),(2,'landing_page_1604308752home_2.jpg','{\"en\":\"Don\'t Miss TV Shows\"}','{\"en\":\"With your Next Hour membership, you approach select US and all TV shows, grant winning Next Hour Original Series and kids and children shows.\"}',1,'{\"en\":\"Register Now\"}','register',1,2,'2020-11-02 14:29:39','2020-11-02 14:49:12'),(3,'landing_page_1604308763home_3.jpg','{\"en\":\"Membership for Movies & TV shows\"}','{\"en\":\"Notwithstanding boundless gushing, your Next Hour membership incorporates elite Bollywood, Hollywood films, US and all TV shows, grant winning Next Hour Series and kids shows.\"}',1,'{\"en\":\"Login Now\"}','login',0,3,'2020-11-02 14:30:01','2020-11-02 14:49:23'),(4,'landing_page_1604308776home_4.jpg','{\"en\":\"Kids Special\"}','{\"en\":\"With simple to utilize parental controls and a committed children page, you can appreciate secure, advertisement free children and kids diversion. Children and kids can appreciate famous TV shows.\"}',1,'{\"en\":\"Get Now\"}','register',0,4,'2020-11-02 14:30:18','2020-11-02 14:49:36');
/*!40000 ALTER TABLE `landing_pages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `languages`
--

DROP TABLE IF EXISTS `languages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `languages` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `local` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `def` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `rtl` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `languages`
--

LOCK TABLES `languages` WRITE;
/*!40000 ALTER TABLE `languages` DISABLE KEYS */;
INSERT INTO `languages` VALUES (1,'en','English',0,'2020-11-02 14:19:55','2022-04-09 19:05:28',1),(2,'ar','Arabic',1,'2022-03-31 15:54:50','2022-04-09 19:05:28',1);
/*!40000 ALTER TABLE `languages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `likes`
--

DROP TABLE IF EXISTS `likes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `likes` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `blog_id` int NOT NULL,
  `added` varchar(11) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `likes`
--

LOCK TABLES `likes` WRITE;
/*!40000 ALTER TABLE `likes` DISABLE KEYS */;
/*!40000 ALTER TABLE `likes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `live_events`
--

DROP TABLE IF EXISTS `live_events`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `live_events` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `iframeurl` text COLLATE utf8mb4_unicode_ci,
  `ready_url` text COLLATE utf8mb4_unicode_ci,
  `start_time` datetime NOT NULL,
  `end_time` datetime NOT NULL,
  `status` tinyint(1) NOT NULL,
  `thumbnail` text COLLATE utf8mb4_unicode_ci,
  `poster` text COLLATE utf8mb4_unicode_ci,
  `genre_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `detail` longtext COLLATE utf8mb4_unicode_ci,
  `organized_by` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `live_events`
--

LOCK TABLES `live_events` WRITE;
/*!40000 ALTER TABLE `live_events` DISABLE KEYS */;
/*!40000 ALTER TABLE `live_events` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `log`
--

DROP TABLE IF EXISTS `log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `log` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `log` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `log`
--

LOCK TABLES `log` WRITE;
/*!40000 ALTER TABLE `log` DISABLE KEYS */;
/*!40000 ALTER TABLE `log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `manual_payment_methods`
--

DROP TABLE IF EXISTS `manual_payment_methods`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `manual_payment_methods` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `payment_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `thumbnail` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `manual_payment_methods_payment_name_unique` (`payment_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `manual_payment_methods`
--

LOCK TABLES `manual_payment_methods` WRITE;
/*!40000 ALTER TABLE `manual_payment_methods` DISABLE KEYS */;
/*!40000 ALTER TABLE `manual_payment_methods` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `manual_payments`
--

DROP TABLE IF EXISTS `manual_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `manual_payments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned NOT NULL,
  `payment_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `package_id` int DEFAULT NULL,
  `price` double(8,2) NOT NULL,
  `status` tinyint(1) NOT NULL,
  `method` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subscription_from` datetime DEFAULT NULL,
  `subscription_to` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `manual_payments`
--

LOCK TABLES `manual_payments` WRITE;
/*!40000 ALTER TABLE `manual_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `manual_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mass_withdrawals`
--

DROP TABLE IF EXISTS `mass_withdrawals`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mass_withdrawals` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mass_withdrawals`
--

LOCK TABLES `mass_withdrawals` WRITE;
/*!40000 ALTER TABLE `mass_withdrawals` DISABLE KEYS */;
/*!40000 ALTER TABLE `mass_withdrawals` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_genre_shows`
--

DROP TABLE IF EXISTS `menu_genre_shows`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_genre_shows` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` int unsigned NOT NULL,
  `menu_section_id` int unsigned NOT NULL,
  `genre_id` int unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_genre_shows`
--

LOCK TABLES `menu_genre_shows` WRITE;
/*!40000 ALTER TABLE `menu_genre_shows` DISABLE KEYS */;
INSERT INTO `menu_genre_shows` VALUES (24,1,2,9),(25,1,2,10),(26,1,2,11),(27,1,2,12),(28,1,2,13);
/*!40000 ALTER TABLE `menu_genre_shows` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_sections`
--

DROP TABLE IF EXISTS `menu_sections`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_sections` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` int unsigned DEFAULT NULL,
  `section_id` int unsigned DEFAULT NULL,
  `item_limit` int unsigned DEFAULT NULL,
  `view` int unsigned NOT NULL DEFAULT '1',
  `order` int unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_sections`
--

LOCK TABLES `menu_sections` WRITE;
/*!40000 ALTER TABLE `menu_sections` DISABLE KEYS */;
INSERT INTO `menu_sections` VALUES (12,1,2,5,1,1);
/*!40000 ALTER TABLE `menu_sections` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_videos`
--

DROP TABLE IF EXISTS `menu_videos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_videos` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` int unsigned NOT NULL,
  `movie_id` int unsigned DEFAULT NULL,
  `tv_series_id` int unsigned DEFAULT NULL,
  `live_event_id` int DEFAULT NULL,
  `audio_id` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `menu_videos_menu_id_foreign` (`menu_id`),
  KEY `menu_videos_movie_id_foreign` (`movie_id`),
  KEY `menu_videos_tv_series_id_foreign` (`tv_series_id`)
) ENGINE=InnoDB AUTO_INCREMENT=267 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_videos`
--

LOCK TABLES `menu_videos` WRITE;
/*!40000 ALTER TABLE `menu_videos` DISABLE KEYS */;
INSERT INTO `menu_videos` VALUES (197,1,1,NULL,NULL,NULL,'2025-09-23 02:13:15','2025-09-23 02:13:15'),(198,1,2,NULL,NULL,NULL,'2025-09-23 02:17:50','2025-09-23 02:17:50'),(199,1,3,NULL,NULL,NULL,'2025-09-23 15:06:49','2025-09-23 15:06:49'),(200,1,4,NULL,NULL,NULL,'2025-09-23 15:20:18','2025-09-23 15:20:18'),(201,1,5,NULL,NULL,NULL,'2025-09-23 15:31:16','2025-09-23 15:31:16'),(203,1,6,NULL,NULL,NULL,'2025-09-23 15:37:57','2025-09-23 15:37:57'),(204,1,7,NULL,NULL,NULL,'2025-09-23 16:44:36','2025-09-23 16:44:36'),(205,1,8,NULL,NULL,NULL,'2025-09-23 16:47:56','2025-09-23 16:47:56'),(206,1,9,NULL,NULL,NULL,'2025-09-23 16:56:35','2025-09-23 16:56:35'),(207,1,10,NULL,NULL,NULL,'2025-09-23 17:00:03','2025-09-23 17:00:03'),(208,1,11,NULL,NULL,NULL,'2025-09-23 17:03:53','2025-09-23 17:03:53'),(209,1,12,NULL,NULL,NULL,'2025-09-23 17:06:17','2025-09-23 17:06:17'),(210,1,13,NULL,NULL,NULL,'2025-09-23 17:10:09','2025-09-23 17:10:09'),(211,1,14,NULL,NULL,NULL,'2025-09-23 17:17:01','2025-09-23 17:17:01'),(212,1,15,NULL,NULL,NULL,'2025-09-23 17:27:27','2025-09-23 17:27:27'),(213,1,16,NULL,NULL,NULL,'2025-09-23 17:47:21','2025-09-23 17:47:21'),(215,1,18,NULL,NULL,NULL,'2025-09-23 17:58:48','2025-09-23 17:58:48'),(216,1,19,NULL,NULL,NULL,'2025-09-23 18:37:35','2025-09-23 18:37:35'),(217,1,20,NULL,NULL,NULL,'2025-09-23 19:04:40','2025-09-23 19:04:40'),(218,1,21,NULL,NULL,NULL,'2025-09-23 19:15:38','2025-09-23 19:15:38'),(219,1,22,NULL,NULL,NULL,'2025-09-23 19:17:49','2025-09-23 19:17:49'),(220,1,23,NULL,NULL,NULL,'2025-09-23 19:50:04','2025-09-23 19:50:04'),(221,1,24,NULL,NULL,NULL,'2025-09-23 23:28:47','2025-09-23 23:28:47'),(222,1,25,NULL,NULL,NULL,'2025-09-23 23:31:19','2025-09-23 23:31:19'),(223,1,26,NULL,NULL,NULL,'2025-09-23 23:38:15','2025-09-23 23:38:15'),(225,1,28,NULL,NULL,NULL,'2025-09-23 23:44:05','2025-09-23 23:44:05'),(226,1,29,NULL,NULL,NULL,'2025-09-23 23:46:24','2025-09-23 23:46:24'),(227,1,30,NULL,NULL,NULL,'2025-09-24 01:23:44','2025-09-24 01:23:44'),(228,1,31,NULL,NULL,NULL,'2025-09-24 01:27:08','2025-09-24 01:27:08'),(229,1,32,NULL,NULL,NULL,'2025-09-24 01:29:41','2025-09-24 01:29:41'),(230,1,33,NULL,NULL,NULL,'2025-09-24 01:31:30','2025-09-24 01:31:30'),(231,1,34,NULL,NULL,NULL,'2025-09-24 01:33:57','2025-09-24 01:33:57'),(232,1,35,NULL,NULL,NULL,'2025-09-24 01:36:24','2025-09-24 01:36:24'),(233,1,36,NULL,NULL,NULL,'2025-09-24 01:40:07','2025-09-24 01:40:07'),(234,1,37,NULL,NULL,NULL,'2025-09-24 01:47:27','2025-09-24 01:47:27'),(235,1,38,NULL,NULL,NULL,'2025-09-24 02:37:46','2025-09-24 02:37:46'),(236,1,39,NULL,NULL,NULL,'2025-09-24 02:39:14','2025-09-24 02:39:14'),(237,1,40,NULL,NULL,NULL,'2025-09-24 03:04:53','2025-09-24 03:04:53'),(238,1,41,NULL,NULL,NULL,'2025-09-24 03:06:47','2025-09-24 03:06:47'),(239,1,27,NULL,NULL,NULL,'2025-09-24 03:08:33','2025-09-24 03:08:33'),(241,1,43,NULL,NULL,NULL,'2025-09-24 03:14:58','2025-09-24 03:14:58'),(242,1,44,NULL,NULL,NULL,'2025-09-24 03:17:00','2025-09-24 03:17:00'),(243,1,45,NULL,NULL,NULL,'2025-09-24 03:19:18','2025-09-24 03:19:18'),(244,1,46,NULL,NULL,NULL,'2025-09-24 03:22:31','2025-09-24 03:22:31'),(245,1,47,NULL,NULL,NULL,'2025-09-24 03:24:24','2025-09-24 03:24:24'),(246,1,48,NULL,NULL,NULL,'2025-09-24 03:28:49','2025-09-24 03:28:49'),(247,1,49,NULL,NULL,NULL,'2025-09-24 03:31:49','2025-09-24 03:31:49'),(248,1,50,NULL,NULL,NULL,'2025-09-24 03:33:46','2025-09-24 03:33:46'),(249,1,51,NULL,NULL,NULL,'2025-09-24 03:37:03','2025-09-24 03:37:03'),(250,1,52,NULL,NULL,NULL,'2025-09-24 03:39:49','2025-09-24 03:39:49'),(251,1,53,NULL,NULL,NULL,'2025-09-24 03:42:21','2025-09-24 03:42:21'),(252,1,54,NULL,NULL,NULL,'2025-09-24 03:44:24','2025-09-24 03:44:24'),(253,1,55,NULL,NULL,NULL,'2025-09-24 03:46:20','2025-09-24 03:46:20'),(254,1,56,NULL,NULL,NULL,'2025-09-24 03:47:52','2025-09-24 03:47:52'),(255,1,57,NULL,NULL,NULL,'2025-09-24 03:50:21','2025-09-24 03:50:21'),(256,1,58,NULL,NULL,NULL,'2025-09-24 03:52:12','2025-09-24 03:52:12'),(257,1,59,NULL,NULL,NULL,'2025-09-28 14:41:27','2025-09-28 14:41:27'),(258,1,60,NULL,NULL,NULL,'2025-09-28 14:43:45','2025-09-28 14:43:45'),(260,1,17,NULL,NULL,NULL,'2025-09-28 14:44:47','2025-09-28 14:44:47'),(261,1,61,NULL,NULL,NULL,'2025-09-28 14:47:23','2025-09-28 14:47:23'),(262,1,62,NULL,NULL,NULL,'2025-09-28 14:50:06','2025-09-28 14:50:06'),(263,1,63,NULL,NULL,NULL,'2025-09-28 14:52:50','2025-09-28 14:52:50'),(264,1,64,NULL,NULL,NULL,'2025-09-28 14:56:01','2025-09-28 14:56:01'),(265,1,65,NULL,NULL,NULL,'2025-09-29 19:30:22','2025-09-29 19:30:22'),(266,1,42,NULL,NULL,NULL,'2025-09-29 19:30:58','2025-09-29 19:30:58');
/*!40000 ALTER TABLE `menu_videos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menus`
--

DROP TABLE IF EXISTS `menus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menus` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` bigint DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menus`
--

LOCK TABLES `menus` WRITE;
/*!40000 ALTER TABLE `menus` DISABLE KEYS */;
INSERT INTO `menus` VALUES (1,'{\"en\":\"\\u0648\\u0635\\u0641\\u0627\\u062a\",\"ar\":\"\\u0648\\u0635\\u0641\\u0627\\u062a\"}','osfat',1,'2022-03-31 16:19:30','2022-04-10 18:37:24');
/*!40000 ALTER TABLE `menus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrations`
--

DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=106 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrations`
--

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'2016_06_01_000001_create_oauth_auth_codes_table',1),(2,'2016_06_01_000002_create_oauth_access_tokens_table',1),(3,'2016_06_01_000003_create_oauth_refresh_tokens_table',1),(4,'2016_06_01_000004_create_oauth_clients_table',1),(5,'2016_06_01_000005_create_oauth_personal_access_clients_table',1),(6,'2017_09_15_051156_setup_coinpayment_tables',1),(7,'2018_03_24_032432_create_callback_address_table',1),(8,'2018_05_07_123123_fix_transactions_table',1),(9,'2018_05_08_037214_cp_create_mass_withdrawal',1),(10,'2018_07_01_112608_add_column_dest_tag_to_transactions_table',1),(11,'2018_08_29_205156_create_translations_table',1),(12,'2019_05_03_000002_create_subscriptions_table',1),(13,'2019_05_03_000003_create_subscription_items_table',1),(14,'2020_06_14_180448_create_actors_table',1),(15,'2020_06_14_180448_create_ads_table',1),(16,'2020_06_14_180448_create_adsenses_table',1),(17,'2020_06_14_180448_create_audio_languages_table',1),(18,'2020_06_14_180448_create_auth_customizes_table',1),(19,'2020_06_14_180448_create_blog_menu_table',1),(20,'2020_06_14_180448_create_blogs_table',1),(21,'2020_06_14_180448_create_buttons_table',1),(22,'2020_06_14_180448_create_comments_table',1),(23,'2020_06_14_180448_create_configs_table',1),(24,'2020_06_14_180448_create_coupon_codes_table',1),(25,'2020_06_14_180448_create_cps_cpp_table',1),(26,'2020_06_14_180448_create_custom_pages_table',1),(27,'2020_06_14_180448_create_directors_table',1),(28,'2020_06_14_180448_create_donater_lists_table',1),(29,'2020_06_14_180448_create_episodes_table',1),(30,'2020_06_14_180448_create_faqs_table',1),(31,'2020_06_14_180448_create_front_slider_updates_table',1),(32,'2020_06_14_180448_create_genres_table',1),(33,'2020_06_14_180448_create_home_blocks_table',1),(34,'2020_06_14_180448_create_home_sliders_table',1),(35,'2020_06_14_180448_create_home_translations_table',1),(36,'2020_06_14_180448_create_jobs_table',1),(37,'2020_06_14_180448_create_landing_pages_table',1),(38,'2020_06_14_180448_create_languages_table',1),(39,'2020_06_14_180448_create_likes_table',1),(40,'2020_06_14_180448_create_live_events_table',1),(41,'2020_06_14_180448_create_menu_sections_table',1),(42,'2020_06_14_180448_create_menu_videos_table',1),(43,'2020_06_14_180448_create_menus_table',1),(44,'2020_06_14_180448_create_movie_comments_table',1),(45,'2020_06_14_180448_create_movie_series_table',1),(46,'2020_06_14_180448_create_movie_subcomments_table',1),(47,'2020_06_14_180448_create_movies_table',1),(48,'2020_06_14_180448_create_multiple_links_table',1),(49,'2020_06_14_180448_create_multiplescreens_table',1),(50,'2020_06_14_180448_create_notifications_table',1),(51,'2020_06_14_180448_create_package_menu_table',1),(52,'2020_06_14_180448_create_packages_table',1),(53,'2020_06_14_180448_create_password_resets_table',1),(54,'2020_06_14_180448_create_paypal_subscriptions_table',1),(55,'2020_06_14_180448_create_plans_table',1),(56,'2020_06_14_180448_create_player_settings_table',1),(57,'2020_06_14_180448_create_pricing_texts_table',1),(58,'2020_06_14_180448_create_seasons_table',1),(59,'2020_06_14_180448_create_seos_table',1),(60,'2020_06_14_180448_create_sessions_table',1),(61,'2020_06_14_180448_create_social_icons_table',1),(62,'2020_06_14_180448_create_subcomments_table',1),(63,'2020_06_14_180448_create_subtitles_table',1),(64,'2020_06_14_180448_create_tv_series_table',1),(65,'2020_06_14_180448_create_user_ratings_table',1),(66,'2020_06_14_180448_create_users_table',1),(67,'2020_06_14_180448_create_videolinks_table',1),(68,'2020_06_14_180448_create_views_table',1),(69,'2020_06_14_180448_create_watch_histories_table',1),(70,'2020_06_14_180448_create_wishlists_table',1),(71,'2020_06_14_180452_add_foreign_keys_to_episodes_table',1),(72,'2020_06_14_180452_add_foreign_keys_to_home_sliders_table',1),(73,'2020_06_22_122007_create_audio_table',1),(74,'2020_06_24_150735_create_manual_payments_table',1),(75,'2020_06_25_115048_create_app_configs_table',1),(76,'2020_06_25_132738_create_splash_screens_table',1),(77,'2020_06_25_180556_create_app_sliders_table',1),(78,'2020_06_29_102308_commingsoon_enabled_ip_to_buttons_table',1),(79,'2020_10_31_114942_add_column_to_player_settings_table',1),(80,'2020_11_02_113133_add_columns',1),(81,'2020_11_02_114440_create_reminder_mails_table',1),(82,'2020_11_07_135552_create_chat_setting_table',1),(83,'2021_06_05_112917_add_columns_in_users_table_custom',1),(84,'2021_06_05_130920_add_columns_existing',1),(85,'2020_11_06_114837_create_table',2),(86,'2020_11_06_115740_add_column_table',2),(87,'2020_12_03_153005_add_column_update_31_table',3),(88,'2020_12_24_121353_add_column_update_v3_2',4),(89,'2021_03_07_162535_create_coupon_applies_table',4),(90,'2021_03_22_112446_create_menu_genre_shows_table',5),(91,'2021_04_17_131827_create_google_ads_table',5),(92,'2021_05_03_144635_add_column_update_v3_3',5),(93,'2020_12_02_123844_create_manual_payment_methods_table',6),(94,'2021_06_13_182042_remove_column_update_v3_4',6),(95,'2021_06_13_185438_add_column_update_v3_4',6),(96,'2021_06_12_145328_create_package_features_table',7),(97,'2021_06_18_112730_add_column_update_v4_0',7),(98,'2021_07_03_084019_create_color_schemes_table',7),(99,'2021_07_20_094823_create_labels_table',7),(100,'2021_08_20_183347_remove_column_v4_0',7),(101,'2013_11_26_161501_create_currency_table',8),(102,'2021_08_30_180428_create_new_permission_tables',8),(103,'2021_08_30_180428_create_permission_tables',8),(104,'2021_09_04_110417_add_column_update_v_4_1',8),(105,'2021_09_17_182123_remove_column_v4_1',8);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `model_has_permissions`
--

DROP TABLE IF EXISTS `model_has_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `model_has_permissions` (
  `permission_id` bigint unsigned NOT NULL,
  `model_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`model_id`,`model_type`),
  KEY `model_has_permissions_model_id_model_type_index` (`model_id`,`model_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `model_has_permissions`
--

LOCK TABLES `model_has_permissions` WRITE;
/*!40000 ALTER TABLE `model_has_permissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `model_has_permissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `model_has_roles`
--

DROP TABLE IF EXISTS `model_has_roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `model_has_roles` (
  `role_id` bigint unsigned NOT NULL,
  `model_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint unsigned NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `model_has_roles`
--

LOCK TABLES `model_has_roles` WRITE;
/*!40000 ALTER TABLE `model_has_roles` DISABLE KEYS */;
INSERT INTO `model_has_roles` VALUES (1,'App\\User',1);
/*!40000 ALTER TABLE `model_has_roles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `movie_comments`
--

DROP TABLE IF EXISTS `movie_comments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `movie_comments` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` int NOT NULL,
  `email` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `movie_id` int DEFAULT NULL,
  `tv_series_id` int DEFAULT NULL,
  `comment` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `movie_comments`
--

LOCK TABLES `movie_comments` WRITE;
/*!40000 ALTER TABLE `movie_comments` DISABLE KEYS */;
/*!40000 ALTER TABLE `movie_comments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `movie_series`
--

DROP TABLE IF EXISTS `movie_series`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `movie_series` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `movie_id` int unsigned NOT NULL,
  `series_movie_id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `movie_series_movie_id_foreign` (`movie_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `movie_series`
--

LOCK TABLES `movie_series` WRITE;
/*!40000 ALTER TABLE `movie_series` DISABLE KEYS */;
/*!40000 ALTER TABLE `movie_series` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `movie_subcomments`
--

DROP TABLE IF EXISTS `movie_subcomments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `movie_subcomments` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int DEFAULT NULL,
  `comment_id` int DEFAULT NULL,
  `reply` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `movie_subcomments`
--

LOCK TABLES `movie_subcomments` WRITE;
/*!40000 ALTER TABLE `movie_subcomments` DISABLE KEYS */;
/*!40000 ALTER TABLE `movie_subcomments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `movies`
--

DROP TABLE IF EXISTS `movies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `movies` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `tmdb_id` int DEFAULT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `keyword` text COLLATE utf8mb4_unicode_ci,
  `description` text COLLATE utf8mb4_unicode_ci,
  `duration` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `thumbnail` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `poster` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tmdb` char(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fetch_by` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `director_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `actor_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `genre_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `trailer_url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `detail` text COLLATE utf8mb4_unicode_ci,
  `rating` double(8,2) DEFAULT NULL,
  `maturity_rating` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subtitle` tinyint(1) DEFAULT NULL,
  `publish_year` int DEFAULT NULL,
  `released` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `upload_video` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `featured` tinyint(1) DEFAULT NULL,
  `series` tinyint(1) DEFAULT NULL,
  `a_language` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `audio_files` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` char(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'M',
  `live` tinyint(1) DEFAULT '0',
  `livetvicon` tinyint(1) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '1',
  `is_protect` int NOT NULL DEFAULT '0',
  `password` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `is_upcoming` tinyint(1) NOT NULL DEFAULT '0',
  `is_custom_label` tinyint(1) NOT NULL DEFAULT '0',
  `label_id` int DEFAULT NULL,
  `upcoming_date` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=66 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `movies`
--

LOCK TABLES `movies` WRITE;
/*!40000 ALTER TABLE `movies` DISABLE KEYS */;
INSERT INTO `movies` VALUES (1,NULL,'دجاج بالرز','chicken with rice','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_175857739518.jpg',NULL,'N','title',NULL,NULL,'9',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-23 02:13:15','2025-09-23 02:13:15',0,0,NULL,NULL),(2,NULL,'اللحم بعجين التركي بخبز التورتيلا','Easy Turkish Lahmacun with Tortilla','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_175857767016.jpg',NULL,'N','title',NULL,NULL,'9',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-23 02:17:50','2025-09-23 02:17:50',0,0,NULL,NULL),(3,NULL,'كرات اللحم مع البطاطس','Meat balls with Potatoes','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_175862380939.jpg',NULL,'N','title',NULL,NULL,'9',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-23 15:06:49','2025-09-23 15:06:49',0,0,NULL,NULL),(4,NULL,'افطار صحي لذيذ بالشوفان','Delicious Breakfast With Oats','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_175862461841.jpg',NULL,'N','title',NULL,NULL,'9',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-23 15:20:18','2025-09-23 15:20:18',0,0,NULL,NULL),(5,NULL,'الحواوشي','Hawawshi','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_175862527632.jpg',NULL,'N','title',NULL,NULL,'9',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-23 15:31:16','2025-09-23 15:31:16',0,0,NULL,NULL),(6,NULL,'متبل باذنجان مشوي','Mutabal Roasted Eggplant Dip','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_175862567714.jpg',NULL,'N','title',NULL,NULL,'9',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-23 15:32:56','2025-09-23 15:37:57',0,0,NULL,NULL),(7,NULL,'خبز النان الهندي بالثوم','Indian Garlic Naan Bread Recipe','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_175862967646.jpg',NULL,'N','title',NULL,NULL,'9',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-23 16:44:36','2025-09-23 16:44:36',0,0,NULL,NULL),(8,NULL,'شرائح خبز حبوب كاملة مقرمشة و صحية','Gluten Free Crispy Seeds Crackers','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_175862987622.jpg',NULL,'N','title',NULL,NULL,'9',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-23 16:47:56','2025-09-23 16:47:56',0,0,NULL,NULL),(9,NULL,'الكباب اليمني','Yemeni Kebab Recipe','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_175863039535.jpg',NULL,'N','title',NULL,NULL,'9',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-23 16:56:35','2025-09-23 16:56:35',0,0,NULL,NULL),(10,NULL,'دجاج مشوي تندوري','Chicken Tandoori','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_175863060345.jpg',NULL,'N','title',NULL,NULL,'9',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-23 17:00:03','2025-09-23 17:00:03',0,0,NULL,NULL),(11,NULL,'لحم البريسكت المدخن في الفرن','Oven smoked brisket','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_175863083325.jpg',NULL,'N','title',NULL,NULL,'9',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-23 17:03:53','2025-09-23 17:03:53',0,0,NULL,NULL),(12,NULL,'ساندويتش الدجاج المقرمش الحار','Spicy crispy chicken sandwich','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_175863097710.jpg',NULL,'N','title',NULL,NULL,'9',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-23 17:06:17','2025-09-23 17:06:17',0,0,NULL,NULL),(13,NULL,'فتة الحمص','Hummus fatteh','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_175863120947.jpg',NULL,'N','title',NULL,NULL,'9',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-23 17:10:09','2025-09-23 17:10:09',0,0,NULL,NULL),(14,NULL,'مكرونة أصداف باللحمة والبشاميل','Shell pasta with meat and bechamel','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_175863162175.jpg',NULL,'N','title',NULL,NULL,'9',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-23 17:17:01','2025-09-23 17:17:01',0,0,NULL,NULL),(15,NULL,'شرائح اللحم بالخضار','Beef Sizzling Recipe','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_175863224659.jpg',NULL,'N','title',NULL,NULL,'9',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-23 17:27:27','2025-09-23 17:27:27',0,0,NULL,NULL),(16,NULL,'دجاج بالزبدة بالطريقة الهنديه (بتر تشكن)','Indian Butter Chicken','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_175863344143.jpg',NULL,'N','title',NULL,NULL,'9',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-23 17:47:21','2025-09-23 17:47:21',0,0,NULL,NULL),(17,NULL,'صينية الجلاش بالخضار والجبنة','Vegetable and cheese goulash tray','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_1759054487الجلاش بالخضار والجبنة.jpg',NULL,'N','title',NULL,NULL,'9',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-23 17:53:41','2025-09-28 14:44:47',0,0,NULL,NULL),(18,NULL,'القراصة السودانية','gurasa','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_17586341289.jpg',NULL,'N','title',NULL,NULL,'9',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-23 17:58:48','2025-09-23 17:58:48',0,0,NULL,NULL),(19,NULL,'ملاح النعيمية بدون لحم','Neemiaah without meat','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_175863645529.jpg',NULL,'N','title',NULL,NULL,'9',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-23 18:37:35','2025-09-23 18:37:35',0,0,NULL,NULL),(20,NULL,'دجاج تكالا مسالا','Chicken Tikka masala','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_1758638080تكالا مسالا.jpg',NULL,'N','title',NULL,NULL,'9',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-23 19:04:40','2025-09-23 19:04:40',0,0,NULL,NULL),(21,NULL,'وصفات الأرز','Rice recipes','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_175863873840.jpg',NULL,'N','title',NULL,NULL,'9',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-23 19:15:38','2025-09-23 19:15:38',0,0,NULL,NULL),(22,NULL,'بطاطس بالقيمة','b6a6is bi gima','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_175863886937.jpg',NULL,'N','title',NULL,NULL,'9',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-23 19:17:49','2025-09-23 19:17:49',0,0,NULL,NULL),(23,NULL,'شية الصاج','Shaia saj','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_17586408048.jpg',NULL,'N','title',NULL,NULL,'9',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-23 19:50:04','2025-09-23 19:50:04',0,0,NULL,NULL),(24,NULL,'المحشي','Mahshi','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_175865392727.jpg',NULL,'N','title',NULL,NULL,'9',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-23 23:28:47','2025-09-23 23:28:47',0,0,NULL,NULL),(25,NULL,'ريش ضاني','Lamb feathers','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_175865407926.jpg',NULL,'N','title',NULL,NULL,'9',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-23 23:31:19','2025-09-23 23:31:19',0,0,NULL,NULL),(26,NULL,'الكبدة المحمرة','Kebda','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_175865449550.jpg',NULL,'N','title',NULL,NULL,'9',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-23 23:38:15','2025-09-23 23:38:15',0,0,NULL,NULL),(27,NULL,'عجينة الفطائر','Fatayer dough','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_175866711312.jpg',NULL,'N','title',NULL,NULL,'9',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-23 23:40:53','2025-09-24 03:08:33',0,0,NULL,NULL),(28,NULL,'كبسة لحم','Meat kabbsa','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_175865484574.jpg',NULL,'N','title',NULL,NULL,'9',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-23 23:44:05','2025-09-23 23:44:05',0,0,NULL,NULL),(29,NULL,'عجينة البيتزا','Pizza dough','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_175865498477.jpg',NULL,'N','title',NULL,NULL,'9',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-23 23:46:24','2025-09-23 23:46:24',0,0,NULL,NULL),(30,NULL,'مشروب التمر بالحليب','Milk with date','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_17586608242.jpg',NULL,'N','title',NULL,NULL,'12',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-24 01:23:44','2025-09-24 01:23:44',0,0,NULL,NULL),(31,NULL,'مخلل المانجو','Mango pickle','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_1758661028Alchef covers copy.jpg',NULL,'N','title',NULL,NULL,'11',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-24 01:27:08','2025-09-24 01:27:08',0,0,NULL,NULL),(32,NULL,'شوربة الفلفل الأحمر المشوي','Roasted red pepper soup','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_175866118113.jpg',NULL,'N','title',NULL,NULL,'11',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-24 01:29:41','2025-09-24 01:29:41',0,0,NULL,NULL),(33,NULL,'شوربة لسان العصفور','Sparrow tongue soup','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_175866129021.jpg',NULL,'N','title',NULL,NULL,'11',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-24 01:31:30','2025-09-24 01:31:30',0,0,NULL,NULL),(34,NULL,'سلطة السيزر','Caesar salad','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_17586614375.jpg',NULL,'N','title',NULL,NULL,'11',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-24 01:33:57','2025-09-24 01:33:57',0,0,NULL,NULL),(35,NULL,'شوربة الشوفان مع الخضار','Oatmeal soup with vegetables','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_175866158438.jpg',NULL,'N','title',NULL,NULL,'11',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-24 01:36:24','2025-09-24 01:36:24',0,0,NULL,NULL),(36,NULL,'شوربة اللحم بالشعيرية والحمص','Beef soup with vermicelli and chickpeas','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_17586618074.jpg',NULL,'N','title',NULL,NULL,'11',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-24 01:40:07','2025-09-24 01:40:07',0,0,NULL,NULL),(37,NULL,'شوربة الزبادي التركية','Turkish yogurt soup','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_175866224736.jpg',NULL,'N','title',NULL,NULL,'11',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-24 01:47:27','2025-09-24 01:47:27',0,0,NULL,NULL),(38,NULL,'شوربة الفطر بالكريمة','Cream of mushroom soup','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_175866526624.jpg',NULL,'N','title',NULL,NULL,'11',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-24 02:37:46','2025-09-24 02:37:46',0,0,NULL,NULL),(39,NULL,'شوربة الدجاج بالكريمة','Cream of chicken soup','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_175866535434.jpg',NULL,'N','title',NULL,NULL,'11',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-24 02:39:14','2025-09-24 02:39:14',0,0,NULL,NULL),(40,NULL,'تشيز كيك مع صوص الفراولة','Creamy Strawberry Cheesecake','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_17586668921.jpg',NULL,'N','title',NULL,NULL,'10',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-24 03:04:53','2025-09-24 03:04:53',0,0,NULL,NULL),(41,NULL,'كرات الشوفان بجوز الهند','Swedish Chocolate Balls','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_175866700748.jpg',NULL,'N','title',NULL,NULL,'10',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-24 03:06:47','2025-09-24 03:06:47',0,0,NULL,NULL),(42,NULL,'الحلاوة التركية','Turkish delight','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_1759158058حلاوة تركيه.jpg',NULL,'N','title',NULL,NULL,'10',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-24 03:12:11','2025-09-29 19:30:58',0,0,NULL,NULL),(43,NULL,'ايس تيراميسو','Ice Tiramisu','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_17586674986.jpg',NULL,'N','title',NULL,NULL,'10',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-24 03:14:58','2025-09-24 03:14:58',0,0,NULL,NULL),(44,NULL,'باسطة كعب الغزال','Gazelle heel','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_175866762030.jpg',NULL,'N','title',NULL,NULL,'10',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-24 03:17:00','2025-09-24 03:17:00',0,0,NULL,NULL),(45,NULL,'مربى الفراولة','strawberry jam','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_175866775842.jpg',NULL,'N','title',NULL,NULL,'10',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-24 03:19:18','2025-09-24 03:19:18',0,0,NULL,NULL),(46,NULL,'باسطة سودانية بالقشطة','Bas6a bi gish6a','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_175866795153.jpg',NULL,'N','title',NULL,NULL,'10',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-24 03:22:31','2025-09-24 03:22:31',0,0,NULL,NULL),(47,NULL,'سلطة الفواكه','Fruit salad','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_175866806415.jpg',NULL,'N','title',NULL,NULL,'10',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-24 03:24:24','2025-09-24 03:24:24',0,0,NULL,NULL),(48,NULL,'كيكة البلح بصوص الكراميل','Date Cake with caramel sauce','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_175866832928.jpg',NULL,'N','title',NULL,NULL,'13',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-24 03:28:49','2025-09-24 03:28:49',0,0,NULL,NULL),(49,NULL,'كيكة الشوكولاته بالموز بدون بيض','Eggless Banana Chocolate Cake','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_175866850951.jpg',NULL,'N','title',NULL,NULL,'13',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-24 03:31:49','2025-09-24 03:31:49',0,0,NULL,NULL),(50,NULL,'كيكة الشعيرية الباكستانية','Pakistani Sweet Vermicelli Cake','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_175866862649.jpg',NULL,'N','title',NULL,NULL,'13',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-24 03:33:46','2025-09-24 03:33:46',0,0,NULL,NULL),(51,NULL,'كيكه حادقه بالخضروات','Vegetable Savory Cake','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_17586688233.jpg',NULL,'N','title',NULL,NULL,'13',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-24 03:37:03','2025-09-24 03:37:03',0,0,NULL,NULL),(52,NULL,'كيكة الجلاش','Gulash cake','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_175866898878.jpg',NULL,'N','title',NULL,NULL,'13',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-24 03:39:48','2025-09-24 03:39:48',0,0,NULL,NULL),(53,NULL,'براونيز','Brownies','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_175866914157.jpg',NULL,'N','title',NULL,NULL,'13',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-24 03:42:21','2025-09-24 03:42:21',0,0,NULL,NULL),(54,NULL,'الكعك','Ka3k','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_175866926476.jpg',NULL,'N','title',NULL,NULL,'13',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-24 03:44:24','2025-09-24 03:44:24',0,0,NULL,NULL),(55,NULL,'بسكويت اليانسون','Yansoon biscuit','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_175866938070.jpg',NULL,'N','title',NULL,NULL,'13',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-24 03:46:20','2025-09-24 03:46:20',0,0,NULL,NULL),(56,NULL,'المنين','Minin','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_175866947258.jpg',NULL,'N','title',NULL,NULL,'13',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-24 03:47:52','2025-09-24 03:47:52',0,0,NULL,NULL),(57,NULL,'تورتة','Toart','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_175866962154.jpg',NULL,'N','title',NULL,NULL,'13',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-24 03:50:21','2025-09-24 03:50:21',0,0,NULL,NULL),(58,NULL,'بسكويت النشادر السوداني','Sudanese ammonia biscuits','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_175866973269.jpg',NULL,'N','title',NULL,NULL,'13',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-24 03:52:12','2025-09-24 03:52:12',0,0,NULL,NULL),(59,NULL,'عصير البطيخ','Watermelon juice','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_175905428720.jpg',NULL,'N','title',NULL,NULL,'12',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-28 14:41:27','2025-09-28 14:41:27',0,0,NULL,NULL),(60,NULL,'عصير المانجو والجزر','Mango and carrot juice','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_175905442519.jpg',NULL,'N','title',NULL,NULL,'12',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-28 14:43:45','2025-09-28 14:43:45',0,0,NULL,NULL),(61,NULL,'مخلل الباذنجان','Pickled eggplant','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_1759054643مخلل الباذنجان.jpg',NULL,'N','title',NULL,NULL,'11',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-28 14:47:23','2025-09-28 14:47:23',0,0,NULL,NULL),(62,NULL,'كوكيز الشوكولاتة','Cookie Dough Cubes','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_175905480565.jpg',NULL,'N','title',NULL,NULL,'13',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-28 14:50:05','2025-09-28 14:50:05',0,0,NULL,NULL),(63,NULL,'الفتة (السليقة)','Fattah','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_1759054970الفتة والضلع.jpg',NULL,'N','title',NULL,NULL,'9',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-28 14:52:50','2025-09-28 14:52:50',0,0,NULL,NULL),(64,NULL,'حلا الرواني','Rawwani','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_1759055161حلا الرواني.jpg',NULL,'N','title',NULL,NULL,'10',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-28 14:56:01','2025-09-28 14:56:01',0,0,NULL,NULL),(65,NULL,'الضلع وملاح أم رقيقة','dali3','{\"ar\":null}','{\"ar\":null}',NULL,'thumb_1759158022Alchef covers copy (1).jpg',NULL,'N','title',NULL,NULL,'9',NULL,'{\"ar\":null}',NULL,'all age',0,NULL,NULL,NULL,0,0,NULL,NULL,'M',0,NULL,1,0,NULL,1,'2025-09-29 19:30:22','2025-09-29 19:30:22',0,0,NULL,NULL);
/*!40000 ALTER TABLE `movies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `multiple_links`
--

DROP TABLE IF EXISTS `multiple_links`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `multiple_links` (
  `id` int NOT NULL AUTO_INCREMENT,
  `movie_id` int DEFAULT NULL,
  `episode_id` int DEFAULT NULL,
  `download` tinyint(1) NOT NULL,
  `quality` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `language` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `clicks` int NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `multiple_links`
--

LOCK TABLES `multiple_links` WRITE;
/*!40000 ALTER TABLE `multiple_links` DISABLE KEYS */;
/*!40000 ALTER TABLE `multiple_links` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `multiplescreens`
--

DROP TABLE IF EXISTS `multiplescreens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `multiplescreens` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `screen1` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `screen2` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `screen3` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `screen4` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` int unsigned NOT NULL,
  `activescreen` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `screen_1_used` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'NO',
  `screen_2_used` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'NO',
  `screen_3_used` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'NO',
  `screen_4_used` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'NO',
  `device_mac_1` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `device_mac_2` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `device_mac_3` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `device_mac_4` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `download_1` int DEFAULT NULL,
  `download_2` int DEFAULT NULL,
  `download_3` int DEFAULT NULL,
  `download_4` int DEFAULT NULL,
  `pkg_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `multiplescreens`
--

LOCK TABLES `multiplescreens` WRITE;
/*!40000 ALTER TABLE `multiplescreens` DISABLE KEYS */;
/*!40000 ALTER TABLE `multiplescreens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `notifications`
--

DROP TABLE IF EXISTS `notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `notifications` (
  `id` char(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` longtext COLLATE utf8mb4_unicode_ci,
  `notifiable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `notifiable_id` bigint unsigned NOT NULL,
  `data` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `movie_id` int DEFAULT NULL,
  `tv_id` int DEFAULT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notifications_notifiable_type_notifiable_id_index` (`notifiable_type`,`notifiable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `notifications`
--

LOCK TABLES `notifications` WRITE;
/*!40000 ALTER TABLE `notifications` DISABLE KEYS */;
INSERT INTO `notifications` VALUES ('216375d3-11fe-4086-be48-db13d2bea5e2','App\\Notifications\\MyNotification','وصل','App\\User',28,'{\"title\":\"\\u0648\\u0635\\u0644\",\"data\":\"car snorkel\",\"movie_id\":\"89\",\"tv_id\":null,\"notifiable_id\":[[\"28\"]]}',89,NULL,'2022-06-02 17:26:42','2022-06-02 17:26:05','2022-06-02 17:26:42'),('c7db879e-4d8c-4a8b-80bc-b9ef4f41b21b','App\\Notifications\\MyNotification','test','App\\User',28,'{\"title\":\"test\",\"data\":\"est\",\"movie_id\":\"92\",\"tv_id\":null,\"notifiable_id\":[[\"28\"]]}',92,NULL,'2022-06-02 17:25:46','2022-06-02 17:24:28','2022-06-02 17:25:46');
/*!40000 ALTER TABLE `notifications` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oauth_access_tokens`
--

DROP TABLE IF EXISTS `oauth_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `oauth_access_tokens` (
  `id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `client_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `scopes` text COLLATE utf8mb4_unicode_ci,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_access_tokens_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oauth_access_tokens`
--

LOCK TABLES `oauth_access_tokens` WRITE;
/*!40000 ALTER TABLE `oauth_access_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oauth_auth_codes`
--

DROP TABLE IF EXISTS `oauth_auth_codes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `oauth_auth_codes` (
  `id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `client_id` bigint unsigned NOT NULL,
  `scopes` text COLLATE utf8mb4_unicode_ci,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_auth_codes_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oauth_auth_codes`
--

LOCK TABLES `oauth_auth_codes` WRITE;
/*!40000 ALTER TABLE `oauth_auth_codes` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_auth_codes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oauth_clients`
--

DROP TABLE IF EXISTS `oauth_clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `oauth_clients` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `secret` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `provider` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `redirect` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `personal_access_client` tinyint(1) NOT NULL,
  `password_client` tinyint(1) NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_clients_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oauth_clients`
--

LOCK TABLES `oauth_clients` WRITE;
/*!40000 ALTER TABLE `oauth_clients` DISABLE KEYS */;
INSERT INTO `oauth_clients` VALUES (1,NULL,'Nexthour Personal Access Client','Z9kvpHyT5nzRQrGKvLoKxXces8bxDzexeqZVP5sA',NULL,'http://localhost',1,0,0,'2019-12-09 09:59:26','2019-12-09 09:59:26'),(2,NULL,'Nexthour Password Grant Client','C2VrZuB5yr78fKGJcbPMtS4k6U1DAWePGhNu4Uq8',NULL,'http://localhost',0,1,0,'2019-12-09 09:59:27','2019-12-09 09:59:27');
/*!40000 ALTER TABLE `oauth_clients` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oauth_personal_access_clients`
--

DROP TABLE IF EXISTS `oauth_personal_access_clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `oauth_personal_access_clients` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `client_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oauth_personal_access_clients`
--

LOCK TABLES `oauth_personal_access_clients` WRITE;
/*!40000 ALTER TABLE `oauth_personal_access_clients` DISABLE KEYS */;
INSERT INTO `oauth_personal_access_clients` VALUES (1,1,'2019-12-09 09:59:27','2019-12-09 09:59:27');
/*!40000 ALTER TABLE `oauth_personal_access_clients` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oauth_refresh_tokens`
--

DROP TABLE IF EXISTS `oauth_refresh_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `oauth_refresh_tokens` (
  `id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `access_token_id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_refresh_tokens_access_token_id_index` (`access_token_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oauth_refresh_tokens`
--

LOCK TABLES `oauth_refresh_tokens` WRITE;
/*!40000 ALTER TABLE `oauth_refresh_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_refresh_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `package_features`
--

DROP TABLE IF EXISTS `package_features`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `package_features` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `package_features`
--

LOCK TABLES `package_features` WRITE;
/*!40000 ALTER TABLE `package_features` DISABLE KEYS */;
/*!40000 ALTER TABLE `package_features` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `package_menu`
--

DROP TABLE IF EXISTS `package_menu`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `package_menu` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` int NOT NULL,
  `pkg_id` int NOT NULL,
  `package_id` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `package_menu`
--

LOCK TABLES `package_menu` WRITE;
/*!40000 ALTER TABLE `package_menu` DISABLE KEYS */;
/*!40000 ALTER TABLE `package_menu` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `packages`
--

DROP TABLE IF EXISTS `packages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `packages` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `plan_id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `currency` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `currency_symbol` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` decimal(8,2) NOT NULL DEFAULT '0.00',
  `interval` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `interval_count` int DEFAULT NULL,
  `trial_period_days` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `screens` int unsigned NOT NULL DEFAULT '1',
  `download` tinyint(1) NOT NULL DEFAULT '0',
  `downloadlimit` int DEFAULT NULL,
  `delete_status` int NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `free` tinyint(1) NOT NULL DEFAULT '0',
  `feature` longtext COLLATE utf8mb4_unicode_ci,
  `ads_in_web` tinyint(1) NOT NULL DEFAULT '0',
  `ads_in_app` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `packages`
--

LOCK TABLES `packages` WRITE;
/*!40000 ALTER TABLE `packages` DISABLE KEYS */;
/*!40000 ALTER TABLE `packages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password_resets`
--

DROP TABLE IF EXISTS `password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `password_resets` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime DEFAULT NULL,
  KEY `password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password_resets`
--

LOCK TABLES `password_resets` WRITE;
/*!40000 ALTER TABLE `password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_resets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `paypal_subscriptions`
--

DROP TABLE IF EXISTS `paypal_subscriptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `paypal_subscriptions` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned NOT NULL,
  `payment_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `package_id` int DEFAULT NULL,
  `price` double(8,2) NOT NULL,
  `status` tinyint(1) NOT NULL,
  `method` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `subscription_from` datetime DEFAULT NULL,
  `subscription_to` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `paypal_subscriptions`
--

LOCK TABLES `paypal_subscriptions` WRITE;
/*!40000 ALTER TABLE `paypal_subscriptions` DISABLE KEYS */;
/*!40000 ALTER TABLE `paypal_subscriptions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `permissions`
--

DROP TABLE IF EXISTS `permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `permissions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `permissions_name_guard_name_unique` (`name`,`guard_name`)
) ENGINE=InnoDB AUTO_INCREMENT=131 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `permissions`
--

LOCK TABLES `permissions` WRITE;
/*!40000 ALTER TABLE `permissions` DISABLE KEYS */;
INSERT INTO `permissions` VALUES (1,'users.view','web','2021-09-01 12:50:34','2021-09-01 12:50:34'),(2,'users.create','web','2021-09-01 12:50:34','2021-09-01 12:50:34'),(3,'users.edit','web','2021-09-01 12:50:34','2021-09-01 12:50:34'),(4,'users.delete','web','2021-09-01 12:50:34','2021-09-01 12:50:34'),(5,'menu.view','web','2021-09-01 13:08:10','2021-09-01 13:08:10'),(6,'menu.create','web','2021-09-01 13:08:10','2021-09-01 13:08:10'),(7,'menu.edit','web','2021-09-01 13:08:10','2021-09-01 13:08:10'),(8,'menu.delete','web','2021-09-01 13:08:10','2021-09-01 13:08:10'),(9,'movies.view','web','2021-09-02 12:14:20','2021-09-02 12:14:20'),(10,'movies.create','web','2021-09-02 12:14:20','2021-09-02 12:14:20'),(11,'movies.edit','web','2021-09-02 12:14:20','2021-09-02 12:14:20'),(12,'movies.delete','web','2021-09-02 12:14:20','2021-09-02 12:14:20'),(13,'tvseries.view','web','2021-09-02 12:14:28','2021-09-02 12:14:28'),(14,'tvseries.create','web','2021-09-02 12:14:28','2021-09-02 12:14:28'),(15,'tvseries.edit','web','2021-09-02 12:14:28','2021-09-02 12:14:28'),(16,'tvseries.delete','web','2021-09-02 12:14:29','2021-09-02 12:14:29'),(17,'livetv.view','web','2021-09-02 12:14:37','2021-09-02 12:14:37'),(18,'livetv.create','web','2021-09-02 12:14:37','2021-09-02 12:14:37'),(19,'livetv.edit','web','2021-09-02 12:14:37','2021-09-02 12:14:37'),(20,'livetv.delete','web','2021-09-02 12:14:37','2021-09-02 12:14:37'),(21,'liveevent.view','web','2021-09-02 12:14:44','2021-09-02 12:14:44'),(22,'liveevent.create','web','2021-09-02 12:14:44','2021-09-02 12:14:44'),(23,'liveevent.edit','web','2021-09-02 12:14:44','2021-09-02 12:14:44'),(24,'liveevent.delete','web','2021-09-02 12:14:44','2021-09-02 12:14:44'),(25,'audio.view','web','2021-09-02 12:14:55','2021-09-02 12:14:55'),(26,'audio.create','web','2021-09-02 12:14:55','2021-09-02 12:14:55'),(27,'audio.edit','web','2021-09-02 12:14:55','2021-09-02 12:14:55'),(28,'audio.delete','web','2021-09-02 12:14:55','2021-09-02 12:14:55'),(29,'package.view','web','2021-09-02 12:17:22','2021-09-02 12:17:22'),(30,'package.create','web','2021-09-02 12:17:23','2021-09-02 12:17:23'),(31,'package.edit','web','2021-09-02 12:17:23','2021-09-02 12:17:23'),(32,'package.delete','web','2021-09-02 12:17:23','2021-09-02 12:17:23'),(33,'blog.view','web','2021-09-02 12:17:53','2021-09-02 12:17:53'),(34,'blog.create','web','2021-09-02 12:17:53','2021-09-02 12:17:53'),(35,'blog.edit','web','2021-09-02 12:17:53','2021-09-02 12:17:53'),(36,'blog.delete','web','2021-09-02 12:17:54','2021-09-02 12:17:54'),(37,'coupon.view','web','2021-09-02 12:19:58','2021-09-02 12:19:58'),(38,'coupon.create','web','2021-09-02 12:19:58','2021-09-02 12:19:58'),(39,'coupon.edit','web','2021-09-02 12:19:58','2021-09-02 12:19:58'),(40,'coupon.delete','web','2021-09-02 12:19:58','2021-09-02 12:19:58'),(41,'addon-manager.manage','web','2021-09-02 12:40:25','2021-09-02 12:40:25'),(42,'actor.view','web','2021-09-02 16:44:09','2021-09-02 16:44:09'),(43,'actor.create','web','2021-09-02 16:44:09','2021-09-02 16:44:09'),(44,'actor.edit','web','2021-09-02 16:44:10','2021-09-02 16:44:10'),(45,'actor.delete','web','2021-09-02 16:44:10','2021-09-02 16:44:10'),(46,'genre.view','web','2021-09-02 16:44:19','2021-09-02 16:44:19'),(47,'genre.create','web','2021-09-02 16:44:19','2021-09-02 16:44:19'),(48,'genre.edit','web','2021-09-02 16:44:19','2021-09-02 16:44:19'),(49,'genre.delete','web','2021-09-02 16:44:19','2021-09-02 16:44:19'),(50,'director.view','web','2021-09-02 16:44:48','2021-09-02 16:44:48'),(51,'director.create','web','2021-09-02 16:44:48','2021-09-02 16:44:48'),(52,'director.edit','web','2021-09-02 16:44:49','2021-09-02 16:44:49'),(53,'director.delete','web','2021-09-02 16:44:49','2021-09-02 16:44:49'),(54,'label.view','web','2021-09-02 16:45:23','2021-09-02 16:45:23'),(55,'label.create','web','2021-09-02 16:45:23','2021-09-02 16:45:23'),(56,'label.edit','web','2021-09-02 16:45:23','2021-09-02 16:45:23'),(57,'label.delete','web','2021-09-02 16:45:23','2021-09-02 16:45:23'),(58,'audiolanguage.view','web','2021-09-02 17:07:35','2021-09-02 17:07:35'),(59,'audiolanguage.create','web','2021-09-02 17:07:35','2021-09-02 17:07:35'),(60,'audiolanguage.edit','web','2021-09-02 17:07:35','2021-09-02 17:07:35'),(61,'audiolanguage.delete','web','2021-09-02 17:07:36','2021-09-02 17:07:36'),(62,'manual-payment.view','web','2021-09-02 17:49:38','2021-09-02 17:49:38'),(63,'manual-payment.create','web','2021-09-02 17:49:38','2021-09-02 17:49:38'),(64,'manual-payment.edit','web','2021-09-02 17:49:38','2021-09-02 17:49:38'),(65,'manual-payment.delete','web','2021-09-02 17:49:38','2021-09-02 17:49:38'),(66,'pages.view','web','2021-09-02 17:49:51','2021-09-02 17:49:51'),(67,'pages.create','web','2021-09-02 17:49:51','2021-09-02 17:49:51'),(68,'pages.edit','web','2021-09-02 17:49:52','2021-09-02 17:49:52'),(69,'pages.delete','web','2021-09-02 17:49:52','2021-09-02 17:49:52'),(70,'faq.view','web','2021-09-02 17:50:01','2021-09-02 17:50:01'),(71,'faq.create','web','2021-09-02 17:50:01','2021-09-02 17:50:01'),(72,'faq.edit','web','2021-09-02 17:50:01','2021-09-02 17:50:01'),(73,'faq.delete','web','2021-09-02 17:50:02','2021-09-02 17:50:02'),(74,'site-settings.language','web','2021-09-02 17:52:36','2021-09-02 17:52:36'),(75,'pushnotification.settings','web','2021-09-02 17:53:18','2021-09-02 17:53:18'),(76,'front-settings.sliders','web','2021-09-02 17:54:07','2021-09-02 17:54:07'),(77,'reports.viewtraker','web','2021-09-02 17:54:38','2021-09-02 17:54:38'),(78,'site-settings.genral-settings','web','2021-09-02 17:54:54','2021-09-02 17:54:54'),(79,'site-settings.mail-settings','web','2021-09-02 17:55:10','2021-09-02 17:55:10'),(80,'site-settings.social-login-settings','web','2021-09-02 17:55:48','2021-09-02 17:55:48'),(81,'site-settings.style-settings','web','2021-09-02 17:58:12','2021-09-02 17:58:12'),(82,'site-settings.seo','web','2021-09-02 17:58:31','2021-09-02 17:58:31'),(83,'comment-settings.comments','web','2021-09-04 14:33:08','2021-09-04 14:33:08'),(84,'help.db-backup','web','2021-09-04 14:33:42','2021-09-04 14:33:42'),(85,'producer-content.manage','web','2021-09-04 14:34:07','2021-09-04 14:34:07'),(86,'notification.manage','web','2021-09-04 14:34:33','2021-09-04 14:34:33'),(87,'front-settings.landing-page','web','2021-09-04 14:35:38','2021-09-04 14:35:38'),(88,'front-settings.auth-customization','web','2021-09-04 14:36:46','2021-09-04 14:36:46'),(89,'front-settings.short-promo','web','2021-09-04 14:37:17','2021-09-04 14:37:17'),(90,'site-settings.player-setting','web','2021-09-04 14:43:34','2021-09-04 14:43:34'),(91,'site-settings.pwa','web','2021-09-04 14:48:59','2021-09-04 14:48:59'),(92,'comment-settings.subcomments','web','2021-09-04 17:32:14','2021-09-04 17:32:14'),(93,'site-settings.color-option','web','2021-09-04 17:35:06','2021-09-04 17:35:06'),(94,'site-settings.adsense','web','2021-09-04 17:35:25','2021-09-04 17:35:25'),(95,'site-settings.chat-setting','web','2021-09-04 17:35:41','2021-09-04 17:35:41'),(96,'site-settings.api-settings','web','2021-09-04 17:36:05','2021-09-04 17:36:05'),(97,'site-settings.termsandcondition','web','2021-09-04 17:36:44','2021-09-04 17:36:44'),(98,'site-settings.privacy-policy','web','2021-09-04 17:37:07','2021-09-04 17:37:07'),(99,'site-settings.refund-policy','web','2021-09-04 17:37:51','2021-09-04 17:37:51'),(100,'site-settings.copyrights','web','2021-09-04 17:38:12','2021-09-04 17:38:12'),(101,'reports.user-subscription','web','2021-09-04 17:38:33','2021-09-04 17:38:33'),(102,'reports.device-history','web','2021-09-04 17:38:47','2021-09-04 17:38:47'),(103,'reports.revenue','web','2021-09-04 17:39:10','2021-09-04 17:39:10'),(104,'help.system-status','web','2021-09-04 17:40:52','2021-09-04 17:40:52'),(105,'help.remove-public','web','2021-09-04 17:41:10','2021-09-04 17:41:10'),(106,'help.clear-cache','web','2021-09-04 17:41:28','2021-09-04 17:41:28'),(107,'ads.view','web','2021-09-04 17:42:23','2021-09-04 17:42:23'),(108,'ads.create','web','2021-09-04 17:42:23','2021-09-04 17:42:23'),(109,'ads.edit','web','2021-09-04 17:42:24','2021-09-04 17:42:24'),(110,'ads.delete','web','2021-09-04 17:42:24','2021-09-04 17:42:24'),(111,'googleads.view','web','2021-09-04 17:42:34','2021-09-04 17:42:34'),(112,'googleads.create','web','2021-09-04 17:42:34','2021-09-04 17:42:34'),(113,'googleads.edit','web','2021-09-04 17:42:34','2021-09-04 17:42:34'),(114,'googleads.delete','web','2021-09-04 17:42:34','2021-09-04 17:42:34'),(115,'package-feature.view','web','2021-09-04 17:42:48','2021-09-04 17:42:48'),(116,'package-feature.create','web','2021-09-04 17:42:48','2021-09-04 17:42:48'),(117,'package-feature.edit','web','2021-09-04 17:42:48','2021-09-04 17:42:48'),(118,'package-feature.delete','web','2021-09-04 17:42:48','2021-09-04 17:42:48'),(119,'front-settings.social-icon','web','2021-09-06 10:44:57','2021-09-06 10:44:57'),(120,'site-settings.manualpayment','web','2021-09-06 11:01:27','2021-09-06 11:01:27'),(121,'reports.stripe-report','web','2021-09-06 12:28:20','2021-09-06 12:28:20'),(122,'help.import-demo','web','2021-09-22 11:56:05','2021-09-22 11:56:05'),(123,'site-settings.currency','web','2021-09-22 11:56:49','2021-09-22 11:56:49'),(124,'roles.view','web','2021-09-22 12:05:12','2021-09-22 12:05:12'),(125,'roles.create','web','2021-09-22 12:06:30','2021-09-22 12:06:30'),(126,'roles.edit','web','2021-09-22 12:06:30','2021-09-22 12:06:30'),(127,'roles.delete','web','2021-09-22 12:06:30','2021-09-22 12:06:30'),(128,'dashboard.states','web','2021-10-20 14:10:22','2021-10-20 14:10:22'),(129,'app-settings.setting','web','2021-10-21 12:03:43','2021-10-21 12:03:43'),(130,'app-settings.slider','web','2021-10-21 12:03:54','2021-10-21 12:03:54');
/*!40000 ALTER TABLE `permissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `plans`
--

DROP TABLE IF EXISTS `plans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `plans` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `plan` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `mobile` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `stripe_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_brand` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_last_four` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `trial_ends_at` datetime DEFAULT NULL,
  `is_admin` tinyint(1) NOT NULL DEFAULT '0',
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `plans_email_unique` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `plans`
--

LOCK TABLES `plans` WRITE;
/*!40000 ALTER TABLE `plans` DISABLE KEYS */;
/*!40000 ALTER TABLE `plans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `player_settings`
--

DROP TABLE IF EXISTS `player_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `player_settings` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `logo_enable` tinyint(1) DEFAULT NULL,
  `cpy_text` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `share_opt` tinyint(1) DEFAULT NULL,
  `auto_play` tinyint(1) DEFAULT NULL,
  `speed` tinyint(1) DEFAULT NULL,
  `thumbnail` tinyint(1) DEFAULT NULL,
  `info_window` tinyint(1) DEFAULT NULL,
  `skin` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `loop_video` tinyint(1) DEFAULT NULL,
  `is_resume` tinyint(1) DEFAULT '0',
  `player_google_analytics_id` varchar(199) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subtitle_font_size` int DEFAULT NULL,
  `subtitle_color` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `chromecast` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `player_settings`
--

LOCK TABLES `player_settings` WRITE;
/*!40000 ALTER TABLE `player_settings` DISABLE KEYS */;
INSERT INTO `player_settings` VALUES (1,'logo.png',1,'2022 Nxt Level',1,1,1,NULL,1,'minimal_skin_dark',1,1,NULL,20,'#48a3c6',1,NULL,'2022-03-31 16:29:51');
/*!40000 ALTER TABLE `player_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pricing_texts`
--

DROP TABLE IF EXISTS `pricing_texts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pricing_texts` (
  `id` int NOT NULL AUTO_INCREMENT,
  `package_id` int NOT NULL,
  `title1` text COLLATE utf8mb4_unicode_ci,
  `title2` text COLLATE utf8mb4_unicode_ci,
  `title3` text COLLATE utf8mb4_unicode_ci,
  `title4` text COLLATE utf8mb4_unicode_ci,
  `title5` text COLLATE utf8mb4_unicode_ci,
  `title6` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pricing_texts`
--

LOCK TABLES `pricing_texts` WRITE;
/*!40000 ALTER TABLE `pricing_texts` DISABLE KEYS */;
/*!40000 ALTER TABLE `pricing_texts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reminder_mails`
--

DROP TABLE IF EXISTS `reminder_mails`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reminder_mails` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned NOT NULL,
  `subscription_id` int unsigned NOT NULL,
  `today` int DEFAULT NULL,
  `before_7day` int DEFAULT NULL,
  `after_7day` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reminder_mails`
--

LOCK TABLES `reminder_mails` WRITE;
/*!40000 ALTER TABLE `reminder_mails` DISABLE KEYS */;
/*!40000 ALTER TABLE `reminder_mails` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_has_permissions`
--

DROP TABLE IF EXISTS `role_has_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_has_permissions` (
  `permission_id` bigint unsigned NOT NULL,
  `role_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_has_permissions`
--

LOCK TABLES `role_has_permissions` WRITE;
/*!40000 ALTER TABLE `role_has_permissions` DISABLE KEYS */;
INSERT INTO `role_has_permissions` VALUES (1,1),(2,1),(3,1),(4,1),(5,1),(5,2),(6,1),(6,2),(7,1),(7,2),(8,1),(8,2),(9,1),(9,2),(10,1),(10,2),(11,1),(11,2),(12,1),(12,2),(13,1),(13,2),(14,1),(14,2),(15,1),(15,2),(16,1),(16,2),(17,1),(17,2),(18,1),(18,2),(19,1),(19,2),(20,1),(20,2),(21,1),(21,2),(22,1),(22,2),(23,1),(23,2),(24,1),(24,2),(25,1),(25,2),(26,1),(26,2),(27,1),(27,2),(28,1),(28,2),(29,1),(30,1),(31,1),(32,1),(33,1),(33,2),(34,1),(34,2),(35,1),(35,2),(36,1),(36,2),(37,1),(38,1),(39,1),(40,1),(41,1),(42,1),(42,2),(43,1),(43,2),(44,1),(44,2),(45,1),(45,2),(46,1),(46,2),(47,1),(47,2),(48,1),(48,2),(49,1),(49,2),(50,1),(50,2),(51,1),(51,2),(52,1),(52,2),(53,1),(53,2),(54,1),(54,2),(55,1),(55,2),(56,1),(56,2),(57,1),(57,2),(58,1),(58,2),(59,1),(59,2),(60,1),(60,2),(61,1),(61,2),(62,1),(63,1),(64,1),(65,1),(66,1),(67,1),(68,1),(69,1),(70,1),(70,2),(71,1),(71,2),(72,1),(72,2),(73,1),(73,2),(74,1),(75,1),(76,1),(77,1),(78,1),(79,1),(80,1),(81,1),(82,1),(83,1),(84,1),(85,1),(86,1),(87,1),(88,1),(89,1),(90,1),(91,1),(92,1),(93,1),(94,1),(95,1),(96,1),(97,1),(98,1),(99,1),(100,1),(101,1),(102,1),(103,1),(104,1),(105,1),(106,1),(107,1),(108,1),(109,1),(110,1),(111,1),(112,1),(113,1),(114,1),(115,1),(116,1),(117,1),(118,1),(119,1),(120,1),(121,1),(122,1),(123,1),(124,1),(125,1),(126,1),(127,1),(128,1),(129,1),(130,1);
/*!40000 ALTER TABLE `role_has_permissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `roles`
--

DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `roles` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `roles_name_guard_name_unique` (`name`,`guard_name`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `roles`
--

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` VALUES (1,'Super Admin','web','2021-09-01 12:54:28','2021-09-01 12:54:28'),(2,'Producer','web','2021-09-04 14:52:18','2021-09-04 14:52:18'),(3,'User','web',NULL,NULL),(4,'Subscriber','web','2022-03-31 17:59:43','2022-03-31 17:59:43'),(5,'TZARole','web','2022-04-28 14:20:09','2022-04-28 14:20:09');
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `seasons`
--

DROP TABLE IF EXISTS `seasons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `seasons` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `tv_series_id` int unsigned NOT NULL,
  `tmdb_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `season_no` bigint NOT NULL,
  `season_slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tmdb` char(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `publish_year` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `thumbnail` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `poster` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `actor_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `a_language` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `detail` text COLLATE utf8mb4_unicode_ci,
  `featured` tinyint(1) NOT NULL DEFAULT '0',
  `type` char(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'S',
  `is_protect` int NOT NULL DEFAULT '0',
  `password` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `trailer_url` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `seasons_tv_series_id_foreign` (`tv_series_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `seasons`
--

LOCK TABLES `seasons` WRITE;
/*!40000 ALTER TABLE `seasons` DISABLE KEYS */;
/*!40000 ALTER TABLE `seasons` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `seos`
--

DROP TABLE IF EXISTS `seos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `seos` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `author` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fb` text COLLATE utf8mb4_unicode_ci,
  `google` text COLLATE utf8mb4_unicode_ci,
  `metadata` text COLLATE utf8mb4_unicode_ci,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `keyword` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `seos`
--

LOCK TABLES `seos` WRITE;
/*!40000 ALTER TABLE `seos` DISABLE KEYS */;
INSERT INTO `seos` VALUES (1,'{\"en\":\"Next Hour - Movie Tv Show & Video Subscription Portal Cms\"}',NULL,NULL,'{\"en\":\"this ts a next hour\"}','{\"en\":null}','{\"en\":null}',NULL,'2022-04-05 17:15:31');
/*!40000 ALTER TABLE `seos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sessions`
--

DROP TABLE IF EXISTS `sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sessions` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int unsigned DEFAULT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `payload` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_activity` int NOT NULL,
  UNIQUE KEY `sessions_id_unique` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sessions`
--

LOCK TABLES `sessions` WRITE;
/*!40000 ALTER TABLE `sessions` DISABLE KEYS */;
INSERT INTO `sessions` VALUES ('8stzFAN9dqbODTf27oIALRtFWbOTGXEorRmeArO9',NULL,'40.77.167.132','Mozilla/5.0 AppleWebKit/537.36 (KHTML, like Gecko; compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm) Chrome/116.0.1938.76 Safari/537.36','YTo0OntzOjY6Il90b2tlbiI7czo0MDoiNXhVbTdEWWpEcDdMZm5wYk90RlZ1WWxvbXBJZThlN3JJSEZhZ1ZzZiI7czozOiJ1cmwiO2E6MTp7czo4OiJpbnRlbmRlZCI7czo0NzoiaHR0cHM6Ly9jaGVmLm54dHNlcnZlci5jb20vbW92aWUvZGV0YWlsL1Jhd3dhbmkiO31zOjk6Il9wcmV2aW91cyI7YToxOntzOjM6InVybCI7czo0NzoiaHR0cHM6Ly9jaGVmLm54dHNlcnZlci5jb20vbW92aWUvZGV0YWlsL1Jhd3dhbmkiO31zOjY6Il9mbGFzaCI7YToyOntzOjM6Im9sZCI7YTowOnt9czozOiJuZXciO2E6MDp7fX19',1765761604),('CZOaMm0QOWQnezkr7joQtrHYYURFvgJUOK9myDN7',NULL,'175.33.149.122','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:145.0) Gecko/20100101 Firefox/145.0','YTo1OntzOjY6Il90b2tlbiI7czo0MDoiTG4xajlzdWw1cjlvWXpJbnBoQ2lHeW52TklWVnVJbTR6SGV6V3FnMyI7czoxNjoiY2hhbmdlZF9sYW5ndWFnZSI7czoyOiJhciI7czo5OiJfcHJldmlvdXMiO2E6MTp7czozOiJ1cmwiO3M6NDA6Imh0dHBzOi8vY2hlZi5ueHRzZXJ2ZXIuY29tL3phaW5zdWJzY3JpYmUiO31zOjY6Il9mbGFzaCI7YToyOntzOjM6Im9sZCI7YTowOnt9czozOiJuZXciO2E6MDp7fX1zOjM6InVybCI7YToxOntzOjg6ImludGVuZGVkIjtzOjU2OiJodHRwczovL2NoZWYubnh0c2VydmVyLmNvbS9tb3ZpZS9kZXRhaWwvc3RyYXdiZXJyeSUyMGphbSI7fX0=',1765798836),('GdDzyPlR6KQYWlvoW8ntuYePvLNZne03lJBsuJd9',NULL,'52.167.144.24','Mozilla/5.0 AppleWebKit/537.36 (KHTML, like Gecko; compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm) Chrome/116.0.1938.76 Safari/537.36','YTo0OntzOjY6Il90b2tlbiI7czo0MDoiTlB2MzN3Z0h1d3MyN0VmVTgzeEI5Z0pPSkNiRWtzdHE3Y1ZBRW5DbyI7czozOiJ1cmwiO2E6MTp7czo4OiJpbnRlbmRlZCI7czo2NzoiaHR0cHM6Ly9jaGVmLm54dHNlcnZlci5jb20vbW92aWUvZGV0YWlsL0NyZWFtJTIwb2YlMjBjaGlja2VuJTIwc291cCI7fXM6OToiX3ByZXZpb3VzIjthOjE6e3M6MzoidXJsIjtzOjQwOiJodHRwczovL2NoZWYubnh0c2VydmVyLmNvbS96YWluc3Vic2NyaWJlIjt9czo2OiJfZmxhc2giO2E6Mjp7czozOiJvbGQiO2E6MDp7fXM6MzoibmV3IjthOjA6e319fQ==',1765752597),('JIw9VrgYhWMC5nQP5yMrDZCIsLNdd999YODnr3nJ',NULL,'52.167.144.190','Mozilla/5.0 AppleWebKit/537.36 (KHTML, like Gecko; compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm) Chrome/116.0.1938.76 Safari/537.36','YTo0OntzOjY6Il90b2tlbiI7czo0MDoibXREMTZCSmZLRTZjNEZtaGl4VmJIcU54ZnpxajhBaG84VE5KcDNWNyI7czoxNjoiY2hhbmdlZF9sYW5ndWFnZSI7czoyOiJhciI7czo5OiJfcHJldmlvdXMiO2E6MTp7czozOiJ1cmwiO3M6NDA6Imh0dHBzOi8vY2hlZi5ueHRzZXJ2ZXIuY29tL3phaW5zdWJzY3JpYmUiO31zOjY6Il9mbGFzaCI7YToyOntzOjM6Im9sZCI7YTowOnt9czozOiJuZXciO2E6MDp7fX19',1765759996),('kC3pgtIX98F88B1Wz9GPoGeMc9aWOOmjwMuCsWM1',NULL,'40.77.167.132','Mozilla/5.0 AppleWebKit/537.36 (KHTML, like Gecko; compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm) Chrome/116.0.1938.76 Safari/537.36','YTozOntzOjY6Il90b2tlbiI7czo0MDoiZGRzUHl1WjNXQUoyR2QwRUs5cTRpRXVDNGllcGl3Y0RYRE9tVFVJMyI7czo5OiJfcHJldmlvdXMiO2E6MTp7czozOiJ1cmwiO3M6NDA6Imh0dHBzOi8vY2hlZi5ueHRzZXJ2ZXIuY29tL3phaW5zdWJzY3JpYmUiO31zOjY6Il9mbGFzaCI7YToyOntzOjM6Im9sZCI7YTowOnt9czozOiJuZXciO2E6MDp7fX19',1765761624),('l1qsDXgST1onXuD9xjiu0PkQOxcm3C9iCJFF2YNC',NULL,'204.76.203.25','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.3','YTo0OntzOjY6Il90b2tlbiI7czo0MDoiTzV5MzI1blpYcHR5QTBZS25HYUlUNTRDNUQxQk1rNjdsZzNVN2NSVSI7czoxNjoiY2hhbmdlZF9sYW5ndWFnZSI7czoyOiJhciI7czo5OiJfcHJldmlvdXMiO2E6MTp7czozOiJ1cmwiO3M6Mzg6Imh0dHBzOi8vY2hlZi5ueHRzZXJ2ZXIuY29tL2d1ZXN0L29zZmF0Ijt9czo2OiJfZmxhc2giO2E6Mjp7czozOiJvbGQiO2E6MDp7fXM6MzoibmV3IjthOjA6e319fQ==',1765772046),('mS7Nb1qAOsLymN6ffv8s31zlySkzSS1yzn7aG8PA',NULL,'157.55.39.195','Mozilla/5.0 AppleWebKit/537.36 (KHTML, like Gecko; compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm) Chrome/116.0.1938.76 Safari/537.36','YTo0OntzOjY6Il90b2tlbiI7czo0MDoiZTAwN253ekZORUlIV1FkNW05VzQ2MDRHQnRtVjR5UXFrUXVQdWlnSyI7czoxNjoiY2hhbmdlZF9sYW5ndWFnZSI7czoyOiJhciI7czo5OiJfcHJldmlvdXMiO2E6MTp7czozOiJ1cmwiO3M6NDA6Imh0dHBzOi8vY2hlZi5ueHRzZXJ2ZXIuY29tL3phaW5zdWJzY3JpYmUiO31zOjY6Il9mbGFzaCI7YToyOntzOjM6Im9sZCI7YTowOnt9czozOiJuZXciO2E6MDp7fX19',1765756975),('rKRRav5Uet4nUxyD1s1qY2eqaExzb4MpoGavj4Pa',NULL,'40.77.167.136','Mozilla/5.0 AppleWebKit/537.36 (KHTML, like Gecko; compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm) Chrome/116.0.1938.76 Safari/537.36','YTo0OntzOjY6Il90b2tlbiI7czo0MDoiU0ZjbVZPS25OYWFOTmdqQ3hMT0g4OGxTc25qNlhZZG5BV1Z2VjVqQyI7czoxNjoiY2hhbmdlZF9sYW5ndWFnZSI7czoyOiJhciI7czo5OiJfcHJldmlvdXMiO2E6MTp7czozOiJ1cmwiO3M6NDA6Imh0dHBzOi8vY2hlZi5ueHRzZXJ2ZXIuY29tL3phaW5zdWJzY3JpYmUiO31zOjY6Il9mbGFzaCI7YToyOntzOjM6Im9sZCI7YTowOnt9czozOiJuZXciO2E6MDp7fX19',1765752179),('sfdCa5RS1AwyyRTrCnwjVy1L04FN38Ust5X0pRgi',NULL,'204.76.203.25','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.3','YTo0OntzOjY6Il90b2tlbiI7czo0MDoiWG1BWnVJVnJOUDNjeWlBME93dk0yT3RTZmRDNEszU0pCWjdmR3JSWiI7czoxNjoiY2hhbmdlZF9sYW5ndWFnZSI7czoyOiJhciI7czo5OiJfcHJldmlvdXMiO2E6MTp7czozOiJ1cmwiO3M6MjY6Imh0dHBzOi8vY2hlZi5ueHRzZXJ2ZXIuY29tIjt9czo2OiJfZmxhc2giO2E6Mjp7czozOiJvbGQiO2E6MDp7fXM6MzoibmV3IjthOjA6e319fQ==',1765772046),('XiNSmnDfTDyjtY4c9ETugGsEvau4MHQ0MKEg1CON',NULL,'157.55.39.200','Mozilla/5.0 AppleWebKit/537.36 (KHTML, like Gecko; compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm) Chrome/116.0.1938.76 Safari/537.36','YTo0OntzOjY6Il90b2tlbiI7czo0MDoibWtwMTFEWmtaQmR3YkQ4Yll3dTltS2RLVGdXWDFVMFFTbkhuMk1DeCI7czoxNjoiY2hhbmdlZF9sYW5ndWFnZSI7czoyOiJhciI7czo5OiJfcHJldmlvdXMiO2E6MTp7czozOiJ1cmwiO3M6NDA6Imh0dHBzOi8vY2hlZi5ueHRzZXJ2ZXIuY29tL3phaW5zdWJzY3JpYmUiO31zOjY6Il9mbGFzaCI7YToyOntzOjM6Im9sZCI7YTowOnt9czozOiJuZXciO2E6MDp7fX19',1765766101),('ySmEQNVE2UvGnvv0kdgdRYzlYQ8H0frzs5YyN2a3',NULL,'154.182.130.204','Mozilla/5.0 (iPhone; CPU iPhone OS 18_7 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/26.1 Mobile/15E148 Safari/604.1','YTo0OntzOjY6Il90b2tlbiI7czo0MDoiRnJsU1h1ZndjUTJ4VFJKWTlCV1pvcE5Qb1FTQlY4eW9kQzBnZU1ybyI7czoxNjoiY2hhbmdlZF9sYW5ndWFnZSI7czoyOiJhciI7czo5OiJfcHJldmlvdXMiO2E6MTp7czozOiJ1cmwiO3M6Mzg6Imh0dHBzOi8vY2hlZi5ueHRzZXJ2ZXIuY29tL2d1ZXN0L29zZmF0Ijt9czo2OiJfZmxhc2giO2E6Mjp7czozOiJvbGQiO2E6MDp7fXM6MzoibmV3IjthOjA6e319fQ==',1765754829);
/*!40000 ALTER TABLE `sessions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `social_icons`
--

DROP TABLE IF EXISTS `social_icons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `social_icons` (
  `id` int NOT NULL AUTO_INCREMENT,
  `url1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `social_icons`
--

LOCK TABLES `social_icons` WRITE;
/*!40000 ALTER TABLE `social_icons` DISABLE KEYS */;
INSERT INTO `social_icons` VALUES (1,'#','#','#','2020-11-02 09:09:08','2020-11-02 09:10:18');
/*!40000 ALTER TABLE `social_icons` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `splash_screens`
--

DROP TABLE IF EXISTS `splash_screens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `splash_screens` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `logo_enable` tinyint(1) NOT NULL DEFAULT '1',
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `splash_screens`
--

LOCK TABLES `splash_screens` WRITE;
/*!40000 ALTER TABLE `splash_screens` DISABLE KEYS */;
/*!40000 ALTER TABLE `splash_screens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `subcomments`
--

DROP TABLE IF EXISTS `subcomments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `subcomments` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `blog_id` int NOT NULL,
  `comment_id` int NOT NULL,
  `reply` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `subcomments`
--

LOCK TABLES `subcomments` WRITE;
/*!40000 ALTER TABLE `subcomments` DISABLE KEYS */;
/*!40000 ALTER TABLE `subcomments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `subscription_items`
--

DROP TABLE IF EXISTS `subscription_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `subscription_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `subscription_id` bigint unsigned NOT NULL,
  `stripe_id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `stripe_plan` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `quantity` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `subscription_items_subscription_id_stripe_plan_unique` (`subscription_id`,`stripe_plan`),
  KEY `subscription_items_stripe_id_index` (`stripe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `subscription_items`
--

LOCK TABLES `subscription_items` WRITE;
/*!40000 ALTER TABLE `subscription_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `subscription_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `subscriptions`
--

DROP TABLE IF EXISTS `subscriptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `subscriptions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `stripe_id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `stripe_status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `stripe_plan` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `quantity` int DEFAULT NULL,
  `trial_ends_at` timestamp NULL DEFAULT NULL,
  `ends_at` timestamp NULL DEFAULT NULL,
  `subscription_from` timestamp NULL DEFAULT NULL,
  `subscription_to` timestamp NULL DEFAULT NULL,
  `amount` double DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `subscriptions`
--

LOCK TABLES `subscriptions` WRITE;
/*!40000 ALTER TABLE `subscriptions` DISABLE KEYS */;
/*!40000 ALTER TABLE `subscriptions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `subtitles`
--

DROP TABLE IF EXISTS `subtitles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `subtitles` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `sub_lang` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_t` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `m_t_id` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ep_id` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `subtitles`
--

LOCK TABLES `subtitles` WRITE;
/*!40000 ALTER TABLE `subtitles` DISABLE KEYS */;
/*!40000 ALTER TABLE `subtitles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transactions`
--

DROP TABLE IF EXISTS `transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `transactions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `amount1` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount2` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `currency1` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `currency2` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fee` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dest_tag` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `buyer_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `buyer_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `item_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `item_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom` text COLLATE utf8mb4_unicode_ci,
  `ipn_url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `txn_id` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `confirms_needed` tinyint unsigned NOT NULL,
  `timeout` int unsigned NOT NULL,
  `status_url` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `qrcode_url` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `status` smallint DEFAULT NULL,
  `status_text` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `received_confirms` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `received_amount` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `transactions_txn_id_unique` (`txn_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transactions`
--

LOCK TABLES `transactions` WRITE;
/*!40000 ALTER TABLE `transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transfers`
--

DROP TABLE IF EXISTS `transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `transfers` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `amount` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `currency` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `merchant` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pbntag` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `auto_confirm` tinyint(1) NOT NULL DEFAULT '0',
  `ref_id` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` smallint NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `transfers_ref_id_unique` (`ref_id`),
  KEY `transfers_status_index` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transfers`
--

LOCK TABLES `transfers` WRITE;
/*!40000 ALTER TABLE `transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `translations`
--

DROP TABLE IF EXISTS `translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `translations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `language_id` int unsigned NOT NULL,
  `group` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `key` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `translations`
--

LOCK TABLES `translations` WRITE;
/*!40000 ALTER TABLE `translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tv_series`
--

DROP TABLE IF EXISTS `tv_series`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tv_series` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `keyword` text COLLATE utf8mb4_unicode_ci,
  `description` text COLLATE utf8mb4_unicode_ci,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tmdb_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tmdb` char(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fetch_by` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `thumbnail` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `poster` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `genre_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `detail` text COLLATE utf8mb4_unicode_ci,
  `rating` double(8,2) DEFAULT NULL,
  `episode_runtime` double(8,2) DEFAULT NULL,
  `maturity_rating` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `featured` tinyint(1) NOT NULL DEFAULT '0',
  `type` char(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'T',
  `status` int unsigned NOT NULL DEFAULT '1',
  `created_by` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `is_custom_label` tinyint(1) NOT NULL DEFAULT '0',
  `label_id` int DEFAULT NULL,
  `is_upcoming` tinyint(1) NOT NULL DEFAULT '0',
  `upcoming_date` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tv_series`
--

LOCK TABLES `tv_series` WRITE;
/*!40000 ALTER TABLE `tv_series` DISABLE KEYS */;
/*!40000 ALTER TABLE `tv_series` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_ratings`
--

DROP TABLE IF EXISTS `user_ratings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_ratings` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int DEFAULT NULL,
  `tv_id` int DEFAULT NULL,
  `movie_id` int DEFAULT NULL,
  `rating` double DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_ratings`
--

LOCK TABLES `user_ratings` WRITE;
/*!40000 ALTER TABLE `user_ratings` DISABLE KEYS */;
INSERT INTO `user_ratings` VALUES (2,1,NULL,81,NULL,'2022-04-09 17:58:20','2022-04-09 17:58:20');
/*!40000 ALTER TABLE `user_ratings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_views`
--

DROP TABLE IF EXISTS `user_views`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_views` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `viewable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `viewable_id` int unsigned NOT NULL,
  `visitor` int unsigned NOT NULL,
  `collection` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `viewed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `views_viewable_type_viewable_id_index` (`viewable_type`,`viewable_id`)
) ENGINE=InnoDB AUTO_INCREMENT=54 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_views`
--

LOCK TABLES `user_views` WRITE;
/*!40000 ALTER TABLE `user_views` DISABLE KEYS */;
INSERT INTO `user_views` VALUES (4,'App\\Movie',1,1,NULL,'2025-09-23 02:13:56'),(5,'App\\Movie',2,1,NULL,'2025-09-23 02:18:15'),(6,'App\\Movie',3,1,NULL,'2025-09-23 15:07:02'),(7,'App\\Movie',4,1,NULL,'2025-09-23 15:20:31'),(8,'App\\Movie',6,1,NULL,'2025-09-23 15:49:46'),(9,'App\\Movie',7,1,NULL,'2025-09-23 16:45:21'),(10,'App\\Movie',9,1,NULL,'2025-09-23 16:56:43'),(11,'App\\Movie',10,1,NULL,'2025-09-23 17:00:20'),(12,'App\\Movie',11,1,NULL,'2025-09-23 17:04:01'),(13,'App\\Movie',12,1,NULL,'2025-09-23 17:07:14'),(14,'App\\Movie',14,1,NULL,'2025-09-23 17:17:13'),(15,'App\\Movie',15,1,NULL,'2025-09-23 17:28:54'),(16,'App\\Movie',16,1,NULL,'2025-09-23 17:47:34'),(17,'App\\Movie',18,1,NULL,'2025-09-23 18:00:28'),(18,'App\\Movie',19,1,NULL,'2025-09-23 18:38:13'),(19,'App\\Movie',20,1,NULL,'2025-09-23 19:07:51'),(20,'App\\Movie',21,1,NULL,'2025-09-23 19:15:49'),(21,'App\\Movie',24,1,NULL,'2025-09-23 23:31:30'),(22,'App\\Movie',23,1,NULL,'2025-09-23 23:31:47'),(23,'App\\Movie',25,1,NULL,'2025-09-23 23:31:58'),(24,'App\\Movie',26,1,NULL,'2025-09-23 23:38:43'),(25,'App\\Movie',28,1,NULL,'2025-09-23 23:44:16'),(26,'App\\Movie',42,1,NULL,'2025-09-27 18:16:37'),(27,'App\\Movie',62,1,NULL,'2025-09-28 14:50:15'),(28,'App\\Movie',44,1,NULL,'2025-10-01 22:10:24'),(29,'App\\Movie',40,1,NULL,'2025-10-01 22:11:26'),(30,'App\\Movie',43,1,NULL,'2025-10-01 22:37:22'),(31,'App\\Movie',16,1,NULL,'2025-10-01 23:26:14'),(32,'App\\Movie',4,1,NULL,'2025-10-01 23:29:35'),(33,'App\\Movie',44,1,NULL,'2025-10-01 23:29:49'),(34,'App\\Movie',2,1,NULL,'2025-10-01 23:30:06'),(35,'App\\Movie',4,1,NULL,'2025-10-01 23:31:14'),(36,'App\\Movie',4,1,NULL,'2025-10-01 23:34:16'),(37,'App\\Movie',4,1,NULL,'2025-10-01 23:36:47'),(38,'App\\Movie',5,1,NULL,'2025-10-01 23:37:29'),(39,'App\\Movie',2,1,NULL,'2025-10-01 23:37:34'),(40,'App\\Movie',4,1,NULL,'2025-10-02 22:13:33'),(41,'App\\Movie',52,1,NULL,'2025-10-03 02:17:25'),(42,'App\\Movie',5,1,NULL,'2025-10-05 19:55:43'),(43,'App\\Movie',48,1,NULL,'2025-10-06 12:53:15'),(44,'App\\Movie',4,1,NULL,'2025-10-06 12:54:04'),(45,'App\\Movie',43,1,NULL,'2025-10-06 12:54:33'),(46,'App\\Movie',59,1,NULL,'2025-10-06 12:54:58'),(47,'App\\Movie',52,1,NULL,'2025-10-06 12:55:32'),(48,'App\\Movie',57,1,NULL,'2025-10-06 12:59:00'),(49,'App\\Movie',57,1,NULL,'2025-10-06 13:09:21'),(50,'App\\Movie',56,1,NULL,'2025-10-06 13:09:44'),(51,'App\\Movie',49,1,NULL,'2025-10-11 21:51:03'),(52,'App\\Movie',64,1,NULL,'2025-12-13 21:40:23'),(53,'App\\Movie',64,1,NULL,'2025-12-13 21:40:31');
/*!40000 ALTER TABLE `user_views` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `users` (
  `id` int unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `verifyToken` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(1) NOT NULL,
  `password` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `google_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `facebook_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `gitlab_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `age` int DEFAULT '0',
  `mobile` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `braintree_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_admin` tinyint(1) NOT NULL DEFAULT '0',
  `is_assistant` int unsigned NOT NULL DEFAULT '0',
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_blocked` tinyint(1) DEFAULT '0',
  `amazon_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `stripe_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_brand` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_last_four` varchar(4) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `trial_ends_at` timestamp NULL DEFAULT NULL,
  `google2fa_secret` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `google2fa_enable` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users`
--

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES (1,'Admin',NULL,'admin@mediacity.co.in',NULL,1,'$2y$10$NCiYPHZ0wughu1cgWJU98e65QoVjnWz598Uj6T8ez5H3e3Vz6YSDO',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,1,0,'DQa5TDIU7YXUHMeGNYwlNnp9zBnQUOt3Lf2oNN0LjPAKPY3C1Jy6XsBCWWye',0,NULL,'2020-11-02 14:15:56','2020-11-02 14:15:56',NULL,NULL,NULL,NULL,NULL,0),(2,'900986589',NULL,'900986589@nxtlevel.com','aOZE8a3Lpu9HDJm7LYwPI5N80CJzSqOXVpIAVlNP',0,'$2y$10$OQOIBSp2ITF5RVti/C75ke.ca9hJroWgyLVjrmxQLPBctGAJQOtQa',NULL,NULL,NULL,NULL,0,'900986589',NULL,NULL,1,0,NULL,0,NULL,'2022-07-24 17:05:09','2023-03-16 18:42:45',NULL,NULL,NULL,NULL,NULL,0),(3,'969188996',NULL,'969188996@nxtlevel.com','FEVs5CQdtILBRdwJymqiYjBmffBGZuqzvNk2aEIe',1,'$2y$10$Kd3.rlplztC/W18KOAPbrO572/1XaNyGYcb2QADEqMtbcWbZZf9vO',NULL,NULL,NULL,NULL,0,'969188996',NULL,NULL,1,0,NULL,0,NULL,'2022-08-03 15:15:13','2022-08-03 15:15:13',NULL,NULL,NULL,NULL,NULL,0),(4,'960788041',NULL,'960788041@nxtlevel.com','UmuyqnfPz8dagGUGtBAlAZVhT9npXDokyM45omay',0,'$2y$10$6LXmN5lZbnL7huC8nPbeGOd98J7PEo3eGMebtVp.Rd0pdgdbNNWvC',NULL,NULL,NULL,NULL,0,'960788041',NULL,NULL,1,0,NULL,0,NULL,'2022-08-10 18:08:33','2022-09-20 17:00:08',NULL,NULL,NULL,NULL,NULL,0),(5,'964724768',NULL,'964724768@nxtlevel.com','pNuaViBAN3b74Upvc607uIsAFB2e5jLKDNY6zvop',1,'$2y$10$VZd3gpsn2kQV7m7JHaUhzuh3q04EYUTA9n92uQ/.cpuFuGRea99Qi',NULL,NULL,NULL,NULL,0,'964724768',NULL,NULL,1,0,NULL,0,NULL,'2022-08-23 17:56:59','2022-09-25 17:06:30',NULL,NULL,NULL,NULL,NULL,0),(6,'916292771',NULL,'916292771@nxtlevel.com','YYtIB1eTwrO9wMu6Wbl4RuaEaiNArsyyBFjcjPm1',0,'$2y$10$88NK7xVrP0zVDkXaxgcqn.BnJ23XBV5czZG03feekPydVVE1Kh1OK',NULL,NULL,NULL,NULL,0,'916292771',NULL,NULL,1,0,NULL,0,NULL,'2022-09-08 18:49:01','2023-03-28 16:34:12',NULL,NULL,NULL,NULL,NULL,0),(7,'912398276',NULL,'912398276@nxtlevel.com','HmMm0rO2A6NjcoT4ZdKkQVxdKQYrDKL7uU9N3uK2',0,'$2y$10$zTDqpKudBHFx/dYGdX9E9uQmMUicCrHAGxuig2L95WGs3PoX0heFe',NULL,NULL,NULL,NULL,0,'912398276',NULL,NULL,1,0,NULL,0,NULL,'2022-10-24 17:33:12','2022-11-28 17:37:34',NULL,NULL,NULL,NULL,NULL,0),(8,'905018333',NULL,'905018333@nxtlevel.com','9t864uKSRSTOBOkMmbkje0yAJ1wcdqmHBFiWXJHy',1,'$2y$10$.beREOVLB6fnoGCC50AhH.0qDyDVVJOlqK1ghXjYN/Qe9UM88c2LW',NULL,NULL,NULL,NULL,0,'905018333',NULL,NULL,1,0,NULL,0,NULL,'2023-01-25 15:24:46','2023-01-25 15:24:46',NULL,NULL,NULL,NULL,NULL,0),(9,'966806612',NULL,'966806612@nxtlevel.com','m1TEsVV1zsmh7I3OHcGK1ZXHERVJzsYclH98d1Ab',1,'$2y$10$r9gMvR9u.R/wxobZSmRDy.U8x85BMFO6DxAZZJLlSpj7PyVg.RLxK',NULL,NULL,NULL,NULL,0,'966806612',NULL,NULL,1,0,NULL,0,NULL,'2023-01-25 16:14:30','2023-02-27 15:53:51',NULL,NULL,NULL,NULL,NULL,0),(10,'967390565',NULL,'967390565@nxtlevel.com','1bi9kjEa0TWvxMDaZQgJceWi4yfCyWOB8bBb2Xz4',0,'$2y$10$DNJmmS6JMsfGN8DFQgQu6.uXAyXUaSUl/7NFb0nkJao0rNQoEQOtu',NULL,NULL,NULL,NULL,0,'967390565',NULL,NULL,1,0,NULL,0,NULL,'2023-02-22 13:26:28','2023-02-22 13:29:54',NULL,NULL,NULL,NULL,NULL,0),(11,'963251717',NULL,'963251717@nxtlevel.com','EkNNxNJmJVnX9U6RWEKDwfcJ3w79PQqDMPzbEDHv',0,'$2y$10$bHbfwrNXbSVrvsyAPC5u5.JFT6I99nymKBOrrs1bmIaVNIoDARWj.',NULL,NULL,NULL,NULL,0,'963251717',NULL,NULL,1,0,NULL,0,NULL,'2023-03-28 17:01:23','2023-03-28 17:03:37',NULL,NULL,NULL,NULL,NULL,0),(12,'912249335',NULL,'912249335@nxtlevel.com','PG9ZvnFBS2wGye3jRsrjkFChywDHMdiv1wKQTVlJ',0,'$2y$10$OPQEfJeESk.a0FP97WoGue2cAkgXsZzdU3aNBrBQ/amiG9OgSDRLW',NULL,NULL,NULL,NULL,0,'912249335',NULL,NULL,1,0,NULL,0,NULL,'2023-03-28 17:14:30','2023-03-28 17:26:11',NULL,NULL,NULL,NULL,NULL,0);
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `videolinks`
--

DROP TABLE IF EXISTS `videolinks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `videolinks` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `movie_id` int unsigned DEFAULT NULL,
  `episode_id` int unsigned DEFAULT NULL,
  `type` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `iframeurl` text COLLATE utf8mb4_unicode_ci,
  `ready_url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url_360` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url_480` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url_720` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url_1080` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `upload_video` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `videolinks_movie_id_foreign` (`movie_id`),
  KEY `videolinks_episode_id_foreign` (`episode_id`)
) ENGINE=InnoDB AUTO_INCREMENT=66 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `videolinks`
--

LOCK TABLES `videolinks` WRITE;
/*!40000 ALTER TABLE `videolinks` DISABLE KEYS */;
INSERT INTO `videolinks` VALUES (1,1,NULL,'iframeurl','https://player.vimeo.com/video/690169899?h=e563e3cc5f&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-23 02:13:15','2025-09-23 02:13:15',NULL),(2,2,NULL,'iframeurl','https://player.vimeo.com/video/690166660?h=557d460f8d&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-23 02:17:50','2025-09-23 02:17:50',NULL),(3,3,NULL,'iframeurl','https://player.vimeo.com/video/690166218?h=1978721f05&amp;badge=0&',NULL,NULL,NULL,NULL,NULL,'2025-09-23 15:06:49','2025-09-23 15:06:49',NULL),(4,4,NULL,'iframeurl','https://player.vimeo.com/video/690166538?h=6818b3d214&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-23 15:20:18','2025-09-23 15:20:18',NULL),(5,5,NULL,'iframeurl','https://player.vimeo.com/video/690168626?h=6d63642aa8&amp;badge=0&',NULL,NULL,NULL,NULL,NULL,'2025-09-23 15:31:16','2025-09-23 15:31:16',NULL),(6,6,NULL,'iframeurl','https://player.vimeo.com/video/690168347?h=23721a852b&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-23 15:32:56','2025-09-23 15:32:56',NULL),(7,7,NULL,'iframeurl','https://player.vimeo.com/video/690167962?h=e057ddb09e&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-23 16:44:36','2025-09-23 16:44:36',NULL),(8,8,NULL,'iframeurl','https://player.vimeo.com/video/690167073?h=598ac149f0&amp;badge=0&',NULL,NULL,NULL,NULL,NULL,'2025-09-23 16:47:56','2025-09-23 16:47:56',NULL),(9,9,NULL,'iframeurl','https://player.vimeo.com/video/690166765?h=3933d8e42f&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-23 16:56:35','2025-09-23 16:56:35',NULL),(10,10,NULL,'iframeurl','https://player.vimeo.com/video/690168922?h=afd94fa038&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-23 17:00:03','2025-09-23 17:00:03',NULL),(11,11,NULL,'iframeurl','https://player.vimeo.com/video/690175944?h=d762bb0d77&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-23 17:03:53','2025-09-23 17:03:53',NULL),(12,12,NULL,'iframeurl','https://player.vimeo.com/video/690175824?h=dfcebade1a&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-23 17:06:17','2025-09-23 17:06:17',NULL),(13,13,NULL,'iframeurl','https://player.vimeo.com/video/690175875?h=8fddcca9ac&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-23 17:10:09','2025-09-23 17:10:09',NULL),(14,14,NULL,'iframeurl','https://player.vimeo.com/video/690174403?h=11076befe5&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-23 17:17:01','2025-09-23 17:17:01',NULL),(15,15,NULL,'iframeurl','https://player.vimeo.com/video/690175706?h=53abafe570&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-23 17:27:27','2025-09-23 17:27:27',NULL),(16,16,NULL,'iframeurl','https://player.vimeo.com/video/690167556?h=158b85beab&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-23 17:47:21','2025-09-23 17:47:21',NULL),(17,17,NULL,'iframeurl','https://player.vimeo.com/video/788648715?h=f89c3e6e57&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-23 17:53:41','2025-09-23 17:53:41',NULL),(18,18,NULL,'iframeurl','https://player.vimeo.com/video/752442985?h=6b2d31e68b&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-23 17:58:48','2025-09-23 17:58:48',NULL),(19,19,NULL,'iframeurl','https://player.vimeo.com/video/788647914?h=8b42dc7f19&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-23 18:37:35','2025-09-23 18:37:35',NULL),(20,20,NULL,'iframeurl','https://player.vimeo.com/video/690175749?h=8efd9c17e5&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-23 19:04:40','2025-09-23 19:04:40',NULL),(21,21,NULL,'iframeurl','https://player.vimeo.com/video/1121180014?h=45428d3456&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-23 19:15:38','2025-09-23 19:15:38',NULL),(22,22,NULL,'iframeurl','https://player.vimeo.com/video/1051553561?h=679778645f&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-23 19:17:49','2025-09-23 19:17:49',NULL),(23,23,NULL,'iframeurl','https://player.vimeo.com/video/752440352?h=3e221e87a7&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-23 19:50:04','2025-09-23 19:50:04',NULL),(24,24,NULL,'iframeurl','https://player.vimeo.com/video/788646705?h=5ef1b0af6b&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-23 23:28:47','2025-09-23 23:28:47',NULL),(25,25,NULL,'iframeurl','https://player.vimeo.com/video/788646996?h=09da57db77&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-23 23:31:19','2025-09-23 23:31:19',NULL),(26,26,NULL,'iframeurl','https://player.vimeo.com/video/788646614?h=78522cfb45&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-23 23:38:15','2025-09-23 23:38:15',NULL),(27,27,NULL,'iframeurl','https://player.vimeo.com/video/690173574?h=5eef6e16c0&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-23 23:40:53','2025-09-23 23:40:53',NULL),(28,28,NULL,'iframeurl','https://player.vimeo.com/video/1074950268?h=68ebec11b1&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-23 23:44:05','2025-09-23 23:44:05',NULL),(29,29,NULL,'iframeurl','https://player.vimeo.com/video/1074958786?h=a254195fef&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-23 23:46:24','2025-09-23 23:46:24',NULL),(30,30,NULL,'iframeurl','https://player.vimeo.com/video/752084982?h=3508e98e61&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-24 01:23:44','2025-09-24 01:23:44',NULL),(31,31,NULL,'iframeurl','https://player.vimeo.com/video/788640451?h=0889aec656&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-24 01:27:08','2025-09-24 01:27:08',NULL),(32,32,NULL,'iframeurl','https://player.vimeo.com/video/1117080654?h=ceb631e564&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-24 01:29:41','2025-09-24 01:29:41',NULL),(33,33,NULL,'iframeurl','https://player.vimeo.com/video/788637304?h=08fc4af07a&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-24 01:31:30','2025-09-24 01:31:30',NULL),(34,34,NULL,'iframeurl','https://player.vimeo.com/video/690182201?h=0e5b306958&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-24 01:33:57','2025-09-24 01:33:57',NULL),(35,35,NULL,'iframeurl','https://player.vimeo.com/video/788638679?h=5597e4c073&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-24 01:36:24','2025-09-24 01:36:24',NULL),(36,36,NULL,'iframeurl','https://player.vimeo.com/video/788639168?h=7ad7ee015a&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-24 01:40:07','2025-09-24 01:40:07',NULL),(37,37,NULL,'iframeurl','https://player.vimeo.com/video/788638412?h=698ca988d1&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-24 01:47:27','2025-09-24 01:47:27',NULL),(38,38,NULL,'iframeurl','https://player.vimeo.com/video/788638885?h=55919565ef&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-24 02:37:46','2025-09-24 02:37:46',NULL),(39,39,NULL,'iframeurl',NULL,NULL,NULL,NULL,NULL,NULL,'2025-09-24 02:39:14','2025-09-24 02:39:14',NULL),(40,40,NULL,'iframeurl','https://player.vimeo.com/video/690190074?h=311318fb01&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-24 03:04:53','2025-09-24 03:04:53',NULL),(41,41,NULL,'iframeurl','https://player.vimeo.com/video/690200495?h=7a0242377d&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-24 03:06:47','2025-09-24 03:06:47',NULL),(42,42,NULL,'iframeurl','https://player.vimeo.com/video/752437326?h=1119ab8bf1&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-24 03:12:11','2025-09-24 03:12:11',NULL),(43,43,NULL,'iframeurl','https://player.vimeo.com/video/752454432?h=582852685f&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-24 03:14:58','2025-09-24 03:14:58',NULL),(44,44,NULL,'iframeurl','https://player.vimeo.com/video/752456120?h=31bbd010cd&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-24 03:17:00','2025-09-24 03:17:00',NULL),(45,45,NULL,'iframeurl','https://player.vimeo.com/video/752517404?h=48ec5249e9&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-24 03:19:18','2025-09-24 03:19:18',NULL),(46,46,NULL,'iframeurl','https://player.vimeo.com/video/788644072?h=33cc083dde&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-24 03:22:31','2025-09-24 03:22:31',NULL),(47,47,NULL,'iframeurl','https://player.vimeo.com/video/788644012?h=e781208c51&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-24 03:24:24','2025-09-24 03:24:24',NULL),(48,48,NULL,'iframeurl','https://player.vimeo.com/video/690190987?h=1e3b22160c&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-24 03:28:49','2025-09-24 03:28:49',NULL),(49,49,NULL,'iframeurl','https://player.vimeo.com/video/690190337?h=0665913ee2&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-24 03:31:49','2025-09-24 03:31:49',NULL),(50,50,NULL,'iframeurl','https://player.vimeo.com/video/690190477?h=6c96d61a48&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-24 03:33:46','2025-09-24 03:33:46',NULL),(51,51,NULL,'iframeurl','https://player.vimeo.com/video/690190674?h=0b86470cb9&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-24 03:37:03','2025-09-24 03:37:03',NULL),(52,52,NULL,'iframeurl','https://player.vimeo.com/video/788644232?h=20f08b7fa9&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-24 03:39:49','2025-09-24 03:39:49',NULL),(53,53,NULL,'iframeurl','https://player.vimeo.com/video/690406805?h=b43b3ab346&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-24 03:42:21','2025-09-24 03:42:21',NULL),(54,54,NULL,'iframeurl','https://player.vimeo.com/video/910474419?h=5935026016&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-24 03:44:24','2025-09-24 03:44:24',NULL),(55,55,NULL,'iframeurl','https://player.vimeo.com/video/910475105?h=db6c6e7a9d&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-24 03:46:20','2025-09-24 03:46:20',NULL),(56,56,NULL,'iframeurl','https://player.vimeo.com/video/910474842?h=aed37e9222&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-24 03:47:52','2025-09-24 03:47:52',NULL),(57,57,NULL,'iframeurl','https://player.vimeo.com/video/752435939?h=c3d254475a&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-24 03:50:21','2025-09-24 03:50:21',NULL),(58,58,NULL,'iframeurl','https://player.vimeo.com/video/690192734?h=147beb4e37&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-24 03:52:12','2025-09-24 03:52:12',NULL),(59,59,NULL,'iframeurl','https://player.vimeo.com/video/752086137?h=a8a445285d&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-28 14:41:27','2025-09-28 14:41:27',NULL),(60,60,NULL,'iframeurl','https://player.vimeo.com/video/752087136?h=20af4f74a7&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-28 14:43:45','2025-09-28 14:43:45',NULL),(61,61,NULL,'iframeurl','https://player.vimeo.com/video/788641344?h=dfdf1ae4ae&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-28 14:47:23','2025-09-28 14:47:23',NULL),(62,62,NULL,'iframeurl','https://player.vimeo.com/video/690200048?h=fc4ec634fd&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-28 14:50:05','2025-09-28 14:50:05',NULL),(63,63,NULL,'iframeurl','https://player.vimeo.com/video/788645096?h=2de5536a8c&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-28 14:52:50','2025-09-28 14:52:50',NULL),(64,64,NULL,'iframeurl','https://player.vimeo.com/video/1117289618?h=fd0c0b5965&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-28 14:56:01','2025-09-28 14:56:01',NULL),(65,65,NULL,'iframeurl','https://player.vimeo.com/video/788647523?h=812a2295bb&amp;badge=0',NULL,NULL,NULL,NULL,NULL,'2025-09-29 19:30:22','2025-09-29 19:30:22',NULL);
/*!40000 ALTER TABLE `videolinks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `views`
--

DROP TABLE IF EXISTS `views`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `views` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `viewable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `viewable_id` bigint unsigned NOT NULL,
  `visitor` text COLLATE utf8mb4_unicode_ci,
  `collection` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `viewed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `views_viewable_type_viewable_id_index` (`viewable_type`,`viewable_id`)
) ENGINE=InnoDB AUTO_INCREMENT=167 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `views`
--

LOCK TABLES `views` WRITE;
/*!40000 ALTER TABLE `views` DISABLE KEYS */;
/*!40000 ALTER TABLE `views` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `watch_histories`
--

DROP TABLE IF EXISTS `watch_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `watch_histories` (
  `id` int NOT NULL AUTO_INCREMENT,
  `movie_id` int DEFAULT NULL,
  `tv_id` int DEFAULT NULL,
  `user_id` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `watch_histories`
--

LOCK TABLES `watch_histories` WRITE;
/*!40000 ALTER TABLE `watch_histories` DISABLE KEYS */;
/*!40000 ALTER TABLE `watch_histories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wishlists`
--

DROP TABLE IF EXISTS `wishlists`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `wishlists` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned NOT NULL,
  `movie_id` int DEFAULT NULL,
  `season_id` int DEFAULT NULL,
  `added` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `wishlists_user_id_foreign` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wishlists`
--

LOCK TABLES `wishlists` WRITE;
/*!40000 ALTER TABLE `wishlists` DISABLE KEYS */;
/*!40000 ALTER TABLE `wishlists` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `withdrawals`
--

DROP TABLE IF EXISTS `withdrawals`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `withdrawals` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `mass_withdrawal_id` int unsigned DEFAULT NULL,
  `amount` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amounti` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `currency` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `currency2` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pbntag` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dest_tag` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ipn_url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `auto_confirm` tinyint(1) NOT NULL DEFAULT '0',
  `note` text COLLATE utf8mb4_unicode_ci,
  `ref_id` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` smallint NOT NULL,
  `status_text` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `txn_id` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `withdrawals_ref_id_unique` (`ref_id`),
  UNIQUE KEY `withdrawals_txn_id_unique` (`txn_id`),
  KEY `withdrawals_mass_withdrawal_id_index` (`mass_withdrawal_id`),
  CONSTRAINT `withdrawals_mass_withdrawal_id_foreign` FOREIGN KEY (`mass_withdrawal_id`) REFERENCES `mass_withdrawals` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `withdrawals`
--

LOCK TABLES `withdrawals` WRITE;
/*!40000 ALTER TABLE `withdrawals` DISABLE KEYS */;
/*!40000 ALTER TABLE `withdrawals` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2025-12-15 14:16:24
