<!DOCTYPE html>
<!--
**********************************************************************************************************
    Copyright (c) 2021 .
**********************************************************************************************************  
-->
<!--
Template Name: Next Hour - Movie Tv Show & Video Subscription Portal Cms
Version: 4.1
Author: Media City
-->
<!--[if IE 8]> <html lang="en" class="ie8 no-js"> <![endif]-->
<!--[if IE 9]> <html lang="en" class="ie9 no-js"> <![endif]-->
<!--[if !IE]> -->

<html lang="en" <?php if(selected_lang()->rtl == 1): ?> dir="rtl" <?php endif; ?>>
<!-- <![endif]-->
<!-- head -->
<head>
  
  <meta charset="utf-8" />
  <title><?php echo $__env->yieldContent('title'); ?> - <?php echo e($w_title); ?></title>

  
  <meta content="width=device-width, initial-scale=1.0" name="viewport" />
  <meta name="MobileOptimized" content="320" />    
  <?php echo $__env->yieldContent('custom-meta'); ?>
  <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>"><!-- CSRF Token -->
  <link href="//db.onlinewebfonts.com/c/02f502e5eefeb353e5f83fc5045348dc?family=GE+SS+Two+Light" rel="stylesheet" type="text/css"/> 
  <link rel="icon" type="image/icon" href="<?php echo e(url('images/favicon/favicon.png')); ?>"> <!-- favicon icon -->
  <link href="<?php echo e(url('css/starrating.css')); ?>" rel="stylesheet" type="text/css"/> 
  <!-- Star Rating -->
  <!-- theme style -->
  <link href="https://fonts.googleapis.com/css?family=Lato:300,400,700,900" rel="stylesheet"> <!-- google font -->
  <link href="https://fonts.googleapis.com/css2?family=Londrina+Shadow&display=swap" rel="stylesheet">
  <?php if(selected_lang()->rtl == 0): ?>
  <link href="<?php echo e(url('css/bootstrap.min.css')); ?>" rel="stylesheet" type="text/css"/> <!-- bootstrap css -->
  <?php else: ?>
  <link href="<?php echo e(url('css/bootstrap.min.css')); ?>" rel="stylesheet" type="text/css"/> <!-- bootstrap css -->
  <link href="<?php echo e(url('css/bootstrap.rtl.min.css')); ?>" rel="stylesheet" type="text/css"/><!-- bootstrap rtl css -->
  <?php endif; ?>
  <link href="<?php echo e(url('css/menumaker.css')); ?>" type="text/css" rel="stylesheet"> <!-- menu css -->
  <link href="<?php echo e(url('css/owl.carousel.min.css')); ?>" rel="stylesheet" type="text/css"/> <!-- owl carousel css -->
  <link href="<?php echo e(url('css/owl.theme.default.min.css')); ?>" rel="stylesheet" type="text/css"/> <!-- owl carousel css -->
  <link href="<?php echo e(url('css/font-awesome.min.css')); ?>" rel="stylesheet" type="text/css"/> <!-- fontawsome css -->
  <link href="<?php echo e(url('fonts/flaticon/font/flaticon.css')); ?>" rel="stylesheet" type="text/css"/> <!-- flaticon css -->
  <link href="<?php echo e(url('css/popover.css')); ?>" rel="stylesheet" type="text/css"/> <!-- bootstrap popover css -->
  <link href="<?php echo e(url('css/layers.css')); ?>" rel="stylesheet" type="text/css"/> <!-- revolution css -->
  <link href="<?php echo e(url('css/navigation.css')); ?>" rel="stylesheet" type="text/css"/> <!-- revolution css -->
  <link href="<?php echo e(url('css/pe-icon-7-stroke.css')); ?>" rel="stylesheet" type="text/css"/> <!-- revolution css -->
  <link href="<?php echo e(url('css/settings.css')); ?>" rel="stylesheet" type="text/css"/> <!-- revolution css -->
    <link href="<?php echo e(url('css/jquery-ui.css')); ?>" rel="stylesheet" type="text/css"/>
  <link rel="stylesheet" href="<?php echo e(url('css/colorbox.css')); ?>">
  
  <link rel="stylesheet" href="<?php echo e(url('css/venom-button.min.css')); ?>">

  <?php echo $__env->yieldContent('head-script'); ?>
<?php
$auth = Illuminate\Support\Facades\Auth::user();
if(Auth::check() && $auth){
  
      if($auth->status == 0){
       Auth::logout();
       header("Location: " . URL::to('/logout'), true, 302);
        exit();
      }
  }
?>
  <?php
    if(Schema::hasTable('color_schemes')){
      $color = App\ColorScheme::first();
    }
  ?>
  <?php if(isset($color)): ?>
    <?php if($color->color_scheme == 'dark'): ?>

    <style type="text/css">
        
        :root {
        
         --body_bg_color: #111;
         --btn-prime_bg_color: <?php echo e($color->custom_text_color != NULL ? $color->custom_text_color : $color->default_text_color); ?>;
         --footer_bg_color: <?php echo e($color->custom_footer_background_color != NULL ? $color->custom_footer_background_color : $color->default_footer_background_color); ?>;
         --background_black_bg_color: #111;
         --background_white_bg_color: #FFF;
         --background_dark-black_bg_color: #000;
         --back2top_bg_color: #DDD;
         --bg-success_bg_color: #198754;
         --blue_bg_color: <?php echo e($color->custom_text_color != NULL ? $color->custom_text_color : $color->default_text_color); ?>;
         --light-blue_bg_color: #90DFFE;
         --watchhistory_remove_bg_color: #D9534F;
         --btn-default_bg_color: #515151;
 
         --blue_border_color: <?php echo e($color->custom_text_color != NULL ? $color->custom_text_color : $color->default_text_color); ?>;
         --light-grey_border_color: #B1B1B1;
         --btn-prime_border_color: <?php echo e($color->custom_text_color != NULL ? $color->custom_text_color : $color->default_text_color); ?>;
         --see-more_border_color: #B1B1B1;
         --btn-default_border_color: #515151;
 
         --text_blue_color: <?php echo e($color->custom_text_color != NULL ? $color->custom_text_color : $color->default_text_color); ?>;
         --text_black_color: #111;
         --text_light_grey_color: #B1B1B1;
         --text_light_blue_color: <?php echo e($color->custom_text_on_color != NULL ? $color->custom_text_on_color : $color->default_text_on_color); ?>;
         --text_grey_color: #949494;
         --text_white_color: #FFF;
 
         /*add more */
         --navigation_bg_color: <?php echo e($color->custom_navigation_color != NULL ? $color->custom_navigation_color : $color->default_navigation_color); ?>;
         --back2top_bg_color_on_hover:  <?php echo e($color->custom_back_to_top_bgcolor_on_hover != NULL ? $color->custom_back_to_top_bgcolor_on_hover : $color->default_back_to_top_bgcolor_on_hover); ?>;
         --back2top_color_on_hover: <?php echo e($color->custom_back_to_top_color_on_hover != NULL ? $color->custom_back_to_top_color_on_hover : $color->default_back_to_top_color_on_hover); ?>;
         
         }
       </style>
     <?php else: ?>
       <style type="text/css">
        :root {
      
           --body_bg_color: #111;
           --btn-prime_bg_color: <?php echo e($color->custom_text_color != NULL ? $color->custom_text_color : $color->default_text_color); ?>;
           --footer_bg_color: <?php echo e($color->custom_footer_background_color != NULL ? $color->custom_footer_background_color : $color->default_footer_background_color); ?>;
           --background_black_bg_color: #111;
           --background_white_bg_color: #FFF;
           --background_dark-black_bg_color: #000;
           --back2top_bg_color: #DDD;
           --bg-success_bg_color: #198754;
           --blue_bg_color: <?php echo e($color->custom_text_color != NULL ? $color->custom_text_color : $color->default_text_color); ?>;
           --light-blue_bg_color: <?php echo e($color->custom_text_on_color != NULL ? $color->custom_text_on_color : $color->default_text_on_color); ?>;
           --watchhistory_remove_bg_color: #D9534F;
           --btn-default_bg_color: #515151;
 
           --blue_border_color: <?php echo e($color->custom_text_color != NULL ? $color->custom_text_color : $color->default_text_color); ?>;
           --light-grey_border_color: #B1B1B1;
           --btn-prime_border_color: <?php echo e($color->custom_text_color != NULL ? $color->custom_text_color : $color->default_text_color); ?>;
           --see-more_border_color: #B1B1B1;
           --btn-default_border_color: <?php echo e($color->custom_text_on_color != NULL ? $color->custom_text_on_color : $color->default_text_on_color); ?>;
 
           --text_blue_color:<?php echo e($color->custom_text_color != NULL ? $color->custom_text_color : $color->default_text_color); ?>;
           --text_black_color: #111;
           --text_light_grey_color: #B1B1B1;
           --text_light_blue_color: <?php echo e($color->custom_text_on_color != NULL ? $color->custom_text_on_color : $color->default_text_on_color); ?>;
           --text_grey_color: #949494;
           --text_white_color: #FFF;
 
           --white: #FFF;
 
           --navigation_bg_color: <?php echo e($color->custom_navigation_color != NULL ? $color->custom_navigation_color : $color->default_navigation_color); ?>;
           --back2top_bg_color_on_hover:  <?php echo e($color->custom_back_to_top_bgcolor_on_hover != NULL ? $color->custom_back_to_top_bgcolor_on_hover : $color->default_back_to_top_bgcolor_on_hover); ?>;
           --back2top_color_on_hover: <?php echo e($color->custom_back_to_top_color_on_hover != NULL ? $color->custom_back_to_top_color_on_hover : $color->default_back_to_top_color_on_hover); ?>;
         }
       </style>
    <?php endif; ?>
    <?php if($color->color_scheme == 'light'): ?>
      <?php if(selected_lang()->rtl == 0): ?>
        <link href="<?php echo e(url('css/style-light.css')); ?>" rel="stylesheet" type="text/css"/> 
      <?php else: ?>
        <link href="<?php echo e(url('css/style-light-rtl.css')); ?>" rel="stylesheet" type="text/css"/>
      <?php endif; ?>
    <?php else: ?>
      <?php if(selected_lang()->rtl == 0): ?>
        <link href="<?php echo e(url('css/style.css')); ?>" rel="stylesheet" type="text/css"/>
      <?php else: ?>
        <link href="<?php echo e(url('css/style-rtl.css')); ?>" rel="stylesheet" type="text/css"/>
      <?php endif; ?>
    <?php endif; ?>
  <?php endif; ?>
  
  <link href="<?php echo e(url('css/custom-style.css')); ?>" rel="stylesheet" type="text/css"/>
  <link href="<?php echo e(url('css/goto.css')); ?>" rel="stylesheet" type="text/css"/>
  <link rel="stylesheet" href="<?php echo e(url('content/global.css')); ?>"><!-- go to top css -->
  <script src="//js.stripe.com/v3/"></script> <!-- stripe script -->
  <script type="text/javascript" src="<?php echo e(url('js/jquery.min.js')); ?>"></script>
  <script type="text/javascript" src="<?php echo e(url('java/FWDUVPlayer.js')); ?>"></script> <!-- jquery library js -->

  <script>
    window.Laravel =  <?php echo json_encode([
      'csrfToken' => csrf_token(),
      ]); ?>
    </script>
    <script type="text/javascript" src="<?php echo e(url('js/app.js')); ?>"></script> <!-- app library js -->
    <!-- notification icon style -->
    <style type="text/css">
     #ex4 .p1[data-count]:after{
      position:absolute;
      right:10%;
      top:8%;
      content: attr(data-count);
      font-size:40%;
      padding:.2em;
      border-radius:50%;
      line-height:1em;
      color: white;
      background:#c0392b;
      text-align:center;
      min-width: 1em;
      //font-weight:bold;
    }
  </style>
  <!-- end theme style -->


  <script type="text/javascript" src="//cdnjs.cloudflare.com/ajax/libs/jquery.lazy/1.7.9/jquery.lazy.min.js"></script>
  <script type="text/javascript" src="//cdnjs.cloudflare.com/ajax/libs/jquery.lazy/1.7.9/jquery.lazy.plugins.min.js"></script>

  <script>
    $(function(){
      "use strict";
      $('.lazy').lazy({
          effect: "fadeIn",
          effectTime: 2000,
          scrollDirection: 'both',
          threshold: 0
      });
    });
  </script>
  <?php echo $__env->yieldContent('player-sc'); ?>

  <?php if(env('PWA_ENABLE') == 1): ?>
    <?php $config = (new \LaravelPWA\Services\ManifestService)->generate(); echo $__env->make( 'laravelpwa::meta' , ['config' => $config])->render(); ?>
  <?php endif; ?>

  <?php
    if(env('MAIL_USERNAME') != NULL && env('MAIL_PASSWORD') != NULL && env('MAIL_HOST') != NULL && env('MAIL_DRIVER') != NULL){
      if(isset(Auth::user()->paypal_subscriptions)){
        //Run wallet point expire background process
        App\Jobs\CheckUserPlanValidity::dispatchNow();
      }
    }
    
  ?>

 

</head>
<!-- end head -->
<!--body start-->
<body>
  <!-- preloader -->
  <?php if($preloader == 1): ?>
  <div class="loading">
    <div class="logo">
      <?php if($configs->preloader_img != NULL): ?>
      <img src="<?php echo e(url('images/'.$configs->preloader_img)); ?>" class="img-responsive" alt="<?php echo e($w_title); ?>">
      <?php else: ?>
      <img src="<?php echo e(url('images/logo/'.$configs->logo)); ?>" class="img-responsive" alt="<?php echo e($w_title); ?>">
      <?php endif; ?>
    </div>
    <div class="loading-text">
      <span class="loading-text-words"><?php echo e(__('L')); ?></span>
      <span class="loading-text-words"><?php echo e(__('O')); ?></span>
      <span class="loading-text-words"><?php echo e(__('A')); ?></span>
      <span class="loading-text-words"><?php echo e(__('D')); ?></span>
      <span class="loading-text-words"><?php echo e(__('I')); ?></span>
      <span class="loading-text-words"><?php echo e(__('N')); ?></span>
      <span class="loading-text-words"><?php echo e(__('G')); ?></span>
    </div>
  </div>
  <?php endif; ?>
  <!-- end preloader -->
  <div class="body-overlay-bg"></div>

  <?php if(Session::has('added')): ?>
  <div id="sessionModal" class="sessionmodal rgba-green-strong z-depth-2">
    <i class="fa fa-check-circle"></i> <p><?php echo e(session('added')); ?></p>
  </div>
  <?php elseif(Session::has('updated')): ?>
  <div id="sessionModal" class="sessionmodal rgba-cyan-strong z-depth-2">
    <i class="fa fa-exclamation-triangle"></i> <p><?php echo e(session('updated')); ?></p>
  </div>
  <?php elseif(Session::has('deleted')): ?>
  <div id="sessionModal" class="sessionmodal rgba-red-strong z-depth-2">
    <i class="fa fa-window-close"></i> <p><?php echo e(session('deleted')); ?></p>
  </div>
  <?php endif; ?>
  <?php
  if (Session::has('added')){
  session()->forget('added');
  }
  if (Session::has('deleted')){
  session()->forget('deleted');
  }
  if (Session::has('updated')){
  session()->forget('updated');
  }
  ?>
  <!-- preloader -->
  <div class="preloader">
    <div class="status">
      <div class="status-message">
      </div>
    </div>
  </div>

<?php
  $auth = Illuminate\Support\Facades\Auth::user();
  
  $subscribed = null;
  $withlogin= $configs->withlogin;
  $catlog = $configs->catlog;  
 
    if(Auth::check() && $auth){
      if($catlog == 1){
        $menuh=App\Menu::orderBy('position','ASC')->get();
      }else{
        if(getSubscription()->getData()->subscribed == true){
          $menuh = getSubscription()->getData()->nav_menus;
        }
      }
      
    }else{
      if($catlog ==1 && $withlogin == 1){
        $menuh=App\Menu::orderBy('position','ASC')->get();
      }
      
    }
 
 


$custom_page = App\CustomPage::where('in_show_menu','1')->where('is_active','1')->get();

?>

<!-- end preloader -->
<!-- navigation -->
<div class="navigation">
  <div class="container-fluid nav-container">
    <div class="row">
      <div class="col-12 col-sm-6 col-md-6 col-lg-4">
        <div class="nav-logo">
           <a href="<?php echo e(url('/')); ?>" title="<?php echo e($w_title); ?>"><img src="<?php echo e(url('images/logo/'.$logo)); ?>"   class="img-responsive" alt="<?php echo e($w_title); ?>" style="max-width: fit-content;"></a>
          
        </div>
      </div>
     <div class="col-sm-6 col-lg-3">
        <div id="cssmenu">
          <?php if($auth && isset($menuh) || isset($custom_page) && getSubscription()->getData()->subscribed == true): ?>
            <ul>
              <?php if(isset($menuh) && count($menuh) > 0): ?>
                <?php $__currentLoopData = $menuh; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menus): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <?php if($auth && getSubscription()->getData()->subscribed == true): ?>
                  
                    <li>
                      <a class="<?php echo e(Nav::hasSegment($menus->slug)); ?>" href="<?php echo e(url('/', $menus->slug)); ?>"  title="<?php echo e($menus->name); ?>">
                        <?php echo e($menus->name); ?>

                      </a>
                    </li>
                  <?php else: ?>
                  
                    <li>
                      <a class="<?php echo e(Nav::hasSegment($menus->slug)); ?>" href="<?php echo e(url('/guest', $menus->slug)); ?>"  title="<?php echo e($menus->name); ?>">
                        <?php echo e($menus->name); ?>

                      </a>
                    </li>
                  <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              <?php endif; ?>
              
              <?php if(isset($custom_page) && count($custom_page) >0): ?>
                <?php $__currentLoopData = $custom_page; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $custom): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <?php if(isset($custom)): ?>
                    <li>
                      <a class="<?php echo e(Nav::hasSegment($custom->slug)); ?>" href="<?php echo e(url('/page', $custom->slug)); ?>"  title="<?php echo e($custom->title); ?>">
                        <?php echo e($custom->title); ?>

                      </a>
                    </li>
                  <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> 
              <?php endif; ?>
              
            </ul>
          <?php else: ?>
            <?php if($catlog == 1 && $withlogin == 1): ?>
            <ul>
              <?php if(isset($menuh) && count($menuh) > 0): ?>
                <?php $__currentLoopData = $menuh; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menus): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <?php if($auth && getSubscription()->getData()->subscribed == true): ?>
                  
                    <li>
                      <a class="<?php echo e(Nav::hasSegment($menus->slug)); ?>" href="<?php echo e(url('/', $menus->slug)); ?>"  title="<?php echo e($menus->name); ?>">
                        <?php echo e($menus->name); ?>

                      </a>
                    </li>
                  <?php else: ?>
                  
                    <li>
                      <a class="<?php echo e(Nav::hasSegment($menus->slug)); ?>" href="<?php echo e(url('/guest', $menus->slug)); ?>"  title="<?php echo e($menus->name); ?>">
                        <?php echo e($menus->name); ?>

                      </a>
                    </li>
                  <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              <?php endif; ?>
              
              <?php if(isset($custom_page) && count($custom_page) >0): ?>
                <?php $__currentLoopData = $custom_page; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $custom): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <?php if(isset($custom)): ?>
                    <li>
                      <a class="<?php echo e(Nav::hasSegment($custom->slug)); ?>" href="<?php echo e(url('/page', $custom->slug)); ?>"  title="<?php echo e($custom->title); ?>">
                        <?php echo e($custom->title); ?>

                      </a>
                    </li>
                  <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> 
              <?php endif; ?>
              
            </ul>
            <?php endif; ?>
          <?php endif; ?>
        </div>
       
     </div>
      <div class="col-sm-6 col-md-6 col-lg-4 pull-right">
        <div class="login-panel-main-block small-screen-block">
          <ul>
            <?php if(auth()->guard()->check()): ?>
            <?php if($catlog == 0 && getSubscription()->getData()->subscribed == true): ?>
            <!-- <li class="prime-search-block">
              <form class="searchbar" action="<?php echo e(route('search')); ?>" id="searchbar">
                <input type="text" class="btn-extended" placeholder="search" name="search" />
                <label for="search-box" class="btn-search"><i class="flaticon-search"></i></label>
              </form>
            </li> -->
            <?php elseif($catlog == 1): ?>
            <!-- <li class="prime-search-block">
              <form class="searchbar" action="<?php echo e(route('search')); ?>" id="searchbar">
                <input type="text" class="btn-extended" placeholder="search" name="search" />
                <label for="search-box" class="btn-search"><i class="flaticon-search"></i></label>
              </form>
            </li> -->
            <?php endif; ?>
            <?php endif; ?>
          
            <!-- notificaion -->
            <?php if(auth()->guard()->check()): ?>
            <?php if(getSubscription()->getData()->subscribed == true): ?>
            
            <li class="sign-in-block sign-in-block-one ">
              <a class="sign-in" href="<?php echo e(route('custom.logout')); ?>">
                <?php echo e(__('staticwords.signout')); ?>

              </a>
            </li>
            <li class="sign-in-block sign-in-block-one ">
              <a class="sign-in" href="<?php echo e(url('unsubscription')); ?>">
                <?php echo e(__('staticwords.unsubscription')); ?>

              </a>
            </li>

            <?php endif; ?>
          
            <?php else: ?>
            <li class="sign-in-block sign-in-block-one sign-in-block-two mrgn-rt-20"><a class="sign-in" href="<?php echo e(url('zainlogin')); ?>"><i class="flaticon-login"></i> <?php echo e(__('staticwords.signin')); ?></a></li>
            <li class="sign-in-block sign-in-block-one "><a class="sign-in" href="<?php echo e(url('zainsubscribe')); ?>"><i class="flaticon-profile"></i><?php echo e(__('staticwords.register')); ?></a></li>
            <?php endif; ?>
          </ul>
        </div>
        
      </div>
      
    </div>
    <img src="<?php echo e(url('images/logo/Zain.png')); ?>" class="img-responsive" style="height: 65px;
    width: auto;
    position: absolute;
    top: 5px;
    left: 5px;" alt="<?php echo e($w_title); ?>">
  </div>
</div>
<div>




<!-- small screen navigation start-->
<div class="small-screen-navigation">
  <nav class="sidenav" id="mySidenav" role="navigation">
    <a href="javascript:void(0)" class="closebtn" onclick="closeNav()">&times;</a>
    <h3 class="wrapper-heading">القائمة</h3>
    <ul class="nav sidebar-nav">
      <?php if($catlog==1): ?>
          <?php if(isset($menuh) || isset($custom_page)): ?>
            <?php if(isset($menuh) && count($menuh) > 0): ?>
              <?php $__currentLoopData = $menuh; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menus): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if($auth && getSubscription()->getData()->subscribed == true): ?>
                  <li>
                    <a class="<?php echo e(Nav::hasSegment($menus->slug)); ?>" href="<?php echo e(url('/', $menus->slug)); ?>"  title="<?php echo e($menus->name); ?>">
                      <?php echo e($menus->name); ?>

                    </a>
                  </li>
                <?php else: ?>
                  <li>
                    <a class="<?php echo e(Nav::hasSegment($menus->slug)); ?>" href="<?php echo e(url('/guest', $menus->slug)); ?>"  title="<?php echo e($menus->name); ?>">
                      <?php echo e($menus->name); ?>

                    </a>
                  </li>
                <?php endif; ?>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
            <?php if(isset($custom_page) && count($custom_page) >0): ?>
              <?php $__currentLoopData = $custom_page; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $custom): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if(isset($custom)): ?>
                  <li>
                    <a class="<?php echo e(Nav::hasSegment($custom->slug)); ?>" href="<?php echo e(url('/page', $custom->slug)); ?>"  title="<?php echo e($custom->title); ?>">
                      <?php echo e($custom->title); ?>

                    </a>
                  </li>
                <?php endif; ?>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> 
            <?php endif; ?>
        
          <?php endif; ?>
      <?php elseif($catlog == 0 && getSubscription()->getData()->subscribed == true): ?>
        <?php if(isset($menuh) ): ?>
            <?php if(isset($menuh) && count($menuh) > 0): ?>
              <?php $__currentLoopData = $menuh; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menus): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li>
                  <a class="<?php echo e(Nav::hasSegment($menus->slug)); ?>" href="<?php echo e(url('/', $menus->slug)); ?>"  title="<?php echo e($menus->name); ?>">
                    <?php echo e($menus->name); ?>

                  </a>
                </li>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
          
            <?php if(isset($custom_page) && count($custom_page) >0): ?>
              <?php $__currentLoopData = $custom_page; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $custom): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if(isset($custom)): ?>
                  <li>
                    <a class="<?php echo e(Nav::hasSegment($custom->slug)); ?>" href="<?php echo e(url('/page', $custom->slug)); ?>"  title="<?php echo e($custom->title); ?>">
                      <?php echo e($custom->title); ?>

                    </a>
                  </li>
                <?php endif; ?>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> 
            <?php endif; ?>
        <?php endif; ?>
      <?php endif; ?>
       <!-- notificaion -->
      <?php if(auth()->guard()->check()): ?>
      <?php if(getSubscription()->getData()->subscribed == true): ?>
    
      </li>
            <li class="sign-in-block sign-in-block-one ">
              <a class="sign-in" href="<?php echo e(route('custom.logout')); ?>">
                <?php echo e(__('staticwords.signout')); ?>

              </a>
            </li>
            <li class="sign-in-block sign-in-block-one ">
              <a class="sign-in" href="<?php echo e(url('unsubscription')); ?>">
                <?php echo e(__('staticwords.unsubscription')); ?>

              </a>
            </li>
    
      <?php endif; ?>

      

      <?php else: ?>

      <li class="sign-in-block sign-in-block-one sign-in-block-two mrgn-rt-20"><a class="sign-in" href="<?php echo e(url('zainlogin')); ?>"><i class="flaticon-login"></i> <?php echo e(__('staticwords.signin')); ?></a></li>
            <li class="sign-in-block sign-in-block-one "><a class="sign-in" href="<?php echo e(url('zainsubscribe')); ?>"><i class="flaticon-profile"></i><?php echo e(__('staticwords.register')); ?></a></li>
      <?php endif; ?>
    </ul>
  </nav>
  <span class="side-bar" style="    top: 11px;
    left: 26px;
    font-size: 30px;
    cursor: pointer;
    position: fixed;
    color: #B1B1B1;
    width: 15%;
    z-index: 9999;
    right: 20;" onclick="openNav()">&#9776;</span>
</div>
<div id="find">
  <div class="themesearch">
    <button type="button" class="close">×</button>
    <?php echo Form::open(['method' => 'GET', 'action' => 'HomeController@search', 'class' => 'search_form']); ?>

    <input type="find"  name="search" value="" placeholder="Type something to search.." />
    <button type="submit" class="btn btn-outline-info btn_sm">Search</button>
    <?php echo Form::close(); ?>

  </div>
</div>

<?php if($auth): ?>
   <?php if(getSubscription()->getData()->subscribed != true): ?>
    <div class="purchase-sticky">
     <p><?php echo e(__('staticwords.pleasesubscribetoaplan')); ?> &nbsp;<a href="<?php echo e(url('account/purchaseplan')); ?>" style="color: #1B1464;"><button class="btn btn-sm text-white agree_btn js-cookie-consent-agree cookie-consent__agree"><?php echo e(__('staticwords.clickhere')); ?></button></a></p>
    </div>
  <?php endif; ?>
<?php endif; ?>



<!-- end navigation -->
<?php echo $__env->yieldContent('main-wrapper'); ?>
<?php
  $si = App\SocialIcon::first();
?>
<!-- footer -->
<?php if($prime_footer == 1): ?>
<footer id="prime-footer" class="prime-footer-main-block">
  <div class="container-fluid">
    <div style="height:0px;">
      <a id="back2Top" title="Back to top" href="#">&#10148;</a>
    </div>
    <div class="logo">
      <img src="<?php echo e(url('images/logo/'.$logo)); ?>"  class="img-responsive" alt="<?php echo e($w_title); ?>">
    </div>

    <div class="text-center">
   
    </div>
    <?php
      
      $isplay=$configs->is_playstore;
      $isappstore=$configs->is_appstore;
      $appstore=$configs->appstore;
      $playstore=$configs->playstore;
    ?>
    <div class="text-center">
      <div class="footer-widgets social-widgets social-btns">
        <ul>
         <?php if($isappstore==1 &&  $isappstore != NULL): ?>
         <li> <a href="<?php echo e($appstore); ?>" target="_blank"> <img width="12%" height="12%" src="<?php echo e(url('images/app_store_download.png')); ?>"></a></li>
         <?php endif; ?>
         <?php if($isplay==1 && $isplay != NULL): ?>
         <li>
           <a href="<?php echo e($playstore); ?>"  target="_blank"> <img  width="12%" height="12%" src="<?php echo e(url('images/google_play_download.png')); ?>"></a>
         </li>
         <?php endif; ?>
       </ul>
      </div>
    </div>

    <div class="copyright">
      <ul>
        <li>
          <?php if(isset($copyright)): ?>
          
          &copy;<?php echo $copyright; ?><img src="<?php echo e(url('images/logo/nxt.png')); ?>"  width="40" height="auto"  alt="company logo">  <?php echo $rights; ?> <?php echo e(date('Y')); ?> 
          <?php endif; ?>
        </li>
      </ul>
      <ul>
        <?php if(isset($configs->terms_condition) && $configs->terms_condition != NULL): ?>
          <li><a href="<?php echo e(url('terms_condition')); ?>"><?php echo e(__('staticwords.termsandcondition')); ?></a></li>
        <?php endif; ?>
        <?php if(isset($configs->privacy_pol) && $configs->privacy_pol != NULL): ?>
          <li><a href="<?php echo e(url('privacy_policy')); ?>"><?php echo e(__('staticwords.privacypolicy')); ?></a></li>
        <?php endif; ?>
        <?php if(isset($configs->refund_pol) && $configs->refund_pol != NULL): ?>
          <li><a href="<?php echo e(url('refund_policy')); ?>"><?php echo e(__('staticwords.refundpolicy')); ?></a></li>
        <?php endif; ?>
        <li><a href="<?php echo e(url('faq')); ?>"><?php echo e(__('staticwords.help')); ?></a></li>
        <?php if(auth()->guard()->check()): ?>
            <?php if(getSubscription()->getData()->subscribed == true): ?>

           
              <li><a class="sign-in" href="<?php echo e(route('custom.logout')); ?>">
                <?php echo e(__('staticwords.signout')); ?>

              </a>
  </li>
            
           
  <li> <a class="sign-in" href="<?php echo e(url('unsubscription')); ?>">
                <?php echo e(__('staticwords.unsubscription')); ?>

              </a>  </li>
           

            <?php endif; ?>
          
            <?php else: ?>
            <li> <a class="sign-in" href="<?php echo e(url('zainlogin')); ?>"> <?php echo e(__('staticwords.signin')); ?></a>  </li>
            <li><a class="sign-in" href="<?php echo e(url('zainsubscribe')); ?>"><?php echo e(__('staticwords.register')); ?></a>  </li>
            <?php endif; ?>
      </ul>
    </div>
  </div>
</footer>
<?php else: ?>
<footer id="footer-main-block" class="footer-main-block">
  <div class="pre-footer">
    <div class="container-fluid">
      <div class="row">
        <div class="col-md-3">
          <div class="footer-logo footer-widgets">
            <?php if(isset($logo)): ?>
            <img src="<?php echo e(url('images/logo/'.$logo)); ?>" class="img-responsive" alt="<?php echo e($w_title); ?>">
            <?php endif; ?>
          </div>
        </div>
        
        <div class="col-md-4">
          <div class="footer-widgets">
            <div class="row">
              <div class="col-md-6">
                <div class="footer-links-block">
                  <h4 class="footer-widgets-heading"><?php echo e(__('staticwords.corporate')); ?></h4>
                  <ul>
                   
                      <?php if(isset($configs->terms_condition) && $configs->terms_condition != NULL): ?>
                    <li><a href="<?php echo e(url('terms_condition')); ?>"><?php echo e(__('staticwords.termsandcondition')); ?></a></li>
                    <?php endif; ?>
                      <?php if(isset($configs->privacy_policy) && $configs->privacy_policy != NULL): ?>
                    <li><a href="<?php echo e(url('privacy_policy')); ?>"><?php echo e(__('staticwords.privacypolicy')); ?></a></li>
                    <?php endif; ?>
                      <?php if(isset($configs->refund_policy) && $configs->refund_policy != NULL): ?>
                    <li><a href="<?php echo e(url('refund_policy')); ?>"><?php echo e(__('staticwords.refundpolicy')); ?></a></li>
                    <?php endif; ?>
                    <li>test<a href="<?php echo e(url('faq')); ?>"><?php echo e(__('staticwords.help')); ?></a></li>
                
            
                  </ul>
                </div>
              </div>
              <div class="col-md-6">
                <div class="footer-links-block">
                  <h4 class="footer-widgets-heading"><?php echo e(__('staticwords.sitemap')); ?></h4>
                  <ul>
                  
                    <?php if(isset($menuh)): ?>
                      <?php $__currentLoopData = $menuh; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($value->slug != null ||$value->slug != ''): ?>  
                              <?php $mySlug = $value->slug; ?>
                               <li><a href="<?php echo e(url($mySlug)); ?>"><?php echo e($value->name); ?></a></li>
                        <?php endif; ?>      
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                  </ul>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="col-md-3">
          <div class="footer-widgets subscribe-widgets">
            <h4 class="footer-widgets-heading"><?php echo e(__('staticwords.subscribe')); ?></h4>
            <p class="subscribe-text"><?php echo e(__('staticwords.subscribetext')); ?></p>
            <?php echo Form::open(['method' => 'POST', 'action' => 'emailSubscribe@subscribe']); ?>

            <?php echo e(csrf_field()); ?>

            <div class="form-group">
              <input type="email" name="email" class="form-control subscribe-input" placeholder="Enter your e-mail">
              <button type="submit" class="subscribe-btn"><i class="fa fa-long-arrow-alt-right" style="color:red;"></i></button>
            </div>
            <?php echo Form::close(); ?>

          </div>
        </div>
        <div class="col-md-2">
         
          <div class="footer-widgets social-widgets social-btns">
            <ul>
              <?php if(isset( $si->url1)): ?><li><a href="<?php echo e($si->url1); ?>" target="_blank"><i class="fa fa-facebook"></i></a></li><?php endif; ?>
              <?php if(isset($si->url2)): ?><li><a href="<?php echo e($si->url2); ?>" target="_blank"><i class="fa fa-twitter"></i></a></li><?php endif; ?>
              <?php if(isset($si->url3)): ?><li><a href="<?php echo e($si->url3); ?>" target="_blank"><i class="fa fa-youtube"></i></a></li><?php endif; ?>
              <?php
             
              $isplay=$configs->is_playstore;
              $isappstore=$configs->is_appstore;
              $appstore=$configs->appstore;
              $playstore=$configs->playstore;
              ?>
              
              <?php if($isappstore==1 && $isappstore != NULL): ?>
              <li> <a href="<?php echo e($appstore); ?>" target="_blank"> <img width="72%" height="72%" src="<?php echo e(url('images/app_store_download.png')); ?>"></a></li>
              <?php endif; ?>
              <?php if($isplay==1 && $isplay != NULL): ?>
              <li>
               <a href="<?php echo e($playstore); ?>"  target="_blank"> <img  width="72%" height="72%" src="<?php echo e(url('images/google_play_download.png')); ?>"></a>
             </li>
             <?php endif; ?>
             
           </ul>
         </div>
       </div>
     </div>
   </div>

 </div>

  <div class="container-fluid">
    <div class="copyright-footer">
      <?php if(isset($copyright)): ?>
     &copy;<?php echo e(date('M')); ?> <?php echo $copyright; ?>

      <?php endif; ?>
    </div>
  </div>
  
</footer>

<?php endif; ?>
<!-- end footer -->

<div id="myButton"></div>

<!-- jquery -->
<script type="text/javascript" src="<?php echo e(url('js/bootstrap.min.js')); ?>"></script> <!-- bootstrap js -->
<script type="text/javascript" src="<?php echo e(url('js/jquery.popover.js')); ?>"></script> <!-- bootstrap popover js -->
<script type="text/javascript" src="<?php echo e(url('js/menumaker.js')); ?>"></script> <!-- menumaker js -->
<script type="text/javascript" src="<?php echo e(url('js/jquery.curtail.min.js')); ?>"></script> <!-- menumaker js -->
<?php if(selected_lang()->rtl == 0): ?>
<script type="text/javascript" src="<?php echo e(url('js/owl.carousel.min.js')); ?>"></script> 
<?php else: ?>
<script type="text/javascript" src="<?php echo e(url('js/owl-carousel-rtl-js/owl.carousel.min.js')); ?>"></script> <!-- owl carousel js -->
<?php endif; ?>
<script type="text/javascript" src="<?php echo e(url('js/jquery.scrollSpeed.js')); ?>"></script> <!-- owl carousel js -->
<script type="text/javascript" src="<?php echo e(url('js/TweenMax.min.js')); ?>"></script> <!-- animation gsap js -->
<script type="text/javascript" src="<?php echo e(url('js/ScrollMagic.min.js')); ?>"></script> <!-- custom js -->
<script type="text/javascript" src="<?php echo e(url('js/animation.gsap.min.js')); ?>"></script> <!-- animation gsap js -->
<script type="text/javascript" src="<?php echo e(url('js/modernizr-custom.js')); ?>"></script> <!-- debug addIndicators js -->
<script type="text/javascript" src="<?php echo e(url('js/theme.js')); ?>"></script> <!-- custom js -->
<script type="text/javascript" src="<?php echo e(url('js/custom-js.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(url('js/colorbox.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(url('js/checkit.js')); ?>"></script>

<script src="//cdnjs.cloudflare.com/ajax/libs/bootstrap-star-rating/4.0.2/js/star-rating.min.js"></script>
<!-- venomem -->
<script type="text/javascript" src="<?php echo e(url('js/venom-button.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(url('js/jquery-ui.min.js')); ?>"></script>

<!-- end jquery -->
<?php echo $__env->yieldContent('custom-script'); ?>
<?php echo $__env->yieldContent('script'); ?>

<!-- cookie -->
<?php echo $__env->make('cookieConsent::index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<!-- end cookie -->


<?php if(isset($whatsapp_settings) && $whatsapp_settings->enable_whatsapp == 1): ?>
<!-- whatsapp chat -->
<script type="text/javascript">

   $('#myButton').venomButton({
        phone: "<?php echo e($whatsapp_settings->mobile); ?>",
        popupMessage: "<?php echo e($whatsapp_settings->text); ?>",
        message: "",
        showPopup: true,
        position: "<?php echo e($whatsapp_settings->position); ?>",
        linkButton: false,
        showOnIE: false,
        heigth:"<?php echo e($whatsapp_settings->size); ?>",
        width:"<?php echo e($whatsapp_settings->size); ?>",
        headerTitle: "<?php echo e($whatsapp_settings->header); ?>",
        headerColor: "<?php echo e($whatsapp_settings->color); ?>",
        backgroundColor: '#25d366',
        buttonImage: '<img src="<?php echo e(url('/images/whatsapp.svg')); ?>" />'
    });
</script>
<?php endif; ?>
<!-- end whatsapp chat -->

<!-- navigation -->
<script>
function openNav() {
  document.getElementById("mySidenav").style.width = "250px";
}

function closeNav() {
  document.getElementById("mySidenav").style.width = "0";
}
</script>
<!-- end navigation -->

<script>
$(function(){
  $('.hamburger').on('click',function(){
    $('#wrapper').addClass("toggled");
  })
});
</script>
<script type="text/javascript">
   var colors = [ '#f44336',
        '#E91E63',
        '#9C27B0',
        '#673AB7',
        '#3F51B5',
        '#2196F3',
        '#03A9F4',
        '#00BCD4',
        '#009688',
        '#4CAF50',
        '#8BC34A',
        '#CDDC39',
        '#FFC107',
        '#FF9800',
        '#FF5722'];
    var divs = $('.allgenre');
    

    for (var i = 0; i < divs.length; i++) {
        var color = colors[i % colors.length];

        $(divs[i]).css('background-color', color);
    };
</script>

<script async src="https://www.googletagmanager.com/gtag/js?id=AW-323170129"></script>
<script>
  // Gme Script for google 
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'AW-323170129');
</script>

<script>


  (function($) {
    window.addEventListener( "pageshow", function ( event ) {
  var historyTraversal = event.persisted || 
                         ( typeof window.performance != "undefined" && 
                              window.performance.navigation.type === 2 );
  if (!historyTraversal ) {
    $('.sessionmodal').addClass("active");
  setTimeout(function() {
    $('.sessionmodal').removeClass("active");
  }, 2000);
  }
});
 

  if (window.location.hash == '#_=_'){
    history.replaceState
    ? history.replaceState(null, null, window.location.href.split('#')[0])
    : window.location.hash = '';
  }
  })(jQuery);
</script>

<?php if($google): ?>
<script>
  (function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
    (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
    m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
  })(window,document,'script','https://www.google-analytics.com/analytics.js','ga');

  ga('create', '<?php echo e($google); ?>', 'auto');
  ga('send', 'pageview');

</script>
<?php endif; ?>
<?php if($fb): ?>
<!-- facebook pixel -->
<script>
  !function(f,b,e,v,n,t,s){if(f.fbq)return;n=f.fbq=function(){n.callMethod?
    n.callMethod.apply(n,arguments):n.queue.push(arguments)};if(!f._fbq)f._fbq=n;
    n.push=n;n.loaded=!0;n.version='2.0';n.queue=[];t=b.createElement(e);t.async=!0;
    t.src=v;s=b.getElementsByTagName(e)[0];s.parentNode.insertBefore(t,s)}(window,
      document,'script','https://connect.facebook.net/en_US/fbevents.js');
    fbq('init', '<?php echo e($fb); ?>');
    fbq('track', 'PageView');
  </script>
  <!--End facebook pixel -->
  <?php endif; ?>

  <?php if($rightclick == 1): ?>
  <script type="text/javascript" language="javascript">
  // Right click disable
  $(function() {
    $(this).bind("contextmenu", function(inspect) {
      inspect.preventDefault();
    });
  });
  // End Right click disable
</script>
<?php endif; ?>

<?php if($inspect == 1): ?>
<script type="text/javascript" language="javascript">
//all controller is disable
$(function() {
  var isCtrl = false;
  document.onkeyup=function(e){
    if(e.which == 17) isCtrl=false;
  }

  document.onkeydown=function(e){
    if(e.which == 17) isCtrl=true;
    if(e.which == 85 && isCtrl == true) {
      return false;
    }
  };
  $(document).keydown(function (event) {
    if (event.keyCode == 123) { // Prevent F12
      return false;
    }
    else if (event.ctrlKey && event.shiftKey && event.keyCode == 73) { // Prevent Ctrl+Shift+I
      return false;
    }
  });
});
// end all controller is disable
</script>
<?php endif; ?>


<?php if($goto==1): ?>
<script type="text/javascript">
 // go to top
  $(window).scroll(function() {
    var height = $(window).scrollTop();
    if (height > 100) {
      $('#back2Top').fadeIn();
    } else {
      $('#back2Top').fadeOut();
    }
  });
  $(document).ready(function() {
    $("#back2Top").click(function(event) {
      event.preventDefault();
      $("html, body").animate({ scrollTop: 0 }, "slow");
      return false;
    });
  });
  // end go to top
</script>
<?php endif; ?>
 
<!---------------- UC browser block --------------->
<?php if($uc_browser == "1"): ?>
<script >
$(document).ready(function() {
 // var detect=navigator.userAgent.indexOf("UBrowser");
 // alert(detect);

   if ( navigator.userAgent.indexOf("UBrowser")>=0 || navigator.userAgent.indexOf("UCBrowser")>=0)
  {
    
    // Run custom code for Internet Explorer.
    // window.document.write("/404 error");
    alert('Oops ! Its Look Like you are using a UCBrowser.We Blocked the access in it kindly use another browser like chrome.');

    window.location.replace("http://www.ucweb.com/");
  }

 
});
</script>
<?php endif; ?>

<!--------------- end UC browser Block ------------>

<script type="text/javascript">
   function checkSubscription() {
  $.ajax({
            type: "get",
            url:  "/Zain_Check",
            success: function (data) {
             // alert(data);
              if(data!=""){
              window.location.href =data;
              }
            },
            error: function (data) {
             
            }
        });
 }
 function readed(id){

   $.ajax({
    type : 'GET',
    data : { id:id },
    url  : '<?php echo e(url('/user/notification/read')); ?>/'+id,
    success :function(data){
      console.log(data);
    }
  });
 }
 window.onload = checkSubscription;
</script>

<!------ colorbox script ------->

<script>
  $(document).ready(function(){
    
    $(".group1").colorbox({rel:'group1'});
    $(".group2").colorbox({rel:'group2', transition:"fade"});
    $(".group3").colorbox({rel:'group3', transition:"none", width:"75%", height:"75%"});
    $(".group4").colorbox({rel:'group4', slideshow:true});
    $(".ajax").colorbox();
    $(".youtube").colorbox({iframe:true, innerWidth:640, innerHeight:390});
    $(".vimeo").colorbox({iframe:true, innerWidth:500, innerHeight:409});
    $(".iframe").colorbox({iframe:true, width:"100%", height:"100%",controllist:"nodownload"});
    $(".inline").colorbox({inline:true, width:"50%"});
    $(".callbacks").colorbox({
      onOpen:function(){ alert('onOpen: colorbox is about to open'); },
      onLoad:function(){ alert('onLoad: colorbox has started to load the targeted content'); },
      onComplete:function(){ alert('onComplete: colorbox has displayed the loaded content'); },
      onCleanup:function(){ alert('onCleanup: colorbox has begun the close process'); },
      onClosed:function(){ alert('onClosed: colorbox has completely closed'); }
    });

    $('.non-retina').colorbox({rel:'group5', transition:'none'})
    $('.retina').colorbox({rel:'group5', transition:'none', retinaImage:true, retinaUrl:true});
    
    
    $("#click").click(function(){ 
      $('#click').css({"background-color":"#f00", "color":"#fff", "cursor":"inherit"}).text("Open this window again and this message will still be here.");
      return false;
    });
  });
</script>

 
<?php if(selected_lang()->rtl == 0): ?>
  <script src="<?php echo e(url('js/slider.js')); ?>"></script>
<?php else: ?>
  <script src="<?php echo e(url('js/slider-rtl.js')); ?>"></script>
<?php endif; ?>

<script>
  $('.btn-search').click(function(){
    $('.searchbar').toggleClass('clicked');    
    if($('.searchbar').hasClass('clicked')){
      $('.btn-extended').focus();
    } 
  });
</script>
<script>
  $( function() {
    $("#searchbar").autocomplete({
    source: function(request, response) {
      $.ajax({
        url:  "<?php echo e(route('quick.search')); ?>",
        data: {
          search: request.term
        },
        dataType: "json",
        success: function(data) {
          var resp = $.map(data, function(obj) {
            return {
              label: obj.value,
              value: obj.value,
              url: obj.url
            }
          });
          response(resp);
        }
      });
    },
    select: function(event, ui) {
      if(ui.item.value != 'No Result found') {
        event.preventDefault();
        location.href = ui.item.url;
      } else {
        return false;
      }
    },
    html: true,
    open: function(event, ui) {
      $(".ui-autocomplete").css("z-index", 1000);
    },
  });
  });
  </script>
<script>
  $(window).scroll(function() {    
    var scroll = $(window).scrollTop();

    if (scroll >= 10) {
        $(".navigation").addClass("scrolling");
    } else {
        $(".navigation").removeClass("scrolling");
    }
  });
</script>
<!------- end colorbox script----------->
<!---- facebook chat ------->

<?php if(isset($messanger_settings) && $messanger_settings->enable_messanger == 1): ?>
<script src="<?php echo e($messanger_settings->script); ?>" async></script>
<?php endif; ?>

<!----- end facebook --------->

<script type="module">
  // Import the functions you need from the SDKs you need
  import { initializeApp } from "https://www.gstatic.com/firebasejs/9.0.2/firebase-app.js";
  import { getAnalytics } from "https://www.gstatic.com/firebasejs/9.0.2/firebase-analytics.js";
  // TODO: Add SDKs for Firebase products that you want to use
  // https://firebase.google.com/docs/web/setup#available-libraries

  // Your web app's Firebase configuration
  // For Firebase JS SDK v7.20.0 and later, measurementId is optional
  const firebaseConfig = {
    apiKey: "AIzaSyDLe6RkThxCzOd15pVXyx0h7eS9yY1plMQ",
    authDomain: "nexthour-f7e37.firebaseapp.com",
    databaseURL: "https://nexthour-f7e37-default-rtdb.firebaseio.com",
    projectId: "nexthour-f7e37",
    storageBucket: "nexthour-f7e37.appspot.com",
    messagingSenderId: "298634076382",
    appId: "1:298634076382:web:1aeb4ed1ec7f34d184624f",
    measurementId: "G-G8M7XMQ3DV"
  };

  // Initialize Firebase
  const app = initializeApp(firebaseConfig);
  const analytics = getAnalytics(app);
</script>
</body>
<!--body end -->
</html><?php /**PATH /var/www/html/belhana/resources/views/layouts/theme.blade.php ENDPATH**/ ?>