"""
Django settings for fantasy project.

Generated by 'django-admin startproject' using Django 5.2.

For more information on this file, see
https://docs.djangoproject.com/en/5.2/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/5.2/ref/settings/
"""

import os
from pathlib import Path

# Build paths inside the project like this: BASE_DIR / 'subdir'.
BASE_DIR = Path(__file__).resolve().parent.parent


# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/5.2/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = 'django-insecure-0m5)33rzs%%ipiz_3d+eqd%%2j^f-ahx_vj3z32aoju!1t%%(h'
DEBUG = False
# SECURITY WARNING: don't run with debug turned on in production!
ALLOWED_HOSTS = ['api.fantasycoach.net',]
# ALLOWED_HOSTS = [
#    'fantasycoach.net',
#    'www.fantasycoach.net',
# ]
   # 'fantasyapi.nxtserver.com',


CORS_ALLOW_ALL_ORIGINS = True
CORS_ALLOW_CREDENTIALS = True


# Application definition

INSTALLED_APPS = [
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    'rest_framework',
    'fantasy_api.apps.FantasyApiConfig',
    'fantasy_data.apps.FantasyDataConfig',
    'django_crontab', 
    'players.apps.PlayersConfig',
    'squad.apps.SquadConfig',
    'teams.apps.TeamsConfig',
    'corsheaders',
]

MIDDLEWARE = [
    'django.middleware.security.SecurityMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
    'corsheaders.middleware.CorsMiddleware',
    'django.middleware.common.CommonMiddleware',
]

ROOT_URLCONF = 'fantasy.urls'

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    },
]

WSGI_APPLICATION = 'fantasy.wsgi.application'


# Database
# https://docs.djangoproject.com/en/5.2/ref/settings/#databases

DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.sqlite3',
        'NAME': BASE_DIR / 'db.sqlite3',
    }
}

LOG_DIR = os.path.join(BASE_DIR, 'logs')  # Ensure 'logs' directory is within your project

LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,
    'formatters': {
        'verbose': {
            'format': '%(asctime)s - %(name)s - %(levelname)s - %(message)s',
        },
    },
    'handlers': {
        'file': {
            'level': 'INFO',
            'class': 'logging.FileHandler',
            'filename': os.path.join(LOG_DIR, 'fpl_data.log'),  # Use the LOG_DIR
            'formatter': 'verbose',
        }
    },
    'loggers': {
        'fpl_data': {  # This will catch logs from the module where the logger is defined
            'handlers': ['file'],  # send logs to both file and console
            'level': 'INFO',
            'propagate': False, # Important: prevent duplicate logs
        },
         'django': {  # Default Django logger
            'handlers': ['file'],
            'level': 'INFO',  # Or any other level you want
            'propagate': True,
        },
    },
}


# Password validation
# https://docs.djangoproject.com/en/5.2/ref/settings/#auth-password-validators

AUTH_PASSWORD_VALIDATORS = [
    {
        'NAME': 'django.contrib.auth.password_validation.UserAttributeSimilarityValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.MinimumLengthValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.CommonPasswordValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.NumericPasswordValidator',
    },
]



# Internationalization
# https://docs.djangoproject.com/en/5.2/topics/i18n/

LANGUAGE_CODE = 'en-us'

TIME_ZONE = 'Europe/London'

USE_I18N = True

USE_TZ = True


# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/5.2/howto/static-files/

STATIC_URL = 'static/'
STATIC_ROOT = '/var/www/html/fantasy/fantasy_api/static/' # This MUST match your Apache Alias target

# Default primary key field type
# https://docs.djangoproject.com/en/5.2/ref/settings/#default-auto-field

DEFAULT_AUTO_FIELD = 'django.db.models.BigAutoField'

FPL_DATA_FILE = os.path.join(BASE_DIR, 'data/fpl_data.json')
FPL_PLAYERS_FILE = os.path.join(BASE_DIR, 'data/fpl_players.json')
MODEL_PREDICTION_FOLDER = os.path.join(BASE_DIR, 'data/predictions/')
FPL_TEAMS_FILE = os.path.join(BASE_DIR, 'data/fpl_teams.json')
FPL_GAMEWEEKS_FILE = os.path.join(BASE_DIR, 'data/fpl_gameweeks.json')
FPL_FIXTIRES_FILE = os.path.join(BASE_DIR, 'data/fpl_fixtures.json')
FPL_UPCOMING_TEAM_FIXTIRES_DIFFICULTY_FILE = os.path.join(BASE_DIR, 'data/fpl_team_upcoming_fixtures.json')
DREAM_TEAM_FOLDER= os.path.join(BASE_DIR, 'data/dream_team/')
INFO_FILE= os.path.join(BASE_DIR, 'data/info.json')

# Django-crontab settings to schedule the data fetch
# CRONJOBS = [
#     ('0 2 * * *', 'fantasy_data.cron.update_fpl_data',),
# ]
REST_FRAMEWORK = {
    'DEFAULT_RENDERER_CLASSES': [
        'rest_framework.renderers.JSONRenderer',
    ],
}
CRONJOBS = [
   ('0 2 * * *', 'fantasy_data.cron.update_fpl_data',),
]
#     
