from django.shortcuts import render

# Create your views here.
from django.shortcuts import render
from rest_framework.response import Response
from rest_framework.decorators import api_view
from . import services 
from fantasy_data.services import load_info
# Create your views here.

@api_view(['GET'])
def get_all_stats(request):
    """
    List all gamewweks statistics.
    """
    gameweeks = services.get_all_gameweeks_data()
    return Response(gameweeks)

@api_view(['GET'])
def get_gameweek_stats(request,id):
    """
    Get gameweek statistics by id.
    """
    gameweek_stats = services.get_gameweek_stats(id)
    return Response(gameweek_stats)
@api_view(['GET'])
def get_current(request):
    """
    Get gameweek statistics by id.
    """
    info = load_info()
    gameweek_stats = services.get_gameweek_stats(info["gw"])
    return Response({"gw":gameweek_stats["id"], 'deadline': gameweek_stats['deadline_time'],'deadline_epoch': gameweek_stats['deadline_time_epoch']})

@api_view(['GET'])
def get_gameweek_fixtures(request,id):
    """
    Get gameweek fixtures.
    """
    fixtures = services.get_gameweek_fixtures(id)
    return Response(fixtures)