import json
from rest_framework.decorators import api_view
from rest_framework.views import APIView
from rest_framework.response import Response 
#from fantasy_data.tasks import load_fpl_data
from . import services
from django.core.paginator import Paginator, EmptyPage

@api_view(['GET'])
def get_players(request):
    fpl_data = services.get_players_data()
    queryParams = request.query_params
    return Response({'Players': fpl_data,})
    # if fpl_data :
    #     paginator = Paginator(fpl_data, 30)
    #     try:
    #         page_number = queryParams.get('page', 1)
    #         page_content = paginator.page(page_number)
    #         fpl_data = page_content.object_list
    #     except EmptyPage:
    #         fpl_data = []
    #         return Response({'Players': fpl_data,'error':"No More Players"}, status=404)
    #     return Response({'Players': fpl_data,'page':page_number,"page_size":30,"total_pages":paginator.num_pages,'total_item':paginator.count,"has_next":page_content.has_next(),"has_previous":page_content.has_previous()}, status=200)

@api_view(['GET'])
def get_unavailvle_players(request):
    fpl_data = services.get_unavailable_players_data()
    if fpl_data :
        paginator = Paginator(fpl_data, 30)
        try:
            page_number = request.query_params.get('page', 1)
            page_content = paginator.page(page_number)
            fpl_data = page_content.object_list
        except EmptyPage:
            fpl_data = []
            return Response({'Players': fpl_data,'error':"No More Players"}, status=404)
        return Response({'Players': fpl_data,'page':page_number,"page_size":30,"total_pages":paginator.num_pages,'total_item':paginator.count,"has_next":page_content.has_next(),"has_previous":page_content.has_previous()}, status=200)

@api_view(['GET'])
def get_player_stats(request,id):
    data = services.get_player_stats(id)
    return Response(data, status=200)

@api_view(['GET'])
def get_player_history(request,id):
    data = services.get_player_history(id)
    return Response(data, status=200)


# @api_view(['GET'])
# def get_players(request):
#     fpl_data = get_players_data()
#     queryParams = request.query_params
#     if fpl_data :
#         if queryParams:    
#             fpl_data = filter_data(fpl_data, queryParams)
#         # Pagination
#         paginator = Paginator(fpl_data, 30)
#         try:
#             page_number = queryParams.get('page', 1)
#             page_content = paginator.page(page_number)
#             fpl_data = page_content.object_list
#         except EmptyPage:
#             fpl_data = []
#             return Response({'Players': fpl_data,'error':"No More Players"}, status=404)
#         return Response({'Players': fpl_data,'page':page_number,"page_size":30,"total_pages":paginator.num_pages,'total_item':paginator.count,"has_next":page_content.has_next(),"has_previous":page_content.has_previous()}, status=200)
#     return Response({'error': 'FPL player data not available.'}, status=500)

#
#def filter_data(data, queryParams):
    # '''Manipulate the data based on query parameters.
    # This function can be customized to perform various operations'''
    # # Example manipulation: Convert all player names to uppercase
    # # Filter by
    # filtered_data = []
    # for player in data:
    #     if 'team' in queryParams and player['Team'] != queryParams['Team']:
    #         continue
    #     if 'position' in queryParams and player['Position'] != queryParams['position']:
    #         continue
    #     if 'price' in queryParams and player['Price'] > float(queryParams['price']):
    #         continue
    #     if 'form' in queryParams and float(player['Form']) > float(queryParams['form']):
    #         continue
    #     if 'search' in queryParams and player['Player Name'].lower().find(queryParams['search'].lower()) == -1:
    #         continue
    #     filtered_data.append(player)
    # return filtered_data