from django.shortcuts import render
from rest_framework.response import Response
from rest_framework.decorators import api_view
from . import services 
# Create your views here.

@api_view(['GET'])
def get_teams(request):
    """
    List all teams.
    """
    teams_list = services.get_teams_data()
    return Response(teams_list)

@api_view(['GET'])
def get_team(request,id):
    """
    Get Team by id.
    """
    team = services.get_team_data(id)
    return Response(team)