
# # fpl_api/views.py
# import json
# from django.conf import settings
# from django.http import JsonResponse

# def get_plaayers(request):
#     try:
#         with open(settings.FPL_DATA_FILE, 'r') as f:
#             fpl_data = json.load(f)
#         players = fpl_data or []
#         return JsonResponse({'Players': players}, status=200)
#     except FileNotFoundError:
#         return JsonResponse({'error': 'FPL data not yet available.'}, status=503)
#     except Exception as e:
#         return JsonResponse({'error': f'Error processing data: {e}'}, status=500)

# # Add more views for other FPL data like players, events, etc.
import json
from rest_framework.decorators import api_view
from rest_framework.response import Response
#from fantasy_data.tasks import load_fpl_data
from .services import get_players_data,pick_random_team,pick_team

@api_view(['GET'])
def get_players(request):
    fpl_data = get_players_data()
    if fpl_data :
        return Response(fpl_data)
    return Response({'error': 'FPL player data not available.'}, status=500)

@api_view(['GET'])
def get_random_team(request):
    team = pick_random_team()
    if team :
        return Response(team)
    return Response({'error': 'Could not generate a valid team with the given constraints.'}, status=500)

@api_view(['POST'])
def select_team(request):
    team = request.data
    formation = pick_team(team)
    return Response(formation)
