from django.core.management.base import BaseCommand
from fantasy_data.services import fetch_fpl_data, save_fpl_data
import logging
logger = logging.getLogger("fpl_data")  # Get the logger for the current module
class Command(BaseCommand):
    help = 'Fetches and updates FPL data'

    def handle(self, *args, **options):
        """
        Fetches FPL data, saves it, and logs the result.
        """
        self.stdout.write(self.style.SUCCESS('Fetching FPL data...'))
        logger.info('Starting FPL data update...')
        data = fetch_fpl_data()
        if data:
            save_fpl_data(data)
            logger.info('FPL data update completed successfully.')
            self.stdout.write(self.style.SUCCESS('FPL data updated successfully.'))

        else:
            logger.error(f'Error during FPL data update')  # Log the error