# Fantasy API

[![MIT License](https://img.shields.io/badge/license-MIT-blue.svg)](LICENSE)

A Django-powered API for Fantasy Premier League (FPL) fans. Fetch, process, and play around with FPL data — build random squads, get player stats, and generate valid team formations like a manager on a mission.

---

## Features

- **Fetch Players:** Pull live player data from the official FPL API
- **Get Players:** Return stored player data 
- **Random Team:** Generate a random squad 
- **Select Team:** Smart team selection with formation (Starting XI + Subs)

---

## Tech Stack

- **Python 3.x**
- **Django 5.x**
- **DRF 3.x**
- **Pipenv** for dependency management
- **SQLite** for local database (default)

---

## Getting Started

### 1. Clone the Repository

```bash
git clone https://github.com/yourusername/fantasy-api.git
cd fantasy-api
```
### 2. Install Dependencies

```bash
pip install pipenv
pipenv install
pipenv shell
```
### 3. Run Migration

```bash
py manage.py migrate
```

### 4. Run Scheduled Task
 - invoke the command in a seperate terminal
```bash
python manage.py update_fpl_data 
```

### 5. Start Server

```bash
py manage.py runserver
```

---

## API Endpoints
| Method | Endpoint                               | Description                                 |
|--------|----------------------------------------|---------------------------------------------|
| GET    | api/players/                           | Get all players                             |
| GET    | api/players/<int:id>/stats             | Get stats for a specific player             |
| GET    | api/players/<int:id>/history           | Get history for a specific player           |
| GET    | api/players/unavailable                | Get unavailable players                     |
| GET    | api/squad/suggested-squad              | Get a suggested squad                       |
| POST   | api/squad/squad-selected               | Submit a selected squad                     |
| GET    | api/teams/                             | Get all teams                               |
| GET    | api/teams/<int:id>                     | Get details for a specific team             |
| GET    | api/gameweeks/                         | Get all gameweek stats                      |
| GET    | api/gameweeks/<int:id>                 | Get stats for a specific gameweek           |
| GET    | api/gameweeks/<int:id>/fixtures        | Get fixtures for a specific gameweek        |
