import logging
import sys
import os
from logging.handlers import RotatingFileHandler
from pythonjsonlogger import jsonlogger


def setup_logging():
    """
    Set up logging configuration for the application.

    Sets up a JSON formatter for logs, and outputs to rotating files
    """
    log_level_str = os.getenv('LOG_LEVEL', 'INFO').upper()
    log_level = getattr(logging, log_level_str, logging.INFO)
    
    # Create a logger
    logger = logging.getLogger()
    logger.setLevel(log_level)

    # Json log format
    fornatter = jsonlogger.JsonFormatter(
        fmt='%(asctime)s %(name)s %(levelname)s %(message)s',
    )

    
    # Create file handler with rotation
    if not os.path.exists('logs'):
        os.makedirs('logs')
    file_handler = RotatingFileHandler('logs/model.log', maxBytes=10*1024*1024, backupCount=5)
    file_handler.setFormatter(fornatter)
    file_handler.setLevel(log_level)

    if not logger.handlers:
        logger.addHandler(file_handler)
    
    logging.info("Logging setup complete with level: %s", log_level_str)
