from .utills.parsers import *
from .utills.cleaners import *
from .utills.getters import *
from .utills.collector import collect_gw, merge_gw
import csv
import os
import logging
logger = logging.getLogger(__name__)

def update_data():
    """ Parse and store all the data
    """
    season = '2025-26'
    base_filename = 'data/raw/' + season + '/'
    os.makedirs(base_filename, exist_ok=True)

    logger.info("Getting data")
    data = get_data()
    logger.info("Parsing summary data")
    parse_players(data["elements"], base_filename)
    xPoints = []
    for e in data["elements"]:
        xPoint = {}
        xPoint['id'] = e['id']
        xPoint['xP'] = e['ep_this']
        xPoints += [xPoint]
    gw_num = 0
    events = data["events"]
    for event in events:
        if event["is_current"] == True:
            gw_num = event["id"]
    logger.info("Current Gw : {}".format(gw_num))
    logger.info("Cleaning summary data")
    clean_players(base_filename + 'players_raw.csv', base_filename)
    logger.info("Getting fixtures data")
    fixtures(base_filename)
    logger.info("Getting teams data")
    parse_team_data(data["teams"], base_filename)
    logger.info("Extracting player ids")
    id_players(base_filename + 'players_raw.csv', base_filename)
    player_ids = get_player_ids(base_filename)
    num_players = len(data["elements"])
    player_base_filename = base_filename + 'players/'
    gw_base_filename = base_filename + 'gws/'
    logger.info("Extracting player specific data")
    for i,name in player_ids.items():
        player_data = get_individual_player_data(i)
        parse_player_history(player_data["history_past"], player_base_filename, name, i)
        parse_player_gw_history(player_data["history"], player_base_filename, name, i)
    if gw_num > 0:
        logger.info("Writing expected points")
        with open(os.path.join(gw_base_filename, 'xP' + str(gw_num) + '.csv'), 'w+') as outf:
            w = csv.DictWriter(outf, ['id', 'xP'])
            w.writeheader()
            for xp in xPoints:
                w.writerow(xp)
        logger.info("Collecting gw scores")
        collect_gw(gw_num, player_base_filename, gw_base_filename, base_filename) 
        logger.info("Merging gw scores")
        merge_gw(gw_num, gw_base_filename)

def fixtures(base_filename):
    data = get_fixtures_data()
    parse_fixtures(data, base_filename)


if __name__ == "__main__":
    update_data()
