<?php
session_start();
$username = isset( $_SESSION['username'] ) ? $_SESSION['username'] : "";
if ( !$username ) {
	exit('logout');
}
include 'config.php';
include 'init.php';
if ( ADMIN_DEMO ) {
	exit('ADMIN DEMO');
}
if ( !USER_ADMIN ) {
	exit('access forbidden!');
}
$str = '<?xml version="1.0" encoding="UTF-8"?>
<urlset
    xmlns="http://www.sitemaps.org/schemas/sitemap/0.9"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
    xsi:schemaLocation="http://www.sitemaps.org/schemas/sitemap/0.9
    http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd">
<!-- generated by CloudArcade -->';

//domain
$str = $str.'
<url>
	<loc>'.DOMAIN.'</loc>
	<priority>1.00</priority>
</url>';
//categories
$cats = get_all_categories();
foreach ($cats as $cat) {
	if (strpos($cat->slug, '&') == false) {
		$str = $str.'
		<url>
			<loc>'.get_permalink('category', $cat->slug).'</loc>
			<changefreq>weekly</changefreq>
		</url>';
	}
}
//games
$conn = new PDO(DB_DSN, DB_USERNAME, DB_PASSWORD);
$conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
$sql = "SELECT slug FROM games";
$st = $conn->prepare($sql);
$st->execute();
$games = $st -> fetchAll();
$conn = null;
foreach ($games as $game) {
	if (strpos($game['slug'], '&') == false) {
		$str = $str.'
		<url>
			<loc>'.get_permalink('game', $game['slug']).'</loc>
		</url>';
	}
}
$str = $str.'</urlset>';

$sitemap = fopen("sitemap.xml", "w") or die("Unable to open file!");
$content = $str;
fwrite($sitemap, $content);
fclose($sitemap);

header('Location: sitemap.xml');

?>