<?php
/**
 * DefaultApi
 * PHP version 7.3
 *
 * @category Class
 * @package  onesignal\client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OneSignal
 *
 * A powerful way to send personalized messages at scale and build effective customer engagement strategies. Learn more at onesignal.com
 *
 * The version of the OpenAPI document: 1.2.2
 * Contact: devrel@onesignal.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0-SNAPSHOT
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace onesignal\client\api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use onesignal\client\ApiException;
use onesignal\client\Configuration;
use onesignal\client\HeaderSelector;
use onesignal\client\ObjectSerializer;

/**
 * DefaultApi Class Doc Comment
 *
 * @category Class
 * @package  onesignal\client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class DefaultApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation beginLiveActivity
     *
     * Start Live Activity
     *
     * @param  string $app_id The OneSignal App ID for your app.  Available in Keys &amp; IDs. (required)
     * @param  string $activity_id Live Activity record ID (required)
     * @param  \onesignal\client\model\BeginLiveActivityRequest $begin_live_activity_request begin_live_activity_request (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function beginLiveActivity($app_id, $activity_id, $begin_live_activity_request)
    {
        $this->beginLiveActivityWithHttpInfo($app_id, $activity_id, $begin_live_activity_request);
    }

    /**
     * Operation beginLiveActivityWithHttpInfo
     *
     * Start Live Activity
     *
     * @param  string $app_id The OneSignal App ID for your app.  Available in Keys &amp; IDs. (required)
     * @param  string $activity_id Live Activity record ID (required)
     * @param  \onesignal\client\model\BeginLiveActivityRequest $begin_live_activity_request (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function beginLiveActivityWithHttpInfo($app_id, $activity_id, $begin_live_activity_request)
    {
        $request = $this->beginLiveActivityRequest($app_id, $activity_id, $begin_live_activity_request);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\GenericError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\RateLimiterError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation beginLiveActivityAsync
     *
     * Start Live Activity
     *
     * @param  string $app_id The OneSignal App ID for your app.  Available in Keys &amp; IDs. (required)
     * @param  string $activity_id Live Activity record ID (required)
     * @param  \onesignal\client\model\BeginLiveActivityRequest $begin_live_activity_request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function beginLiveActivityAsync($app_id, $activity_id, $begin_live_activity_request)
    {
        return $this->beginLiveActivityAsyncWithHttpInfo($app_id, $activity_id, $begin_live_activity_request)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation beginLiveActivityAsyncWithHttpInfo
     *
     * Start Live Activity
     *
     * @param  string $app_id The OneSignal App ID for your app.  Available in Keys &amp; IDs. (required)
     * @param  string $activity_id Live Activity record ID (required)
     * @param  \onesignal\client\model\BeginLiveActivityRequest $begin_live_activity_request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function beginLiveActivityAsyncWithHttpInfo($app_id, $activity_id, $begin_live_activity_request)
    {
        $returnType = '';
        $request = $this->beginLiveActivityRequest($app_id, $activity_id, $begin_live_activity_request);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'beginLiveActivity'
     *
     * @param  string $app_id The OneSignal App ID for your app.  Available in Keys &amp; IDs. (required)
     * @param  string $activity_id Live Activity record ID (required)
     * @param  \onesignal\client\model\BeginLiveActivityRequest $begin_live_activity_request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function beginLiveActivityRequest($app_id, $activity_id, $begin_live_activity_request)
    {
        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling beginLiveActivity'
            );
        }
        // verify the required parameter 'activity_id' is set
        if ($activity_id === null || (is_array($activity_id) && count($activity_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $activity_id when calling beginLiveActivity'
            );
        }
        // verify the required parameter 'begin_live_activity_request' is set
        if ($begin_live_activity_request === null || (is_array($begin_live_activity_request) && count($begin_live_activity_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $begin_live_activity_request when calling beginLiveActivity'
            );
        }

        $resourcePath = '/apps/{app_id}/live_activities/{activity_id}/token';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'app_id' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }
        // path params
        if ($activity_id !== null) {
            $resourcePath = str_replace(
                '{' . 'activity_id' . '}',
                ObjectSerializer::toPathValue($activity_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($begin_live_activity_request)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($begin_live_activity_request));
            } else {
                $httpBody = $begin_live_activity_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        if (!empty($this->config->getAppKeyToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAppKeyToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        // Adding the telemetry header
        $defaultHeaders['OS-Usage-Data'] = 'kind=sdk, sdk-name=onesignal-php, version=1.2.2';

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation cancelNotification
     *
     * Stop a scheduled or currently outgoing notification
     *
     * @param  string $app_id app_id (required)
     * @param  string $notification_id notification_id (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \onesignal\client\model\CancelNotificationSuccessResponse|\onesignal\client\model\GenericError|\onesignal\client\model\RateLimiterError
     */
    public function cancelNotification($app_id, $notification_id)
    {
        list($response) = $this->cancelNotificationWithHttpInfo($app_id, $notification_id);
        return $response;
    }

    /**
     * Operation cancelNotificationWithHttpInfo
     *
     * Stop a scheduled or currently outgoing notification
     *
     * @param  string $app_id (required)
     * @param  string $notification_id (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \onesignal\client\model\CancelNotificationSuccessResponse|\onesignal\client\model\GenericError|\onesignal\client\model\RateLimiterError, HTTP status code, HTTP response headers (array of strings)
     */
    public function cancelNotificationWithHttpInfo($app_id, $notification_id)
    {
        $request = $this->cancelNotificationRequest($app_id, $notification_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\onesignal\client\model\CancelNotificationSuccessResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\CancelNotificationSuccessResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\CancelNotificationSuccessResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\onesignal\client\model\GenericError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\GenericError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\GenericError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\onesignal\client\model\RateLimiterError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\RateLimiterError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\RateLimiterError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\onesignal\client\model\CancelNotificationSuccessResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\CancelNotificationSuccessResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\GenericError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\RateLimiterError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation cancelNotificationAsync
     *
     * Stop a scheduled or currently outgoing notification
     *
     * @param  string $app_id (required)
     * @param  string $notification_id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function cancelNotificationAsync($app_id, $notification_id)
    {
        return $this->cancelNotificationAsyncWithHttpInfo($app_id, $notification_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation cancelNotificationAsyncWithHttpInfo
     *
     * Stop a scheduled or currently outgoing notification
     *
     * @param  string $app_id (required)
     * @param  string $notification_id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function cancelNotificationAsyncWithHttpInfo($app_id, $notification_id)
    {
        $returnType = '\onesignal\client\model\CancelNotificationSuccessResponse';
        $request = $this->cancelNotificationRequest($app_id, $notification_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'cancelNotification'
     *
     * @param  string $app_id (required)
     * @param  string $notification_id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function cancelNotificationRequest($app_id, $notification_id)
    {
        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling cancelNotification'
            );
        }
        // verify the required parameter 'notification_id' is set
        if ($notification_id === null || (is_array($notification_id) && count($notification_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $notification_id when calling cancelNotification'
            );
        }

        $resourcePath = '/notifications/{notification_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $app_id,
            'app_id', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);


        // path params
        if ($notification_id !== null) {
            $resourcePath = str_replace(
                '{' . 'notification_id' . '}',
                ObjectSerializer::toPathValue($notification_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        if (!empty($this->config->getAppKeyToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAppKeyToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        // Adding the telemetry header
        $defaultHeaders['OS-Usage-Data'] = 'kind=sdk, sdk-name=onesignal-php, version=1.2.2';

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createApp
     *
     * Create an app
     *
     * @param  \onesignal\client\model\App $app app (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \onesignal\client\model\App|\onesignal\client\model\GenericError|\onesignal\client\model\RateLimiterError
     */
    public function createApp($app)
    {
        list($response) = $this->createAppWithHttpInfo($app);
        return $response;
    }

    /**
     * Operation createAppWithHttpInfo
     *
     * Create an app
     *
     * @param  \onesignal\client\model\App $app (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \onesignal\client\model\App|\onesignal\client\model\GenericError|\onesignal\client\model\RateLimiterError, HTTP status code, HTTP response headers (array of strings)
     */
    public function createAppWithHttpInfo($app)
    {
        $request = $this->createAppRequest($app);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\onesignal\client\model\App' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\App' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\App', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\onesignal\client\model\GenericError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\GenericError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\GenericError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\onesignal\client\model\RateLimiterError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\RateLimiterError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\RateLimiterError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\onesignal\client\model\App';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\App',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\GenericError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\RateLimiterError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createAppAsync
     *
     * Create an app
     *
     * @param  \onesignal\client\model\App $app (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createAppAsync($app)
    {
        return $this->createAppAsyncWithHttpInfo($app)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createAppAsyncWithHttpInfo
     *
     * Create an app
     *
     * @param  \onesignal\client\model\App $app (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createAppAsyncWithHttpInfo($app)
    {
        $returnType = '\onesignal\client\model\App';
        $request = $this->createAppRequest($app);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createApp'
     *
     * @param  \onesignal\client\model\App $app (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createAppRequest($app)
    {
        // verify the required parameter 'app' is set
        if ($app === null || (is_array($app) && count($app) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app when calling createApp'
            );
        }

        $resourcePath = '/apps';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($app)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($app));
            } else {
                $httpBody = $app;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        if (!empty($this->config->getUserKeyToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getUserKeyToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        // Adding the telemetry header
        $defaultHeaders['OS-Usage-Data'] = 'kind=sdk, sdk-name=onesignal-php, version=1.2.2';

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createNotification
     *
     * Create notification
     *
     * @param  \onesignal\client\model\Notification $notification notification (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \onesignal\client\model\CreateNotificationSuccessResponse|\onesignal\client\model\GenericError|\onesignal\client\model\RateLimiterError
     */
    public function createNotification($notification)
    {
        list($response) = $this->createNotificationWithHttpInfo($notification);
        return $response;
    }

    /**
     * Operation createNotificationWithHttpInfo
     *
     * Create notification
     *
     * @param  \onesignal\client\model\Notification $notification (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \onesignal\client\model\CreateNotificationSuccessResponse|\onesignal\client\model\GenericError|\onesignal\client\model\RateLimiterError, HTTP status code, HTTP response headers (array of strings)
     */
    public function createNotificationWithHttpInfo($notification)
    {
        $request = $this->createNotificationRequest($notification);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\onesignal\client\model\CreateNotificationSuccessResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\CreateNotificationSuccessResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\CreateNotificationSuccessResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\onesignal\client\model\GenericError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\GenericError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\GenericError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\onesignal\client\model\RateLimiterError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\RateLimiterError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\RateLimiterError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\onesignal\client\model\CreateNotificationSuccessResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\CreateNotificationSuccessResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\GenericError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\RateLimiterError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createNotificationAsync
     *
     * Create notification
     *
     * @param  \onesignal\client\model\Notification $notification (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createNotificationAsync($notification)
    {
        return $this->createNotificationAsyncWithHttpInfo($notification)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createNotificationAsyncWithHttpInfo
     *
     * Create notification
     *
     * @param  \onesignal\client\model\Notification $notification (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createNotificationAsyncWithHttpInfo($notification)
    {
        $returnType = '\onesignal\client\model\CreateNotificationSuccessResponse';
        $request = $this->createNotificationRequest($notification);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createNotification'
     *
     * @param  \onesignal\client\model\Notification $notification (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createNotificationRequest($notification)
    {
        // verify the required parameter 'notification' is set
        if ($notification === null || (is_array($notification) && count($notification) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $notification when calling createNotification'
            );
        }

        $resourcePath = '/notifications';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($notification)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($notification));
            } else {
                $httpBody = $notification;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        if (!empty($this->config->getAppKeyToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAppKeyToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        // Adding the telemetry header
        $defaultHeaders['OS-Usage-Data'] = 'kind=sdk, sdk-name=onesignal-php, version=1.2.2';

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createPlayer
     *
     * Add a device
     *
     * @param  \onesignal\client\model\Player $player player (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \onesignal\client\model\CreatePlayerSuccessResponse|\onesignal\client\model\GenericError|\onesignal\client\model\GenericError|\onesignal\client\model\RateLimiterError
     */
    public function createPlayer($player)
    {
        list($response) = $this->createPlayerWithHttpInfo($player);
        return $response;
    }

    /**
     * Operation createPlayerWithHttpInfo
     *
     * Add a device
     *
     * @param  \onesignal\client\model\Player $player (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \onesignal\client\model\CreatePlayerSuccessResponse|\onesignal\client\model\GenericError|\onesignal\client\model\GenericError|\onesignal\client\model\RateLimiterError, HTTP status code, HTTP response headers (array of strings)
     */
    public function createPlayerWithHttpInfo($player)
    {
        $request = $this->createPlayerRequest($player);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\onesignal\client\model\CreatePlayerSuccessResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\CreatePlayerSuccessResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\CreatePlayerSuccessResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\onesignal\client\model\GenericError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\GenericError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\GenericError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 409:
                    if ('\onesignal\client\model\GenericError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\GenericError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\GenericError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\onesignal\client\model\RateLimiterError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\RateLimiterError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\RateLimiterError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\onesignal\client\model\CreatePlayerSuccessResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\CreatePlayerSuccessResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\GenericError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\GenericError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\RateLimiterError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createPlayerAsync
     *
     * Add a device
     *
     * @param  \onesignal\client\model\Player $player (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPlayerAsync($player)
    {
        return $this->createPlayerAsyncWithHttpInfo($player)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createPlayerAsyncWithHttpInfo
     *
     * Add a device
     *
     * @param  \onesignal\client\model\Player $player (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPlayerAsyncWithHttpInfo($player)
    {
        $returnType = '\onesignal\client\model\CreatePlayerSuccessResponse';
        $request = $this->createPlayerRequest($player);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createPlayer'
     *
     * @param  \onesignal\client\model\Player $player (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createPlayerRequest($player)
    {
        // verify the required parameter 'player' is set
        if ($player === null || (is_array($player) && count($player) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $player when calling createPlayer'
            );
        }

        $resourcePath = '/players';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($player)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($player));
            } else {
                $httpBody = $player;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        if (!empty($this->config->getAppKeyToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAppKeyToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        // Adding the telemetry header
        $defaultHeaders['OS-Usage-Data'] = 'kind=sdk, sdk-name=onesignal-php, version=1.2.2';

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createSegments
     *
     * Create Segments
     *
     * @param  string $app_id The OneSignal App ID for your app.  Available in Keys &amp; IDs. (required)
     * @param  \onesignal\client\model\Segment $segment segment (optional)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \onesignal\client\model\CreateSegmentSuccessResponse|\onesignal\client\model\GenericError|\onesignal\client\model\CreateSegmentConflictResponse|\onesignal\client\model\RateLimiterError
     */
    public function createSegments($app_id, $segment = null)
    {
        list($response) = $this->createSegmentsWithHttpInfo($app_id, $segment);
        return $response;
    }

    /**
     * Operation createSegmentsWithHttpInfo
     *
     * Create Segments
     *
     * @param  string $app_id The OneSignal App ID for your app.  Available in Keys &amp; IDs. (required)
     * @param  \onesignal\client\model\Segment $segment (optional)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \onesignal\client\model\CreateSegmentSuccessResponse|\onesignal\client\model\GenericError|\onesignal\client\model\CreateSegmentConflictResponse|\onesignal\client\model\RateLimiterError, HTTP status code, HTTP response headers (array of strings)
     */
    public function createSegmentsWithHttpInfo($app_id, $segment = null)
    {
        $request = $this->createSegmentsRequest($app_id, $segment);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 201:
                    if ('\onesignal\client\model\CreateSegmentSuccessResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\CreateSegmentSuccessResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\CreateSegmentSuccessResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\onesignal\client\model\GenericError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\GenericError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\GenericError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 409:
                    if ('\onesignal\client\model\CreateSegmentConflictResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\CreateSegmentConflictResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\CreateSegmentConflictResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\onesignal\client\model\RateLimiterError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\RateLimiterError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\RateLimiterError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\onesignal\client\model\CreateSegmentSuccessResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\CreateSegmentSuccessResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\GenericError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\CreateSegmentConflictResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\RateLimiterError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createSegmentsAsync
     *
     * Create Segments
     *
     * @param  string $app_id The OneSignal App ID for your app.  Available in Keys &amp; IDs. (required)
     * @param  \onesignal\client\model\Segment $segment (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createSegmentsAsync($app_id, $segment = null)
    {
        return $this->createSegmentsAsyncWithHttpInfo($app_id, $segment)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createSegmentsAsyncWithHttpInfo
     *
     * Create Segments
     *
     * @param  string $app_id The OneSignal App ID for your app.  Available in Keys &amp; IDs. (required)
     * @param  \onesignal\client\model\Segment $segment (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createSegmentsAsyncWithHttpInfo($app_id, $segment = null)
    {
        $returnType = '\onesignal\client\model\CreateSegmentSuccessResponse';
        $request = $this->createSegmentsRequest($app_id, $segment);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createSegments'
     *
     * @param  string $app_id The OneSignal App ID for your app.  Available in Keys &amp; IDs. (required)
     * @param  \onesignal\client\model\Segment $segment (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createSegmentsRequest($app_id, $segment = null)
    {
        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling createSegments'
            );
        }

        $resourcePath = '/apps/{app_id}/segments';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'app_id' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($segment)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($segment));
            } else {
                $httpBody = $segment;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        if (!empty($this->config->getAppKeyToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAppKeyToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        // Adding the telemetry header
        $defaultHeaders['OS-Usage-Data'] = 'kind=sdk, sdk-name=onesignal-php, version=1.2.2';

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createSubscription
     *
     * @param  string $app_id app_id (required)
     * @param  string $alias_label alias_label (required)
     * @param  string $alias_id alias_id (required)
     * @param  \onesignal\client\model\CreateSubscriptionRequestBody $create_subscription_request_body create_subscription_request_body (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \onesignal\client\model\InlineResponse201|\onesignal\client\model\InlineResponse201|\onesignal\client\model\GenericError|\onesignal\client\model\GenericError|\onesignal\client\model\RateLimiterError
     */
    public function createSubscription($app_id, $alias_label, $alias_id, $create_subscription_request_body)
    {
        list($response) = $this->createSubscriptionWithHttpInfo($app_id, $alias_label, $alias_id, $create_subscription_request_body);
        return $response;
    }

    /**
     * Operation createSubscriptionWithHttpInfo
     *
     * @param  string $app_id (required)
     * @param  string $alias_label (required)
     * @param  string $alias_id (required)
     * @param  \onesignal\client\model\CreateSubscriptionRequestBody $create_subscription_request_body (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \onesignal\client\model\InlineResponse201|\onesignal\client\model\InlineResponse201|\onesignal\client\model\GenericError|\onesignal\client\model\GenericError|\onesignal\client\model\RateLimiterError, HTTP status code, HTTP response headers (array of strings)
     */
    public function createSubscriptionWithHttpInfo($app_id, $alias_label, $alias_id, $create_subscription_request_body)
    {
        $request = $this->createSubscriptionRequest($app_id, $alias_label, $alias_id, $create_subscription_request_body);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 201:
                    if ('\onesignal\client\model\InlineResponse201' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\InlineResponse201' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\InlineResponse201', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 202:
                    if ('\onesignal\client\model\InlineResponse201' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\InlineResponse201' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\InlineResponse201', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\onesignal\client\model\GenericError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\GenericError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\GenericError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 409:
                    if ('\onesignal\client\model\GenericError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\GenericError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\GenericError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\onesignal\client\model\RateLimiterError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\RateLimiterError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\RateLimiterError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\onesignal\client\model\InlineResponse201';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\InlineResponse201',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 202:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\InlineResponse201',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\GenericError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\GenericError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\RateLimiterError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createSubscriptionAsync
     *
     * @param  string $app_id (required)
     * @param  string $alias_label (required)
     * @param  string $alias_id (required)
     * @param  \onesignal\client\model\CreateSubscriptionRequestBody $create_subscription_request_body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createSubscriptionAsync($app_id, $alias_label, $alias_id, $create_subscription_request_body)
    {
        return $this->createSubscriptionAsyncWithHttpInfo($app_id, $alias_label, $alias_id, $create_subscription_request_body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createSubscriptionAsyncWithHttpInfo
     *
     * @param  string $app_id (required)
     * @param  string $alias_label (required)
     * @param  string $alias_id (required)
     * @param  \onesignal\client\model\CreateSubscriptionRequestBody $create_subscription_request_body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createSubscriptionAsyncWithHttpInfo($app_id, $alias_label, $alias_id, $create_subscription_request_body)
    {
        $returnType = '\onesignal\client\model\InlineResponse201';
        $request = $this->createSubscriptionRequest($app_id, $alias_label, $alias_id, $create_subscription_request_body);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createSubscription'
     *
     * @param  string $app_id (required)
     * @param  string $alias_label (required)
     * @param  string $alias_id (required)
     * @param  \onesignal\client\model\CreateSubscriptionRequestBody $create_subscription_request_body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createSubscriptionRequest($app_id, $alias_label, $alias_id, $create_subscription_request_body)
    {
        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling createSubscription'
            );
        }
        // verify the required parameter 'alias_label' is set
        if ($alias_label === null || (is_array($alias_label) && count($alias_label) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $alias_label when calling createSubscription'
            );
        }
        // verify the required parameter 'alias_id' is set
        if ($alias_id === null || (is_array($alias_id) && count($alias_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $alias_id when calling createSubscription'
            );
        }
        // verify the required parameter 'create_subscription_request_body' is set
        if ($create_subscription_request_body === null || (is_array($create_subscription_request_body) && count($create_subscription_request_body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $create_subscription_request_body when calling createSubscription'
            );
        }

        $resourcePath = '/apps/{app_id}/users/by/{alias_label}/{alias_id}/subscriptions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'app_id' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }
        // path params
        if ($alias_label !== null) {
            $resourcePath = str_replace(
                '{' . 'alias_label' . '}',
                ObjectSerializer::toPathValue($alias_label),
                $resourcePath
            );
        }
        // path params
        if ($alias_id !== null) {
            $resourcePath = str_replace(
                '{' . 'alias_id' . '}',
                ObjectSerializer::toPathValue($alias_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($create_subscription_request_body)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($create_subscription_request_body));
            } else {
                $httpBody = $create_subscription_request_body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        if (!empty($this->config->getAppKeyToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAppKeyToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        // Adding the telemetry header
        $defaultHeaders['OS-Usage-Data'] = 'kind=sdk, sdk-name=onesignal-php, version=1.2.2';

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createUser
     *
     * @param  string $app_id app_id (required)
     * @param  \onesignal\client\model\User $user user (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \onesignal\client\model\User|\onesignal\client\model\User|\onesignal\client\model\User|\onesignal\client\model\GenericError|\onesignal\client\model\CreateUserConflictResponse|\onesignal\client\model\RateLimiterError
     */
    public function createUser($app_id, $user)
    {
        list($response) = $this->createUserWithHttpInfo($app_id, $user);
        return $response;
    }

    /**
     * Operation createUserWithHttpInfo
     *
     * @param  string $app_id (required)
     * @param  \onesignal\client\model\User $user (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \onesignal\client\model\User|\onesignal\client\model\User|\onesignal\client\model\User|\onesignal\client\model\GenericError|\onesignal\client\model\CreateUserConflictResponse|\onesignal\client\model\RateLimiterError, HTTP status code, HTTP response headers (array of strings)
     */
    public function createUserWithHttpInfo($app_id, $user)
    {
        $request = $this->createUserRequest($app_id, $user);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\onesignal\client\model\User' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\User' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\User', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 201:
                    if ('\onesignal\client\model\User' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\User' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\User', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 202:
                    if ('\onesignal\client\model\User' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\User' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\User', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\onesignal\client\model\GenericError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\GenericError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\GenericError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 409:
                    if ('\onesignal\client\model\CreateUserConflictResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\CreateUserConflictResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\CreateUserConflictResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\onesignal\client\model\RateLimiterError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\RateLimiterError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\RateLimiterError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\onesignal\client\model\User';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\User',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\User',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 202:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\User',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\GenericError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\CreateUserConflictResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\RateLimiterError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createUserAsync
     *
     * @param  string $app_id (required)
     * @param  \onesignal\client\model\User $user (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createUserAsync($app_id, $user)
    {
        return $this->createUserAsyncWithHttpInfo($app_id, $user)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createUserAsyncWithHttpInfo
     *
     * @param  string $app_id (required)
     * @param  \onesignal\client\model\User $user (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createUserAsyncWithHttpInfo($app_id, $user)
    {
        $returnType = '\onesignal\client\model\User';
        $request = $this->createUserRequest($app_id, $user);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createUser'
     *
     * @param  string $app_id (required)
     * @param  \onesignal\client\model\User $user (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createUserRequest($app_id, $user)
    {
        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling createUser'
            );
        }
        // verify the required parameter 'user' is set
        if ($user === null || (is_array($user) && count($user) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $user when calling createUser'
            );
        }

        $resourcePath = '/apps/{app_id}/users';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'app_id' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($user)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($user));
            } else {
                $httpBody = $user;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        if (!empty($this->config->getAppKeyToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAppKeyToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        // Adding the telemetry header
        $defaultHeaders['OS-Usage-Data'] = 'kind=sdk, sdk-name=onesignal-php, version=1.2.2';

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteAlias
     *
     * @param  string $app_id app_id (required)
     * @param  string $alias_label alias_label (required)
     * @param  string $alias_id alias_id (required)
     * @param  string $alias_label_to_delete alias_label_to_delete (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \onesignal\client\model\InlineResponse200|\onesignal\client\model\GenericError|\onesignal\client\model\GenericError|\onesignal\client\model\RateLimiterError
     */
    public function deleteAlias($app_id, $alias_label, $alias_id, $alias_label_to_delete)
    {
        list($response) = $this->deleteAliasWithHttpInfo($app_id, $alias_label, $alias_id, $alias_label_to_delete);
        return $response;
    }

    /**
     * Operation deleteAliasWithHttpInfo
     *
     * @param  string $app_id (required)
     * @param  string $alias_label (required)
     * @param  string $alias_id (required)
     * @param  string $alias_label_to_delete (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \onesignal\client\model\InlineResponse200|\onesignal\client\model\GenericError|\onesignal\client\model\GenericError|\onesignal\client\model\RateLimiterError, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteAliasWithHttpInfo($app_id, $alias_label, $alias_id, $alias_label_to_delete)
    {
        $request = $this->deleteAliasRequest($app_id, $alias_label, $alias_id, $alias_label_to_delete);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\onesignal\client\model\InlineResponse200' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\InlineResponse200' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\InlineResponse200', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\onesignal\client\model\GenericError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\GenericError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\GenericError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 409:
                    if ('\onesignal\client\model\GenericError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\GenericError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\GenericError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\onesignal\client\model\RateLimiterError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\RateLimiterError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\RateLimiterError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\onesignal\client\model\InlineResponse200';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\InlineResponse200',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\GenericError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\GenericError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\RateLimiterError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deleteAliasAsync
     *
     * @param  string $app_id (required)
     * @param  string $alias_label (required)
     * @param  string $alias_id (required)
     * @param  string $alias_label_to_delete (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteAliasAsync($app_id, $alias_label, $alias_id, $alias_label_to_delete)
    {
        return $this->deleteAliasAsyncWithHttpInfo($app_id, $alias_label, $alias_id, $alias_label_to_delete)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteAliasAsyncWithHttpInfo
     *
     * @param  string $app_id (required)
     * @param  string $alias_label (required)
     * @param  string $alias_id (required)
     * @param  string $alias_label_to_delete (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteAliasAsyncWithHttpInfo($app_id, $alias_label, $alias_id, $alias_label_to_delete)
    {
        $returnType = '\onesignal\client\model\InlineResponse200';
        $request = $this->deleteAliasRequest($app_id, $alias_label, $alias_id, $alias_label_to_delete);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteAlias'
     *
     * @param  string $app_id (required)
     * @param  string $alias_label (required)
     * @param  string $alias_id (required)
     * @param  string $alias_label_to_delete (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteAliasRequest($app_id, $alias_label, $alias_id, $alias_label_to_delete)
    {
        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling deleteAlias'
            );
        }
        // verify the required parameter 'alias_label' is set
        if ($alias_label === null || (is_array($alias_label) && count($alias_label) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $alias_label when calling deleteAlias'
            );
        }
        // verify the required parameter 'alias_id' is set
        if ($alias_id === null || (is_array($alias_id) && count($alias_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $alias_id when calling deleteAlias'
            );
        }
        // verify the required parameter 'alias_label_to_delete' is set
        if ($alias_label_to_delete === null || (is_array($alias_label_to_delete) && count($alias_label_to_delete) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $alias_label_to_delete when calling deleteAlias'
            );
        }

        $resourcePath = '/apps/{app_id}/users/by/{alias_label}/{alias_id}/identity/{alias_label_to_delete}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'app_id' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }
        // path params
        if ($alias_label !== null) {
            $resourcePath = str_replace(
                '{' . 'alias_label' . '}',
                ObjectSerializer::toPathValue($alias_label),
                $resourcePath
            );
        }
        // path params
        if ($alias_id !== null) {
            $resourcePath = str_replace(
                '{' . 'alias_id' . '}',
                ObjectSerializer::toPathValue($alias_id),
                $resourcePath
            );
        }
        // path params
        if ($alias_label_to_delete !== null) {
            $resourcePath = str_replace(
                '{' . 'alias_label_to_delete' . '}',
                ObjectSerializer::toPathValue($alias_label_to_delete),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        if (!empty($this->config->getAppKeyToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAppKeyToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        // Adding the telemetry header
        $defaultHeaders['OS-Usage-Data'] = 'kind=sdk, sdk-name=onesignal-php, version=1.2.2';

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deletePlayer
     *
     * Delete a user record
     *
     * @param  string $app_id The OneSignal App ID for your app.  Available in Keys &amp; IDs. (required)
     * @param  string $player_id The OneSignal player_id (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \onesignal\client\model\DeletePlayerSuccessResponse|\onesignal\client\model\GenericError|\onesignal\client\model\DeletePlayerNotFoundResponse|\onesignal\client\model\RateLimiterError
     */
    public function deletePlayer($app_id, $player_id)
    {
        list($response) = $this->deletePlayerWithHttpInfo($app_id, $player_id);
        return $response;
    }

    /**
     * Operation deletePlayerWithHttpInfo
     *
     * Delete a user record
     *
     * @param  string $app_id The OneSignal App ID for your app.  Available in Keys &amp; IDs. (required)
     * @param  string $player_id The OneSignal player_id (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \onesignal\client\model\DeletePlayerSuccessResponse|\onesignal\client\model\GenericError|\onesignal\client\model\DeletePlayerNotFoundResponse|\onesignal\client\model\RateLimiterError, HTTP status code, HTTP response headers (array of strings)
     */
    public function deletePlayerWithHttpInfo($app_id, $player_id)
    {
        $request = $this->deletePlayerRequest($app_id, $player_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\onesignal\client\model\DeletePlayerSuccessResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\DeletePlayerSuccessResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\DeletePlayerSuccessResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\onesignal\client\model\GenericError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\GenericError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\GenericError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\onesignal\client\model\DeletePlayerNotFoundResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\DeletePlayerNotFoundResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\DeletePlayerNotFoundResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\onesignal\client\model\RateLimiterError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\RateLimiterError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\RateLimiterError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\onesignal\client\model\DeletePlayerSuccessResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\DeletePlayerSuccessResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\GenericError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\DeletePlayerNotFoundResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\RateLimiterError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deletePlayerAsync
     *
     * Delete a user record
     *
     * @param  string $app_id The OneSignal App ID for your app.  Available in Keys &amp; IDs. (required)
     * @param  string $player_id The OneSignal player_id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deletePlayerAsync($app_id, $player_id)
    {
        return $this->deletePlayerAsyncWithHttpInfo($app_id, $player_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deletePlayerAsyncWithHttpInfo
     *
     * Delete a user record
     *
     * @param  string $app_id The OneSignal App ID for your app.  Available in Keys &amp; IDs. (required)
     * @param  string $player_id The OneSignal player_id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deletePlayerAsyncWithHttpInfo($app_id, $player_id)
    {
        $returnType = '\onesignal\client\model\DeletePlayerSuccessResponse';
        $request = $this->deletePlayerRequest($app_id, $player_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deletePlayer'
     *
     * @param  string $app_id The OneSignal App ID for your app.  Available in Keys &amp; IDs. (required)
     * @param  string $player_id The OneSignal player_id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deletePlayerRequest($app_id, $player_id)
    {
        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling deletePlayer'
            );
        }
        // verify the required parameter 'player_id' is set
        if ($player_id === null || (is_array($player_id) && count($player_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $player_id when calling deletePlayer'
            );
        }

        $resourcePath = '/players/{player_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $app_id,
            'app_id', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);


        // path params
        if ($player_id !== null) {
            $resourcePath = str_replace(
                '{' . 'player_id' . '}',
                ObjectSerializer::toPathValue($player_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        if (!empty($this->config->getAppKeyToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAppKeyToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        // Adding the telemetry header
        $defaultHeaders['OS-Usage-Data'] = 'kind=sdk, sdk-name=onesignal-php, version=1.2.2';

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteSegments
     *
     * Delete Segments
     *
     * @param  string $app_id The OneSignal App ID for your app.  Available in Keys &amp; IDs. (required)
     * @param  string $segment_id The segment_id can be found in the URL of the segment when viewing it in the dashboard. (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \onesignal\client\model\DeleteSegmentSuccessResponse|\onesignal\client\model\GenericError|\onesignal\client\model\DeleteSegmentNotFoundResponse|\onesignal\client\model\RateLimiterError
     */
    public function deleteSegments($app_id, $segment_id)
    {
        list($response) = $this->deleteSegmentsWithHttpInfo($app_id, $segment_id);
        return $response;
    }

    /**
     * Operation deleteSegmentsWithHttpInfo
     *
     * Delete Segments
     *
     * @param  string $app_id The OneSignal App ID for your app.  Available in Keys &amp; IDs. (required)
     * @param  string $segment_id The segment_id can be found in the URL of the segment when viewing it in the dashboard. (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \onesignal\client\model\DeleteSegmentSuccessResponse|\onesignal\client\model\GenericError|\onesignal\client\model\DeleteSegmentNotFoundResponse|\onesignal\client\model\RateLimiterError, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteSegmentsWithHttpInfo($app_id, $segment_id)
    {
        $request = $this->deleteSegmentsRequest($app_id, $segment_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\onesignal\client\model\DeleteSegmentSuccessResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\DeleteSegmentSuccessResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\DeleteSegmentSuccessResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\onesignal\client\model\GenericError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\GenericError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\GenericError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\onesignal\client\model\DeleteSegmentNotFoundResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\DeleteSegmentNotFoundResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\DeleteSegmentNotFoundResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\onesignal\client\model\RateLimiterError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\RateLimiterError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\RateLimiterError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\onesignal\client\model\DeleteSegmentSuccessResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\DeleteSegmentSuccessResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\GenericError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\DeleteSegmentNotFoundResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\RateLimiterError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deleteSegmentsAsync
     *
     * Delete Segments
     *
     * @param  string $app_id The OneSignal App ID for your app.  Available in Keys &amp; IDs. (required)
     * @param  string $segment_id The segment_id can be found in the URL of the segment when viewing it in the dashboard. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteSegmentsAsync($app_id, $segment_id)
    {
        return $this->deleteSegmentsAsyncWithHttpInfo($app_id, $segment_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteSegmentsAsyncWithHttpInfo
     *
     * Delete Segments
     *
     * @param  string $app_id The OneSignal App ID for your app.  Available in Keys &amp; IDs. (required)
     * @param  string $segment_id The segment_id can be found in the URL of the segment when viewing it in the dashboard. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteSegmentsAsyncWithHttpInfo($app_id, $segment_id)
    {
        $returnType = '\onesignal\client\model\DeleteSegmentSuccessResponse';
        $request = $this->deleteSegmentsRequest($app_id, $segment_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteSegments'
     *
     * @param  string $app_id The OneSignal App ID for your app.  Available in Keys &amp; IDs. (required)
     * @param  string $segment_id The segment_id can be found in the URL of the segment when viewing it in the dashboard. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteSegmentsRequest($app_id, $segment_id)
    {
        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling deleteSegments'
            );
        }
        // verify the required parameter 'segment_id' is set
        if ($segment_id === null || (is_array($segment_id) && count($segment_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $segment_id when calling deleteSegments'
            );
        }

        $resourcePath = '/apps/{app_id}/segments/{segment_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'app_id' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }
        // path params
        if ($segment_id !== null) {
            $resourcePath = str_replace(
                '{' . 'segment_id' . '}',
                ObjectSerializer::toPathValue($segment_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        if (!empty($this->config->getAppKeyToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAppKeyToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        // Adding the telemetry header
        $defaultHeaders['OS-Usage-Data'] = 'kind=sdk, sdk-name=onesignal-php, version=1.2.2';

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteSubscription
     *
     * @param  string $app_id app_id (required)
     * @param  string $subscription_id subscription_id (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteSubscription($app_id, $subscription_id)
    {
        $this->deleteSubscriptionWithHttpInfo($app_id, $subscription_id);
    }

    /**
     * Operation deleteSubscriptionWithHttpInfo
     *
     * @param  string $app_id (required)
     * @param  string $subscription_id (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteSubscriptionWithHttpInfo($app_id, $subscription_id)
    {
        $request = $this->deleteSubscriptionRequest($app_id, $subscription_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\GenericError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\GenericError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\RateLimiterError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deleteSubscriptionAsync
     *
     * @param  string $app_id (required)
     * @param  string $subscription_id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteSubscriptionAsync($app_id, $subscription_id)
    {
        return $this->deleteSubscriptionAsyncWithHttpInfo($app_id, $subscription_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteSubscriptionAsyncWithHttpInfo
     *
     * @param  string $app_id (required)
     * @param  string $subscription_id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteSubscriptionAsyncWithHttpInfo($app_id, $subscription_id)
    {
        $returnType = '';
        $request = $this->deleteSubscriptionRequest($app_id, $subscription_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteSubscription'
     *
     * @param  string $app_id (required)
     * @param  string $subscription_id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteSubscriptionRequest($app_id, $subscription_id)
    {
        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling deleteSubscription'
            );
        }
        // verify the required parameter 'subscription_id' is set
        if ($subscription_id === null || (is_array($subscription_id) && count($subscription_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $subscription_id when calling deleteSubscription'
            );
        }

        $resourcePath = '/apps/{app_id}/subscriptions/{subscription_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'app_id' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }
        // path params
        if ($subscription_id !== null) {
            $resourcePath = str_replace(
                '{' . 'subscription_id' . '}',
                ObjectSerializer::toPathValue($subscription_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        if (!empty($this->config->getAppKeyToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAppKeyToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        // Adding the telemetry header
        $defaultHeaders['OS-Usage-Data'] = 'kind=sdk, sdk-name=onesignal-php, version=1.2.2';

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteUser
     *
     * @param  string $app_id app_id (required)
     * @param  string $alias_label alias_label (required)
     * @param  string $alias_id alias_id (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteUser($app_id, $alias_label, $alias_id)
    {
        $this->deleteUserWithHttpInfo($app_id, $alias_label, $alias_id);
    }

    /**
     * Operation deleteUserWithHttpInfo
     *
     * @param  string $app_id (required)
     * @param  string $alias_label (required)
     * @param  string $alias_id (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteUserWithHttpInfo($app_id, $alias_label, $alias_id)
    {
        $request = $this->deleteUserRequest($app_id, $alias_label, $alias_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\GenericError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\GenericError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\RateLimiterError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deleteUserAsync
     *
     * @param  string $app_id (required)
     * @param  string $alias_label (required)
     * @param  string $alias_id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteUserAsync($app_id, $alias_label, $alias_id)
    {
        return $this->deleteUserAsyncWithHttpInfo($app_id, $alias_label, $alias_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteUserAsyncWithHttpInfo
     *
     * @param  string $app_id (required)
     * @param  string $alias_label (required)
     * @param  string $alias_id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteUserAsyncWithHttpInfo($app_id, $alias_label, $alias_id)
    {
        $returnType = '';
        $request = $this->deleteUserRequest($app_id, $alias_label, $alias_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteUser'
     *
     * @param  string $app_id (required)
     * @param  string $alias_label (required)
     * @param  string $alias_id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteUserRequest($app_id, $alias_label, $alias_id)
    {
        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling deleteUser'
            );
        }
        // verify the required parameter 'alias_label' is set
        if ($alias_label === null || (is_array($alias_label) && count($alias_label) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $alias_label when calling deleteUser'
            );
        }
        // verify the required parameter 'alias_id' is set
        if ($alias_id === null || (is_array($alias_id) && count($alias_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $alias_id when calling deleteUser'
            );
        }

        $resourcePath = '/apps/{app_id}/users/by/{alias_label}/{alias_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'app_id' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }
        // path params
        if ($alias_label !== null) {
            $resourcePath = str_replace(
                '{' . 'alias_label' . '}',
                ObjectSerializer::toPathValue($alias_label),
                $resourcePath
            );
        }
        // path params
        if ($alias_id !== null) {
            $resourcePath = str_replace(
                '{' . 'alias_id' . '}',
                ObjectSerializer::toPathValue($alias_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        // Adding the telemetry header
        $defaultHeaders['OS-Usage-Data'] = 'kind=sdk, sdk-name=onesignal-php, version=1.2.2';

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation endLiveActivity
     *
     * Stop Live Activity
     *
     * @param  string $app_id The OneSignal App ID for your app.  Available in Keys &amp; IDs. (required)
     * @param  string $activity_id Live Activity record ID (required)
     * @param  string $subscription_id Subscription ID (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function endLiveActivity($app_id, $activity_id, $subscription_id)
    {
        $this->endLiveActivityWithHttpInfo($app_id, $activity_id, $subscription_id);
    }

    /**
     * Operation endLiveActivityWithHttpInfo
     *
     * Stop Live Activity
     *
     * @param  string $app_id The OneSignal App ID for your app.  Available in Keys &amp; IDs. (required)
     * @param  string $activity_id Live Activity record ID (required)
     * @param  string $subscription_id Subscription ID (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function endLiveActivityWithHttpInfo($app_id, $activity_id, $subscription_id)
    {
        $request = $this->endLiveActivityRequest($app_id, $activity_id, $subscription_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\GenericError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\RateLimiterError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation endLiveActivityAsync
     *
     * Stop Live Activity
     *
     * @param  string $app_id The OneSignal App ID for your app.  Available in Keys &amp; IDs. (required)
     * @param  string $activity_id Live Activity record ID (required)
     * @param  string $subscription_id Subscription ID (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function endLiveActivityAsync($app_id, $activity_id, $subscription_id)
    {
        return $this->endLiveActivityAsyncWithHttpInfo($app_id, $activity_id, $subscription_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation endLiveActivityAsyncWithHttpInfo
     *
     * Stop Live Activity
     *
     * @param  string $app_id The OneSignal App ID for your app.  Available in Keys &amp; IDs. (required)
     * @param  string $activity_id Live Activity record ID (required)
     * @param  string $subscription_id Subscription ID (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function endLiveActivityAsyncWithHttpInfo($app_id, $activity_id, $subscription_id)
    {
        $returnType = '';
        $request = $this->endLiveActivityRequest($app_id, $activity_id, $subscription_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'endLiveActivity'
     *
     * @param  string $app_id The OneSignal App ID for your app.  Available in Keys &amp; IDs. (required)
     * @param  string $activity_id Live Activity record ID (required)
     * @param  string $subscription_id Subscription ID (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function endLiveActivityRequest($app_id, $activity_id, $subscription_id)
    {
        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling endLiveActivity'
            );
        }
        // verify the required parameter 'activity_id' is set
        if ($activity_id === null || (is_array($activity_id) && count($activity_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $activity_id when calling endLiveActivity'
            );
        }
        // verify the required parameter 'subscription_id' is set
        if ($subscription_id === null || (is_array($subscription_id) && count($subscription_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $subscription_id when calling endLiveActivity'
            );
        }

        $resourcePath = '/apps/{app_id}/live_activities/{activity_id}/token/{subscription_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'app_id' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }
        // path params
        if ($activity_id !== null) {
            $resourcePath = str_replace(
                '{' . 'activity_id' . '}',
                ObjectSerializer::toPathValue($activity_id),
                $resourcePath
            );
        }
        // path params
        if ($subscription_id !== null) {
            $resourcePath = str_replace(
                '{' . 'subscription_id' . '}',
                ObjectSerializer::toPathValue($subscription_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        if (!empty($this->config->getAppKeyToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAppKeyToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        // Adding the telemetry header
        $defaultHeaders['OS-Usage-Data'] = 'kind=sdk, sdk-name=onesignal-php, version=1.2.2';

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation exportEvents
     *
     * Export CSV of Events
     *
     * @param  string $notification_id The ID of the notification to export events from. (required)
     * @param  string $app_id The ID of the app that the notification belongs to. (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \onesignal\client\model\ExportEventsSuccessResponse|\onesignal\client\model\GenericError|\onesignal\client\model\GenericError|\onesignal\client\model\RateLimiterError
     */
    public function exportEvents($notification_id, $app_id)
    {
        list($response) = $this->exportEventsWithHttpInfo($notification_id, $app_id);
        return $response;
    }

    /**
     * Operation exportEventsWithHttpInfo
     *
     * Export CSV of Events
     *
     * @param  string $notification_id The ID of the notification to export events from. (required)
     * @param  string $app_id The ID of the app that the notification belongs to. (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \onesignal\client\model\ExportEventsSuccessResponse|\onesignal\client\model\GenericError|\onesignal\client\model\GenericError|\onesignal\client\model\RateLimiterError, HTTP status code, HTTP response headers (array of strings)
     */
    public function exportEventsWithHttpInfo($notification_id, $app_id)
    {
        $request = $this->exportEventsRequest($notification_id, $app_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\onesignal\client\model\ExportEventsSuccessResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\ExportEventsSuccessResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\ExportEventsSuccessResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\onesignal\client\model\GenericError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\GenericError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\GenericError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\onesignal\client\model\GenericError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\GenericError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\GenericError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\onesignal\client\model\RateLimiterError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\RateLimiterError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\RateLimiterError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\onesignal\client\model\ExportEventsSuccessResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\ExportEventsSuccessResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\GenericError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\GenericError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\RateLimiterError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation exportEventsAsync
     *
     * Export CSV of Events
     *
     * @param  string $notification_id The ID of the notification to export events from. (required)
     * @param  string $app_id The ID of the app that the notification belongs to. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function exportEventsAsync($notification_id, $app_id)
    {
        return $this->exportEventsAsyncWithHttpInfo($notification_id, $app_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation exportEventsAsyncWithHttpInfo
     *
     * Export CSV of Events
     *
     * @param  string $notification_id The ID of the notification to export events from. (required)
     * @param  string $app_id The ID of the app that the notification belongs to. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function exportEventsAsyncWithHttpInfo($notification_id, $app_id)
    {
        $returnType = '\onesignal\client\model\ExportEventsSuccessResponse';
        $request = $this->exportEventsRequest($notification_id, $app_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'exportEvents'
     *
     * @param  string $notification_id The ID of the notification to export events from. (required)
     * @param  string $app_id The ID of the app that the notification belongs to. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function exportEventsRequest($notification_id, $app_id)
    {
        // verify the required parameter 'notification_id' is set
        if ($notification_id === null || (is_array($notification_id) && count($notification_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $notification_id when calling exportEvents'
            );
        }
        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling exportEvents'
            );
        }

        $resourcePath = '/notifications/{notification_id}/export_events?app_id={app_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $app_id,
            'app_id', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);


        // path params
        if ($notification_id !== null) {
            $resourcePath = str_replace(
                '{' . 'notification_id' . '}',
                ObjectSerializer::toPathValue($notification_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        if (!empty($this->config->getAppKeyToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAppKeyToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        // Adding the telemetry header
        $defaultHeaders['OS-Usage-Data'] = 'kind=sdk, sdk-name=onesignal-php, version=1.2.2';

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation exportPlayers
     *
     * Export CSV of Players
     *
     * @param  string $app_id The app ID that you want to export devices from (required)
     * @param  \onesignal\client\model\ExportPlayersRequestBody $export_players_request_body export_players_request_body (optional)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \onesignal\client\model\ExportPlayersSuccessResponse|\onesignal\client\model\GenericError|\onesignal\client\model\RateLimiterError
     */
    public function exportPlayers($app_id, $export_players_request_body = null)
    {
        list($response) = $this->exportPlayersWithHttpInfo($app_id, $export_players_request_body);
        return $response;
    }

    /**
     * Operation exportPlayersWithHttpInfo
     *
     * Export CSV of Players
     *
     * @param  string $app_id The app ID that you want to export devices from (required)
     * @param  \onesignal\client\model\ExportPlayersRequestBody $export_players_request_body (optional)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \onesignal\client\model\ExportPlayersSuccessResponse|\onesignal\client\model\GenericError|\onesignal\client\model\RateLimiterError, HTTP status code, HTTP response headers (array of strings)
     */
    public function exportPlayersWithHttpInfo($app_id, $export_players_request_body = null)
    {
        $request = $this->exportPlayersRequest($app_id, $export_players_request_body);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\onesignal\client\model\ExportPlayersSuccessResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\ExportPlayersSuccessResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\ExportPlayersSuccessResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\onesignal\client\model\GenericError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\GenericError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\GenericError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\onesignal\client\model\RateLimiterError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\RateLimiterError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\RateLimiterError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\onesignal\client\model\ExportPlayersSuccessResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\ExportPlayersSuccessResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\GenericError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\RateLimiterError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation exportPlayersAsync
     *
     * Export CSV of Players
     *
     * @param  string $app_id The app ID that you want to export devices from (required)
     * @param  \onesignal\client\model\ExportPlayersRequestBody $export_players_request_body (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function exportPlayersAsync($app_id, $export_players_request_body = null)
    {
        return $this->exportPlayersAsyncWithHttpInfo($app_id, $export_players_request_body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation exportPlayersAsyncWithHttpInfo
     *
     * Export CSV of Players
     *
     * @param  string $app_id The app ID that you want to export devices from (required)
     * @param  \onesignal\client\model\ExportPlayersRequestBody $export_players_request_body (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function exportPlayersAsyncWithHttpInfo($app_id, $export_players_request_body = null)
    {
        $returnType = '\onesignal\client\model\ExportPlayersSuccessResponse';
        $request = $this->exportPlayersRequest($app_id, $export_players_request_body);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'exportPlayers'
     *
     * @param  string $app_id The app ID that you want to export devices from (required)
     * @param  \onesignal\client\model\ExportPlayersRequestBody $export_players_request_body (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function exportPlayersRequest($app_id, $export_players_request_body = null)
    {
        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling exportPlayers'
            );
        }

        $resourcePath = '/players/csv_export?app_id={app_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'app_id' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($export_players_request_body)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($export_players_request_body));
            } else {
                $httpBody = $export_players_request_body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        if (!empty($this->config->getAppKeyToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAppKeyToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        // Adding the telemetry header
        $defaultHeaders['OS-Usage-Data'] = 'kind=sdk, sdk-name=onesignal-php, version=1.2.2';

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation fetchAliases
     *
     * @param  string $app_id app_id (required)
     * @param  string $subscription_id subscription_id (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \onesignal\client\model\UserIdentityResponse|\onesignal\client\model\GenericError
     */
    public function fetchAliases($app_id, $subscription_id)
    {
        list($response) = $this->fetchAliasesWithHttpInfo($app_id, $subscription_id);
        return $response;
    }

    /**
     * Operation fetchAliasesWithHttpInfo
     *
     * @param  string $app_id (required)
     * @param  string $subscription_id (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \onesignal\client\model\UserIdentityResponse|\onesignal\client\model\GenericError, HTTP status code, HTTP response headers (array of strings)
     */
    public function fetchAliasesWithHttpInfo($app_id, $subscription_id)
    {
        $request = $this->fetchAliasesRequest($app_id, $subscription_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\onesignal\client\model\UserIdentityResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\UserIdentityResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\UserIdentityResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\onesignal\client\model\GenericError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\GenericError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\GenericError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\onesignal\client\model\UserIdentityResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\UserIdentityResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\GenericError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation fetchAliasesAsync
     *
     * @param  string $app_id (required)
     * @param  string $subscription_id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function fetchAliasesAsync($app_id, $subscription_id)
    {
        return $this->fetchAliasesAsyncWithHttpInfo($app_id, $subscription_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation fetchAliasesAsyncWithHttpInfo
     *
     * @param  string $app_id (required)
     * @param  string $subscription_id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function fetchAliasesAsyncWithHttpInfo($app_id, $subscription_id)
    {
        $returnType = '\onesignal\client\model\UserIdentityResponse';
        $request = $this->fetchAliasesRequest($app_id, $subscription_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'fetchAliases'
     *
     * @param  string $app_id (required)
     * @param  string $subscription_id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function fetchAliasesRequest($app_id, $subscription_id)
    {
        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling fetchAliases'
            );
        }
        // verify the required parameter 'subscription_id' is set
        if ($subscription_id === null || (is_array($subscription_id) && count($subscription_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $subscription_id when calling fetchAliases'
            );
        }

        $resourcePath = '/apps/{app_id}/subscriptions/{subscription_id}/user/identity';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'app_id' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }
        // path params
        if ($subscription_id !== null) {
            $resourcePath = str_replace(
                '{' . 'subscription_id' . '}',
                ObjectSerializer::toPathValue($subscription_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        if (!empty($this->config->getAppKeyToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAppKeyToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        // Adding the telemetry header
        $defaultHeaders['OS-Usage-Data'] = 'kind=sdk, sdk-name=onesignal-php, version=1.2.2';

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation fetchUser
     *
     * @param  string $app_id app_id (required)
     * @param  string $alias_label alias_label (required)
     * @param  string $alias_id alias_id (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \onesignal\client\model\User|\onesignal\client\model\GenericError|\onesignal\client\model\RateLimiterError
     */
    public function fetchUser($app_id, $alias_label, $alias_id)
    {
        list($response) = $this->fetchUserWithHttpInfo($app_id, $alias_label, $alias_id);
        return $response;
    }

    /**
     * Operation fetchUserWithHttpInfo
     *
     * @param  string $app_id (required)
     * @param  string $alias_label (required)
     * @param  string $alias_id (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \onesignal\client\model\User|\onesignal\client\model\GenericError|\onesignal\client\model\RateLimiterError, HTTP status code, HTTP response headers (array of strings)
     */
    public function fetchUserWithHttpInfo($app_id, $alias_label, $alias_id)
    {
        $request = $this->fetchUserRequest($app_id, $alias_label, $alias_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\onesignal\client\model\User' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\User' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\User', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\onesignal\client\model\GenericError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\GenericError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\GenericError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\onesignal\client\model\RateLimiterError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\RateLimiterError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\RateLimiterError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\onesignal\client\model\User';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\User',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\GenericError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\RateLimiterError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation fetchUserAsync
     *
     * @param  string $app_id (required)
     * @param  string $alias_label (required)
     * @param  string $alias_id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function fetchUserAsync($app_id, $alias_label, $alias_id)
    {
        return $this->fetchUserAsyncWithHttpInfo($app_id, $alias_label, $alias_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation fetchUserAsyncWithHttpInfo
     *
     * @param  string $app_id (required)
     * @param  string $alias_label (required)
     * @param  string $alias_id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function fetchUserAsyncWithHttpInfo($app_id, $alias_label, $alias_id)
    {
        $returnType = '\onesignal\client\model\User';
        $request = $this->fetchUserRequest($app_id, $alias_label, $alias_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'fetchUser'
     *
     * @param  string $app_id (required)
     * @param  string $alias_label (required)
     * @param  string $alias_id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function fetchUserRequest($app_id, $alias_label, $alias_id)
    {
        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling fetchUser'
            );
        }
        // verify the required parameter 'alias_label' is set
        if ($alias_label === null || (is_array($alias_label) && count($alias_label) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $alias_label when calling fetchUser'
            );
        }
        // verify the required parameter 'alias_id' is set
        if ($alias_id === null || (is_array($alias_id) && count($alias_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $alias_id when calling fetchUser'
            );
        }

        $resourcePath = '/apps/{app_id}/users/by/{alias_label}/{alias_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'app_id' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }
        // path params
        if ($alias_label !== null) {
            $resourcePath = str_replace(
                '{' . 'alias_label' . '}',
                ObjectSerializer::toPathValue($alias_label),
                $resourcePath
            );
        }
        // path params
        if ($alias_id !== null) {
            $resourcePath = str_replace(
                '{' . 'alias_id' . '}',
                ObjectSerializer::toPathValue($alias_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        if (!empty($this->config->getAppKeyToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAppKeyToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        // Adding the telemetry header
        $defaultHeaders['OS-Usage-Data'] = 'kind=sdk, sdk-name=onesignal-php, version=1.2.2';

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation fetchUserIdentity
     *
     * @param  string $app_id app_id (required)
     * @param  string $alias_label alias_label (required)
     * @param  string $alias_id alias_id (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \onesignal\client\model\InlineResponse200|\onesignal\client\model\GenericError|\onesignal\client\model\RateLimiterError
     */
    public function fetchUserIdentity($app_id, $alias_label, $alias_id)
    {
        list($response) = $this->fetchUserIdentityWithHttpInfo($app_id, $alias_label, $alias_id);
        return $response;
    }

    /**
     * Operation fetchUserIdentityWithHttpInfo
     *
     * @param  string $app_id (required)
     * @param  string $alias_label (required)
     * @param  string $alias_id (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \onesignal\client\model\InlineResponse200|\onesignal\client\model\GenericError|\onesignal\client\model\RateLimiterError, HTTP status code, HTTP response headers (array of strings)
     */
    public function fetchUserIdentityWithHttpInfo($app_id, $alias_label, $alias_id)
    {
        $request = $this->fetchUserIdentityRequest($app_id, $alias_label, $alias_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\onesignal\client\model\InlineResponse200' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\InlineResponse200' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\InlineResponse200', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\onesignal\client\model\GenericError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\GenericError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\GenericError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\onesignal\client\model\RateLimiterError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\RateLimiterError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\RateLimiterError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\onesignal\client\model\InlineResponse200';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\InlineResponse200',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\GenericError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\RateLimiterError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation fetchUserIdentityAsync
     *
     * @param  string $app_id (required)
     * @param  string $alias_label (required)
     * @param  string $alias_id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function fetchUserIdentityAsync($app_id, $alias_label, $alias_id)
    {
        return $this->fetchUserIdentityAsyncWithHttpInfo($app_id, $alias_label, $alias_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation fetchUserIdentityAsyncWithHttpInfo
     *
     * @param  string $app_id (required)
     * @param  string $alias_label (required)
     * @param  string $alias_id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function fetchUserIdentityAsyncWithHttpInfo($app_id, $alias_label, $alias_id)
    {
        $returnType = '\onesignal\client\model\InlineResponse200';
        $request = $this->fetchUserIdentityRequest($app_id, $alias_label, $alias_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'fetchUserIdentity'
     *
     * @param  string $app_id (required)
     * @param  string $alias_label (required)
     * @param  string $alias_id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function fetchUserIdentityRequest($app_id, $alias_label, $alias_id)
    {
        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling fetchUserIdentity'
            );
        }
        // verify the required parameter 'alias_label' is set
        if ($alias_label === null || (is_array($alias_label) && count($alias_label) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $alias_label when calling fetchUserIdentity'
            );
        }
        // verify the required parameter 'alias_id' is set
        if ($alias_id === null || (is_array($alias_id) && count($alias_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $alias_id when calling fetchUserIdentity'
            );
        }

        $resourcePath = '/apps/{app_id}/users/by/{alias_label}/{alias_id}/identity';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'app_id' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }
        // path params
        if ($alias_label !== null) {
            $resourcePath = str_replace(
                '{' . 'alias_label' . '}',
                ObjectSerializer::toPathValue($alias_label),
                $resourcePath
            );
        }
        // path params
        if ($alias_id !== null) {
            $resourcePath = str_replace(
                '{' . 'alias_id' . '}',
                ObjectSerializer::toPathValue($alias_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        if (!empty($this->config->getAppKeyToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAppKeyToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        // Adding the telemetry header
        $defaultHeaders['OS-Usage-Data'] = 'kind=sdk, sdk-name=onesignal-php, version=1.2.2';

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getApp
     *
     * View an app
     *
     * @param  string $app_id An app id (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \onesignal\client\model\App|\onesignal\client\model\GenericError|\onesignal\client\model\RateLimiterError
     */
    public function getApp($app_id)
    {
        list($response) = $this->getAppWithHttpInfo($app_id);
        return $response;
    }

    /**
     * Operation getAppWithHttpInfo
     *
     * View an app
     *
     * @param  string $app_id An app id (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \onesignal\client\model\App|\onesignal\client\model\GenericError|\onesignal\client\model\RateLimiterError, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAppWithHttpInfo($app_id)
    {
        $request = $this->getAppRequest($app_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\onesignal\client\model\App' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\App' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\App', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\onesignal\client\model\GenericError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\GenericError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\GenericError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\onesignal\client\model\RateLimiterError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\RateLimiterError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\RateLimiterError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\onesignal\client\model\App';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\App',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\GenericError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\RateLimiterError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getAppAsync
     *
     * View an app
     *
     * @param  string $app_id An app id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAppAsync($app_id)
    {
        return $this->getAppAsyncWithHttpInfo($app_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAppAsyncWithHttpInfo
     *
     * View an app
     *
     * @param  string $app_id An app id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAppAsyncWithHttpInfo($app_id)
    {
        $returnType = '\onesignal\client\model\App';
        $request = $this->getAppRequest($app_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getApp'
     *
     * @param  string $app_id An app id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getAppRequest($app_id)
    {
        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling getApp'
            );
        }

        $resourcePath = '/apps/{app_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'app_id' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        if (!empty($this->config->getUserKeyToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getUserKeyToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        // Adding the telemetry header
        $defaultHeaders['OS-Usage-Data'] = 'kind=sdk, sdk-name=onesignal-php, version=1.2.2';

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getApps
     *
     * View apps
     *
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \onesignal\client\model\App[]|\onesignal\client\model\GenericError|\onesignal\client\model\RateLimiterError
     */
    public function getApps()
    {
        list($response) = $this->getAppsWithHttpInfo();
        return $response;
    }

    /**
     * Operation getAppsWithHttpInfo
     *
     * View apps
     *
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \onesignal\client\model\App[]|\onesignal\client\model\GenericError|\onesignal\client\model\RateLimiterError, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAppsWithHttpInfo()
    {
        $request = $this->getAppsRequest();

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\onesignal\client\model\App[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\App[]' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\App[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\onesignal\client\model\GenericError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\GenericError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\GenericError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\onesignal\client\model\RateLimiterError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\RateLimiterError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\RateLimiterError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\onesignal\client\model\App[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\App[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\GenericError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\RateLimiterError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getAppsAsync
     *
     * View apps
     *
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAppsAsync()
    {
        return $this->getAppsAsyncWithHttpInfo()
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAppsAsyncWithHttpInfo
     *
     * View apps
     *
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAppsAsyncWithHttpInfo()
    {
        $returnType = '\onesignal\client\model\App[]';
        $request = $this->getAppsRequest();

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getApps'
     *
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getAppsRequest()
    {

        $resourcePath = '/apps';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        if (!empty($this->config->getUserKeyToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getUserKeyToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        // Adding the telemetry header
        $defaultHeaders['OS-Usage-Data'] = 'kind=sdk, sdk-name=onesignal-php, version=1.2.2';

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getEligibleIams
     *
     * @param  string $app_id app_id (required)
     * @param  string $subscription_id subscription_id (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \onesignal\client\model\InlineResponse2003|\onesignal\client\model\GenericError|\onesignal\client\model\RateLimiterError
     */
    public function getEligibleIams($app_id, $subscription_id)
    {
        list($response) = $this->getEligibleIamsWithHttpInfo($app_id, $subscription_id);
        return $response;
    }

    /**
     * Operation getEligibleIamsWithHttpInfo
     *
     * @param  string $app_id (required)
     * @param  string $subscription_id (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \onesignal\client\model\InlineResponse2003|\onesignal\client\model\GenericError|\onesignal\client\model\RateLimiterError, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEligibleIamsWithHttpInfo($app_id, $subscription_id)
    {
        $request = $this->getEligibleIamsRequest($app_id, $subscription_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\onesignal\client\model\InlineResponse2003' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\InlineResponse2003' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\InlineResponse2003', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\onesignal\client\model\GenericError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\GenericError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\GenericError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\onesignal\client\model\RateLimiterError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\RateLimiterError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\RateLimiterError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\onesignal\client\model\InlineResponse2003';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\InlineResponse2003',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\GenericError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\RateLimiterError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getEligibleIamsAsync
     *
     * @param  string $app_id (required)
     * @param  string $subscription_id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEligibleIamsAsync($app_id, $subscription_id)
    {
        return $this->getEligibleIamsAsyncWithHttpInfo($app_id, $subscription_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getEligibleIamsAsyncWithHttpInfo
     *
     * @param  string $app_id (required)
     * @param  string $subscription_id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEligibleIamsAsyncWithHttpInfo($app_id, $subscription_id)
    {
        $returnType = '\onesignal\client\model\InlineResponse2003';
        $request = $this->getEligibleIamsRequest($app_id, $subscription_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getEligibleIams'
     *
     * @param  string $app_id (required)
     * @param  string $subscription_id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getEligibleIamsRequest($app_id, $subscription_id)
    {
        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling getEligibleIams'
            );
        }
        // verify the required parameter 'subscription_id' is set
        if ($subscription_id === null || (is_array($subscription_id) && count($subscription_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $subscription_id when calling getEligibleIams'
            );
        }

        $resourcePath = '/apps/{app_id}/subscriptions/{subscription_id}/iams';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'app_id' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }
        // path params
        if ($subscription_id !== null) {
            $resourcePath = str_replace(
                '{' . 'subscription_id' . '}',
                ObjectSerializer::toPathValue($subscription_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        if (!empty($this->config->getAppKeyToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAppKeyToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        // Adding the telemetry header
        $defaultHeaders['OS-Usage-Data'] = 'kind=sdk, sdk-name=onesignal-php, version=1.2.2';

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getNotification
     *
     * View notification
     *
     * @param  string $app_id app_id (required)
     * @param  string $notification_id notification_id (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \onesignal\client\model\NotificationWithMeta|\onesignal\client\model\GenericError|\onesignal\client\model\RateLimiterError
     */
    public function getNotification($app_id, $notification_id)
    {
        list($response) = $this->getNotificationWithHttpInfo($app_id, $notification_id);
        return $response;
    }

    /**
     * Operation getNotificationWithHttpInfo
     *
     * View notification
     *
     * @param  string $app_id (required)
     * @param  string $notification_id (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \onesignal\client\model\NotificationWithMeta|\onesignal\client\model\GenericError|\onesignal\client\model\RateLimiterError, HTTP status code, HTTP response headers (array of strings)
     */
    public function getNotificationWithHttpInfo($app_id, $notification_id)
    {
        $request = $this->getNotificationRequest($app_id, $notification_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\onesignal\client\model\NotificationWithMeta' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\NotificationWithMeta' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\NotificationWithMeta', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\onesignal\client\model\GenericError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\GenericError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\GenericError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\onesignal\client\model\RateLimiterError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\RateLimiterError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\RateLimiterError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\onesignal\client\model\NotificationWithMeta';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\NotificationWithMeta',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\GenericError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\RateLimiterError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getNotificationAsync
     *
     * View notification
     *
     * @param  string $app_id (required)
     * @param  string $notification_id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getNotificationAsync($app_id, $notification_id)
    {
        return $this->getNotificationAsyncWithHttpInfo($app_id, $notification_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getNotificationAsyncWithHttpInfo
     *
     * View notification
     *
     * @param  string $app_id (required)
     * @param  string $notification_id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getNotificationAsyncWithHttpInfo($app_id, $notification_id)
    {
        $returnType = '\onesignal\client\model\NotificationWithMeta';
        $request = $this->getNotificationRequest($app_id, $notification_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getNotification'
     *
     * @param  string $app_id (required)
     * @param  string $notification_id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getNotificationRequest($app_id, $notification_id)
    {
        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling getNotification'
            );
        }
        // verify the required parameter 'notification_id' is set
        if ($notification_id === null || (is_array($notification_id) && count($notification_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $notification_id when calling getNotification'
            );
        }

        $resourcePath = '/notifications/{notification_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $app_id,
            'app_id', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);


        // path params
        if ($notification_id !== null) {
            $resourcePath = str_replace(
                '{' . 'notification_id' . '}',
                ObjectSerializer::toPathValue($notification_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        if (!empty($this->config->getAppKeyToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAppKeyToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        // Adding the telemetry header
        $defaultHeaders['OS-Usage-Data'] = 'kind=sdk, sdk-name=onesignal-php, version=1.2.2';

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getNotificationHistory
     *
     * Notification History
     *
     * @param  string $notification_id The \&quot;id\&quot; of the message found in the Notification object (required)
     * @param  \onesignal\client\model\GetNotificationRequestBody $get_notification_request_body get_notification_request_body (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \onesignal\client\model\NotificationHistorySuccessResponse|\onesignal\client\model\GenericError|\onesignal\client\model\RateLimiterError
     */
    public function getNotificationHistory($notification_id, $get_notification_request_body)
    {
        list($response) = $this->getNotificationHistoryWithHttpInfo($notification_id, $get_notification_request_body);
        return $response;
    }

    /**
     * Operation getNotificationHistoryWithHttpInfo
     *
     * Notification History
     *
     * @param  string $notification_id The \&quot;id\&quot; of the message found in the Notification object (required)
     * @param  \onesignal\client\model\GetNotificationRequestBody $get_notification_request_body (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \onesignal\client\model\NotificationHistorySuccessResponse|\onesignal\client\model\GenericError|\onesignal\client\model\RateLimiterError, HTTP status code, HTTP response headers (array of strings)
     */
    public function getNotificationHistoryWithHttpInfo($notification_id, $get_notification_request_body)
    {
        $request = $this->getNotificationHistoryRequest($notification_id, $get_notification_request_body);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\onesignal\client\model\NotificationHistorySuccessResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\NotificationHistorySuccessResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\NotificationHistorySuccessResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\onesignal\client\model\GenericError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\GenericError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\GenericError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\onesignal\client\model\RateLimiterError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\RateLimiterError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\RateLimiterError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\onesignal\client\model\NotificationHistorySuccessResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\NotificationHistorySuccessResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\GenericError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\RateLimiterError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getNotificationHistoryAsync
     *
     * Notification History
     *
     * @param  string $notification_id The \&quot;id\&quot; of the message found in the Notification object (required)
     * @param  \onesignal\client\model\GetNotificationRequestBody $get_notification_request_body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getNotificationHistoryAsync($notification_id, $get_notification_request_body)
    {
        return $this->getNotificationHistoryAsyncWithHttpInfo($notification_id, $get_notification_request_body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getNotificationHistoryAsyncWithHttpInfo
     *
     * Notification History
     *
     * @param  string $notification_id The \&quot;id\&quot; of the message found in the Notification object (required)
     * @param  \onesignal\client\model\GetNotificationRequestBody $get_notification_request_body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getNotificationHistoryAsyncWithHttpInfo($notification_id, $get_notification_request_body)
    {
        $returnType = '\onesignal\client\model\NotificationHistorySuccessResponse';
        $request = $this->getNotificationHistoryRequest($notification_id, $get_notification_request_body);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getNotificationHistory'
     *
     * @param  string $notification_id The \&quot;id\&quot; of the message found in the Notification object (required)
     * @param  \onesignal\client\model\GetNotificationRequestBody $get_notification_request_body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getNotificationHistoryRequest($notification_id, $get_notification_request_body)
    {
        // verify the required parameter 'notification_id' is set
        if ($notification_id === null || (is_array($notification_id) && count($notification_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $notification_id when calling getNotificationHistory'
            );
        }
        // verify the required parameter 'get_notification_request_body' is set
        if ($get_notification_request_body === null || (is_array($get_notification_request_body) && count($get_notification_request_body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $get_notification_request_body when calling getNotificationHistory'
            );
        }

        $resourcePath = '/notifications/{notification_id}/history';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($notification_id !== null) {
            $resourcePath = str_replace(
                '{' . 'notification_id' . '}',
                ObjectSerializer::toPathValue($notification_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($get_notification_request_body)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($get_notification_request_body));
            } else {
                $httpBody = $get_notification_request_body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        if (!empty($this->config->getAppKeyToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAppKeyToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        // Adding the telemetry header
        $defaultHeaders['OS-Usage-Data'] = 'kind=sdk, sdk-name=onesignal-php, version=1.2.2';

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getNotifications
     *
     * View notifications
     *
     * @param  string $app_id The app ID that you want to view notifications from (required)
     * @param  int $limit How many notifications to return.  Max is 50.  Default is 50. (optional)
     * @param  int $offset Page offset.  Default is 0.  Results are sorted by queued_at in descending order.  queued_at is a representation of the time that the notification was queued at. (optional)
     * @param  int $kind Kind of notifications returned:   * unset - All notification types (default)   * &#x60;0&#x60; - Dashboard only   * &#x60;1&#x60; - API only   * &#x60;3&#x60; - Automated only (optional)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \onesignal\client\model\NotificationSlice|\onesignal\client\model\GenericError|\onesignal\client\model\RateLimiterError
     */
    public function getNotifications($app_id, $limit = null, $offset = null, $kind = null)
    {
        list($response) = $this->getNotificationsWithHttpInfo($app_id, $limit, $offset, $kind);
        return $response;
    }

    /**
     * Operation getNotificationsWithHttpInfo
     *
     * View notifications
     *
     * @param  string $app_id The app ID that you want to view notifications from (required)
     * @param  int $limit How many notifications to return.  Max is 50.  Default is 50. (optional)
     * @param  int $offset Page offset.  Default is 0.  Results are sorted by queued_at in descending order.  queued_at is a representation of the time that the notification was queued at. (optional)
     * @param  int $kind Kind of notifications returned:   * unset - All notification types (default)   * &#x60;0&#x60; - Dashboard only   * &#x60;1&#x60; - API only   * &#x60;3&#x60; - Automated only (optional)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \onesignal\client\model\NotificationSlice|\onesignal\client\model\GenericError|\onesignal\client\model\RateLimiterError, HTTP status code, HTTP response headers (array of strings)
     */
    public function getNotificationsWithHttpInfo($app_id, $limit = null, $offset = null, $kind = null)
    {
        $request = $this->getNotificationsRequest($app_id, $limit, $offset, $kind);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\onesignal\client\model\NotificationSlice' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\NotificationSlice' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\NotificationSlice', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\onesignal\client\model\GenericError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\GenericError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\GenericError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\onesignal\client\model\RateLimiterError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\RateLimiterError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\RateLimiterError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\onesignal\client\model\NotificationSlice';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\NotificationSlice',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\GenericError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\RateLimiterError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getNotificationsAsync
     *
     * View notifications
     *
     * @param  string $app_id The app ID that you want to view notifications from (required)
     * @param  int $limit How many notifications to return.  Max is 50.  Default is 50. (optional)
     * @param  int $offset Page offset.  Default is 0.  Results are sorted by queued_at in descending order.  queued_at is a representation of the time that the notification was queued at. (optional)
     * @param  int $kind Kind of notifications returned:   * unset - All notification types (default)   * &#x60;0&#x60; - Dashboard only   * &#x60;1&#x60; - API only   * &#x60;3&#x60; - Automated only (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getNotificationsAsync($app_id, $limit = null, $offset = null, $kind = null)
    {
        return $this->getNotificationsAsyncWithHttpInfo($app_id, $limit, $offset, $kind)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getNotificationsAsyncWithHttpInfo
     *
     * View notifications
     *
     * @param  string $app_id The app ID that you want to view notifications from (required)
     * @param  int $limit How many notifications to return.  Max is 50.  Default is 50. (optional)
     * @param  int $offset Page offset.  Default is 0.  Results are sorted by queued_at in descending order.  queued_at is a representation of the time that the notification was queued at. (optional)
     * @param  int $kind Kind of notifications returned:   * unset - All notification types (default)   * &#x60;0&#x60; - Dashboard only   * &#x60;1&#x60; - API only   * &#x60;3&#x60; - Automated only (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getNotificationsAsyncWithHttpInfo($app_id, $limit = null, $offset = null, $kind = null)
    {
        $returnType = '\onesignal\client\model\NotificationSlice';
        $request = $this->getNotificationsRequest($app_id, $limit, $offset, $kind);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getNotifications'
     *
     * @param  string $app_id The app ID that you want to view notifications from (required)
     * @param  int $limit How many notifications to return.  Max is 50.  Default is 50. (optional)
     * @param  int $offset Page offset.  Default is 0.  Results are sorted by queued_at in descending order.  queued_at is a representation of the time that the notification was queued at. (optional)
     * @param  int $kind Kind of notifications returned:   * unset - All notification types (default)   * &#x60;0&#x60; - Dashboard only   * &#x60;1&#x60; - API only   * &#x60;3&#x60; - Automated only (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getNotificationsRequest($app_id, $limit = null, $offset = null, $kind = null)
    {
        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling getNotifications'
            );
        }

        $resourcePath = '/notifications';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $app_id,
            'app_id', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $offset,
            'offset', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $kind,
            'kind', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        if (!empty($this->config->getAppKeyToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAppKeyToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        // Adding the telemetry header
        $defaultHeaders['OS-Usage-Data'] = 'kind=sdk, sdk-name=onesignal-php, version=1.2.2';

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getOutcomes
     *
     * View Outcomes
     *
     * @param  string $app_id The OneSignal App ID for your app.  Available in Keys &amp; IDs. (required)
     * @param  string $outcome_names Required Comma-separated list of names and the value (sum/count) for the returned outcome data. Note: Clicks only support count aggregation. For out-of-the-box OneSignal outcomes such as click and session duration, please use the \&quot;os\&quot; prefix with two underscores. For other outcomes, please use the name specified by the user. Example:os__session_duration.count,os__click.count,CustomOutcomeName.sum (required)
     * @param  string $outcome_names2 Optional If outcome names contain any commas, then please specify only one value at a time. Example: outcome_names[]&#x3D;os__click.count&amp;outcome_names[]&#x3D;Sales, Purchase.count where \&quot;Sales, Purchase\&quot; is the custom outcomes with a comma in the name. (optional)
     * @param  string $outcome_time_range Optional Time range for the returned data. The values can be 1h (for the last 1 hour data), 1d (for the last 1 day data), or 1mo (for the last 1 month data). Default is 1h if the parameter is omitted. (optional)
     * @param  string $outcome_platforms Optional Platform id. Refer device&#39;s platform ids for values. Example: outcome_platform&#x3D;0 for iOS outcome_platform&#x3D;7,8 for Safari and Firefox Default is data from all platforms if the parameter is omitted. (optional)
     * @param  string $outcome_attribution Optional Attribution type for the outcomes. The values can be direct or influenced or unattributed. Example: outcome_attribution&#x3D;direct Default is total (returns direct+influenced+unattributed) if the parameter is omitted. (optional)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \onesignal\client\model\OutcomesData|\onesignal\client\model\GenericError|\onesignal\client\model\RateLimiterError
     */
    public function getOutcomes($app_id, $outcome_names, $outcome_names2 = null, $outcome_time_range = null, $outcome_platforms = null, $outcome_attribution = null)
    {
        list($response) = $this->getOutcomesWithHttpInfo($app_id, $outcome_names, $outcome_names2, $outcome_time_range, $outcome_platforms, $outcome_attribution);
        return $response;
    }

    /**
     * Operation getOutcomesWithHttpInfo
     *
     * View Outcomes
     *
     * @param  string $app_id The OneSignal App ID for your app.  Available in Keys &amp; IDs. (required)
     * @param  string $outcome_names Required Comma-separated list of names and the value (sum/count) for the returned outcome data. Note: Clicks only support count aggregation. For out-of-the-box OneSignal outcomes such as click and session duration, please use the \&quot;os\&quot; prefix with two underscores. For other outcomes, please use the name specified by the user. Example:os__session_duration.count,os__click.count,CustomOutcomeName.sum (required)
     * @param  string $outcome_names2 Optional If outcome names contain any commas, then please specify only one value at a time. Example: outcome_names[]&#x3D;os__click.count&amp;outcome_names[]&#x3D;Sales, Purchase.count where \&quot;Sales, Purchase\&quot; is the custom outcomes with a comma in the name. (optional)
     * @param  string $outcome_time_range Optional Time range for the returned data. The values can be 1h (for the last 1 hour data), 1d (for the last 1 day data), or 1mo (for the last 1 month data). Default is 1h if the parameter is omitted. (optional)
     * @param  string $outcome_platforms Optional Platform id. Refer device&#39;s platform ids for values. Example: outcome_platform&#x3D;0 for iOS outcome_platform&#x3D;7,8 for Safari and Firefox Default is data from all platforms if the parameter is omitted. (optional)
     * @param  string $outcome_attribution Optional Attribution type for the outcomes. The values can be direct or influenced or unattributed. Example: outcome_attribution&#x3D;direct Default is total (returns direct+influenced+unattributed) if the parameter is omitted. (optional)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \onesignal\client\model\OutcomesData|\onesignal\client\model\GenericError|\onesignal\client\model\RateLimiterError, HTTP status code, HTTP response headers (array of strings)
     */
    public function getOutcomesWithHttpInfo($app_id, $outcome_names, $outcome_names2 = null, $outcome_time_range = null, $outcome_platforms = null, $outcome_attribution = null)
    {
        $request = $this->getOutcomesRequest($app_id, $outcome_names, $outcome_names2, $outcome_time_range, $outcome_platforms, $outcome_attribution);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\onesignal\client\model\OutcomesData' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\OutcomesData' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\OutcomesData', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\onesignal\client\model\GenericError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\GenericError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\GenericError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\onesignal\client\model\RateLimiterError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\RateLimiterError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\RateLimiterError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\onesignal\client\model\OutcomesData';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\OutcomesData',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\GenericError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\RateLimiterError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getOutcomesAsync
     *
     * View Outcomes
     *
     * @param  string $app_id The OneSignal App ID for your app.  Available in Keys &amp; IDs. (required)
     * @param  string $outcome_names Required Comma-separated list of names and the value (sum/count) for the returned outcome data. Note: Clicks only support count aggregation. For out-of-the-box OneSignal outcomes such as click and session duration, please use the \&quot;os\&quot; prefix with two underscores. For other outcomes, please use the name specified by the user. Example:os__session_duration.count,os__click.count,CustomOutcomeName.sum (required)
     * @param  string $outcome_names2 Optional If outcome names contain any commas, then please specify only one value at a time. Example: outcome_names[]&#x3D;os__click.count&amp;outcome_names[]&#x3D;Sales, Purchase.count where \&quot;Sales, Purchase\&quot; is the custom outcomes with a comma in the name. (optional)
     * @param  string $outcome_time_range Optional Time range for the returned data. The values can be 1h (for the last 1 hour data), 1d (for the last 1 day data), or 1mo (for the last 1 month data). Default is 1h if the parameter is omitted. (optional)
     * @param  string $outcome_platforms Optional Platform id. Refer device&#39;s platform ids for values. Example: outcome_platform&#x3D;0 for iOS outcome_platform&#x3D;7,8 for Safari and Firefox Default is data from all platforms if the parameter is omitted. (optional)
     * @param  string $outcome_attribution Optional Attribution type for the outcomes. The values can be direct or influenced or unattributed. Example: outcome_attribution&#x3D;direct Default is total (returns direct+influenced+unattributed) if the parameter is omitted. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOutcomesAsync($app_id, $outcome_names, $outcome_names2 = null, $outcome_time_range = null, $outcome_platforms = null, $outcome_attribution = null)
    {
        return $this->getOutcomesAsyncWithHttpInfo($app_id, $outcome_names, $outcome_names2, $outcome_time_range, $outcome_platforms, $outcome_attribution)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getOutcomesAsyncWithHttpInfo
     *
     * View Outcomes
     *
     * @param  string $app_id The OneSignal App ID for your app.  Available in Keys &amp; IDs. (required)
     * @param  string $outcome_names Required Comma-separated list of names and the value (sum/count) for the returned outcome data. Note: Clicks only support count aggregation. For out-of-the-box OneSignal outcomes such as click and session duration, please use the \&quot;os\&quot; prefix with two underscores. For other outcomes, please use the name specified by the user. Example:os__session_duration.count,os__click.count,CustomOutcomeName.sum (required)
     * @param  string $outcome_names2 Optional If outcome names contain any commas, then please specify only one value at a time. Example: outcome_names[]&#x3D;os__click.count&amp;outcome_names[]&#x3D;Sales, Purchase.count where \&quot;Sales, Purchase\&quot; is the custom outcomes with a comma in the name. (optional)
     * @param  string $outcome_time_range Optional Time range for the returned data. The values can be 1h (for the last 1 hour data), 1d (for the last 1 day data), or 1mo (for the last 1 month data). Default is 1h if the parameter is omitted. (optional)
     * @param  string $outcome_platforms Optional Platform id. Refer device&#39;s platform ids for values. Example: outcome_platform&#x3D;0 for iOS outcome_platform&#x3D;7,8 for Safari and Firefox Default is data from all platforms if the parameter is omitted. (optional)
     * @param  string $outcome_attribution Optional Attribution type for the outcomes. The values can be direct or influenced or unattributed. Example: outcome_attribution&#x3D;direct Default is total (returns direct+influenced+unattributed) if the parameter is omitted. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOutcomesAsyncWithHttpInfo($app_id, $outcome_names, $outcome_names2 = null, $outcome_time_range = null, $outcome_platforms = null, $outcome_attribution = null)
    {
        $returnType = '\onesignal\client\model\OutcomesData';
        $request = $this->getOutcomesRequest($app_id, $outcome_names, $outcome_names2, $outcome_time_range, $outcome_platforms, $outcome_attribution);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getOutcomes'
     *
     * @param  string $app_id The OneSignal App ID for your app.  Available in Keys &amp; IDs. (required)
     * @param  string $outcome_names Required Comma-separated list of names and the value (sum/count) for the returned outcome data. Note: Clicks only support count aggregation. For out-of-the-box OneSignal outcomes such as click and session duration, please use the \&quot;os\&quot; prefix with two underscores. For other outcomes, please use the name specified by the user. Example:os__session_duration.count,os__click.count,CustomOutcomeName.sum (required)
     * @param  string $outcome_names2 Optional If outcome names contain any commas, then please specify only one value at a time. Example: outcome_names[]&#x3D;os__click.count&amp;outcome_names[]&#x3D;Sales, Purchase.count where \&quot;Sales, Purchase\&quot; is the custom outcomes with a comma in the name. (optional)
     * @param  string $outcome_time_range Optional Time range for the returned data. The values can be 1h (for the last 1 hour data), 1d (for the last 1 day data), or 1mo (for the last 1 month data). Default is 1h if the parameter is omitted. (optional)
     * @param  string $outcome_platforms Optional Platform id. Refer device&#39;s platform ids for values. Example: outcome_platform&#x3D;0 for iOS outcome_platform&#x3D;7,8 for Safari and Firefox Default is data from all platforms if the parameter is omitted. (optional)
     * @param  string $outcome_attribution Optional Attribution type for the outcomes. The values can be direct or influenced or unattributed. Example: outcome_attribution&#x3D;direct Default is total (returns direct+influenced+unattributed) if the parameter is omitted. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getOutcomesRequest($app_id, $outcome_names, $outcome_names2 = null, $outcome_time_range = null, $outcome_platforms = null, $outcome_attribution = null)
    {
        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling getOutcomes'
            );
        }
        // verify the required parameter 'outcome_names' is set
        if ($outcome_names === null || (is_array($outcome_names) && count($outcome_names) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $outcome_names when calling getOutcomes'
            );
        }

        $resourcePath = '/apps/{app_id}/outcomes';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $outcome_names,
            'outcome_names', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $outcome_names2,
            'outcome_names[]', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $outcome_time_range,
            'outcome_time_range', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $outcome_platforms,
            'outcome_platforms', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $outcome_attribution,
            'outcome_attribution', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'app_id' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        if (!empty($this->config->getAppKeyToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAppKeyToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        // Adding the telemetry header
        $defaultHeaders['OS-Usage-Data'] = 'kind=sdk, sdk-name=onesignal-php, version=1.2.2';

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getPlayer
     *
     * View device
     *
     * @param  string $app_id Your app_id for this device (required)
     * @param  string $player_id Player&#39;s OneSignal ID (required)
     * @param  string $email_auth_hash Email - Only required if you have enabled Identity Verification and device_type is email (11). (optional)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \onesignal\client\model\Player|\onesignal\client\model\GenericError|\onesignal\client\model\RateLimiterError
     */
    public function getPlayer($app_id, $player_id, $email_auth_hash = null)
    {
        list($response) = $this->getPlayerWithHttpInfo($app_id, $player_id, $email_auth_hash);
        return $response;
    }

    /**
     * Operation getPlayerWithHttpInfo
     *
     * View device
     *
     * @param  string $app_id Your app_id for this device (required)
     * @param  string $player_id Player&#39;s OneSignal ID (required)
     * @param  string $email_auth_hash Email - Only required if you have enabled Identity Verification and device_type is email (11). (optional)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \onesignal\client\model\Player|\onesignal\client\model\GenericError|\onesignal\client\model\RateLimiterError, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPlayerWithHttpInfo($app_id, $player_id, $email_auth_hash = null)
    {
        $request = $this->getPlayerRequest($app_id, $player_id, $email_auth_hash);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\onesignal\client\model\Player' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\Player' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\Player', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\onesignal\client\model\GenericError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\GenericError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\GenericError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\onesignal\client\model\RateLimiterError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\RateLimiterError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\RateLimiterError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\onesignal\client\model\Player';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\Player',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\GenericError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\RateLimiterError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getPlayerAsync
     *
     * View device
     *
     * @param  string $app_id Your app_id for this device (required)
     * @param  string $player_id Player&#39;s OneSignal ID (required)
     * @param  string $email_auth_hash Email - Only required if you have enabled Identity Verification and device_type is email (11). (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPlayerAsync($app_id, $player_id, $email_auth_hash = null)
    {
        return $this->getPlayerAsyncWithHttpInfo($app_id, $player_id, $email_auth_hash)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getPlayerAsyncWithHttpInfo
     *
     * View device
     *
     * @param  string $app_id Your app_id for this device (required)
     * @param  string $player_id Player&#39;s OneSignal ID (required)
     * @param  string $email_auth_hash Email - Only required if you have enabled Identity Verification and device_type is email (11). (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPlayerAsyncWithHttpInfo($app_id, $player_id, $email_auth_hash = null)
    {
        $returnType = '\onesignal\client\model\Player';
        $request = $this->getPlayerRequest($app_id, $player_id, $email_auth_hash);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getPlayer'
     *
     * @param  string $app_id Your app_id for this device (required)
     * @param  string $player_id Player&#39;s OneSignal ID (required)
     * @param  string $email_auth_hash Email - Only required if you have enabled Identity Verification and device_type is email (11). (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getPlayerRequest($app_id, $player_id, $email_auth_hash = null)
    {
        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling getPlayer'
            );
        }
        // verify the required parameter 'player_id' is set
        if ($player_id === null || (is_array($player_id) && count($player_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $player_id when calling getPlayer'
            );
        }

        $resourcePath = '/players/{player_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $app_id,
            'app_id', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $email_auth_hash,
            'email_auth_hash', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($player_id !== null) {
            $resourcePath = str_replace(
                '{' . 'player_id' . '}',
                ObjectSerializer::toPathValue($player_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        if (!empty($this->config->getAppKeyToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAppKeyToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        // Adding the telemetry header
        $defaultHeaders['OS-Usage-Data'] = 'kind=sdk, sdk-name=onesignal-php, version=1.2.2';

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getPlayers
     *
     * View devices
     *
     * @param  string $app_id The app ID that you want to view players from (required)
     * @param  int $limit How many devices to return. Max is 300. Default is 300 (optional)
     * @param  int $offset Result offset. Default is 0. Results are sorted by id; (optional)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \onesignal\client\model\PlayerSlice|\onesignal\client\model\GenericError|\onesignal\client\model\RateLimiterError
     */
    public function getPlayers($app_id, $limit = null, $offset = null)
    {
        list($response) = $this->getPlayersWithHttpInfo($app_id, $limit, $offset);
        return $response;
    }

    /**
     * Operation getPlayersWithHttpInfo
     *
     * View devices
     *
     * @param  string $app_id The app ID that you want to view players from (required)
     * @param  int $limit How many devices to return. Max is 300. Default is 300 (optional)
     * @param  int $offset Result offset. Default is 0. Results are sorted by id; (optional)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \onesignal\client\model\PlayerSlice|\onesignal\client\model\GenericError|\onesignal\client\model\RateLimiterError, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPlayersWithHttpInfo($app_id, $limit = null, $offset = null)
    {
        $request = $this->getPlayersRequest($app_id, $limit, $offset);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\onesignal\client\model\PlayerSlice' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\PlayerSlice' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\PlayerSlice', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\onesignal\client\model\GenericError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\GenericError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\GenericError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\onesignal\client\model\RateLimiterError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\RateLimiterError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\RateLimiterError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\onesignal\client\model\PlayerSlice';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\PlayerSlice',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\GenericError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\RateLimiterError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getPlayersAsync
     *
     * View devices
     *
     * @param  string $app_id The app ID that you want to view players from (required)
     * @param  int $limit How many devices to return. Max is 300. Default is 300 (optional)
     * @param  int $offset Result offset. Default is 0. Results are sorted by id; (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPlayersAsync($app_id, $limit = null, $offset = null)
    {
        return $this->getPlayersAsyncWithHttpInfo($app_id, $limit, $offset)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getPlayersAsyncWithHttpInfo
     *
     * View devices
     *
     * @param  string $app_id The app ID that you want to view players from (required)
     * @param  int $limit How many devices to return. Max is 300. Default is 300 (optional)
     * @param  int $offset Result offset. Default is 0. Results are sorted by id; (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPlayersAsyncWithHttpInfo($app_id, $limit = null, $offset = null)
    {
        $returnType = '\onesignal\client\model\PlayerSlice';
        $request = $this->getPlayersRequest($app_id, $limit, $offset);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getPlayers'
     *
     * @param  string $app_id The app ID that you want to view players from (required)
     * @param  int $limit How many devices to return. Max is 300. Default is 300 (optional)
     * @param  int $offset Result offset. Default is 0. Results are sorted by id; (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getPlayersRequest($app_id, $limit = null, $offset = null)
    {
        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling getPlayers'
            );
        }

        $resourcePath = '/players';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $app_id,
            'app_id', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $offset,
            'offset', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        if (!empty($this->config->getAppKeyToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAppKeyToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        // Adding the telemetry header
        $defaultHeaders['OS-Usage-Data'] = 'kind=sdk, sdk-name=onesignal-php, version=1.2.2';

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation identifyUserByAlias
     *
     * @param  string $app_id app_id (required)
     * @param  string $alias_label alias_label (required)
     * @param  string $alias_id alias_id (required)
     * @param  \onesignal\client\model\UserIdentityRequestBody $user_identity_request_body user_identity_request_body (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \onesignal\client\model\InlineResponse200|\onesignal\client\model\GenericError|\onesignal\client\model\GenericError|\onesignal\client\model\RateLimiterError
     */
    public function identifyUserByAlias($app_id, $alias_label, $alias_id, $user_identity_request_body)
    {
        list($response) = $this->identifyUserByAliasWithHttpInfo($app_id, $alias_label, $alias_id, $user_identity_request_body);
        return $response;
    }

    /**
     * Operation identifyUserByAliasWithHttpInfo
     *
     * @param  string $app_id (required)
     * @param  string $alias_label (required)
     * @param  string $alias_id (required)
     * @param  \onesignal\client\model\UserIdentityRequestBody $user_identity_request_body (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \onesignal\client\model\InlineResponse200|\onesignal\client\model\GenericError|\onesignal\client\model\GenericError|\onesignal\client\model\RateLimiterError, HTTP status code, HTTP response headers (array of strings)
     */
    public function identifyUserByAliasWithHttpInfo($app_id, $alias_label, $alias_id, $user_identity_request_body)
    {
        $request = $this->identifyUserByAliasRequest($app_id, $alias_label, $alias_id, $user_identity_request_body);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\onesignal\client\model\InlineResponse200' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\InlineResponse200' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\InlineResponse200', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\onesignal\client\model\GenericError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\GenericError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\GenericError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 409:
                    if ('\onesignal\client\model\GenericError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\GenericError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\GenericError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\onesignal\client\model\RateLimiterError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\RateLimiterError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\RateLimiterError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\onesignal\client\model\InlineResponse200';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\InlineResponse200',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\GenericError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\GenericError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\RateLimiterError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation identifyUserByAliasAsync
     *
     * @param  string $app_id (required)
     * @param  string $alias_label (required)
     * @param  string $alias_id (required)
     * @param  \onesignal\client\model\UserIdentityRequestBody $user_identity_request_body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function identifyUserByAliasAsync($app_id, $alias_label, $alias_id, $user_identity_request_body)
    {
        return $this->identifyUserByAliasAsyncWithHttpInfo($app_id, $alias_label, $alias_id, $user_identity_request_body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation identifyUserByAliasAsyncWithHttpInfo
     *
     * @param  string $app_id (required)
     * @param  string $alias_label (required)
     * @param  string $alias_id (required)
     * @param  \onesignal\client\model\UserIdentityRequestBody $user_identity_request_body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function identifyUserByAliasAsyncWithHttpInfo($app_id, $alias_label, $alias_id, $user_identity_request_body)
    {
        $returnType = '\onesignal\client\model\InlineResponse200';
        $request = $this->identifyUserByAliasRequest($app_id, $alias_label, $alias_id, $user_identity_request_body);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'identifyUserByAlias'
     *
     * @param  string $app_id (required)
     * @param  string $alias_label (required)
     * @param  string $alias_id (required)
     * @param  \onesignal\client\model\UserIdentityRequestBody $user_identity_request_body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function identifyUserByAliasRequest($app_id, $alias_label, $alias_id, $user_identity_request_body)
    {
        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling identifyUserByAlias'
            );
        }
        // verify the required parameter 'alias_label' is set
        if ($alias_label === null || (is_array($alias_label) && count($alias_label) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $alias_label when calling identifyUserByAlias'
            );
        }
        // verify the required parameter 'alias_id' is set
        if ($alias_id === null || (is_array($alias_id) && count($alias_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $alias_id when calling identifyUserByAlias'
            );
        }
        // verify the required parameter 'user_identity_request_body' is set
        if ($user_identity_request_body === null || (is_array($user_identity_request_body) && count($user_identity_request_body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $user_identity_request_body when calling identifyUserByAlias'
            );
        }

        $resourcePath = '/apps/{app_id}/users/by/{alias_label}/{alias_id}/identity';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'app_id' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }
        // path params
        if ($alias_label !== null) {
            $resourcePath = str_replace(
                '{' . 'alias_label' . '}',
                ObjectSerializer::toPathValue($alias_label),
                $resourcePath
            );
        }
        // path params
        if ($alias_id !== null) {
            $resourcePath = str_replace(
                '{' . 'alias_id' . '}',
                ObjectSerializer::toPathValue($alias_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($user_identity_request_body)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($user_identity_request_body));
            } else {
                $httpBody = $user_identity_request_body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        if (!empty($this->config->getAppKeyToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAppKeyToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        // Adding the telemetry header
        $defaultHeaders['OS-Usage-Data'] = 'kind=sdk, sdk-name=onesignal-php, version=1.2.2';

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PATCH',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation identifyUserBySubscriptionId
     *
     * @param  string $app_id app_id (required)
     * @param  string $subscription_id subscription_id (required)
     * @param  \onesignal\client\model\UserIdentityRequestBody $user_identity_request_body user_identity_request_body (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \onesignal\client\model\UserIdentityResponse|\onesignal\client\model\GenericError|\onesignal\client\model\GenericError|\onesignal\client\model\RateLimiterError
     */
    public function identifyUserBySubscriptionId($app_id, $subscription_id, $user_identity_request_body)
    {
        list($response) = $this->identifyUserBySubscriptionIdWithHttpInfo($app_id, $subscription_id, $user_identity_request_body);
        return $response;
    }

    /**
     * Operation identifyUserBySubscriptionIdWithHttpInfo
     *
     * @param  string $app_id (required)
     * @param  string $subscription_id (required)
     * @param  \onesignal\client\model\UserIdentityRequestBody $user_identity_request_body (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \onesignal\client\model\UserIdentityResponse|\onesignal\client\model\GenericError|\onesignal\client\model\GenericError|\onesignal\client\model\RateLimiterError, HTTP status code, HTTP response headers (array of strings)
     */
    public function identifyUserBySubscriptionIdWithHttpInfo($app_id, $subscription_id, $user_identity_request_body)
    {
        $request = $this->identifyUserBySubscriptionIdRequest($app_id, $subscription_id, $user_identity_request_body);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\onesignal\client\model\UserIdentityResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\UserIdentityResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\UserIdentityResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\onesignal\client\model\GenericError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\GenericError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\GenericError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 409:
                    if ('\onesignal\client\model\GenericError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\GenericError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\GenericError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\onesignal\client\model\RateLimiterError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\RateLimiterError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\RateLimiterError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\onesignal\client\model\UserIdentityResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\UserIdentityResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\GenericError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\GenericError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\RateLimiterError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation identifyUserBySubscriptionIdAsync
     *
     * @param  string $app_id (required)
     * @param  string $subscription_id (required)
     * @param  \onesignal\client\model\UserIdentityRequestBody $user_identity_request_body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function identifyUserBySubscriptionIdAsync($app_id, $subscription_id, $user_identity_request_body)
    {
        return $this->identifyUserBySubscriptionIdAsyncWithHttpInfo($app_id, $subscription_id, $user_identity_request_body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation identifyUserBySubscriptionIdAsyncWithHttpInfo
     *
     * @param  string $app_id (required)
     * @param  string $subscription_id (required)
     * @param  \onesignal\client\model\UserIdentityRequestBody $user_identity_request_body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function identifyUserBySubscriptionIdAsyncWithHttpInfo($app_id, $subscription_id, $user_identity_request_body)
    {
        $returnType = '\onesignal\client\model\UserIdentityResponse';
        $request = $this->identifyUserBySubscriptionIdRequest($app_id, $subscription_id, $user_identity_request_body);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'identifyUserBySubscriptionId'
     *
     * @param  string $app_id (required)
     * @param  string $subscription_id (required)
     * @param  \onesignal\client\model\UserIdentityRequestBody $user_identity_request_body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function identifyUserBySubscriptionIdRequest($app_id, $subscription_id, $user_identity_request_body)
    {
        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling identifyUserBySubscriptionId'
            );
        }
        // verify the required parameter 'subscription_id' is set
        if ($subscription_id === null || (is_array($subscription_id) && count($subscription_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $subscription_id when calling identifyUserBySubscriptionId'
            );
        }
        // verify the required parameter 'user_identity_request_body' is set
        if ($user_identity_request_body === null || (is_array($user_identity_request_body) && count($user_identity_request_body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $user_identity_request_body when calling identifyUserBySubscriptionId'
            );
        }

        $resourcePath = '/apps/{app_id}/subscriptions/{subscription_id}/user/identity';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'app_id' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }
        // path params
        if ($subscription_id !== null) {
            $resourcePath = str_replace(
                '{' . 'subscription_id' . '}',
                ObjectSerializer::toPathValue($subscription_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($user_identity_request_body)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($user_identity_request_body));
            } else {
                $httpBody = $user_identity_request_body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        if (!empty($this->config->getAppKeyToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAppKeyToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        // Adding the telemetry header
        $defaultHeaders['OS-Usage-Data'] = 'kind=sdk, sdk-name=onesignal-php, version=1.2.2';

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PATCH',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation transferSubscription
     *
     * @param  string $app_id app_id (required)
     * @param  string $subscription_id subscription_id (required)
     * @param  \onesignal\client\model\TransferSubscriptionRequestBody $transfer_subscription_request_body transfer_subscription_request_body (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \onesignal\client\model\UserIdentityResponse|\onesignal\client\model\GenericError|\onesignal\client\model\GenericError|\onesignal\client\model\RateLimiterError
     */
    public function transferSubscription($app_id, $subscription_id, $transfer_subscription_request_body)
    {
        list($response) = $this->transferSubscriptionWithHttpInfo($app_id, $subscription_id, $transfer_subscription_request_body);
        return $response;
    }

    /**
     * Operation transferSubscriptionWithHttpInfo
     *
     * @param  string $app_id (required)
     * @param  string $subscription_id (required)
     * @param  \onesignal\client\model\TransferSubscriptionRequestBody $transfer_subscription_request_body (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \onesignal\client\model\UserIdentityResponse|\onesignal\client\model\GenericError|\onesignal\client\model\GenericError|\onesignal\client\model\RateLimiterError, HTTP status code, HTTP response headers (array of strings)
     */
    public function transferSubscriptionWithHttpInfo($app_id, $subscription_id, $transfer_subscription_request_body)
    {
        $request = $this->transferSubscriptionRequest($app_id, $subscription_id, $transfer_subscription_request_body);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\onesignal\client\model\UserIdentityResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\UserIdentityResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\UserIdentityResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\onesignal\client\model\GenericError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\GenericError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\GenericError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 409:
                    if ('\onesignal\client\model\GenericError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\GenericError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\GenericError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\onesignal\client\model\RateLimiterError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\RateLimiterError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\RateLimiterError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\onesignal\client\model\UserIdentityResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\UserIdentityResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\GenericError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\GenericError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\RateLimiterError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation transferSubscriptionAsync
     *
     * @param  string $app_id (required)
     * @param  string $subscription_id (required)
     * @param  \onesignal\client\model\TransferSubscriptionRequestBody $transfer_subscription_request_body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function transferSubscriptionAsync($app_id, $subscription_id, $transfer_subscription_request_body)
    {
        return $this->transferSubscriptionAsyncWithHttpInfo($app_id, $subscription_id, $transfer_subscription_request_body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation transferSubscriptionAsyncWithHttpInfo
     *
     * @param  string $app_id (required)
     * @param  string $subscription_id (required)
     * @param  \onesignal\client\model\TransferSubscriptionRequestBody $transfer_subscription_request_body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function transferSubscriptionAsyncWithHttpInfo($app_id, $subscription_id, $transfer_subscription_request_body)
    {
        $returnType = '\onesignal\client\model\UserIdentityResponse';
        $request = $this->transferSubscriptionRequest($app_id, $subscription_id, $transfer_subscription_request_body);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'transferSubscription'
     *
     * @param  string $app_id (required)
     * @param  string $subscription_id (required)
     * @param  \onesignal\client\model\TransferSubscriptionRequestBody $transfer_subscription_request_body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function transferSubscriptionRequest($app_id, $subscription_id, $transfer_subscription_request_body)
    {
        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling transferSubscription'
            );
        }
        // verify the required parameter 'subscription_id' is set
        if ($subscription_id === null || (is_array($subscription_id) && count($subscription_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $subscription_id when calling transferSubscription'
            );
        }
        // verify the required parameter 'transfer_subscription_request_body' is set
        if ($transfer_subscription_request_body === null || (is_array($transfer_subscription_request_body) && count($transfer_subscription_request_body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $transfer_subscription_request_body when calling transferSubscription'
            );
        }

        $resourcePath = '/apps/{app_id}/subscriptions/{subscription_id}/owner';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'app_id' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }
        // path params
        if ($subscription_id !== null) {
            $resourcePath = str_replace(
                '{' . 'subscription_id' . '}',
                ObjectSerializer::toPathValue($subscription_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($transfer_subscription_request_body)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($transfer_subscription_request_body));
            } else {
                $httpBody = $transfer_subscription_request_body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        if (!empty($this->config->getAppKeyToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAppKeyToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        // Adding the telemetry header
        $defaultHeaders['OS-Usage-Data'] = 'kind=sdk, sdk-name=onesignal-php, version=1.2.2';

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PATCH',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateApp
     *
     * Update an app
     *
     * @param  string $app_id An app id (required)
     * @param  \onesignal\client\model\App $app app (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \onesignal\client\model\App|\onesignal\client\model\GenericError|\onesignal\client\model\RateLimiterError
     */
    public function updateApp($app_id, $app)
    {
        list($response) = $this->updateAppWithHttpInfo($app_id, $app);
        return $response;
    }

    /**
     * Operation updateAppWithHttpInfo
     *
     * Update an app
     *
     * @param  string $app_id An app id (required)
     * @param  \onesignal\client\model\App $app (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \onesignal\client\model\App|\onesignal\client\model\GenericError|\onesignal\client\model\RateLimiterError, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateAppWithHttpInfo($app_id, $app)
    {
        $request = $this->updateAppRequest($app_id, $app);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\onesignal\client\model\App' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\App' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\App', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\onesignal\client\model\GenericError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\GenericError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\GenericError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\onesignal\client\model\RateLimiterError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\RateLimiterError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\RateLimiterError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\onesignal\client\model\App';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\App',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\GenericError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\RateLimiterError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updateAppAsync
     *
     * Update an app
     *
     * @param  string $app_id An app id (required)
     * @param  \onesignal\client\model\App $app (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateAppAsync($app_id, $app)
    {
        return $this->updateAppAsyncWithHttpInfo($app_id, $app)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateAppAsyncWithHttpInfo
     *
     * Update an app
     *
     * @param  string $app_id An app id (required)
     * @param  \onesignal\client\model\App $app (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateAppAsyncWithHttpInfo($app_id, $app)
    {
        $returnType = '\onesignal\client\model\App';
        $request = $this->updateAppRequest($app_id, $app);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateApp'
     *
     * @param  string $app_id An app id (required)
     * @param  \onesignal\client\model\App $app (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateAppRequest($app_id, $app)
    {
        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling updateApp'
            );
        }
        // verify the required parameter 'app' is set
        if ($app === null || (is_array($app) && count($app) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app when calling updateApp'
            );
        }

        $resourcePath = '/apps/{app_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'app_id' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($app)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($app));
            } else {
                $httpBody = $app;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        if (!empty($this->config->getUserKeyToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getUserKeyToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        // Adding the telemetry header
        $defaultHeaders['OS-Usage-Data'] = 'kind=sdk, sdk-name=onesignal-php, version=1.2.2';

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateLiveActivity
     *
     * Update a Live Activity via Push
     *
     * @param  string $app_id The OneSignal App ID for your app.  Available in Keys &amp; IDs. (required)
     * @param  string $activity_id Live Activity record ID (required)
     * @param  \onesignal\client\model\UpdateLiveActivityRequest $update_live_activity_request update_live_activity_request (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \onesignal\client\model\UpdateLiveActivitySuccessResponse|\onesignal\client\model\GenericError|\onesignal\client\model\RateLimiterError
     */
    public function updateLiveActivity($app_id, $activity_id, $update_live_activity_request)
    {
        list($response) = $this->updateLiveActivityWithHttpInfo($app_id, $activity_id, $update_live_activity_request);
        return $response;
    }

    /**
     * Operation updateLiveActivityWithHttpInfo
     *
     * Update a Live Activity via Push
     *
     * @param  string $app_id The OneSignal App ID for your app.  Available in Keys &amp; IDs. (required)
     * @param  string $activity_id Live Activity record ID (required)
     * @param  \onesignal\client\model\UpdateLiveActivityRequest $update_live_activity_request (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \onesignal\client\model\UpdateLiveActivitySuccessResponse|\onesignal\client\model\GenericError|\onesignal\client\model\RateLimiterError, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateLiveActivityWithHttpInfo($app_id, $activity_id, $update_live_activity_request)
    {
        $request = $this->updateLiveActivityRequest($app_id, $activity_id, $update_live_activity_request);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\onesignal\client\model\UpdateLiveActivitySuccessResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\UpdateLiveActivitySuccessResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\UpdateLiveActivitySuccessResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\onesignal\client\model\GenericError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\GenericError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\GenericError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\onesignal\client\model\RateLimiterError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\RateLimiterError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\RateLimiterError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\onesignal\client\model\UpdateLiveActivitySuccessResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\UpdateLiveActivitySuccessResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\GenericError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\RateLimiterError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updateLiveActivityAsync
     *
     * Update a Live Activity via Push
     *
     * @param  string $app_id The OneSignal App ID for your app.  Available in Keys &amp; IDs. (required)
     * @param  string $activity_id Live Activity record ID (required)
     * @param  \onesignal\client\model\UpdateLiveActivityRequest $update_live_activity_request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateLiveActivityAsync($app_id, $activity_id, $update_live_activity_request)
    {
        return $this->updateLiveActivityAsyncWithHttpInfo($app_id, $activity_id, $update_live_activity_request)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateLiveActivityAsyncWithHttpInfo
     *
     * Update a Live Activity via Push
     *
     * @param  string $app_id The OneSignal App ID for your app.  Available in Keys &amp; IDs. (required)
     * @param  string $activity_id Live Activity record ID (required)
     * @param  \onesignal\client\model\UpdateLiveActivityRequest $update_live_activity_request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateLiveActivityAsyncWithHttpInfo($app_id, $activity_id, $update_live_activity_request)
    {
        $returnType = '\onesignal\client\model\UpdateLiveActivitySuccessResponse';
        $request = $this->updateLiveActivityRequest($app_id, $activity_id, $update_live_activity_request);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateLiveActivity'
     *
     * @param  string $app_id The OneSignal App ID for your app.  Available in Keys &amp; IDs. (required)
     * @param  string $activity_id Live Activity record ID (required)
     * @param  \onesignal\client\model\UpdateLiveActivityRequest $update_live_activity_request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateLiveActivityRequest($app_id, $activity_id, $update_live_activity_request)
    {
        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling updateLiveActivity'
            );
        }
        // verify the required parameter 'activity_id' is set
        if ($activity_id === null || (is_array($activity_id) && count($activity_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $activity_id when calling updateLiveActivity'
            );
        }
        // verify the required parameter 'update_live_activity_request' is set
        if ($update_live_activity_request === null || (is_array($update_live_activity_request) && count($update_live_activity_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $update_live_activity_request when calling updateLiveActivity'
            );
        }

        $resourcePath = '/apps/{app_id}/live_activities/{activity_id}/notifications';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'app_id' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }
        // path params
        if ($activity_id !== null) {
            $resourcePath = str_replace(
                '{' . 'activity_id' . '}',
                ObjectSerializer::toPathValue($activity_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($update_live_activity_request)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($update_live_activity_request));
            } else {
                $httpBody = $update_live_activity_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        if (!empty($this->config->getAppKeyToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAppKeyToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        // Adding the telemetry header
        $defaultHeaders['OS-Usage-Data'] = 'kind=sdk, sdk-name=onesignal-php, version=1.2.2';

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updatePlayer
     *
     * Edit device
     *
     * @param  string $player_id Player&#39;s OneSignal ID (required)
     * @param  \onesignal\client\model\Player $player player (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \onesignal\client\model\UpdatePlayerSuccessResponse|\onesignal\client\model\GenericError|\onesignal\client\model\GenericError|\onesignal\client\model\RateLimiterError
     */
    public function updatePlayer($player_id, $player)
    {
        list($response) = $this->updatePlayerWithHttpInfo($player_id, $player);
        return $response;
    }

    /**
     * Operation updatePlayerWithHttpInfo
     *
     * Edit device
     *
     * @param  string $player_id Player&#39;s OneSignal ID (required)
     * @param  \onesignal\client\model\Player $player (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \onesignal\client\model\UpdatePlayerSuccessResponse|\onesignal\client\model\GenericError|\onesignal\client\model\GenericError|\onesignal\client\model\RateLimiterError, HTTP status code, HTTP response headers (array of strings)
     */
    public function updatePlayerWithHttpInfo($player_id, $player)
    {
        $request = $this->updatePlayerRequest($player_id, $player);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\onesignal\client\model\UpdatePlayerSuccessResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\UpdatePlayerSuccessResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\UpdatePlayerSuccessResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\onesignal\client\model\GenericError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\GenericError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\GenericError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 409:
                    if ('\onesignal\client\model\GenericError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\GenericError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\GenericError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\onesignal\client\model\RateLimiterError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\RateLimiterError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\RateLimiterError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\onesignal\client\model\UpdatePlayerSuccessResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\UpdatePlayerSuccessResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\GenericError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\GenericError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\RateLimiterError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updatePlayerAsync
     *
     * Edit device
     *
     * @param  string $player_id Player&#39;s OneSignal ID (required)
     * @param  \onesignal\client\model\Player $player (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updatePlayerAsync($player_id, $player)
    {
        return $this->updatePlayerAsyncWithHttpInfo($player_id, $player)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updatePlayerAsyncWithHttpInfo
     *
     * Edit device
     *
     * @param  string $player_id Player&#39;s OneSignal ID (required)
     * @param  \onesignal\client\model\Player $player (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updatePlayerAsyncWithHttpInfo($player_id, $player)
    {
        $returnType = '\onesignal\client\model\UpdatePlayerSuccessResponse';
        $request = $this->updatePlayerRequest($player_id, $player);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updatePlayer'
     *
     * @param  string $player_id Player&#39;s OneSignal ID (required)
     * @param  \onesignal\client\model\Player $player (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updatePlayerRequest($player_id, $player)
    {
        // verify the required parameter 'player_id' is set
        if ($player_id === null || (is_array($player_id) && count($player_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $player_id when calling updatePlayer'
            );
        }
        // verify the required parameter 'player' is set
        if ($player === null || (is_array($player) && count($player) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $player when calling updatePlayer'
            );
        }

        $resourcePath = '/players/{player_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($player_id !== null) {
            $resourcePath = str_replace(
                '{' . 'player_id' . '}',
                ObjectSerializer::toPathValue($player_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($player)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($player));
            } else {
                $httpBody = $player;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        if (!empty($this->config->getAppKeyToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAppKeyToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        // Adding the telemetry header
        $defaultHeaders['OS-Usage-Data'] = 'kind=sdk, sdk-name=onesignal-php, version=1.2.2';

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updatePlayerTags
     *
     * Edit tags with external user id
     *
     * @param  string $app_id The OneSignal App ID the user record is found under. (required)
     * @param  string $external_user_id The External User ID mapped to teh device record in OneSignal.  Must be actively set on the device to be updated. (required)
     * @param  \onesignal\client\model\UpdatePlayerTagsRequestBody $update_player_tags_request_body update_player_tags_request_body (optional)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \onesignal\client\model\UpdatePlayerTagsSuccessResponse|\onesignal\client\model\GenericError|\onesignal\client\model\GenericError|\onesignal\client\model\RateLimiterError
     */
    public function updatePlayerTags($app_id, $external_user_id, $update_player_tags_request_body = null)
    {
        list($response) = $this->updatePlayerTagsWithHttpInfo($app_id, $external_user_id, $update_player_tags_request_body);
        return $response;
    }

    /**
     * Operation updatePlayerTagsWithHttpInfo
     *
     * Edit tags with external user id
     *
     * @param  string $app_id The OneSignal App ID the user record is found under. (required)
     * @param  string $external_user_id The External User ID mapped to teh device record in OneSignal.  Must be actively set on the device to be updated. (required)
     * @param  \onesignal\client\model\UpdatePlayerTagsRequestBody $update_player_tags_request_body (optional)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \onesignal\client\model\UpdatePlayerTagsSuccessResponse|\onesignal\client\model\GenericError|\onesignal\client\model\GenericError|\onesignal\client\model\RateLimiterError, HTTP status code, HTTP response headers (array of strings)
     */
    public function updatePlayerTagsWithHttpInfo($app_id, $external_user_id, $update_player_tags_request_body = null)
    {
        $request = $this->updatePlayerTagsRequest($app_id, $external_user_id, $update_player_tags_request_body);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\onesignal\client\model\UpdatePlayerTagsSuccessResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\UpdatePlayerTagsSuccessResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\UpdatePlayerTagsSuccessResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\onesignal\client\model\GenericError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\GenericError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\GenericError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 409:
                    if ('\onesignal\client\model\GenericError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\GenericError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\GenericError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\onesignal\client\model\RateLimiterError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\RateLimiterError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\RateLimiterError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\onesignal\client\model\UpdatePlayerTagsSuccessResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\UpdatePlayerTagsSuccessResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\GenericError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\GenericError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\RateLimiterError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updatePlayerTagsAsync
     *
     * Edit tags with external user id
     *
     * @param  string $app_id The OneSignal App ID the user record is found under. (required)
     * @param  string $external_user_id The External User ID mapped to teh device record in OneSignal.  Must be actively set on the device to be updated. (required)
     * @param  \onesignal\client\model\UpdatePlayerTagsRequestBody $update_player_tags_request_body (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updatePlayerTagsAsync($app_id, $external_user_id, $update_player_tags_request_body = null)
    {
        return $this->updatePlayerTagsAsyncWithHttpInfo($app_id, $external_user_id, $update_player_tags_request_body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updatePlayerTagsAsyncWithHttpInfo
     *
     * Edit tags with external user id
     *
     * @param  string $app_id The OneSignal App ID the user record is found under. (required)
     * @param  string $external_user_id The External User ID mapped to teh device record in OneSignal.  Must be actively set on the device to be updated. (required)
     * @param  \onesignal\client\model\UpdatePlayerTagsRequestBody $update_player_tags_request_body (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updatePlayerTagsAsyncWithHttpInfo($app_id, $external_user_id, $update_player_tags_request_body = null)
    {
        $returnType = '\onesignal\client\model\UpdatePlayerTagsSuccessResponse';
        $request = $this->updatePlayerTagsRequest($app_id, $external_user_id, $update_player_tags_request_body);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updatePlayerTags'
     *
     * @param  string $app_id The OneSignal App ID the user record is found under. (required)
     * @param  string $external_user_id The External User ID mapped to teh device record in OneSignal.  Must be actively set on the device to be updated. (required)
     * @param  \onesignal\client\model\UpdatePlayerTagsRequestBody $update_player_tags_request_body (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updatePlayerTagsRequest($app_id, $external_user_id, $update_player_tags_request_body = null)
    {
        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling updatePlayerTags'
            );
        }
        // verify the required parameter 'external_user_id' is set
        if ($external_user_id === null || (is_array($external_user_id) && count($external_user_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $external_user_id when calling updatePlayerTags'
            );
        }

        $resourcePath = '/apps/{app_id}/users/{external_user_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'app_id' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }
        // path params
        if ($external_user_id !== null) {
            $resourcePath = str_replace(
                '{' . 'external_user_id' . '}',
                ObjectSerializer::toPathValue($external_user_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($update_player_tags_request_body)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($update_player_tags_request_body));
            } else {
                $httpBody = $update_player_tags_request_body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        if (!empty($this->config->getAppKeyToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAppKeyToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        // Adding the telemetry header
        $defaultHeaders['OS-Usage-Data'] = 'kind=sdk, sdk-name=onesignal-php, version=1.2.2';

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateSubscription
     *
     * @param  string $app_id app_id (required)
     * @param  string $subscription_id subscription_id (required)
     * @param  \onesignal\client\model\UpdateSubscriptionRequestBody $update_subscription_request_body update_subscription_request_body (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function updateSubscription($app_id, $subscription_id, $update_subscription_request_body)
    {
        $this->updateSubscriptionWithHttpInfo($app_id, $subscription_id, $update_subscription_request_body);
    }

    /**
     * Operation updateSubscriptionWithHttpInfo
     *
     * @param  string $app_id (required)
     * @param  string $subscription_id (required)
     * @param  \onesignal\client\model\UpdateSubscriptionRequestBody $update_subscription_request_body (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateSubscriptionWithHttpInfo($app_id, $subscription_id, $update_subscription_request_body)
    {
        $request = $this->updateSubscriptionRequest($app_id, $subscription_id, $update_subscription_request_body);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\GenericError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\GenericError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\RateLimiterError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updateSubscriptionAsync
     *
     * @param  string $app_id (required)
     * @param  string $subscription_id (required)
     * @param  \onesignal\client\model\UpdateSubscriptionRequestBody $update_subscription_request_body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateSubscriptionAsync($app_id, $subscription_id, $update_subscription_request_body)
    {
        return $this->updateSubscriptionAsyncWithHttpInfo($app_id, $subscription_id, $update_subscription_request_body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateSubscriptionAsyncWithHttpInfo
     *
     * @param  string $app_id (required)
     * @param  string $subscription_id (required)
     * @param  \onesignal\client\model\UpdateSubscriptionRequestBody $update_subscription_request_body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateSubscriptionAsyncWithHttpInfo($app_id, $subscription_id, $update_subscription_request_body)
    {
        $returnType = '';
        $request = $this->updateSubscriptionRequest($app_id, $subscription_id, $update_subscription_request_body);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateSubscription'
     *
     * @param  string $app_id (required)
     * @param  string $subscription_id (required)
     * @param  \onesignal\client\model\UpdateSubscriptionRequestBody $update_subscription_request_body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateSubscriptionRequest($app_id, $subscription_id, $update_subscription_request_body)
    {
        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling updateSubscription'
            );
        }
        // verify the required parameter 'subscription_id' is set
        if ($subscription_id === null || (is_array($subscription_id) && count($subscription_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $subscription_id when calling updateSubscription'
            );
        }
        // verify the required parameter 'update_subscription_request_body' is set
        if ($update_subscription_request_body === null || (is_array($update_subscription_request_body) && count($update_subscription_request_body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $update_subscription_request_body when calling updateSubscription'
            );
        }

        $resourcePath = '/apps/{app_id}/subscriptions/{subscription_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'app_id' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }
        // path params
        if ($subscription_id !== null) {
            $resourcePath = str_replace(
                '{' . 'subscription_id' . '}',
                ObjectSerializer::toPathValue($subscription_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($update_subscription_request_body)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($update_subscription_request_body));
            } else {
                $httpBody = $update_subscription_request_body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        if (!empty($this->config->getAppKeyToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAppKeyToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        // Adding the telemetry header
        $defaultHeaders['OS-Usage-Data'] = 'kind=sdk, sdk-name=onesignal-php, version=1.2.2';

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PATCH',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateUser
     *
     * @param  string $app_id app_id (required)
     * @param  string $alias_label alias_label (required)
     * @param  string $alias_id alias_id (required)
     * @param  \onesignal\client\model\UpdateUserRequest $update_user_request update_user_request (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \onesignal\client\model\InlineResponse202|\onesignal\client\model\GenericError|\onesignal\client\model\GenericError|\onesignal\client\model\RateLimiterError
     */
    public function updateUser($app_id, $alias_label, $alias_id, $update_user_request)
    {
        list($response) = $this->updateUserWithHttpInfo($app_id, $alias_label, $alias_id, $update_user_request);
        return $response;
    }

    /**
     * Operation updateUserWithHttpInfo
     *
     * @param  string $app_id (required)
     * @param  string $alias_label (required)
     * @param  string $alias_id (required)
     * @param  \onesignal\client\model\UpdateUserRequest $update_user_request (required)
     *
     * @throws \onesignal\client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \onesignal\client\model\InlineResponse202|\onesignal\client\model\GenericError|\onesignal\client\model\GenericError|\onesignal\client\model\RateLimiterError, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateUserWithHttpInfo($app_id, $alias_label, $alias_id, $update_user_request)
    {
        $request = $this->updateUserRequest($app_id, $alias_label, $alias_id, $update_user_request);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 202:
                    if ('\onesignal\client\model\InlineResponse202' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\InlineResponse202' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\InlineResponse202', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\onesignal\client\model\GenericError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\GenericError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\GenericError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 409:
                    if ('\onesignal\client\model\GenericError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\GenericError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\GenericError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\onesignal\client\model\RateLimiterError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\onesignal\client\model\RateLimiterError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\onesignal\client\model\RateLimiterError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\onesignal\client\model\InlineResponse202';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 202:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\InlineResponse202',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\GenericError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\GenericError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\onesignal\client\model\RateLimiterError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updateUserAsync
     *
     * @param  string $app_id (required)
     * @param  string $alias_label (required)
     * @param  string $alias_id (required)
     * @param  \onesignal\client\model\UpdateUserRequest $update_user_request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateUserAsync($app_id, $alias_label, $alias_id, $update_user_request)
    {
        return $this->updateUserAsyncWithHttpInfo($app_id, $alias_label, $alias_id, $update_user_request)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateUserAsyncWithHttpInfo
     *
     * @param  string $app_id (required)
     * @param  string $alias_label (required)
     * @param  string $alias_id (required)
     * @param  \onesignal\client\model\UpdateUserRequest $update_user_request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateUserAsyncWithHttpInfo($app_id, $alias_label, $alias_id, $update_user_request)
    {
        $returnType = '\onesignal\client\model\InlineResponse202';
        $request = $this->updateUserRequest($app_id, $alias_label, $alias_id, $update_user_request);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateUser'
     *
     * @param  string $app_id (required)
     * @param  string $alias_label (required)
     * @param  string $alias_id (required)
     * @param  \onesignal\client\model\UpdateUserRequest $update_user_request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateUserRequest($app_id, $alias_label, $alias_id, $update_user_request)
    {
        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling updateUser'
            );
        }
        // verify the required parameter 'alias_label' is set
        if ($alias_label === null || (is_array($alias_label) && count($alias_label) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $alias_label when calling updateUser'
            );
        }
        // verify the required parameter 'alias_id' is set
        if ($alias_id === null || (is_array($alias_id) && count($alias_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $alias_id when calling updateUser'
            );
        }
        // verify the required parameter 'update_user_request' is set
        if ($update_user_request === null || (is_array($update_user_request) && count($update_user_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $update_user_request when calling updateUser'
            );
        }

        $resourcePath = '/apps/{app_id}/users/by/{alias_label}/{alias_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'app_id' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }
        // path params
        if ($alias_label !== null) {
            $resourcePath = str_replace(
                '{' . 'alias_label' . '}',
                ObjectSerializer::toPathValue($alias_label),
                $resourcePath
            );
        }
        // path params
        if ($alias_id !== null) {
            $resourcePath = str_replace(
                '{' . 'alias_id' . '}',
                ObjectSerializer::toPathValue($alias_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($update_user_request)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($update_user_request));
            } else {
                $httpBody = $update_user_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        if (!empty($this->config->getAppKeyToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAppKeyToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        // Adding the telemetry header
        $defaultHeaders['OS-Usage-Data'] = 'kind=sdk, sdk-name=onesignal-php, version=1.2.2';

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PATCH',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
