<?php
/**
 * BasicNotificationAllOf
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  onesignal\client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OneSignal
 *
 * A powerful way to send personalized messages at scale and build effective customer engagement strategies. Learn more at onesignal.com
 *
 * The version of the OpenAPI document: 1.2.2
 * Contact: devrel@onesignal.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0-SNAPSHOT
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace onesignal\client\model;

use \ArrayAccess;
use \onesignal\client\ObjectSerializer;

/**
 * BasicNotificationAllOf Class Doc Comment
 *
 * @category Class
 * @package  onesignal\client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class BasicNotificationAllOf implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'BasicNotification_allOf';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'string',
        'value' => 'int',
        'name' => 'string',
        'aggregation' => 'string',
        'is_ios' => 'bool',
        'is_android' => 'bool',
        'is_huawei' => 'bool',
        'is_any_web' => 'bool',
        'is_chrome_web' => 'bool',
        'is_firefox' => 'bool',
        'is_safari' => 'bool',
        'is_wp_wns' => 'bool',
        'is_adm' => 'bool',
        'is_chrome' => 'bool',
        'channel_for_external_user_ids' => 'string',
        'app_id' => 'string',
        'external_id' => 'string',
        'contents' => 'StringMap',
        'headings' => 'StringMap',
        'subtitle' => 'StringMap',
        'data' => 'object',
        'huawei_msg_type' => 'string',
        'url' => 'string',
        'web_url' => 'string',
        'app_url' => 'string',
        'ios_attachments' => 'object',
        'template_id' => 'string',
        'content_available' => 'bool',
        'mutable_content' => 'bool',
        'target_content_identifier' => 'string',
        'big_picture' => 'string',
        'huawei_big_picture' => 'string',
        'adm_big_picture' => 'string',
        'chrome_big_picture' => 'string',
        'chrome_web_image' => 'string',
        'buttons' => '\onesignal\client\model\Button[]',
        'web_buttons' => '\onesignal\client\model\Button[]',
        'ios_category' => 'string',
        'android_channel_id' => 'string',
        'huawei_channel_id' => 'string',
        'existing_android_channel_id' => 'string',
        'huawei_existing_channel_id' => 'string',
        'android_background_layout' => '\onesignal\client\model\BasicNotificationAllOfAndroidBackgroundLayout',
        'small_icon' => 'string',
        'huawei_small_icon' => 'string',
        'large_icon' => 'string',
        'huawei_large_icon' => 'string',
        'adm_small_icon' => 'string',
        'adm_large_icon' => 'string',
        'chrome_web_icon' => 'string',
        'chrome_web_badge' => 'string',
        'firefox_icon' => 'string',
        'chrome_icon' => 'string',
        'ios_sound' => 'string',
        'android_sound' => 'string',
        'huawei_sound' => 'string',
        'adm_sound' => 'string',
        'wp_wns_sound' => 'string',
        'android_led_color' => 'string',
        'huawei_led_color' => 'string',
        'android_accent_color' => 'string',
        'huawei_accent_color' => 'string',
        'android_visibility' => 'int',
        'huawei_visibility' => 'int',
        'ios_badge_type' => 'string',
        'ios_badge_count' => 'int',
        'collapse_id' => 'string',
        'web_push_topic' => 'string',
        'apns_alert' => 'object',
        'delayed_option' => 'string',
        'delivery_time_of_day' => 'string',
        'ttl' => 'int',
        'priority' => 'int',
        'apns_push_type_override' => 'string',
        'throttle_rate_per_minute' => 'string',
        'android_group' => 'string',
        'android_group_message' => 'string',
        'adm_group' => 'string',
        'adm_group_message' => 'object',
        'thread_id' => 'string',
        'summary_arg' => 'string',
        'summary_arg_count' => 'int',
        'email_subject' => 'string',
        'email_body' => 'string',
        'email_from_name' => 'string',
        'email_from_address' => 'string',
        'email_preheader' => 'string',
        'include_unsubscribed' => 'bool',
        'sms_from' => 'string',
        'sms_media_urls' => 'string[]',
        'filters' => '\onesignal\client\model\Filter[]',
        'custom_data' => 'object'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => null,
        'value' => null,
        'name' => null,
        'aggregation' => null,
        'is_ios' => null,
        'is_android' => null,
        'is_huawei' => null,
        'is_any_web' => null,
        'is_chrome_web' => null,
        'is_firefox' => null,
        'is_safari' => null,
        'is_wp_wns' => null,
        'is_adm' => null,
        'is_chrome' => null,
        'channel_for_external_user_ids' => null,
        'app_id' => null,
        'external_id' => null,
        'contents' => null,
        'headings' => null,
        'subtitle' => null,
        'data' => null,
        'huawei_msg_type' => null,
        'url' => null,
        'web_url' => null,
        'app_url' => null,
        'ios_attachments' => null,
        'template_id' => null,
        'content_available' => null,
        'mutable_content' => null,
        'target_content_identifier' => null,
        'big_picture' => null,
        'huawei_big_picture' => null,
        'adm_big_picture' => null,
        'chrome_big_picture' => null,
        'chrome_web_image' => null,
        'buttons' => null,
        'web_buttons' => null,
        'ios_category' => null,
        'android_channel_id' => null,
        'huawei_channel_id' => null,
        'existing_android_channel_id' => null,
        'huawei_existing_channel_id' => null,
        'android_background_layout' => null,
        'small_icon' => null,
        'huawei_small_icon' => null,
        'large_icon' => null,
        'huawei_large_icon' => null,
        'adm_small_icon' => null,
        'adm_large_icon' => null,
        'chrome_web_icon' => null,
        'chrome_web_badge' => null,
        'firefox_icon' => null,
        'chrome_icon' => null,
        'ios_sound' => null,
        'android_sound' => null,
        'huawei_sound' => null,
        'adm_sound' => null,
        'wp_wns_sound' => null,
        'android_led_color' => null,
        'huawei_led_color' => null,
        'android_accent_color' => null,
        'huawei_accent_color' => null,
        'android_visibility' => null,
        'huawei_visibility' => null,
        'ios_badge_type' => null,
        'ios_badge_count' => null,
        'collapse_id' => null,
        'web_push_topic' => null,
        'apns_alert' => null,
        'delayed_option' => null,
        'delivery_time_of_day' => null,
        'ttl' => null,
        'priority' => null,
        'apns_push_type_override' => null,
        'throttle_rate_per_minute' => null,
        'android_group' => null,
        'android_group_message' => null,
        'adm_group' => null,
        'adm_group_message' => null,
        'thread_id' => null,
        'summary_arg' => null,
        'summary_arg_count' => null,
        'email_subject' => null,
        'email_body' => null,
        'email_from_name' => null,
        'email_from_address' => null,
        'email_preheader' => null,
        'include_unsubscribed' => null,
        'sms_from' => null,
        'sms_media_urls' => null,
        'filters' => null,
        'custom_data' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'value' => 'value',
        'name' => 'name',
        'aggregation' => 'aggregation',
        'is_ios' => 'isIos',
        'is_android' => 'isAndroid',
        'is_huawei' => 'isHuawei',
        'is_any_web' => 'isAnyWeb',
        'is_chrome_web' => 'isChromeWeb',
        'is_firefox' => 'isFirefox',
        'is_safari' => 'isSafari',
        'is_wp_wns' => 'isWP_WNS',
        'is_adm' => 'isAdm',
        'is_chrome' => 'isChrome',
        'channel_for_external_user_ids' => 'channel_for_external_user_ids',
        'app_id' => 'app_id',
        'external_id' => 'external_id',
        'contents' => 'contents',
        'headings' => 'headings',
        'subtitle' => 'subtitle',
        'data' => 'data',
        'huawei_msg_type' => 'huawei_msg_type',
        'url' => 'url',
        'web_url' => 'web_url',
        'app_url' => 'app_url',
        'ios_attachments' => 'ios_attachments',
        'template_id' => 'template_id',
        'content_available' => 'content_available',
        'mutable_content' => 'mutable_content',
        'target_content_identifier' => 'target_content_identifier',
        'big_picture' => 'big_picture',
        'huawei_big_picture' => 'huawei_big_picture',
        'adm_big_picture' => 'adm_big_picture',
        'chrome_big_picture' => 'chrome_big_picture',
        'chrome_web_image' => 'chrome_web_image',
        'buttons' => 'buttons',
        'web_buttons' => 'web_buttons',
        'ios_category' => 'ios_category',
        'android_channel_id' => 'android_channel_id',
        'huawei_channel_id' => 'huawei_channel_id',
        'existing_android_channel_id' => 'existing_android_channel_id',
        'huawei_existing_channel_id' => 'huawei_existing_channel_id',
        'android_background_layout' => 'android_background_layout',
        'small_icon' => 'small_icon',
        'huawei_small_icon' => 'huawei_small_icon',
        'large_icon' => 'large_icon',
        'huawei_large_icon' => 'huawei_large_icon',
        'adm_small_icon' => 'adm_small_icon',
        'adm_large_icon' => 'adm_large_icon',
        'chrome_web_icon' => 'chrome_web_icon',
        'chrome_web_badge' => 'chrome_web_badge',
        'firefox_icon' => 'firefox_icon',
        'chrome_icon' => 'chrome_icon',
        'ios_sound' => 'ios_sound',
        'android_sound' => 'android_sound',
        'huawei_sound' => 'huawei_sound',
        'adm_sound' => 'adm_sound',
        'wp_wns_sound' => 'wp_wns_sound',
        'android_led_color' => 'android_led_color',
        'huawei_led_color' => 'huawei_led_color',
        'android_accent_color' => 'android_accent_color',
        'huawei_accent_color' => 'huawei_accent_color',
        'android_visibility' => 'android_visibility',
        'huawei_visibility' => 'huawei_visibility',
        'ios_badge_type' => 'ios_badgeType',
        'ios_badge_count' => 'ios_badgeCount',
        'collapse_id' => 'collapse_id',
        'web_push_topic' => 'web_push_topic',
        'apns_alert' => 'apns_alert',
        'delayed_option' => 'delayed_option',
        'delivery_time_of_day' => 'delivery_time_of_day',
        'ttl' => 'ttl',
        'priority' => 'priority',
        'apns_push_type_override' => 'apns_push_type_override',
        'throttle_rate_per_minute' => 'throttle_rate_per_minute',
        'android_group' => 'android_group',
        'android_group_message' => 'android_group_message',
        'adm_group' => 'adm_group',
        'adm_group_message' => 'adm_group_message',
        'thread_id' => 'thread_id',
        'summary_arg' => 'summary_arg',
        'summary_arg_count' => 'summary_arg_count',
        'email_subject' => 'email_subject',
        'email_body' => 'email_body',
        'email_from_name' => 'email_from_name',
        'email_from_address' => 'email_from_address',
        'email_preheader' => 'email_preheader',
        'include_unsubscribed' => 'include_unsubscribed',
        'sms_from' => 'sms_from',
        'sms_media_urls' => 'sms_media_urls',
        'filters' => 'filters',
        'custom_data' => 'custom_data'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'value' => 'setValue',
        'name' => 'setName',
        'aggregation' => 'setAggregation',
        'is_ios' => 'setIsIos',
        'is_android' => 'setIsAndroid',
        'is_huawei' => 'setIsHuawei',
        'is_any_web' => 'setIsAnyWeb',
        'is_chrome_web' => 'setIsChromeWeb',
        'is_firefox' => 'setIsFirefox',
        'is_safari' => 'setIsSafari',
        'is_wp_wns' => 'setIsWpWns',
        'is_adm' => 'setIsAdm',
        'is_chrome' => 'setIsChrome',
        'channel_for_external_user_ids' => 'setChannelForExternalUserIds',
        'app_id' => 'setAppId',
        'external_id' => 'setExternalId',
        'contents' => 'setContents',
        'headings' => 'setHeadings',
        'subtitle' => 'setSubtitle',
        'data' => 'setData',
        'huawei_msg_type' => 'setHuaweiMsgType',
        'url' => 'setUrl',
        'web_url' => 'setWebUrl',
        'app_url' => 'setAppUrl',
        'ios_attachments' => 'setIosAttachments',
        'template_id' => 'setTemplateId',
        'content_available' => 'setContentAvailable',
        'mutable_content' => 'setMutableContent',
        'target_content_identifier' => 'setTargetContentIdentifier',
        'big_picture' => 'setBigPicture',
        'huawei_big_picture' => 'setHuaweiBigPicture',
        'adm_big_picture' => 'setAdmBigPicture',
        'chrome_big_picture' => 'setChromeBigPicture',
        'chrome_web_image' => 'setChromeWebImage',
        'buttons' => 'setButtons',
        'web_buttons' => 'setWebButtons',
        'ios_category' => 'setIosCategory',
        'android_channel_id' => 'setAndroidChannelId',
        'huawei_channel_id' => 'setHuaweiChannelId',
        'existing_android_channel_id' => 'setExistingAndroidChannelId',
        'huawei_existing_channel_id' => 'setHuaweiExistingChannelId',
        'android_background_layout' => 'setAndroidBackgroundLayout',
        'small_icon' => 'setSmallIcon',
        'huawei_small_icon' => 'setHuaweiSmallIcon',
        'large_icon' => 'setLargeIcon',
        'huawei_large_icon' => 'setHuaweiLargeIcon',
        'adm_small_icon' => 'setAdmSmallIcon',
        'adm_large_icon' => 'setAdmLargeIcon',
        'chrome_web_icon' => 'setChromeWebIcon',
        'chrome_web_badge' => 'setChromeWebBadge',
        'firefox_icon' => 'setFirefoxIcon',
        'chrome_icon' => 'setChromeIcon',
        'ios_sound' => 'setIosSound',
        'android_sound' => 'setAndroidSound',
        'huawei_sound' => 'setHuaweiSound',
        'adm_sound' => 'setAdmSound',
        'wp_wns_sound' => 'setWpWnsSound',
        'android_led_color' => 'setAndroidLedColor',
        'huawei_led_color' => 'setHuaweiLedColor',
        'android_accent_color' => 'setAndroidAccentColor',
        'huawei_accent_color' => 'setHuaweiAccentColor',
        'android_visibility' => 'setAndroidVisibility',
        'huawei_visibility' => 'setHuaweiVisibility',
        'ios_badge_type' => 'setIosBadgeType',
        'ios_badge_count' => 'setIosBadgeCount',
        'collapse_id' => 'setCollapseId',
        'web_push_topic' => 'setWebPushTopic',
        'apns_alert' => 'setApnsAlert',
        'delayed_option' => 'setDelayedOption',
        'delivery_time_of_day' => 'setDeliveryTimeOfDay',
        'ttl' => 'setTtl',
        'priority' => 'setPriority',
        'apns_push_type_override' => 'setApnsPushTypeOverride',
        'throttle_rate_per_minute' => 'setThrottleRatePerMinute',
        'android_group' => 'setAndroidGroup',
        'android_group_message' => 'setAndroidGroupMessage',
        'adm_group' => 'setAdmGroup',
        'adm_group_message' => 'setAdmGroupMessage',
        'thread_id' => 'setThreadId',
        'summary_arg' => 'setSummaryArg',
        'summary_arg_count' => 'setSummaryArgCount',
        'email_subject' => 'setEmailSubject',
        'email_body' => 'setEmailBody',
        'email_from_name' => 'setEmailFromName',
        'email_from_address' => 'setEmailFromAddress',
        'email_preheader' => 'setEmailPreheader',
        'include_unsubscribed' => 'setIncludeUnsubscribed',
        'sms_from' => 'setSmsFrom',
        'sms_media_urls' => 'setSmsMediaUrls',
        'filters' => 'setFilters',
        'custom_data' => 'setCustomData'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'value' => 'getValue',
        'name' => 'getName',
        'aggregation' => 'getAggregation',
        'is_ios' => 'getIsIos',
        'is_android' => 'getIsAndroid',
        'is_huawei' => 'getIsHuawei',
        'is_any_web' => 'getIsAnyWeb',
        'is_chrome_web' => 'getIsChromeWeb',
        'is_firefox' => 'getIsFirefox',
        'is_safari' => 'getIsSafari',
        'is_wp_wns' => 'getIsWpWns',
        'is_adm' => 'getIsAdm',
        'is_chrome' => 'getIsChrome',
        'channel_for_external_user_ids' => 'getChannelForExternalUserIds',
        'app_id' => 'getAppId',
        'external_id' => 'getExternalId',
        'contents' => 'getContents',
        'headings' => 'getHeadings',
        'subtitle' => 'getSubtitle',
        'data' => 'getData',
        'huawei_msg_type' => 'getHuaweiMsgType',
        'url' => 'getUrl',
        'web_url' => 'getWebUrl',
        'app_url' => 'getAppUrl',
        'ios_attachments' => 'getIosAttachments',
        'template_id' => 'getTemplateId',
        'content_available' => 'getContentAvailable',
        'mutable_content' => 'getMutableContent',
        'target_content_identifier' => 'getTargetContentIdentifier',
        'big_picture' => 'getBigPicture',
        'huawei_big_picture' => 'getHuaweiBigPicture',
        'adm_big_picture' => 'getAdmBigPicture',
        'chrome_big_picture' => 'getChromeBigPicture',
        'chrome_web_image' => 'getChromeWebImage',
        'buttons' => 'getButtons',
        'web_buttons' => 'getWebButtons',
        'ios_category' => 'getIosCategory',
        'android_channel_id' => 'getAndroidChannelId',
        'huawei_channel_id' => 'getHuaweiChannelId',
        'existing_android_channel_id' => 'getExistingAndroidChannelId',
        'huawei_existing_channel_id' => 'getHuaweiExistingChannelId',
        'android_background_layout' => 'getAndroidBackgroundLayout',
        'small_icon' => 'getSmallIcon',
        'huawei_small_icon' => 'getHuaweiSmallIcon',
        'large_icon' => 'getLargeIcon',
        'huawei_large_icon' => 'getHuaweiLargeIcon',
        'adm_small_icon' => 'getAdmSmallIcon',
        'adm_large_icon' => 'getAdmLargeIcon',
        'chrome_web_icon' => 'getChromeWebIcon',
        'chrome_web_badge' => 'getChromeWebBadge',
        'firefox_icon' => 'getFirefoxIcon',
        'chrome_icon' => 'getChromeIcon',
        'ios_sound' => 'getIosSound',
        'android_sound' => 'getAndroidSound',
        'huawei_sound' => 'getHuaweiSound',
        'adm_sound' => 'getAdmSound',
        'wp_wns_sound' => 'getWpWnsSound',
        'android_led_color' => 'getAndroidLedColor',
        'huawei_led_color' => 'getHuaweiLedColor',
        'android_accent_color' => 'getAndroidAccentColor',
        'huawei_accent_color' => 'getHuaweiAccentColor',
        'android_visibility' => 'getAndroidVisibility',
        'huawei_visibility' => 'getHuaweiVisibility',
        'ios_badge_type' => 'getIosBadgeType',
        'ios_badge_count' => 'getIosBadgeCount',
        'collapse_id' => 'getCollapseId',
        'web_push_topic' => 'getWebPushTopic',
        'apns_alert' => 'getApnsAlert',
        'delayed_option' => 'getDelayedOption',
        'delivery_time_of_day' => 'getDeliveryTimeOfDay',
        'ttl' => 'getTtl',
        'priority' => 'getPriority',
        'apns_push_type_override' => 'getApnsPushTypeOverride',
        'throttle_rate_per_minute' => 'getThrottleRatePerMinute',
        'android_group' => 'getAndroidGroup',
        'android_group_message' => 'getAndroidGroupMessage',
        'adm_group' => 'getAdmGroup',
        'adm_group_message' => 'getAdmGroupMessage',
        'thread_id' => 'getThreadId',
        'summary_arg' => 'getSummaryArg',
        'summary_arg_count' => 'getSummaryArgCount',
        'email_subject' => 'getEmailSubject',
        'email_body' => 'getEmailBody',
        'email_from_name' => 'getEmailFromName',
        'email_from_address' => 'getEmailFromAddress',
        'email_preheader' => 'getEmailPreheader',
        'include_unsubscribed' => 'getIncludeUnsubscribed',
        'sms_from' => 'getSmsFrom',
        'sms_media_urls' => 'getSmsMediaUrls',
        'filters' => 'getFilters',
        'custom_data' => 'getCustomData'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const AGGREGATION_SUM = 'sum';
    public const AGGREGATION_COUNT = 'count';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getAggregationAllowableValues()
    {
        return [
            self::AGGREGATION_SUM,
            self::AGGREGATION_COUNT,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = $data['id'] ?? null;
        $this->container['value'] = $data['value'] ?? null;
        $this->container['name'] = $data['name'] ?? null;
        $this->container['aggregation'] = $data['aggregation'] ?? null;
        $this->container['is_ios'] = $data['is_ios'] ?? null;
        $this->container['is_android'] = $data['is_android'] ?? null;
        $this->container['is_huawei'] = $data['is_huawei'] ?? null;
        $this->container['is_any_web'] = $data['is_any_web'] ?? null;
        $this->container['is_chrome_web'] = $data['is_chrome_web'] ?? null;
        $this->container['is_firefox'] = $data['is_firefox'] ?? null;
        $this->container['is_safari'] = $data['is_safari'] ?? null;
        $this->container['is_wp_wns'] = $data['is_wp_wns'] ?? null;
        $this->container['is_adm'] = $data['is_adm'] ?? null;
        $this->container['is_chrome'] = $data['is_chrome'] ?? null;
        $this->container['channel_for_external_user_ids'] = $data['channel_for_external_user_ids'] ?? null;
        $this->container['app_id'] = $data['app_id'] ?? null;
        $this->container['external_id'] = $data['external_id'] ?? null;
        $this->container['contents'] = $data['contents'] ?? null;
        $this->container['headings'] = $data['headings'] ?? null;
        $this->container['subtitle'] = $data['subtitle'] ?? null;
        $this->container['data'] = $data['data'] ?? null;
        $this->container['huawei_msg_type'] = $data['huawei_msg_type'] ?? null;
        $this->container['url'] = $data['url'] ?? null;
        $this->container['web_url'] = $data['web_url'] ?? null;
        $this->container['app_url'] = $data['app_url'] ?? null;
        $this->container['ios_attachments'] = $data['ios_attachments'] ?? null;
        $this->container['template_id'] = $data['template_id'] ?? null;
        $this->container['content_available'] = $data['content_available'] ?? null;
        $this->container['mutable_content'] = $data['mutable_content'] ?? null;
        $this->container['target_content_identifier'] = $data['target_content_identifier'] ?? null;
        $this->container['big_picture'] = $data['big_picture'] ?? null;
        $this->container['huawei_big_picture'] = $data['huawei_big_picture'] ?? null;
        $this->container['adm_big_picture'] = $data['adm_big_picture'] ?? null;
        $this->container['chrome_big_picture'] = $data['chrome_big_picture'] ?? null;
        $this->container['chrome_web_image'] = $data['chrome_web_image'] ?? null;
        $this->container['buttons'] = $data['buttons'] ?? null;
        $this->container['web_buttons'] = $data['web_buttons'] ?? null;
        $this->container['ios_category'] = $data['ios_category'] ?? null;
        $this->container['android_channel_id'] = $data['android_channel_id'] ?? null;
        $this->container['huawei_channel_id'] = $data['huawei_channel_id'] ?? null;
        $this->container['existing_android_channel_id'] = $data['existing_android_channel_id'] ?? null;
        $this->container['huawei_existing_channel_id'] = $data['huawei_existing_channel_id'] ?? null;
        $this->container['android_background_layout'] = $data['android_background_layout'] ?? null;
        $this->container['small_icon'] = $data['small_icon'] ?? null;
        $this->container['huawei_small_icon'] = $data['huawei_small_icon'] ?? null;
        $this->container['large_icon'] = $data['large_icon'] ?? null;
        $this->container['huawei_large_icon'] = $data['huawei_large_icon'] ?? null;
        $this->container['adm_small_icon'] = $data['adm_small_icon'] ?? null;
        $this->container['adm_large_icon'] = $data['adm_large_icon'] ?? null;
        $this->container['chrome_web_icon'] = $data['chrome_web_icon'] ?? null;
        $this->container['chrome_web_badge'] = $data['chrome_web_badge'] ?? null;
        $this->container['firefox_icon'] = $data['firefox_icon'] ?? null;
        $this->container['chrome_icon'] = $data['chrome_icon'] ?? null;
        $this->container['ios_sound'] = $data['ios_sound'] ?? null;
        $this->container['android_sound'] = $data['android_sound'] ?? null;
        $this->container['huawei_sound'] = $data['huawei_sound'] ?? null;
        $this->container['adm_sound'] = $data['adm_sound'] ?? null;
        $this->container['wp_wns_sound'] = $data['wp_wns_sound'] ?? null;
        $this->container['android_led_color'] = $data['android_led_color'] ?? null;
        $this->container['huawei_led_color'] = $data['huawei_led_color'] ?? null;
        $this->container['android_accent_color'] = $data['android_accent_color'] ?? null;
        $this->container['huawei_accent_color'] = $data['huawei_accent_color'] ?? null;
        $this->container['android_visibility'] = $data['android_visibility'] ?? null;
        $this->container['huawei_visibility'] = $data['huawei_visibility'] ?? null;
        $this->container['ios_badge_type'] = $data['ios_badge_type'] ?? null;
        $this->container['ios_badge_count'] = $data['ios_badge_count'] ?? null;
        $this->container['collapse_id'] = $data['collapse_id'] ?? null;
        $this->container['web_push_topic'] = $data['web_push_topic'] ?? null;
        $this->container['apns_alert'] = $data['apns_alert'] ?? null;
        $this->container['delayed_option'] = $data['delayed_option'] ?? null;
        $this->container['delivery_time_of_day'] = $data['delivery_time_of_day'] ?? null;
        $this->container['ttl'] = $data['ttl'] ?? null;
        $this->container['priority'] = $data['priority'] ?? null;
        $this->container['apns_push_type_override'] = $data['apns_push_type_override'] ?? null;
        $this->container['throttle_rate_per_minute'] = $data['throttle_rate_per_minute'] ?? null;
        $this->container['android_group'] = $data['android_group'] ?? null;
        $this->container['android_group_message'] = $data['android_group_message'] ?? null;
        $this->container['adm_group'] = $data['adm_group'] ?? null;
        $this->container['adm_group_message'] = $data['adm_group_message'] ?? null;
        $this->container['thread_id'] = $data['thread_id'] ?? null;
        $this->container['summary_arg'] = $data['summary_arg'] ?? null;
        $this->container['summary_arg_count'] = $data['summary_arg_count'] ?? null;
        $this->container['email_subject'] = $data['email_subject'] ?? null;
        $this->container['email_body'] = $data['email_body'] ?? null;
        $this->container['email_from_name'] = $data['email_from_name'] ?? null;
        $this->container['email_from_address'] = $data['email_from_address'] ?? null;
        $this->container['email_preheader'] = $data['email_preheader'] ?? null;
        $this->container['include_unsubscribed'] = $data['include_unsubscribed'] ?? null;
        $this->container['sms_from'] = $data['sms_from'] ?? null;
        $this->container['sms_media_urls'] = $data['sms_media_urls'] ?? null;
        $this->container['filters'] = $data['filters'] ?? null;
        $this->container['custom_data'] = $data['custom_data'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getAggregationAllowableValues();
        if (!is_null($this->container['aggregation']) && !in_array($this->container['aggregation'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'aggregation', must be one of '%s'",
                $this->container['aggregation'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id id
     *
     * @return self
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets value
     *
     * @return int|null
     */
    public function getValue()
    {
        return $this->container['value'];
    }

    /**
     * Sets value
     *
     * @param int|null $value value
     *
     * @return self
     */
    public function setValue($value)
    {
        $this->container['value'] = $value;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name Required for SMS Messages. An identifier for tracking message within the OneSignal dashboard or export analytics. Not shown to end user.
     *
     * @return self
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets aggregation
     *
     * @return string|null
     */
    public function getAggregation()
    {
        return $this->container['aggregation'];
    }

    /**
     * Sets aggregation
     *
     * @param string|null $aggregation aggregation
     *
     * @return self
     */
    public function setAggregation($aggregation)
    {
        $allowedValues = $this->getAggregationAllowableValues();
        if (!is_null($aggregation) && !in_array($aggregation, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'aggregation', must be one of '%s'",
                    $aggregation,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['aggregation'] = $aggregation;

        return $this;
    }

    /**
     * Gets is_ios
     *
     * @return bool|null
     */
    public function getIsIos()
    {
        return $this->container['is_ios'];
    }

    /**
     * Sets is_ios
     *
     * @param bool|null $is_ios Indicates whether to send to all devices registered under your app's Apple iOS platform.
     *
     * @return self
     */
    public function setIsIos($is_ios)
    {
        $this->container['is_ios'] = $is_ios;

        return $this;
    }

    /**
     * Gets is_android
     *
     * @return bool|null
     */
    public function getIsAndroid()
    {
        return $this->container['is_android'];
    }

    /**
     * Sets is_android
     *
     * @param bool|null $is_android Indicates whether to send to all devices registered under your app's Google Android platform.
     *
     * @return self
     */
    public function setIsAndroid($is_android)
    {
        $this->container['is_android'] = $is_android;

        return $this;
    }

    /**
     * Gets is_huawei
     *
     * @return bool|null
     */
    public function getIsHuawei()
    {
        return $this->container['is_huawei'];
    }

    /**
     * Sets is_huawei
     *
     * @param bool|null $is_huawei Indicates whether to send to all devices registered under your app's Huawei Android platform.
     *
     * @return self
     */
    public function setIsHuawei($is_huawei)
    {
        $this->container['is_huawei'] = $is_huawei;

        return $this;
    }

    /**
     * Gets is_any_web
     *
     * @return bool|null
     */
    public function getIsAnyWeb()
    {
        return $this->container['is_any_web'];
    }

    /**
     * Sets is_any_web
     *
     * @param bool|null $is_any_web Indicates whether to send to all subscribed web browser users, including Chrome, Firefox, and Safari. You may use this instead as a combined flag instead of separately enabling isChromeWeb, isFirefox, and isSafari, though the three options are equivalent to this one.
     *
     * @return self
     */
    public function setIsAnyWeb($is_any_web)
    {
        $this->container['is_any_web'] = $is_any_web;

        return $this;
    }

    /**
     * Gets is_chrome_web
     *
     * @return bool|null
     */
    public function getIsChromeWeb()
    {
        return $this->container['is_chrome_web'];
    }

    /**
     * Sets is_chrome_web
     *
     * @param bool|null $is_chrome_web Indicates whether to send to all Google Chrome, Chrome on Android, and Mozilla Firefox users registered under your Chrome & Firefox web push platform.
     *
     * @return self
     */
    public function setIsChromeWeb($is_chrome_web)
    {
        $this->container['is_chrome_web'] = $is_chrome_web;

        return $this;
    }

    /**
     * Gets is_firefox
     *
     * @return bool|null
     */
    public function getIsFirefox()
    {
        return $this->container['is_firefox'];
    }

    /**
     * Sets is_firefox
     *
     * @param bool|null $is_firefox Indicates whether to send to all Mozilla Firefox desktop users registered under your Firefox web push platform.
     *
     * @return self
     */
    public function setIsFirefox($is_firefox)
    {
        $this->container['is_firefox'] = $is_firefox;

        return $this;
    }

    /**
     * Gets is_safari
     *
     * @return bool|null
     */
    public function getIsSafari()
    {
        return $this->container['is_safari'];
    }

    /**
     * Sets is_safari
     *
     * @param bool|null $is_safari Does not support iOS Safari. Indicates whether to send to all Apple's Safari desktop users registered under your Safari web push platform. Read more iOS Safari
     *
     * @return self
     */
    public function setIsSafari($is_safari)
    {
        $this->container['is_safari'] = $is_safari;

        return $this;
    }

    /**
     * Gets is_wp_wns
     *
     * @return bool|null
     */
    public function getIsWpWns()
    {
        return $this->container['is_wp_wns'];
    }

    /**
     * Sets is_wp_wns
     *
     * @param bool|null $is_wp_wns Indicates whether to send to all devices registered under your app's Windows platform.
     *
     * @return self
     */
    public function setIsWpWns($is_wp_wns)
    {
        $this->container['is_wp_wns'] = $is_wp_wns;

        return $this;
    }

    /**
     * Gets is_adm
     *
     * @return bool|null
     */
    public function getIsAdm()
    {
        return $this->container['is_adm'];
    }

    /**
     * Sets is_adm
     *
     * @param bool|null $is_adm Indicates whether to send to all devices registered under your app's Amazon Fire platform.
     *
     * @return self
     */
    public function setIsAdm($is_adm)
    {
        $this->container['is_adm'] = $is_adm;

        return $this;
    }

    /**
     * Gets is_chrome
     *
     * @return bool|null
     */
    public function getIsChrome()
    {
        return $this->container['is_chrome'];
    }

    /**
     * Sets is_chrome
     *
     * @param bool|null $is_chrome This flag is not used for web push Please see isChromeWeb for sending to web push users. This flag only applies to Google Chrome Apps & Extensions. Indicates whether to send to all devices registered under your app's Google Chrome Apps & Extension platform.
     *
     * @return self
     */
    public function setIsChrome($is_chrome)
    {
        $this->container['is_chrome'] = $is_chrome;

        return $this;
    }

    /**
     * Gets channel_for_external_user_ids
     *
     * @return string|null
     */
    public function getChannelForExternalUserIds()
    {
        return $this->container['channel_for_external_user_ids'];
    }

    /**
     * Sets channel_for_external_user_ids
     *
     * @param string|null $channel_for_external_user_ids Indicates if the message type when targeting with include_external_user_ids for cases where an email, sms, and/or push subscribers have the same external user id. Example: Use the string \"push\" to indicate you are sending a push notification or the string \"email\"for sending emails or \"sms\"for sending SMS.
     *
     * @return self
     */
    public function setChannelForExternalUserIds($channel_for_external_user_ids)
    {
        $this->container['channel_for_external_user_ids'] = $channel_for_external_user_ids;

        return $this;
    }

    /**
     * Gets app_id
     *
     * @return string|null
     */
    public function getAppId()
    {
        return $this->container['app_id'];
    }

    /**
     * Sets app_id
     *
     * @param string|null $app_id Required: Your OneSignal Application ID, which can be found in Keys & IDs. It is a UUID and looks similar to 8250eaf6-1a58-489e-b136-7c74a864b434.
     *
     * @return self
     */
    public function setAppId($app_id)
    {
        $this->container['app_id'] = $app_id;

        return $this;
    }

    /**
     * Gets external_id
     *
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->container['external_id'];
    }

    /**
     * Sets external_id
     *
     * @param string|null $external_id Correlation and idempotency key. A request received with this parameter will first look for another notification with the same external_id. If one exists, a notification will not be sent, and result of the previous operation will instead be returned. Therefore, if you plan on using this feature, it's important to use a good source of randomness to generate the UUID passed here. This key is only idempotent for 30 days. After 30 days, the notification could be removed from our system and a notification with the same external_id will be sent again.   See Idempotent Notification Requests for more details writeOnly: true
     *
     * @return self
     */
    public function setExternalId($external_id)
    {
        $this->container['external_id'] = $external_id;

        return $this;
    }

    /**
     * Gets contents
     *
     * @return StringMap|null
     */
    public function getContents()
    {
        return $this->container['contents'];
    }

    /**
     * Sets contents
     *
     * @param StringMap|null $contents contents
     *
     * @return self
     */
    public function setContents($contents)
    {
        $this->container['contents'] = $contents;

        return $this;
    }

    /**
     * Gets headings
     *
     * @return StringMap|null
     */
    public function getHeadings()
    {
        return $this->container['headings'];
    }

    /**
     * Sets headings
     *
     * @param StringMap|null $headings headings
     *
     * @return self
     */
    public function setHeadings($headings)
    {
        $this->container['headings'] = $headings;

        return $this;
    }

    /**
     * Gets subtitle
     *
     * @return StringMap|null
     */
    public function getSubtitle()
    {
        return $this->container['subtitle'];
    }

    /**
     * Sets subtitle
     *
     * @param StringMap|null $subtitle subtitle
     *
     * @return self
     */
    public function setSubtitle($subtitle)
    {
        $this->container['subtitle'] = $subtitle;

        return $this;
    }

    /**
     * Gets data
     *
     * @return object|null
     */
    public function getData()
    {
        return $this->container['data'];
    }

    /**
     * Sets data
     *
     * @param object|null $data Channel: Push Notifications Platform: Huawei A custom map of data that is passed back to your app. Same as using Additional Data within the dashboard. Can use up to 2048 bytes of data. Example: {\"abc\": 123, \"foo\": \"bar\", \"event_performed\": true, \"amount\": 12.1}
     *
     * @return self
     */
    public function setData($data)
    {
        $this->container['data'] = $data;

        return $this;
    }

    /**
     * Gets huawei_msg_type
     *
     * @return string|null
     */
    public function getHuaweiMsgType()
    {
        return $this->container['huawei_msg_type'];
    }

    /**
     * Sets huawei_msg_type
     *
     * @param string|null $huawei_msg_type Channel: Push Notifications Platform: Huawei Use \"data\" or \"message\" depending on the type of notification you are sending. More details in Data & Background Notifications.
     *
     * @return self
     */
    public function setHuaweiMsgType($huawei_msg_type)
    {
        $this->container['huawei_msg_type'] = $huawei_msg_type;

        return $this;
    }

    /**
     * Gets url
     *
     * @return string|null
     */
    public function getUrl()
    {
        return $this->container['url'];
    }

    /**
     * Sets url
     *
     * @param string|null $url Channel: Push Notifications Platform: All The URL to open in the browser when a user clicks on the notification. Note: iOS needs https or updated NSAppTransportSecurity in plist This field supports inline substitutions. Omit if including web_url or app_url Example: https://onesignal.com
     *
     * @return self
     */
    public function setUrl($url)
    {
        $this->container['url'] = $url;

        return $this;
    }

    /**
     * Gets web_url
     *
     * @return string|null
     */
    public function getWebUrl()
    {
        return $this->container['web_url'];
    }

    /**
     * Sets web_url
     *
     * @param string|null $web_url Channel: Push Notifications Platform: All Browsers Same as url but only sent to web push platforms. Including Chrome, Firefox, Safari, Opera, etc. Example: https://onesignal.com
     *
     * @return self
     */
    public function setWebUrl($web_url)
    {
        $this->container['web_url'] = $web_url;

        return $this;
    }

    /**
     * Gets app_url
     *
     * @return string|null
     */
    public function getAppUrl()
    {
        return $this->container['app_url'];
    }

    /**
     * Sets app_url
     *
     * @param string|null $app_url Channel: Push Notifications Platform: All Browsers Same as url but only sent to web push platforms. Including iOS, Android, macOS, Windows, ChromeApps, etc. Example: https://onesignal.com
     *
     * @return self
     */
    public function setAppUrl($app_url)
    {
        $this->container['app_url'] = $app_url;

        return $this;
    }

    /**
     * Gets ios_attachments
     *
     * @return object|null
     */
    public function getIosAttachments()
    {
        return $this->container['ios_attachments'];
    }

    /**
     * Sets ios_attachments
     *
     * @param object|null $ios_attachments Channel: Push Notifications Platform: iOS 10+ Adds media attachments to notifications. Set as JSON object, key as a media id of your choice and the value as a valid local filename or URL. User must press and hold on the notification to view. Do not set mutable_content to download attachments. The OneSignal SDK does this automatically Example: {\"id1\": \"https://domain.com/image.jpg\"}
     *
     * @return self
     */
    public function setIosAttachments($ios_attachments)
    {
        $this->container['ios_attachments'] = $ios_attachments;

        return $this;
    }

    /**
     * Gets template_id
     *
     * @return string|null
     */
    public function getTemplateId()
    {
        return $this->container['template_id'];
    }

    /**
     * Sets template_id
     *
     * @param string|null $template_id Channel: Push Notifications Platform: All Use a template you setup on our dashboard. The template_id is the UUID found in the URL when viewing a template on our dashboard. Example: be4a8044-bbd6-11e4-a581-000c2940e62c
     *
     * @return self
     */
    public function setTemplateId($template_id)
    {
        $this->container['template_id'] = $template_id;

        return $this;
    }

    /**
     * Gets content_available
     *
     * @return bool|null
     */
    public function getContentAvailable()
    {
        return $this->container['content_available'];
    }

    /**
     * Sets content_available
     *
     * @param bool|null $content_available Channel: Push Notifications Platform: iOS Sending true wakes your app from background to run custom native code (Apple interprets this as content-available=1). Note: Not applicable if the app is in the \"force-quit\" state (i.e app was swiped away). Omit the contents field to prevent displaying a visible notification.
     *
     * @return self
     */
    public function setContentAvailable($content_available)
    {
        $this->container['content_available'] = $content_available;

        return $this;
    }

    /**
     * Gets mutable_content
     *
     * @return bool|null
     */
    public function getMutableContent()
    {
        return $this->container['mutable_content'];
    }

    /**
     * Sets mutable_content
     *
     * @param bool|null $mutable_content Channel: Push Notifications Platform: iOS 10+ Always defaults to true and cannot be turned off. Allows tracking of notification receives and changing of the notification content in your app before it is displayed. Triggers didReceive(_:withContentHandler:) on your UNNotificationServiceExtension.
     *
     * @return self
     */
    public function setMutableContent($mutable_content)
    {
        $this->container['mutable_content'] = $mutable_content;

        return $this;
    }

    /**
     * Gets target_content_identifier
     *
     * @return string|null
     */
    public function getTargetContentIdentifier()
    {
        return $this->container['target_content_identifier'];
    }

    /**
     * Sets target_content_identifier
     *
     * @param string|null $target_content_identifier Channel: Push Notifications Platform: iOS 13+ Use to target a specific experience in your App Clip, or to target your notification to a specific window in a multi-scene App.
     *
     * @return self
     */
    public function setTargetContentIdentifier($target_content_identifier)
    {
        $this->container['target_content_identifier'] = $target_content_identifier;

        return $this;
    }

    /**
     * Gets big_picture
     *
     * @return string|null
     */
    public function getBigPicture()
    {
        return $this->container['big_picture'];
    }

    /**
     * Sets big_picture
     *
     * @param string|null $big_picture Channel: Push Notifications Platform: Android Picture to display in the expanded view. Can be a drawable resource name or a URL.
     *
     * @return self
     */
    public function setBigPicture($big_picture)
    {
        $this->container['big_picture'] = $big_picture;

        return $this;
    }

    /**
     * Gets huawei_big_picture
     *
     * @return string|null
     */
    public function getHuaweiBigPicture()
    {
        return $this->container['huawei_big_picture'];
    }

    /**
     * Sets huawei_big_picture
     *
     * @param string|null $huawei_big_picture Channel: Push Notifications Platform: Huawei Picture to display in the expanded view. Can be a drawable resource name or a URL.
     *
     * @return self
     */
    public function setHuaweiBigPicture($huawei_big_picture)
    {
        $this->container['huawei_big_picture'] = $huawei_big_picture;

        return $this;
    }

    /**
     * Gets adm_big_picture
     *
     * @return string|null
     */
    public function getAdmBigPicture()
    {
        return $this->container['adm_big_picture'];
    }

    /**
     * Sets adm_big_picture
     *
     * @param string|null $adm_big_picture Channel: Push Notifications Platform: Amazon Picture to display in the expanded view. Can be a drawable resource name or a URL.
     *
     * @return self
     */
    public function setAdmBigPicture($adm_big_picture)
    {
        $this->container['adm_big_picture'] = $adm_big_picture;

        return $this;
    }

    /**
     * Gets chrome_big_picture
     *
     * @return string|null
     */
    public function getChromeBigPicture()
    {
        return $this->container['chrome_big_picture'];
    }

    /**
     * Sets chrome_big_picture
     *
     * @param string|null $chrome_big_picture Channel: Push Notifications Platform: ChromeApp Large picture to display below the notification text. Must be a local URL.
     *
     * @return self
     */
    public function setChromeBigPicture($chrome_big_picture)
    {
        $this->container['chrome_big_picture'] = $chrome_big_picture;

        return $this;
    }

    /**
     * Gets chrome_web_image
     *
     * @return string|null
     */
    public function getChromeWebImage()
    {
        return $this->container['chrome_web_image'];
    }

    /**
     * Sets chrome_web_image
     *
     * @param string|null $chrome_web_image Channel: Push Notifications Platform: Chrome 56+ Sets the web push notification's large image to be shown below the notification's title and text. Please see Web Push Notification Icons.
     *
     * @return self
     */
    public function setChromeWebImage($chrome_web_image)
    {
        $this->container['chrome_web_image'] = $chrome_web_image;

        return $this;
    }

    /**
     * Gets buttons
     *
     * @return \onesignal\client\model\Button[]|null
     */
    public function getButtons()
    {
        return $this->container['buttons'];
    }

    /**
     * Sets buttons
     *
     * @param \onesignal\client\model\Button[]|null $buttons Channel: Push Notifications Platform: iOS 8.0+, Android 4.1+, and derivatives like Amazon Buttons to add to the notification. Icon only works for Android. Buttons show in reverse order of array position i.e. Last item in array shows as first button on device. Example: [{\"id\": \"id2\", \"text\": \"second button\", \"icon\": \"ic_menu_share\"}, {\"id\": \"id1\", \"text\": \"first button\", \"icon\": \"ic_menu_send\"}]
     *
     * @return self
     */
    public function setButtons($buttons)
    {
        $this->container['buttons'] = $buttons;

        return $this;
    }

    /**
     * Gets web_buttons
     *
     * @return \onesignal\client\model\Button[]|null
     */
    public function getWebButtons()
    {
        return $this->container['web_buttons'];
    }

    /**
     * Sets web_buttons
     *
     * @param \onesignal\client\model\Button[]|null $web_buttons Channel: Push Notifications Platform: Chrome 48+ Add action buttons to the notification. The id field is required. Example: [{\"id\": \"like-button\", \"text\": \"Like\", \"icon\": \"http://i.imgur.com/N8SN8ZS.png\", \"url\": \"https://yoursite.com\"}, {\"id\": \"read-more-button\", \"text\": \"Read more\", \"icon\": \"http://i.imgur.com/MIxJp1L.png\", \"url\": \"https://yoursite.com\"}]
     *
     * @return self
     */
    public function setWebButtons($web_buttons)
    {
        $this->container['web_buttons'] = $web_buttons;

        return $this;
    }

    /**
     * Gets ios_category
     *
     * @return string|null
     */
    public function getIosCategory()
    {
        return $this->container['ios_category'];
    }

    /**
     * Sets ios_category
     *
     * @param string|null $ios_category Channel: Push Notifications Platform: iOS Category APS payload, use with registerUserNotificationSettings:categories in your Objective-C / Swift code. Example: calendar category which contains actions like accept and decline iOS 10+ This will trigger your UNNotificationContentExtension whose ID matches this category.
     *
     * @return self
     */
    public function setIosCategory($ios_category)
    {
        $this->container['ios_category'] = $ios_category;

        return $this;
    }

    /**
     * Gets android_channel_id
     *
     * @return string|null
     */
    public function getAndroidChannelId()
    {
        return $this->container['android_channel_id'];
    }

    /**
     * Sets android_channel_id
     *
     * @param string|null $android_channel_id Channel: Push Notifications Platform: Android The Android Oreo Notification Category to send the notification under. See the Category documentation on creating one and getting it's id.
     *
     * @return self
     */
    public function setAndroidChannelId($android_channel_id)
    {
        $this->container['android_channel_id'] = $android_channel_id;

        return $this;
    }

    /**
     * Gets huawei_channel_id
     *
     * @return string|null
     */
    public function getHuaweiChannelId()
    {
        return $this->container['huawei_channel_id'];
    }

    /**
     * Sets huawei_channel_id
     *
     * @param string|null $huawei_channel_id Channel: Push Notifications Platform: Huawei The Android Oreo Notification Category to send the notification under. See the Category documentation on creating one and getting it's id.
     *
     * @return self
     */
    public function setHuaweiChannelId($huawei_channel_id)
    {
        $this->container['huawei_channel_id'] = $huawei_channel_id;

        return $this;
    }

    /**
     * Gets existing_android_channel_id
     *
     * @return string|null
     */
    public function getExistingAndroidChannelId()
    {
        return $this->container['existing_android_channel_id'];
    }

    /**
     * Sets existing_android_channel_id
     *
     * @param string|null $existing_android_channel_id Channel: Push Notifications Platform: Android Use this if you have client side Android Oreo Channels you have already defined in your app with code.
     *
     * @return self
     */
    public function setExistingAndroidChannelId($existing_android_channel_id)
    {
        $this->container['existing_android_channel_id'] = $existing_android_channel_id;

        return $this;
    }

    /**
     * Gets huawei_existing_channel_id
     *
     * @return string|null
     */
    public function getHuaweiExistingChannelId()
    {
        return $this->container['huawei_existing_channel_id'];
    }

    /**
     * Sets huawei_existing_channel_id
     *
     * @param string|null $huawei_existing_channel_id Channel: Push Notifications Platform: Huawei Use this if you have client side Android Oreo Channels you have already defined in your app with code.
     *
     * @return self
     */
    public function setHuaweiExistingChannelId($huawei_existing_channel_id)
    {
        $this->container['huawei_existing_channel_id'] = $huawei_existing_channel_id;

        return $this;
    }

    /**
     * Gets android_background_layout
     *
     * @return \onesignal\client\model\BasicNotificationAllOfAndroidBackgroundLayout|null
     */
    public function getAndroidBackgroundLayout()
    {
        return $this->container['android_background_layout'];
    }

    /**
     * Sets android_background_layout
     *
     * @param \onesignal\client\model\BasicNotificationAllOfAndroidBackgroundLayout|null $android_background_layout android_background_layout
     *
     * @return self
     */
    public function setAndroidBackgroundLayout($android_background_layout)
    {
        $this->container['android_background_layout'] = $android_background_layout;

        return $this;
    }

    /**
     * Gets small_icon
     *
     * @return string|null
     */
    public function getSmallIcon()
    {
        return $this->container['small_icon'];
    }

    /**
     * Sets small_icon
     *
     * @param string|null $small_icon Channel: Push Notifications Platform: Android Icon shown in the status bar and on the top left of the notification. If not set a bell icon will be used or ic_stat_onesignal_default if you have set this resource name. See: How to create small icons
     *
     * @return self
     */
    public function setSmallIcon($small_icon)
    {
        $this->container['small_icon'] = $small_icon;

        return $this;
    }

    /**
     * Gets huawei_small_icon
     *
     * @return string|null
     */
    public function getHuaweiSmallIcon()
    {
        return $this->container['huawei_small_icon'];
    }

    /**
     * Sets huawei_small_icon
     *
     * @param string|null $huawei_small_icon Channel: Push Notifications Platform: Huawei Icon shown in the status bar and on the top left of the notification. Use an Android resource path (E.g. /drawable/small_icon). Defaults to your app icon if not set.
     *
     * @return self
     */
    public function setHuaweiSmallIcon($huawei_small_icon)
    {
        $this->container['huawei_small_icon'] = $huawei_small_icon;

        return $this;
    }

    /**
     * Gets large_icon
     *
     * @return string|null
     */
    public function getLargeIcon()
    {
        return $this->container['large_icon'];
    }

    /**
     * Sets large_icon
     *
     * @param string|null $large_icon Channel: Push Notifications Platform: Android Can be a drawable resource name or a URL. See: How to create large icons
     *
     * @return self
     */
    public function setLargeIcon($large_icon)
    {
        $this->container['large_icon'] = $large_icon;

        return $this;
    }

    /**
     * Gets huawei_large_icon
     *
     * @return string|null
     */
    public function getHuaweiLargeIcon()
    {
        return $this->container['huawei_large_icon'];
    }

    /**
     * Sets huawei_large_icon
     *
     * @param string|null $huawei_large_icon Channel: Push Notifications Platform: Huawei Can be a drawable resource name or a URL. See: How to create large icons
     *
     * @return self
     */
    public function setHuaweiLargeIcon($huawei_large_icon)
    {
        $this->container['huawei_large_icon'] = $huawei_large_icon;

        return $this;
    }

    /**
     * Gets adm_small_icon
     *
     * @return string|null
     */
    public function getAdmSmallIcon()
    {
        return $this->container['adm_small_icon'];
    }

    /**
     * Sets adm_small_icon
     *
     * @param string|null $adm_small_icon Channel: Push Notifications Platform: Amazon If not set a bell icon will be used or ic_stat_onesignal_default if you have set this resource name. See: How to create small icons
     *
     * @return self
     */
    public function setAdmSmallIcon($adm_small_icon)
    {
        $this->container['adm_small_icon'] = $adm_small_icon;

        return $this;
    }

    /**
     * Gets adm_large_icon
     *
     * @return string|null
     */
    public function getAdmLargeIcon()
    {
        return $this->container['adm_large_icon'];
    }

    /**
     * Sets adm_large_icon
     *
     * @param string|null $adm_large_icon Channel: Push Notifications Platform: Amazon If blank the small_icon is used. Can be a drawable resource name or a URL. See: How to create large icons
     *
     * @return self
     */
    public function setAdmLargeIcon($adm_large_icon)
    {
        $this->container['adm_large_icon'] = $adm_large_icon;

        return $this;
    }

    /**
     * Gets chrome_web_icon
     *
     * @return string|null
     */
    public function getChromeWebIcon()
    {
        return $this->container['chrome_web_icon'];
    }

    /**
     * Sets chrome_web_icon
     *
     * @param string|null $chrome_web_icon Channel: Push Notifications Platform: Chrome Sets the web push notification's icon. An image URL linking to a valid image. Common image types are supported; GIF will not animate. We recommend 256x256 (at least 80x80) to display well on high DPI devices. Firefox will also use this icon, unless you specify firefox_icon.
     *
     * @return self
     */
    public function setChromeWebIcon($chrome_web_icon)
    {
        $this->container['chrome_web_icon'] = $chrome_web_icon;

        return $this;
    }

    /**
     * Gets chrome_web_badge
     *
     * @return string|null
     */
    public function getChromeWebBadge()
    {
        return $this->container['chrome_web_badge'];
    }

    /**
     * Sets chrome_web_badge
     *
     * @param string|null $chrome_web_badge Channel: Push Notifications Platform: Chrome Sets the web push notification icon for Android devices in the notification shade. Please see Web Push Notification Badge.
     *
     * @return self
     */
    public function setChromeWebBadge($chrome_web_badge)
    {
        $this->container['chrome_web_badge'] = $chrome_web_badge;

        return $this;
    }

    /**
     * Gets firefox_icon
     *
     * @return string|null
     */
    public function getFirefoxIcon()
    {
        return $this->container['firefox_icon'];
    }

    /**
     * Sets firefox_icon
     *
     * @param string|null $firefox_icon Channel: Push Notifications Platform: Firefox Not recommended Few people need to set Firefox-specific icons. We recommend setting chrome_web_icon instead, which Firefox will also use. Sets the web push notification's icon for Firefox. An image URL linking to a valid image. Common image types are supported; GIF will not animate. We recommend 256x256 (at least 80x80) to display well on high DPI devices.
     *
     * @return self
     */
    public function setFirefoxIcon($firefox_icon)
    {
        $this->container['firefox_icon'] = $firefox_icon;

        return $this;
    }

    /**
     * Gets chrome_icon
     *
     * @return string|null
     */
    public function getChromeIcon()
    {
        return $this->container['chrome_icon'];
    }

    /**
     * Sets chrome_icon
     *
     * @param string|null $chrome_icon Channel: Push Notifications Platform: ChromeApp This flag is not used for web push For web push, please see chrome_web_icon instead. The local URL to an icon to use. If blank, the app icon will be used.
     *
     * @return self
     */
    public function setChromeIcon($chrome_icon)
    {
        $this->container['chrome_icon'] = $chrome_icon;

        return $this;
    }

    /**
     * Gets ios_sound
     *
     * @return string|null
     */
    public function getIosSound()
    {
        return $this->container['ios_sound'];
    }

    /**
     * Sets ios_sound
     *
     * @param string|null $ios_sound Channel: Push Notifications Platform: iOS Sound file that is included in your app to play instead of the default device notification sound. Pass nil to disable vibration and sound for the notification. Example: \"notification.wav\"
     *
     * @return self
     */
    public function setIosSound($ios_sound)
    {
        $this->container['ios_sound'] = $ios_sound;

        return $this;
    }

    /**
     * Gets android_sound
     *
     * @return string|null
     */
    public function getAndroidSound()
    {
        return $this->container['android_sound'];
    }

    /**
     * Sets android_sound
     *
     * @param string|null $android_sound Channel: Push Notifications Platform: Android &#9888;&#65039;Deprecated, this field doesn't work on Android 8 (Oreo) and newer devices! Please use Notification Categories / Channels noted above instead to support ALL versions of Android. Sound file that is included in your app to play instead of the default device notification sound. Pass nil to disable sound for the notification. NOTE: Leave off file extension for Android. Example: \"notification\"
     *
     * @return self
     */
    public function setAndroidSound($android_sound)
    {
        $this->container['android_sound'] = $android_sound;

        return $this;
    }

    /**
     * Gets huawei_sound
     *
     * @return string|null
     */
    public function getHuaweiSound()
    {
        return $this->container['huawei_sound'];
    }

    /**
     * Sets huawei_sound
     *
     * @param string|null $huawei_sound Channel: Push Notifications Platform: Huawei &#9888;&#65039;Deprecated, this field ONLY works on EMUI 5 (Android 7 based) and older devices. Please also set Notification Categories / Channels noted above to support EMUI 8 (Android 8 based) devices. Sound file that is included in your app to play instead of the default device notification sound. NOTE: Leave off file extension for and include the full path.  Example: \"/res/raw/notification\"
     *
     * @return self
     */
    public function setHuaweiSound($huawei_sound)
    {
        $this->container['huawei_sound'] = $huawei_sound;

        return $this;
    }

    /**
     * Gets adm_sound
     *
     * @return string|null
     */
    public function getAdmSound()
    {
        return $this->container['adm_sound'];
    }

    /**
     * Sets adm_sound
     *
     * @param string|null $adm_sound Channel: Push Notifications Platform: Amazon &#9888;&#65039;Deprecated, this field doesn't work on Android 8 (Oreo) and newer devices! Please use Notification Categories / Channels noted above instead to support ALL versions of Android. Sound file that is included in your app to play instead of the default device notification sound. Pass nil to disable sound for the notification. NOTE: Leave off file extension for Android. Example: \"notification\"
     *
     * @return self
     */
    public function setAdmSound($adm_sound)
    {
        $this->container['adm_sound'] = $adm_sound;

        return $this;
    }

    /**
     * Gets wp_wns_sound
     *
     * @return string|null
     */
    public function getWpWnsSound()
    {
        return $this->container['wp_wns_sound'];
    }

    /**
     * Sets wp_wns_sound
     *
     * @param string|null $wp_wns_sound Channel: Push Notifications Platform: Windows Sound file that is included in your app to play instead of the default device notification sound. Example: \"notification.wav\"
     *
     * @return self
     */
    public function setWpWnsSound($wp_wns_sound)
    {
        $this->container['wp_wns_sound'] = $wp_wns_sound;

        return $this;
    }

    /**
     * Gets android_led_color
     *
     * @return string|null
     */
    public function getAndroidLedColor()
    {
        return $this->container['android_led_color'];
    }

    /**
     * Sets android_led_color
     *
     * @param string|null $android_led_color Channel: Push Notifications Platform: Android &#9888;&#65039;Deprecated, this field doesn't work on Android 8 (Oreo) and newer devices! Please use Notification Categories / Channels noted above instead to support ALL versions of Android. Sets the devices LED notification light if the device has one. ARGB Hex format. Example(Blue): \"FF0000FF\"
     *
     * @return self
     */
    public function setAndroidLedColor($android_led_color)
    {
        $this->container['android_led_color'] = $android_led_color;

        return $this;
    }

    /**
     * Gets huawei_led_color
     *
     * @return string|null
     */
    public function getHuaweiLedColor()
    {
        return $this->container['huawei_led_color'];
    }

    /**
     * Sets huawei_led_color
     *
     * @param string|null $huawei_led_color Channel: Push Notifications Platform: Huawei &#9888;&#65039;Deprecated, this field ONLY works on EMUI 5 (Android 7 based) and older devices. Please also set Notification Categories / Channels noted above to support EMUI 8 (Android 8 based) devices. Sets the devices LED notification light if the device has one. RGB Hex format. Example(Blue): \"0000FF\"
     *
     * @return self
     */
    public function setHuaweiLedColor($huawei_led_color)
    {
        $this->container['huawei_led_color'] = $huawei_led_color;

        return $this;
    }

    /**
     * Gets android_accent_color
     *
     * @return string|null
     */
    public function getAndroidAccentColor()
    {
        return $this->container['android_accent_color'];
    }

    /**
     * Sets android_accent_color
     *
     * @param string|null $android_accent_color Channel: Push Notifications Platform: Android Sets the background color of the notification circle to the left of the notification text. Only applies to apps targeting Android API level 21+ on Android 5.0+ devices. Example(Red): \"FFFF0000\"
     *
     * @return self
     */
    public function setAndroidAccentColor($android_accent_color)
    {
        $this->container['android_accent_color'] = $android_accent_color;

        return $this;
    }

    /**
     * Gets huawei_accent_color
     *
     * @return string|null
     */
    public function getHuaweiAccentColor()
    {
        return $this->container['huawei_accent_color'];
    }

    /**
     * Sets huawei_accent_color
     *
     * @param string|null $huawei_accent_color Channel: Push Notifications Platform: Huawei Accent Color used on Action Buttons and Group overflow count. Uses RGB Hex value (E.g. #9900FF). Defaults to device's theme color if not set.
     *
     * @return self
     */
    public function setHuaweiAccentColor($huawei_accent_color)
    {
        $this->container['huawei_accent_color'] = $huawei_accent_color;

        return $this;
    }

    /**
     * Gets android_visibility
     *
     * @return int|null
     */
    public function getAndroidVisibility()
    {
        return $this->container['android_visibility'];
    }

    /**
     * Sets android_visibility
     *
     * @param int|null $android_visibility Channel: Push Notifications Platform: Android 5.0_ &#9888;&#65039;Deprecated, this field doesn't work on Android 8 (Oreo) and newer devices! Please use Notification Categories / Channels noted above instead to support ALL versions of Android. 1 = Public (default) (Shows the full message on the lock screen unless the user has disabled all notifications from showing on the lock screen. Please consider the user and mark private if the contents are.) 0 = Private (Hides message contents on lock screen if the user set \"Hide sensitive notification content\" in the system settings) -1 = Secret (Notification does not show on the lock screen at all)
     *
     * @return self
     */
    public function setAndroidVisibility($android_visibility)
    {
        $this->container['android_visibility'] = $android_visibility;

        return $this;
    }

    /**
     * Gets huawei_visibility
     *
     * @return int|null
     */
    public function getHuaweiVisibility()
    {
        return $this->container['huawei_visibility'];
    }

    /**
     * Sets huawei_visibility
     *
     * @param int|null $huawei_visibility Channel: Push Notifications Platform: Huawei &#9888;&#65039;Deprecated, this field ONLY works on EMUI 5 (Android 7 based) and older devices. Please also set Notification Categories / Channels noted above to support EMUI 8 (Android 8 based) devices. 1 = Public (default) (Shows the full message on the lock screen unless the user has disabled all notifications from showing on the lock screen. Please consider the user and mark private if the contents are.) 0 = Private (Hides message contents on lock screen if the user set \"Hide sensitive notification content\" in the system settings) -1 = Secret (Notification does not show on the lock screen at all)
     *
     * @return self
     */
    public function setHuaweiVisibility($huawei_visibility)
    {
        $this->container['huawei_visibility'] = $huawei_visibility;

        return $this;
    }

    /**
     * Gets ios_badge_type
     *
     * @return string|null
     */
    public function getIosBadgeType()
    {
        return $this->container['ios_badge_type'];
    }

    /**
     * Sets ios_badge_type
     *
     * @param string|null $ios_badge_type Channel: Push Notifications Platform: iOS Describes whether to set or increase/decrease your app's iOS badge count by the ios_badgeCount specified count. Can specify None, SetTo, or Increase. `None` leaves the count unaffected. `SetTo` directly sets the badge count to the number specified in ios_badgeCount. `Increase` adds the number specified in ios_badgeCount to the total. Use a negative number to decrease the badge count.
     *
     * @return self
     */
    public function setIosBadgeType($ios_badge_type)
    {
        $this->container['ios_badge_type'] = $ios_badge_type;

        return $this;
    }

    /**
     * Gets ios_badge_count
     *
     * @return int|null
     */
    public function getIosBadgeCount()
    {
        return $this->container['ios_badge_count'];
    }

    /**
     * Sets ios_badge_count
     *
     * @param int|null $ios_badge_count Channel: Push Notifications Platform: iOS Used with ios_badgeType, describes the value to set or amount to increase/decrease your app's iOS badge count by. You can use a negative number to decrease the badge count when used with an ios_badgeType of Increase.
     *
     * @return self
     */
    public function setIosBadgeCount($ios_badge_count)
    {
        $this->container['ios_badge_count'] = $ios_badge_count;

        return $this;
    }

    /**
     * Gets collapse_id
     *
     * @return string|null
     */
    public function getCollapseId()
    {
        return $this->container['collapse_id'];
    }

    /**
     * Sets collapse_id
     *
     * @param string|null $collapse_id Channel: Push Notifications Platform: iOS 10+, Android Only one notification with the same id will be shown on the device. Use the same id to update an existing notification instead of showing a new one. Limit of 64 characters.
     *
     * @return self
     */
    public function setCollapseId($collapse_id)
    {
        $this->container['collapse_id'] = $collapse_id;

        return $this;
    }

    /**
     * Gets web_push_topic
     *
     * @return string|null
     */
    public function getWebPushTopic()
    {
        return $this->container['web_push_topic'];
    }

    /**
     * Sets web_push_topic
     *
     * @param string|null $web_push_topic Channel: Push Notifications Platform: All Browsers Display multiple notifications at once with different topics.
     *
     * @return self
     */
    public function setWebPushTopic($web_push_topic)
    {
        $this->container['web_push_topic'] = $web_push_topic;

        return $this;
    }

    /**
     * Gets apns_alert
     *
     * @return object|null
     */
    public function getApnsAlert()
    {
        return $this->container['apns_alert'];
    }

    /**
     * Sets apns_alert
     *
     * @param object|null $apns_alert Channel: Push Notifications Platform: iOS 10+ iOS can localize push notification messages on the client using special parameters such as loc-key. When using the Create Notification endpoint, you must include these parameters inside of a field called apns_alert. Please see Apple's guide on localizing push notifications to learn more.
     *
     * @return self
     */
    public function setApnsAlert($apns_alert)
    {
        $this->container['apns_alert'] = $apns_alert;

        return $this;
    }

    /**
     * Gets delayed_option
     *
     * @return string|null
     */
    public function getDelayedOption()
    {
        return $this->container['delayed_option'];
    }

    /**
     * Sets delayed_option
     *
     * @param string|null $delayed_option Channel: All Possible values are: timezone (Deliver at a specific time-of-day in each users own timezone) last-active Same as Intelligent Delivery . (Deliver at the same time of day as each user last used your app). If send_after is used, this takes effect after the send_after time has elapsed.
     *
     * @return self
     */
    public function setDelayedOption($delayed_option)
    {
        $this->container['delayed_option'] = $delayed_option;

        return $this;
    }

    /**
     * Gets delivery_time_of_day
     *
     * @return string|null
     */
    public function getDeliveryTimeOfDay()
    {
        return $this->container['delivery_time_of_day'];
    }

    /**
     * Sets delivery_time_of_day
     *
     * @param string|null $delivery_time_of_day Channel: All Use with delayed_option=timezone. Examples: \"9:00AM\" \"21:45\" \"9:45:30\"
     *
     * @return self
     */
    public function setDeliveryTimeOfDay($delivery_time_of_day)
    {
        $this->container['delivery_time_of_day'] = $delivery_time_of_day;

        return $this;
    }

    /**
     * Gets ttl
     *
     * @return int|null
     */
    public function getTtl()
    {
        return $this->container['ttl'];
    }

    /**
     * Sets ttl
     *
     * @param int|null $ttl Channel: Push Notifications Platform: iOS, Android, Chrome, Firefox, Safari, ChromeWeb Time To Live - In seconds. The notification will be expired if the device does not come back online within this time. The default is 259,200 seconds (3 days). Max value to set is 2419200 seconds (28 days).
     *
     * @return self
     */
    public function setTtl($ttl)
    {
        $this->container['ttl'] = $ttl;

        return $this;
    }

    /**
     * Gets priority
     *
     * @return int|null
     */
    public function getPriority()
    {
        return $this->container['priority'];
    }

    /**
     * Sets priority
     *
     * @param int|null $priority Channel: Push Notifications Platform: Android, Chrome, ChromeWeb Delivery priority through the push server (example GCM/FCM). Pass 10 for high priority or any other integer for normal priority. Defaults to normal priority for Android and high for iOS. For Android 6.0+ devices setting priority to high will wake the device out of doze mode.
     *
     * @return self
     */
    public function setPriority($priority)
    {
        $this->container['priority'] = $priority;

        return $this;
    }

    /**
     * Gets apns_push_type_override
     *
     * @return string|null
     */
    public function getApnsPushTypeOverride()
    {
        return $this->container['apns_push_type_override'];
    }

    /**
     * Sets apns_push_type_override
     *
     * @param string|null $apns_push_type_override Channel: Push Notifications Platform: iOS valid values: voip Set the value to voip for sending VoIP Notifications This field maps to the APNS header apns-push-type. Note: alert and background are automatically set by OneSignal
     *
     * @return self
     */
    public function setApnsPushTypeOverride($apns_push_type_override)
    {
        $this->container['apns_push_type_override'] = $apns_push_type_override;

        return $this;
    }

    /**
     * Gets throttle_rate_per_minute
     *
     * @return string|null
     */
    public function getThrottleRatePerMinute()
    {
        return $this->container['throttle_rate_per_minute'];
    }

    /**
     * Sets throttle_rate_per_minute
     *
     * @param string|null $throttle_rate_per_minute Channel: All Apps with throttling enabled:   - the parameter value will be used to override the default application throttling value set from the dashboard settings.   - parameter value 0 indicates not to apply throttling to the notification.   - if the parameter is not passed then the default app throttling value will be applied to the notification. Apps with throttling disabled:   - this parameter can be used to throttle delivery for the notification even though throttling is not enabled at the application level. Refer to throttling for more details.
     *
     * @return self
     */
    public function setThrottleRatePerMinute($throttle_rate_per_minute)
    {
        $this->container['throttle_rate_per_minute'] = $throttle_rate_per_minute;

        return $this;
    }

    /**
     * Gets android_group
     *
     * @return string|null
     */
    public function getAndroidGroup()
    {
        return $this->container['android_group'];
    }

    /**
     * Sets android_group
     *
     * @param string|null $android_group Channel: Push Notifications Platform: Android Notifications with the same group will be stacked together using Android's Notification Grouping feature.
     *
     * @return self
     */
    public function setAndroidGroup($android_group)
    {
        $this->container['android_group'] = $android_group;

        return $this;
    }

    /**
     * Gets android_group_message
     *
     * @return string|null
     */
    public function getAndroidGroupMessage()
    {
        return $this->container['android_group_message'];
    }

    /**
     * Sets android_group_message
     *
     * @param string|null $android_group_message Channel: Push Notifications Platform: Android Note: This only works for Android 6 and older. Android 7+ allows full expansion of all message. Summary message to display when 2+ notifications are stacked together. Default is \"# new messages\". Include $[notif_count] in your message and it will be replaced with the current number. Languages - The value of each key is the message that will be sent to users for that language. \"en\" (English) is required. The key of each hash is either a a 2 character language code or one of zh-Hans/zh-Hant for Simplified or Traditional Chinese. Read more: supported languages. Example: {\"en\": \"You have $[notif_count] new messages\"}
     *
     * @return self
     */
    public function setAndroidGroupMessage($android_group_message)
    {
        $this->container['android_group_message'] = $android_group_message;

        return $this;
    }

    /**
     * Gets adm_group
     *
     * @return string|null
     */
    public function getAdmGroup()
    {
        return $this->container['adm_group'];
    }

    /**
     * Sets adm_group
     *
     * @param string|null $adm_group Channel: Push Notifications Platform: Amazon Notifications with the same group will be stacked together using Android's Notification Grouping feature.
     *
     * @return self
     */
    public function setAdmGroup($adm_group)
    {
        $this->container['adm_group'] = $adm_group;

        return $this;
    }

    /**
     * Gets adm_group_message
     *
     * @return object|null
     */
    public function getAdmGroupMessage()
    {
        return $this->container['adm_group_message'];
    }

    /**
     * Sets adm_group_message
     *
     * @param object|null $adm_group_message Channel: Push Notifications Platform: Amazon Summary message to display when 2+ notifications are stacked together. Default is \"# new messages\". Include $[notif_count] in your message and it will be replaced with the current number. \"en\" (English) is required. The key of each hash is either a a 2 character language code or one of zh-Hans/zh-Hant for Simplified or Traditional Chinese. The value of each key is the message that will be sent to users for that language. Example: {\"en\": \"You have $[notif_count] new messages\"}
     *
     * @return self
     */
    public function setAdmGroupMessage($adm_group_message)
    {
        $this->container['adm_group_message'] = $adm_group_message;

        return $this;
    }

    /**
     * Gets thread_id
     *
     * @return string|null
     */
    public function getThreadId()
    {
        return $this->container['thread_id'];
    }

    /**
     * Sets thread_id
     *
     * @param string|null $thread_id Channel: Push Notifications Platform: iOS 12+ This parameter is supported in iOS 12 and above. It allows you to group related notifications together. If two notifications have the same thread-id, they will both be added to the same group.
     *
     * @return self
     */
    public function setThreadId($thread_id)
    {
        $this->container['thread_id'] = $thread_id;

        return $this;
    }

    /**
     * Gets summary_arg
     *
     * @return string|null
     */
    public function getSummaryArg()
    {
        return $this->container['summary_arg'];
    }

    /**
     * Sets summary_arg
     *
     * @param string|null $summary_arg Channel: Push Notifications Platform: iOS 12+ When using thread_id to create grouped notifications in iOS 12+, you can also control the summary. For example, a grouped notification can say \"12 more notifications from John Doe\". The summary_arg lets you set the name of the person/thing the notifications are coming from, and will show up as \"X more notifications from summary_arg\"
     *
     * @return self
     */
    public function setSummaryArg($summary_arg)
    {
        $this->container['summary_arg'] = $summary_arg;

        return $this;
    }

    /**
     * Gets summary_arg_count
     *
     * @return int|null
     */
    public function getSummaryArgCount()
    {
        return $this->container['summary_arg_count'];
    }

    /**
     * Sets summary_arg_count
     *
     * @param int|null $summary_arg_count Channel: Push Notifications Platform: iOS 12+ When using thread_id, you can also control the count of the number of notifications in the group. For example, if the group already has 12 notifications, and you send a new notification with summary_arg_count = 2, the new total will be 14 and the summary will be \"14 more notifications from summary_arg\"
     *
     * @return self
     */
    public function setSummaryArgCount($summary_arg_count)
    {
        $this->container['summary_arg_count'] = $summary_arg_count;

        return $this;
    }

    /**
     * Gets email_subject
     *
     * @return string|null
     */
    public function getEmailSubject()
    {
        return $this->container['email_subject'];
    }

    /**
     * Sets email_subject
     *
     * @param string|null $email_subject Channel: Email Required.  The subject of the email.
     *
     * @return self
     */
    public function setEmailSubject($email_subject)
    {
        $this->container['email_subject'] = $email_subject;

        return $this;
    }

    /**
     * Gets email_body
     *
     * @return string|null
     */
    public function getEmailBody()
    {
        return $this->container['email_body'];
    }

    /**
     * Sets email_body
     *
     * @param string|null $email_body Channel: Email Required unless template_id is set. HTML suported The body of the email you wish to send. Typically, customers include their own HTML templates here. Must include [unsubscribe_url] in an <a> tag somewhere in the email. Note: any malformed HTML content will be sent to users. Please double-check your HTML is valid.
     *
     * @return self
     */
    public function setEmailBody($email_body)
    {
        $this->container['email_body'] = $email_body;

        return $this;
    }

    /**
     * Gets email_from_name
     *
     * @return string|null
     */
    public function getEmailFromName()
    {
        return $this->container['email_from_name'];
    }

    /**
     * Sets email_from_name
     *
     * @param string|null $email_from_name Channel: Email The name the email is from. If not specified, will default to \"from name\" set in the OneSignal Dashboard Email Settings.
     *
     * @return self
     */
    public function setEmailFromName($email_from_name)
    {
        $this->container['email_from_name'] = $email_from_name;

        return $this;
    }

    /**
     * Gets email_from_address
     *
     * @return string|null
     */
    public function getEmailFromAddress()
    {
        return $this->container['email_from_address'];
    }

    /**
     * Sets email_from_address
     *
     * @param string|null $email_from_address Channel: Email The email address the email is from. If not specified, will default to \"from email\" set in the OneSignal Dashboard Email Settings.
     *
     * @return self
     */
    public function setEmailFromAddress($email_from_address)
    {
        $this->container['email_from_address'] = $email_from_address;

        return $this;
    }

    /**
     * Gets email_preheader
     *
     * @return string|null
     */
    public function getEmailPreheader()
    {
        return $this->container['email_preheader'];
    }

    /**
     * Sets email_preheader
     *
     * @param string|null $email_preheader Channel: Email The preheader text of the email. Preheader is the preview text displayed immediately after an email subject that provides additional context about the email content. If not specified, will default to null.
     *
     * @return self
     */
    public function setEmailPreheader($email_preheader)
    {
        $this->container['email_preheader'] = $email_preheader;

        return $this;
    }

    /**
     * Gets include_unsubscribed
     *
     * @return bool|null
     */
    public function getIncludeUnsubscribed()
    {
        return $this->container['include_unsubscribed'];
    }

    /**
     * Sets include_unsubscribed
     *
     * @param bool|null $include_unsubscribed Channel: Email Default is `false`. This field is used to send transactional notifications. If set to `true`, this notification will also be sent to unsubscribed emails. If a `template_id` is provided, the `include_unsubscribed` value from the template will be inherited. If you are using a third-party ESP, this field requires the ESP's list of unsubscribed emails to be cleared.
     *
     * @return self
     */
    public function setIncludeUnsubscribed($include_unsubscribed)
    {
        $this->container['include_unsubscribed'] = $include_unsubscribed;

        return $this;
    }

    /**
     * Gets sms_from
     *
     * @return string|null
     */
    public function getSmsFrom()
    {
        return $this->container['sms_from'];
    }

    /**
     * Sets sms_from
     *
     * @param string|null $sms_from Channel: SMS Phone Number used to send SMS. Should be a registered Twilio phone number in E.164 format.
     *
     * @return self
     */
    public function setSmsFrom($sms_from)
    {
        $this->container['sms_from'] = $sms_from;

        return $this;
    }

    /**
     * Gets sms_media_urls
     *
     * @return string[]|null
     */
    public function getSmsMediaUrls()
    {
        return $this->container['sms_media_urls'];
    }

    /**
     * Sets sms_media_urls
     *
     * @param string[]|null $sms_media_urls Channel: SMS URLs for the media files to be attached to the SMS content. Limit: 10 media urls with a total max. size of 5MBs.
     *
     * @return self
     */
    public function setSmsMediaUrls($sms_media_urls)
    {
        $this->container['sms_media_urls'] = $sms_media_urls;

        return $this;
    }

    /**
     * Gets filters
     *
     * @return \onesignal\client\model\Filter[]|null
     */
    public function getFilters()
    {
        return $this->container['filters'];
    }

    /**
     * Sets filters
     *
     * @param \onesignal\client\model\Filter[]|null $filters filters
     *
     * @return self
     */
    public function setFilters($filters)
    {
        $this->container['filters'] = $filters;

        return $this;
    }

    /**
     * Gets custom_data
     *
     * @return object|null
     */
    public function getCustomData()
    {
        return $this->container['custom_data'];
    }

    /**
     * Sets custom_data
     *
     * @param object|null $custom_data Channel: All JSON object that can be used as a source of message personalization data for fields that support tag variable substitution. Push, SMS: Can accept up to 2048 bytes of valid JSON. Email: Can accept up to 10000 bytes of valid JSON. Example: {\"order_id\": 123, \"currency\": \"USD\", \"amount\": 25}
     *
     * @return self
     */
    public function setCustomData($custom_data)
    {
        $this->container['custom_data'] = $custom_data;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


