<?php
/**
 * NotificationWithMetaAllOf
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  onesignal\client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OneSignal
 *
 * A powerful way to send personalized messages at scale and build effective customer engagement strategies. Learn more at onesignal.com
 *
 * The version of the OpenAPI document: 1.2.2
 * Contact: devrel@onesignal.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0-SNAPSHOT
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace onesignal\client\model;

use \ArrayAccess;
use \onesignal\client\ObjectSerializer;

/**
 * NotificationWithMetaAllOf Class Doc Comment
 *
 * @category Class
 * @package  onesignal\client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class NotificationWithMetaAllOf implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'NotificationWithMeta_allOf';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'remaining' => 'int',
        'successful' => 'int',
        'failed' => 'int',
        'errored' => 'int',
        'converted' => 'int',
        'queued_at' => 'int',
        'send_after' => 'int',
        'completed_at' => 'int',
        'platform_delivery_stats' => '\onesignal\client\model\PlatformDeliveryData',
        'received' => 'int',
        'throttle_rate_per_minute' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'remaining' => null,
        'successful' => null,
        'failed' => null,
        'errored' => null,
        'converted' => null,
        'queued_at' => 'int64',
        'send_after' => 'int64',
        'completed_at' => 'int64',
        'platform_delivery_stats' => null,
        'received' => null,
        'throttle_rate_per_minute' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'remaining' => 'remaining',
        'successful' => 'successful',
        'failed' => 'failed',
        'errored' => 'errored',
        'converted' => 'converted',
        'queued_at' => 'queued_at',
        'send_after' => 'send_after',
        'completed_at' => 'completed_at',
        'platform_delivery_stats' => 'platform_delivery_stats',
        'received' => 'received',
        'throttle_rate_per_minute' => 'throttle_rate_per_minute'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'remaining' => 'setRemaining',
        'successful' => 'setSuccessful',
        'failed' => 'setFailed',
        'errored' => 'setErrored',
        'converted' => 'setConverted',
        'queued_at' => 'setQueuedAt',
        'send_after' => 'setSendAfter',
        'completed_at' => 'setCompletedAt',
        'platform_delivery_stats' => 'setPlatformDeliveryStats',
        'received' => 'setReceived',
        'throttle_rate_per_minute' => 'setThrottleRatePerMinute'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'remaining' => 'getRemaining',
        'successful' => 'getSuccessful',
        'failed' => 'getFailed',
        'errored' => 'getErrored',
        'converted' => 'getConverted',
        'queued_at' => 'getQueuedAt',
        'send_after' => 'getSendAfter',
        'completed_at' => 'getCompletedAt',
        'platform_delivery_stats' => 'getPlatformDeliveryStats',
        'received' => 'getReceived',
        'throttle_rate_per_minute' => 'getThrottleRatePerMinute'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['remaining'] = $data['remaining'] ?? null;
        $this->container['successful'] = $data['successful'] ?? null;
        $this->container['failed'] = $data['failed'] ?? null;
        $this->container['errored'] = $data['errored'] ?? null;
        $this->container['converted'] = $data['converted'] ?? null;
        $this->container['queued_at'] = $data['queued_at'] ?? null;
        $this->container['send_after'] = $data['send_after'] ?? null;
        $this->container['completed_at'] = $data['completed_at'] ?? null;
        $this->container['platform_delivery_stats'] = $data['platform_delivery_stats'] ?? null;
        $this->container['received'] = $data['received'] ?? null;
        $this->container['throttle_rate_per_minute'] = $data['throttle_rate_per_minute'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets remaining
     *
     * @return int|null
     */
    public function getRemaining()
    {
        return $this->container['remaining'];
    }

    /**
     * Sets remaining
     *
     * @param int|null $remaining Number of notifications that have not been sent out yet. This can mean either our system is still processing the notification or you have delayed options set.
     *
     * @return self
     */
    public function setRemaining($remaining)
    {
        $this->container['remaining'] = $remaining;

        return $this;
    }

    /**
     * Gets successful
     *
     * @return int|null
     */
    public function getSuccessful()
    {
        return $this->container['successful'];
    }

    /**
     * Sets successful
     *
     * @param int|null $successful Number of notifications that were successfully delivered.
     *
     * @return self
     */
    public function setSuccessful($successful)
    {
        $this->container['successful'] = $successful;

        return $this;
    }

    /**
     * Gets failed
     *
     * @return int|null
     */
    public function getFailed()
    {
        return $this->container['failed'];
    }

    /**
     * Sets failed
     *
     * @param int|null $failed Number of notifications that could not be delivered due to those devices being unsubscribed.
     *
     * @return self
     */
    public function setFailed($failed)
    {
        $this->container['failed'] = $failed;

        return $this;
    }

    /**
     * Gets errored
     *
     * @return int|null
     */
    public function getErrored()
    {
        return $this->container['errored'];
    }

    /**
     * Sets errored
     *
     * @param int|null $errored Number of notifications that could not be delivered due to an error. You can find more information by viewing the notification in the dashboard.
     *
     * @return self
     */
    public function setErrored($errored)
    {
        $this->container['errored'] = $errored;

        return $this;
    }

    /**
     * Gets converted
     *
     * @return int|null
     */
    public function getConverted()
    {
        return $this->container['converted'];
    }

    /**
     * Sets converted
     *
     * @param int|null $converted Number of users who have clicked / tapped on your notification.
     *
     * @return self
     */
    public function setConverted($converted)
    {
        $this->container['converted'] = $converted;

        return $this;
    }

    /**
     * Gets queued_at
     *
     * @return int|null
     */
    public function getQueuedAt()
    {
        return $this->container['queued_at'];
    }

    /**
     * Sets queued_at
     *
     * @param int|null $queued_at Unix timestamp indicating when the notification was created.
     *
     * @return self
     */
    public function setQueuedAt($queued_at)
    {
        $this->container['queued_at'] = $queued_at;

        return $this;
    }

    /**
     * Gets send_after
     *
     * @return int|null
     */
    public function getSendAfter()
    {
        return $this->container['send_after'];
    }

    /**
     * Sets send_after
     *
     * @param int|null $send_after Unix timestamp indicating when notification delivery should begin.
     *
     * @return self
     */
    public function setSendAfter($send_after)
    {
        $this->container['send_after'] = $send_after;

        return $this;
    }

    /**
     * Gets completed_at
     *
     * @return int|null
     */
    public function getCompletedAt()
    {
        return $this->container['completed_at'];
    }

    /**
     * Sets completed_at
     *
     * @param int|null $completed_at Unix timestamp indicating when notification delivery completed. The delivery duration from start to finish can be calculated with completed_at - send_after.
     *
     * @return self
     */
    public function setCompletedAt($completed_at)
    {
        $this->container['completed_at'] = $completed_at;

        return $this;
    }

    /**
     * Gets platform_delivery_stats
     *
     * @return \onesignal\client\model\PlatformDeliveryData|null
     */
    public function getPlatformDeliveryStats()
    {
        return $this->container['platform_delivery_stats'];
    }

    /**
     * Sets platform_delivery_stats
     *
     * @param \onesignal\client\model\PlatformDeliveryData|null $platform_delivery_stats platform_delivery_stats
     *
     * @return self
     */
    public function setPlatformDeliveryStats($platform_delivery_stats)
    {
        $this->container['platform_delivery_stats'] = $platform_delivery_stats;

        return $this;
    }

    /**
     * Gets received
     *
     * @return int|null
     */
    public function getReceived()
    {
        return $this->container['received'];
    }

    /**
     * Sets received
     *
     * @param int|null $received Confirmed Deliveries number of devices that received the push notification. Paid Feature Only. Free accounts will see 0.
     *
     * @return self
     */
    public function setReceived($received)
    {
        $this->container['received'] = $received;

        return $this;
    }

    /**
     * Gets throttle_rate_per_minute
     *
     * @return int|null
     */
    public function getThrottleRatePerMinute()
    {
        return $this->container['throttle_rate_per_minute'];
    }

    /**
     * Sets throttle_rate_per_minute
     *
     * @param int|null $throttle_rate_per_minute number of push notifications sent per minute. Paid Feature Only. If throttling is not enabled for the app or the notification, and for free accounts, null is returned. Refer to Throttling for more details.
     *
     * @return self
     */
    public function setThrottleRatePerMinute($throttle_rate_per_minute)
    {
        $this->container['throttle_rate_per_minute'] = $throttle_rate_per_minute;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


