<?php
/**
 * Player
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  onesignal\client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OneSignal
 *
 * A powerful way to send personalized messages at scale and build effective customer engagement strategies. Learn more at onesignal.com
 *
 * The version of the OpenAPI document: 1.2.2
 * Contact: devrel@onesignal.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0-SNAPSHOT
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace onesignal\client\model;

use \ArrayAccess;
use \onesignal\client\ObjectSerializer;

/**
 * Player Class Doc Comment
 *
 * @category Class
 * @package  onesignal\client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class Player implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Player';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'string',
        'invalid_identifier' => 'bool',
        'app_id' => 'string',
        'device_type' => 'int',
        'external_user_id' => 'string',
        'external_user_id_auth_hash' => 'string',
        'email_auth_hash' => 'string',
        'identifier' => 'string',
        'language' => 'string',
        'timezone' => 'int',
        'game_version' => 'string',
        'device_model' => 'string',
        'device_os' => 'string',
        'ad_id' => 'string',
        'sdk' => 'string',
        'session_count' => 'int',
        'tags' => 'object',
        'amount_spent' => 'float',
        'created_at' => 'int',
        'playtime' => 'int',
        'badge_count' => 'int',
        'last_active' => 'int',
        'notification_types' => 'int',
        'test_type' => 'int',
        'long' => 'float',
        'lat' => 'float',
        'country' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => null,
        'invalid_identifier' => null,
        'app_id' => null,
        'device_type' => null,
        'external_user_id' => null,
        'external_user_id_auth_hash' => null,
        'email_auth_hash' => null,
        'identifier' => null,
        'language' => null,
        'timezone' => null,
        'game_version' => null,
        'device_model' => null,
        'device_os' => null,
        'ad_id' => null,
        'sdk' => null,
        'session_count' => null,
        'tags' => null,
        'amount_spent' => null,
        'created_at' => 'int64',
        'playtime' => 'int64',
        'badge_count' => null,
        'last_active' => null,
        'notification_types' => null,
        'test_type' => null,
        'long' => null,
        'lat' => null,
        'country' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'invalid_identifier' => 'invalid_identifier',
        'app_id' => 'app_id',
        'device_type' => 'device_type',
        'external_user_id' => 'external_user_id',
        'external_user_id_auth_hash' => 'external_user_id_auth_hash',
        'email_auth_hash' => 'email_auth_hash',
        'identifier' => 'identifier',
        'language' => 'language',
        'timezone' => 'timezone',
        'game_version' => 'game_version',
        'device_model' => 'device_model',
        'device_os' => 'device_os',
        'ad_id' => 'ad_id',
        'sdk' => 'sdk',
        'session_count' => 'session_count',
        'tags' => 'tags',
        'amount_spent' => 'amount_spent',
        'created_at' => 'created_at',
        'playtime' => 'playtime',
        'badge_count' => 'badge_count',
        'last_active' => 'last_active',
        'notification_types' => 'notification_types',
        'test_type' => 'test_type',
        'long' => 'long',
        'lat' => 'lat',
        'country' => 'country'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'invalid_identifier' => 'setInvalidIdentifier',
        'app_id' => 'setAppId',
        'device_type' => 'setDeviceType',
        'external_user_id' => 'setExternalUserId',
        'external_user_id_auth_hash' => 'setExternalUserIdAuthHash',
        'email_auth_hash' => 'setEmailAuthHash',
        'identifier' => 'setIdentifier',
        'language' => 'setLanguage',
        'timezone' => 'setTimezone',
        'game_version' => 'setGameVersion',
        'device_model' => 'setDeviceModel',
        'device_os' => 'setDeviceOs',
        'ad_id' => 'setAdId',
        'sdk' => 'setSdk',
        'session_count' => 'setSessionCount',
        'tags' => 'setTags',
        'amount_spent' => 'setAmountSpent',
        'created_at' => 'setCreatedAt',
        'playtime' => 'setPlaytime',
        'badge_count' => 'setBadgeCount',
        'last_active' => 'setLastActive',
        'notification_types' => 'setNotificationTypes',
        'test_type' => 'setTestType',
        'long' => 'setLong',
        'lat' => 'setLat',
        'country' => 'setCountry'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'invalid_identifier' => 'getInvalidIdentifier',
        'app_id' => 'getAppId',
        'device_type' => 'getDeviceType',
        'external_user_id' => 'getExternalUserId',
        'external_user_id_auth_hash' => 'getExternalUserIdAuthHash',
        'email_auth_hash' => 'getEmailAuthHash',
        'identifier' => 'getIdentifier',
        'language' => 'getLanguage',
        'timezone' => 'getTimezone',
        'game_version' => 'getGameVersion',
        'device_model' => 'getDeviceModel',
        'device_os' => 'getDeviceOs',
        'ad_id' => 'getAdId',
        'sdk' => 'getSdk',
        'session_count' => 'getSessionCount',
        'tags' => 'getTags',
        'amount_spent' => 'getAmountSpent',
        'created_at' => 'getCreatedAt',
        'playtime' => 'getPlaytime',
        'badge_count' => 'getBadgeCount',
        'last_active' => 'getLastActive',
        'notification_types' => 'getNotificationTypes',
        'test_type' => 'getTestType',
        'long' => 'getLong',
        'lat' => 'getLat',
        'country' => 'getCountry'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = $data['id'] ?? null;
        $this->container['invalid_identifier'] = $data['invalid_identifier'] ?? null;
        $this->container['app_id'] = $data['app_id'] ?? null;
        $this->container['device_type'] = $data['device_type'] ?? null;
        $this->container['external_user_id'] = $data['external_user_id'] ?? null;
        $this->container['external_user_id_auth_hash'] = $data['external_user_id_auth_hash'] ?? null;
        $this->container['email_auth_hash'] = $data['email_auth_hash'] ?? null;
        $this->container['identifier'] = $data['identifier'] ?? null;
        $this->container['language'] = $data['language'] ?? null;
        $this->container['timezone'] = $data['timezone'] ?? null;
        $this->container['game_version'] = $data['game_version'] ?? null;
        $this->container['device_model'] = $data['device_model'] ?? null;
        $this->container['device_os'] = $data['device_os'] ?? null;
        $this->container['ad_id'] = $data['ad_id'] ?? null;
        $this->container['sdk'] = $data['sdk'] ?? null;
        $this->container['session_count'] = $data['session_count'] ?? null;
        $this->container['tags'] = $data['tags'] ?? null;
        $this->container['amount_spent'] = $data['amount_spent'] ?? null;
        $this->container['created_at'] = $data['created_at'] ?? null;
        $this->container['playtime'] = $data['playtime'] ?? null;
        $this->container['badge_count'] = $data['badge_count'] ?? null;
        $this->container['last_active'] = $data['last_active'] ?? null;
        $this->container['notification_types'] = $data['notification_types'] ?? null;
        $this->container['test_type'] = $data['test_type'] ?? null;
        $this->container['long'] = $data['long'] ?? null;
        $this->container['lat'] = $data['lat'] ?? null;
        $this->container['country'] = $data['country'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['device_type'] === null) {
            $invalidProperties[] = "'device_type' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id The device's OneSignal ID
     *
     * @return self
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets invalid_identifier
     *
     * @return bool|null
     */
    public function getInvalidIdentifier()
    {
        return $this->container['invalid_identifier'];
    }

    /**
     * Sets invalid_identifier
     *
     * @param bool|null $invalid_identifier If true, this is the equivalent of a user being Unsubscribed
     *
     * @return self
     */
    public function setInvalidIdentifier($invalid_identifier)
    {
        $this->container['invalid_identifier'] = $invalid_identifier;

        return $this;
    }

    /**
     * Gets app_id
     *
     * @return string|null
     */
    public function getAppId()
    {
        return $this->container['app_id'];
    }

    /**
     * Sets app_id
     *
     * @param string|null $app_id app_id
     *
     * @return self
     */
    public function setAppId($app_id)
    {
        $this->container['app_id'] = $app_id;

        return $this;
    }

    /**
     * Gets device_type
     *
     * @return int
     */
    public function getDeviceType()
    {
        return $this->container['device_type'];
    }

    /**
     * Sets device_type
     *
     * @param int $device_type Required The device's platform:   0 = iOS   1 = Android   2 = Amazon   3 = WindowsPhone (MPNS)   4 = Chrome Apps / Extensions   5 = Chrome Web Push   6 = Windows (WNS)   7 = Safari   8 = Firefox   9 = MacOS   10 = Alexa   11 = Email   13 = For Huawei App Gallery Builds SDK Setup. Not for Huawei Devices using FCM   14 = SMS
     *
     * @return self
     */
    public function setDeviceType($device_type)
    {
        $this->container['device_type'] = $device_type;

        return $this;
    }

    /**
     * Gets external_user_id
     *
     * @return string|null
     */
    public function getExternalUserId()
    {
        return $this->container['external_user_id'];
    }

    /**
     * Sets external_user_id
     *
     * @param string|null $external_user_id a custom user ID
     *
     * @return self
     */
    public function setExternalUserId($external_user_id)
    {
        $this->container['external_user_id'] = $external_user_id;

        return $this;
    }

    /**
     * Gets external_user_id_auth_hash
     *
     * @return string|null
     */
    public function getExternalUserIdAuthHash()
    {
        return $this->container['external_user_id_auth_hash'];
    }

    /**
     * Sets external_user_id_auth_hash
     *
     * @param string|null $external_user_id_auth_hash Only required if you have enabled Identity Verification and device_type is NOT 11 email.
     *
     * @return self
     */
    public function setExternalUserIdAuthHash($external_user_id_auth_hash)
    {
        $this->container['external_user_id_auth_hash'] = $external_user_id_auth_hash;

        return $this;
    }

    /**
     * Gets email_auth_hash
     *
     * @return string|null
     */
    public function getEmailAuthHash()
    {
        return $this->container['email_auth_hash'];
    }

    /**
     * Sets email_auth_hash
     *
     * @param string|null $email_auth_hash Email - Only required if you have enabled Identity Verification and device_type is email (11).
     *
     * @return self
     */
    public function setEmailAuthHash($email_auth_hash)
    {
        $this->container['email_auth_hash'] = $email_auth_hash;

        return $this;
    }

    /**
     * Gets identifier
     *
     * @return string|null
     */
    public function getIdentifier()
    {
        return $this->container['identifier'];
    }

    /**
     * Sets identifier
     *
     * @param string|null $identifier Recommended: For Push Notifications, this is the Push Token Identifier from Google or Apple. For Apple Push identifiers, you must strip all non alphanumeric characters. Examples: iOS: 7abcd558f29d0b1f048083e2834ad8ea4b3d87d8ad9c088b33c132706ff445f0 Android: APA91bHbYHk7aq-Uam_2pyJ2qbZvqllyyh2wjfPRaw5gLEX2SUlQBRvOc6sck1sa7H7nGeLNlDco8lXj83HWWwzV... For Email Addresses, set the full email address email@email.com and make sure to set device_type to 11.
     *
     * @return self
     */
    public function setIdentifier($identifier)
    {
        $this->container['identifier'] = $identifier;

        return $this;
    }

    /**
     * Gets language
     *
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->container['language'];
    }

    /**
     * Sets language
     *
     * @param string|null $language Language code. Typically lower case two letters, except for Chinese where it must be one of zh-Hans or zh-Hant. Example: en
     *
     * @return self
     */
    public function setLanguage($language)
    {
        $this->container['language'] = $language;

        return $this;
    }

    /**
     * Gets timezone
     *
     * @return int|null
     */
    public function getTimezone()
    {
        return $this->container['timezone'];
    }

    /**
     * Sets timezone
     *
     * @param int|null $timezone Number of seconds away from UTC. Example: -28800
     *
     * @return self
     */
    public function setTimezone($timezone)
    {
        $this->container['timezone'] = $timezone;

        return $this;
    }

    /**
     * Gets game_version
     *
     * @return string|null
     */
    public function getGameVersion()
    {
        return $this->container['game_version'];
    }

    /**
     * Sets game_version
     *
     * @param string|null $game_version Version of your app. Example: 1.1
     *
     * @return self
     */
    public function setGameVersion($game_version)
    {
        $this->container['game_version'] = $game_version;

        return $this;
    }

    /**
     * Gets device_model
     *
     * @return string|null
     */
    public function getDeviceModel()
    {
        return $this->container['device_model'];
    }

    /**
     * Sets device_model
     *
     * @param string|null $device_model Device make and model. Example: iPhone5,1
     *
     * @return self
     */
    public function setDeviceModel($device_model)
    {
        $this->container['device_model'] = $device_model;

        return $this;
    }

    /**
     * Gets device_os
     *
     * @return string|null
     */
    public function getDeviceOs()
    {
        return $this->container['device_os'];
    }

    /**
     * Sets device_os
     *
     * @param string|null $device_os Device operating system version. Example: 7.0.4
     *
     * @return self
     */
    public function setDeviceOs($device_os)
    {
        $this->container['device_os'] = $device_os;

        return $this;
    }

    /**
     * Gets ad_id
     *
     * @return string|null
     */
    public function getAdId()
    {
        return $this->container['ad_id'];
    }

    /**
     * Sets ad_id
     *
     * @param string|null $ad_id The ad id for the device's platform: Android = Advertising Id iOS = identifierForVendor WP8.0 = DeviceUniqueId WP8.1 = AdvertisingId
     *
     * @return self
     */
    public function setAdId($ad_id)
    {
        $this->container['ad_id'] = $ad_id;

        return $this;
    }

    /**
     * Gets sdk
     *
     * @return string|null
     */
    public function getSdk()
    {
        return $this->container['sdk'];
    }

    /**
     * Sets sdk
     *
     * @param string|null $sdk Name and version of the sdk/plugin that's calling this API method (if any)
     *
     * @return self
     */
    public function setSdk($sdk)
    {
        $this->container['sdk'] = $sdk;

        return $this;
    }

    /**
     * Gets session_count
     *
     * @return int|null
     */
    public function getSessionCount()
    {
        return $this->container['session_count'];
    }

    /**
     * Sets session_count
     *
     * @param int|null $session_count Number of times the user has played the game, defaults to 1
     *
     * @return self
     */
    public function setSessionCount($session_count)
    {
        $this->container['session_count'] = $session_count;

        return $this;
    }

    /**
     * Gets tags
     *
     * @return object|null
     */
    public function getTags()
    {
        return $this->container['tags'];
    }

    /**
     * Sets tags
     *
     * @param object|null $tags Custom tags for the player. Only support string and integer key value pairs. Does not support arrays or other nested objects. Setting a tag value to null or an empty string will remove the tag. Example: {\"foo\":\"bar\",\"this\":\"that\"} Limitations: - 100 tags per call - Android SDK users: tags cannot be removed or changed via API if set through SDK sendTag methods. Recommended to only tag devices with 1 kilobyte of data Please consider using your own Database to save more than 1 kilobyte of data. See: Internal Database & CRM
     *
     * @return self
     */
    public function setTags($tags)
    {
        $this->container['tags'] = $tags;

        return $this;
    }

    /**
     * Gets amount_spent
     *
     * @return float|null
     */
    public function getAmountSpent()
    {
        return $this->container['amount_spent'];
    }

    /**
     * Sets amount_spent
     *
     * @param float|null $amount_spent Amount the user has spent in USD, up to two decimal places
     *
     * @return self
     */
    public function setAmountSpent($amount_spent)
    {
        $this->container['amount_spent'] = $amount_spent;

        return $this;
    }

    /**
     * Gets created_at
     *
     * @return int|null
     */
    public function getCreatedAt()
    {
        return $this->container['created_at'];
    }

    /**
     * Sets created_at
     *
     * @param int|null $created_at Unixtime when the player joined the game
     *
     * @return self
     */
    public function setCreatedAt($created_at)
    {
        $this->container['created_at'] = $created_at;

        return $this;
    }

    /**
     * Gets playtime
     *
     * @return int|null
     */
    public function getPlaytime()
    {
        return $this->container['playtime'];
    }

    /**
     * Sets playtime
     *
     * @param int|null $playtime Seconds player was running your app.
     *
     * @return self
     */
    public function setPlaytime($playtime)
    {
        $this->container['playtime'] = $playtime;

        return $this;
    }

    /**
     * Gets badge_count
     *
     * @return int|null
     */
    public function getBadgeCount()
    {
        return $this->container['badge_count'];
    }

    /**
     * Sets badge_count
     *
     * @param int|null $badge_count Current iOS badge count displayed on the app icon NOTE: Not supported for apps created after June 2018, since badge count for apps created after this date are handled on the client.
     *
     * @return self
     */
    public function setBadgeCount($badge_count)
    {
        $this->container['badge_count'] = $badge_count;

        return $this;
    }

    /**
     * Gets last_active
     *
     * @return int|null
     */
    public function getLastActive()
    {
        return $this->container['last_active'];
    }

    /**
     * Sets last_active
     *
     * @param int|null $last_active Unixtime when the player was last active
     *
     * @return self
     */
    public function setLastActive($last_active)
    {
        $this->container['last_active'] = $last_active;

        return $this;
    }

    /**
     * Gets notification_types
     *
     * @return int|null
     */
    public function getNotificationTypes()
    {
        return $this->container['notification_types'];
    }

    /**
     * Sets notification_types
     *
     * @param int|null $notification_types 1 = subscribed -2 = unsubscribed iOS - These values are set each time the user opens the app from the SDK. Use the SDK function set Subscription instead. Android - You may set this but you can no longer use the SDK method setSubscription later in your app as it will create synchronization issues.
     *
     * @return self
     */
    public function setNotificationTypes($notification_types)
    {
        $this->container['notification_types'] = $notification_types;

        return $this;
    }

    /**
     * Gets test_type
     *
     * @return int|null
     */
    public function getTestType()
    {
        return $this->container['test_type'];
    }

    /**
     * Sets test_type
     *
     * @param int|null $test_type This is used in deciding whether to use your iOS Sandbox or Production push certificate when sending a push when both have been uploaded. Set to the iOS provisioning profile that was used to build your app. 1 = Development 2 = Ad-Hoc Omit this field for App Store builds.
     *
     * @return self
     */
    public function setTestType($test_type)
    {
        $this->container['test_type'] = $test_type;

        return $this;
    }

    /**
     * Gets long
     *
     * @return float|null
     */
    public function getLong()
    {
        return $this->container['long'];
    }

    /**
     * Sets long
     *
     * @param float|null $long Longitude of the device, used for geotagging to segment on.
     *
     * @return self
     */
    public function setLong($long)
    {
        $this->container['long'] = $long;

        return $this;
    }

    /**
     * Gets lat
     *
     * @return float|null
     */
    public function getLat()
    {
        return $this->container['lat'];
    }

    /**
     * Sets lat
     *
     * @param float|null $lat Latitude of the device, used for geotagging to segment on.
     *
     * @return self
     */
    public function setLat($lat)
    {
        $this->container['lat'] = $lat;

        return $this;
    }

    /**
     * Gets country
     *
     * @return string|null
     */
    public function getCountry()
    {
        return $this->container['country'];
    }

    /**
     * Sets country
     *
     * @param string|null $country Country code in the ISO 3166-1 Alpha 2 format
     *
     * @return self
     */
    public function setCountry($country)
    {
        $this->container['country'] = $country;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


